/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class PurOrderWriteBackPurReq4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1188507867739333743L;

    public PurOrderWriteBackPurReq4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderWriteBackPurReq4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderWriteBackPurReq4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.writebackPurReq(batchResults);
    }

    private void writebackPurReq(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SM_PurOrderEntry", (IObjectPK[])pks);
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            if (flowSet != null && flowSet.contains(pks[i].toString())) continue;
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        try {
            if (params.length() > 0) {
                this.writePurReqBill(this.ctx, params.toString(), pks.length);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void writePurReqBill(Context ctx, String params, int rowCount) throws SQLException, BOSException, PurOrderException {
        Connection con = null;
        Statement srcRateStatement = null;
        Statement statement = null;
        Statement destRateStatement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer valueBuffer = new StringBuffer();
            StringBuffer oldPurOrderSql = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            HashMap<String, String> qtyMap = new HashMap<String, String>();
            valueBuffer.append(" select entry.fpurRequestEntryID,entry.FQty,entry.fbaseQty ").append(" from T_SM_PurOrderEntry entry");
            valueBuffer.append(" where entry.fpurRequestEntryID is not null");
            valueBuffer.append(" and entry.FParentID in(").append(params).append(")");
            valueBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
            oldPurOrderSql.append("select entry.fpurRequestEntryID,entry.FQty ");
            oldPurOrderSql.append("from T_SM_PurOrderEntry as entry ");
            oldPurOrderSql.append("inner join t_sm_purorder po on entry.fparentid = po.fid   ");
            oldPurOrderSql.append("inner join (select max(p.fversion) as version,p.foldid as oldid from t_sm_purorder as p ");
            oldPurOrderSql.append("where p.foldid in(").append(params).append(") ");
            oldPurOrderSql.append("group by p.foldid)  as tp on po.foldid=tp.oldid and po.fversion=tp.version ");
            oldPurOrderSql.append("where entry.fpurRequestEntryID is not null  ");
            ResultSet resultQty = statement.executeQuery(oldPurOrderSql.toString());
            while (resultQty.next()) {
                if (resultQty.getString(1) == null || resultQty.getString(2) == null) continue;
                qtyMap.put(resultQty.getString(1), resultQty.getString(2));
            }
            ResultSet result = statement.executeQuery(valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                srcRateStatement = con.createStatement();
                destRateStatement = con.createStatement();
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,entry.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurOrderEntry entry").append(" on entry.fpurRequestEntryID is not null").append(" and FParentID in(").append(params).append(")").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID");
                srcBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                srcBuffer.append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")");
                srcBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                srcBuffer.append(") temp order by temp.fseq");
                destBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,tempOrder.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurOrderEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.fpurRequestEntryID").append(" where entry.FParentId in(").append(params).append(")");
                destBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                destBuffer.append(")tempOrder on tempOrder.FMaterialID = unit.FMaterialID").append(" and tempOrder.destUnit = unit.FMeasureUnitID ").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")");
                destBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                destBuffer.append(") temp order by temp.fseq");
                String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty+?,FOrderedBaseQty = FOrderedBaseQty+?,  FUnOrderedQty = FQty - FOrderedQty-?,FUnOrderedBaseQty = FBaseQty-FOrderedBaseQty-? where Fid = ?";
                PreparedStatement updateStatement = con.prepareStatement(updateReqSql);
                ResultSet srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
                ResultSet destRateSet = destRateStatement.executeQuery(destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal qty = null;
                BigDecimal baseQty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                BigDecimal destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    if (result.getBigDecimal(2) != null) {
                        qty = result.getBigDecimal(2);
                        if (!qtyMap.isEmpty() && qtyMap.containsKey(result.getString(1))) {
                            qty = qty.subtract(new BigDecimal(qtyMap.get(result.getString(1)).toString()));
                        }
                    }
                    if (result.getBigDecimal(3) != null) {
                        baseQty = result.getBigDecimal(3);
                    }
                    srcRate = srcRateSet.getBigDecimal(1);
                    destRate = destRateSet.getBigDecimal(1);
                    destQty = this.exchangeQtyByUnit(srcRate, destRate, qty, baseQty);
                    if (destRate == null) {
                        destRate = new BigDecimal("1.00");
                    }
                    destBaseQty = destRate.intValue() == 1 ? destQty : destQty.multiply(destRate);
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, destBaseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, destBaseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
            }
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(sourceEntryIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateAuditReqEntryBuffer = new StringBuffer();
                updateAuditReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =4").append(" where FUnOrderedQty >0 and fid in(").append(sqlParams.toString()).append(")");
                statement.execute(updateAuditReqEntryBuffer.toString());
                StringBuffer updateAuditReqBuffer = new StringBuffer();
                updateAuditReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 4").append(" where fid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append(") and FBaseStatus = 4 )");
                statement.execute(updateAuditReqBuffer.toString());
                StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
                updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =7").append(" where FUnOrderedQty <=0 and fid in(").append(sqlParams.toString()).append(")");
                statement.execute(updateCloseReqEntryBuffer.toString());
                StringBuffer updateCloseReqBuffer = new StringBuffer();
                updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 7").append(" where fid not in (select FParentid from T_SM_PurRequestEntry where FBaseStatus <>7 and  fparentid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append(")))").append(" and fid in(select DISTINCT FParentId from T_SM_PurRequestEntry where fid in (").append(sqlParams.toString()).append("))");
                statement.execute(updateCloseReqBuffer.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SQLDataException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private BigDecimal exchangeQtyByUnit(BigDecimal srcRate, BigDecimal destRate, BigDecimal qty, BigDecimal baseQty) {
        if (srcRate == null) {
            srcRate = new BigDecimal("1.00");
        }
        if (destRate == null) {
            destRate = new BigDecimal("1.00");
        }
        if (destRate.equals(srcRate)) {
            return qty;
        }
        return baseQty.divide(destRate, baseQty.scale(), 0);
    }
}

