/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PurOrderWriteBackSrcBill4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -8613939834580044079L;

    public PurOrderWriteBackSrcBill4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderWriteBackSrcBill4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderWriteBackSrcBill4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.writebackSrcBill(batchResults);
    }

    private void writebackSrcBill(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        this.clearInnerDealPrice(this.ctx, pks);
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)this.ctx);
        PurOrderInfo purInfo = null;
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SM_PurOrderEntry", (IObjectPK[])pks);
        HashSet<String> ids = new HashSet<String>();
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            if (flowSet != null && flowSet.contains(pks[j].toString())) continue;
            ids.add(pks[j].toString());
        }
        if (ids != null && ids.size() == 0) {
            return;
        }
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        entityView.getSelector().add(new SelectorItemInfo("id"));
        entityView.getSelector().add(new SelectorItemInfo("billType"));
        entityView.getSelector().add(new SelectorItemInfo("purchaseOrgUnit.id"));
        entityView.getSelector().add(new SelectorItemInfo("baseStatus"));
        entityView.getSelector().add(new SelectorItemInfo("entries.baseStatus"));
        entityView.getSelector().add(new SelectorItemInfo("number"));
        entityView.getSelector().add(new SelectorItemInfo("cu.id"));
        entityView.getSelector().add(new SelectorItemInfo("sourceBillType"));
        entityView.getSelector().add(new SelectorItemInfo("entries.sourceBillEntryId"));
        entityView.getSelector().add(new SelectorItemInfo("auditor.id"));
        PurOrderCollection poCollection = iPurOrder.getPurOrderCollection(entityView);
        PurOrderCollection newCollection = new PurOrderCollection();
        newCollection.addCollection(poCollection);
        String entryTable = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552");
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)entryTable)) {
            int c = poCollection.size();
            for (int i = 0; i < c; ++i) {
                purInfo = poCollection.get(i);
                if (!SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)entryTable, (String)purInfo.getId().toString())) continue;
                newCollection.remove(purInfo);
            }
        }
        if (newCollection == null || newCollection.size() == 0) {
            return;
        }
        StringBuilder params = new StringBuilder();
        int c = newCollection.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(newCollection.get(i).getId().toString());
            params.append("'");
        }
        try {
            List resourceList = new ArrayList();
            String resourceParam = "";
            resourceList = this.getParam(newCollection, "510b6503-0105-1000-e000-0107c0a812fd463ED552");
            resourceParam = PurUtil.getInStringFromList(resourceList);
            if (resourceParam != null) {
                this.writeSourceBillForPurRequest_unAudit(this.ctx, resourceParam);
            } else {
                this.writeBill_unAuditByFpurRequestID(this.ctx, params.toString());
            }
            resourceList = this.getParam(newCollection, "510b6503-0105-1000-e000-010bc0a813fd463ED552");
            resourceParam = PurUtil.getInStringFromList(resourceList);
            if (resourceParam != null) {
                this.writeSourceBillForPurContract_unAudit(this.ctx, resourceParam);
            }
            resourceList = this.getParam(newCollection, "MmEE6VBsR0KaUDQmebwhP0Y+1VI=");
            resourceParam = PurUtil.getInStringFromList(resourceList);
            if (resourceList != null && resourceList.size() > 0) {
                this.writeBackToWantReq(this.ctx, pks, BizActionEnum.UNAUDIT);
            }
            if ((resourceParam = PurUtil.getInStringFromList(resourceList = this.getParam(newCollection, "Htzs+wEkEADgAAMJwKg9YtAMSuo="))) != null) {
                this.writeSourceBillForPurPlan_unAudit(this.ctx, resourceParam);
            }
            if ((resourceParam = PurUtil.getInStringFromList(resourceList = this.getParam(newCollection, "510b6503-0105-1000-e000-0113c0a812fd463ED552"))) != null) {
                this.writeBackTOSaleOrder(this.ctx, resourceParam);
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    private List getParam(PurOrderCollection poCollection, String type) {
        ArrayList<String> params = new ArrayList<String>();
        PurOrderInfo purInfo = null;
        int c = poCollection.size();
        for (int i = 0; i < c; ++i) {
            purInfo = poCollection.get(i);
            if (!SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)purInfo, (String)type)) continue;
            params.add(purInfo.getId().toString());
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceBillForPurRequest_unAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty,entry.fbaseQty,entry.FMaterialGroupId ").append(" from T_SM_PurOrderEntry entry").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and entry.FParentID in ").append(params).append(" order by entry.fseq");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,entry.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurOrderEntry entry").append(" on entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and FParentID in ").append(params).append(" ").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in ").append(params).append(" ").append(") temp order by temp.fseq");
                destBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,tempOrder.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurOrderEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.FSourceBillEntryId").append(" where entry.FParentId in ").append(params).append(" ").append(")tempOrder on tempOrder.FMaterialID = unit.FMaterialID").append(" and tempOrder.destUnit = unit.FMeasureUnitID ").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in ").append(params).append(" ").append(") temp order by temp.fseq");
                String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty-?,FOrderedBaseQty = FOrderedBaseQty-?,  FUnOrderedQty = FQty - FOrderedQty+?,FUnOrderedBaseQty = FBaseQty-FOrderedBaseQty+? where Fid = ?";
                PreparedStatement updateStatement = con.prepareStatement(updateReqSql);
                IRowSet srcRateSet = DbUtil.executeQuery((Context)ctx, (String)srcBuffer.toString());
                IRowSet destRateSet = DbUtil.executeQuery((Context)ctx, (String)destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal qty = null;
                BigDecimal baseQty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                Object destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    if (result.getBigDecimal(2) != null) {
                        qty = result.getBigDecimal(2);
                    }
                    if (result.getBigDecimal(3) != null) {
                        baseQty = result.getBigDecimal(3);
                    }
                    if (result.getString("FMaterialGroupId") == null) {
                        srcRate = srcRateSet.getBigDecimal(1);
                        destRate = destRateSet.getBigDecimal(1);
                        destQty = this.exchangeQtyByUnit(srcRate, destRate, qty, baseQty);
                    } else {
                        destQty = baseQty;
                    }
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, baseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, baseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
                SQLUtils.cleanup((ResultSet)srcRateSet);
                SQLUtils.cleanup((ResultSet)destRateSet);
                SQLUtils.cleanup((Statement)updateStatement);
            }
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(sourceEntryIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() <= 0) return;
            statement = con.createStatement();
            StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
            updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =4").append(" where FIsManualClose = 0 and FUnOrderedQty >0 and fid in(").append(sqlParams.toString()).append(")");
            count = statement.executeUpdate(updateCloseReqEntryBuffer.toString());
            if (count > 0) {
                StringBuffer updateCloseReqBuffer = new StringBuffer();
                updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 4").append(" where fid in (select FParentid from T_SM_PurRequestEntry where fparentid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append("))) and fid not in (select FParentid from T_SM_PurRequestEntry where fbasestatus <> 4 and fbasestatus <> 7 and fparentid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append(")))");
                DbUtil.execute((Context)ctx, (String)updateCloseReqBuffer.toString());
                return;
            }
            SQLUtils.cleanup((Statement)statement);
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SQLDataException e) {
            throw new SQLException(e.getMessage());
        }
        SQLUtils.cleanup((Connection)con);
        return;
        finally {
            SQLUtils.cleanup(statement);
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void writeBill_unAuditByFpurRequestID(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement srcRateStatement = null;
        Statement statement = null;
        Statement destRateStatement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.fpurRequestEntryID,entry.FQty,entry.fbaseQty ").append(" from T_SM_PurOrderEntry entry").append(" where entry.fpurRequestEntryID is not null").append(" and entry.FParentID in(").append(params).append(") ");
            valueBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
            valueBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-010bc0a813fd463ED552").append("'");
            valueBuffer.append(" order by entry.fseq ");
            ResultSet result = statement.executeQuery(valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                srcRateStatement = con.createStatement();
                destRateStatement = con.createStatement();
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,entry.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurOrderEntry entry").append(" on entry.fpurRequestEntryID is not null").append(" and FParentID in(").append(params).append(")").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID");
                srcBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                srcBuffer.append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")");
                srcBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                srcBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-010bc0a813fd463ED552").append("'");
                srcBuffer.append(" ) temp order by temp.fseq");
                destBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,tempOrder.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurOrderEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.fpurRequestEntryID").append(" where entry.FParentId in(").append(params).append(")");
                destBuffer.append(" and  entry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                destBuffer.append(")tempOrder on tempOrder.FMaterialID = unit.FMaterialID").append(" and tempOrder.destUnit = unit.FMeasureUnitID ").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")");
                destBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
                destBuffer.append(" and  anotherEntry.fsourcebilltypeid <>'").append("510b6503-0105-1000-e000-010bc0a813fd463ED552").append("'");
                destBuffer.append(") temp order by temp.fseq");
                String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty-?,FOrderedBaseQty = FOrderedBaseQty-?,  FUnOrderedQty = FQty - FOrderedQty+?,FUnOrderedBaseQty = FBaseQty-FOrderedBaseQty+? where Fid = ?";
                PreparedStatement updateStatement = con.prepareStatement(updateReqSql);
                ResultSet srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
                ResultSet destRateSet = destRateStatement.executeQuery(destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal qty = null;
                BigDecimal baseQty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                Object destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    if (result.getBigDecimal(2) != null) {
                        qty = result.getBigDecimal(2);
                    }
                    if (result.getBigDecimal(3) != null) {
                        baseQty = result.getBigDecimal(3);
                    }
                    srcRate = srcRateSet.getBigDecimal(1);
                    destRate = destRateSet.getBigDecimal(1);
                    destQty = this.exchangeQtyByUnit(srcRate, destRate, qty, baseQty);
                    if (destRate == null) {
                        destRate = new BigDecimal("1.00");
                    }
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, baseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, baseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
            }
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(sourceEntryIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
                updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =4").append(" where FUnOrderedQty >0 and fid in(").append(sqlParams.toString()).append(")");
                statement.execute(updateCloseReqEntryBuffer.toString());
                StringBuffer updateCloseReqBuffer = new StringBuffer();
                updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 4").append(" where fid in (select FParentid from T_SM_PurRequestEntry where fparentid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append(")))");
                statement.execute(updateCloseReqBuffer.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SQLDataException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceBillForPurContract_unAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty,entry.Fseq").append(" from T_SM_PurOrderEntry entry").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-010bc0a813fd463ED552'").append(" and entry.FParentID in ").append(params).append(" ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            String sp = " \r\n";
            boolean hasRow = false;
            while (rs.next()) {
                hasRow = true;
                StringBuffer strSQL = new StringBuffer();
                sourceEntryIdList.add(count++, rs.getString(1));
                strSQL.append("UPDATE T_SM_PurContractEntry").append(sp);
                strSQL.append("SET (FTotalOrderAmount) =").append(sp);
                strSQL.append("          (SELECT IsNull(T_SM_PurContractEntry.FTotalOrderAmount,0) - IsNull(rbe.FTaxAmount, 0) ").append(sp);
                strSQL.append("               AS FTotalOrderAmount ").append(sp);
                strSQL.append("         FROM t_SM_PurOrderEntry rbe").append(sp);
                strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SM_PurContractEntry.FID AND rbe.FParentID in ").append(params).append(" ").append(sp);
                strSQL.append(" and rbe.Fseq=").append(rs.getString("fseq")).append(")").append(sp);
                strSQL.append("WHERE T_SM_PurContractEntry.FID IN").append(sp);
                strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                strSQL.append("         FROM t_SM_PurOrderEntry rbe").append(sp);
                strSQL.append("         WHERE rbe.FParentid in ").append(params).append(" ").append(sp);
                strSQL.append(" and rbe.Fseq=").append(rs.getString("fseq")).append(")").append(sp);
                statement.addBatch(strSQL.toString());
                StringBuffer qtySqlBuffer = new StringBuffer();
                qtySqlBuffer.append("UPDATE T_SM_PurContractEntry  ").append(sp);
                qtySqlBuffer.append("SET (FTotalOrderQty ) =  ").append(sp);
                qtySqlBuffer.append("       (SELECT IsNull(T_SM_PurContractEntry.FTotalOrderQty,0) - Round(Decimal(IsNull(poe.FBaseQty,0)/IsNull(FBaseConvsRate,1),28,16),mu.FQtyPrecision) AS FTotalOrderQty ").append(sp);
                qtySqlBuffer.append("       FROM T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer.append("\t\tLeft outer join T_BD_MultiMeasureUnit mu On poe.FMaterialID = mu.FMaterialID").append(sp);
                qtySqlBuffer.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer.append("\t\tAnd  T_SM_PurContractEntry.FMaterialID = poe.FMaterialID").append(sp);
                qtySqlBuffer.append("\t\tAnd T_SM_PurContractEntry.FUnitID = mu.FMeasureUnitID").append(sp);
                qtySqlBuffer.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer.append("  \t\tand  T_SM_PurContractEntry.FMaterialID is Not Null").append(sp);
                qtySqlBuffer.append("\t\tAnd  T_SM_PurContractEntry.FMaterialGroupID is null").append(sp);
                qtySqlBuffer.append(")  ").append(sp);
                qtySqlBuffer.append("\tWHERE T_SM_PurContractEntry.FID IN  ").append(sp);
                qtySqlBuffer.append("\t(").append(sp);
                qtySqlBuffer.append("\tSELECT T_SM_PurContractEntry.FID  ").append(sp);
                qtySqlBuffer.append("       FROM T_SM_PurContractEntry,T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer.append("\t\tLeft outer join T_BD_MultiMeasureUnit mu On poe.FMaterialID = mu.FMaterialID").append(sp);
                qtySqlBuffer.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer.append("\t\tAnd  T_SM_PurContractEntry.FMaterialID = poe.FMaterialID").append(sp);
                qtySqlBuffer.append("\t\tAnd T_SM_PurContractEntry.FUnitID = mu.FMeasureUnitID").append(sp);
                qtySqlBuffer.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer.append("  \t\tand  T_SM_PurContractEntry.FMaterialID is Not Null").append(sp);
                qtySqlBuffer.append("\t\tAnd  T_SM_PurContractEntry.FMaterialGroupID is null").append(sp);
                qtySqlBuffer.append("\t)").append(sp);
                statement.addBatch(qtySqlBuffer.toString());
                StringBuffer qtySqlBuffer2 = new StringBuffer();
                qtySqlBuffer2.append("UPDATE T_SM_PurContractEntry  ").append(sp);
                qtySqlBuffer2.append("SET (FTotalOrderQty ) =  ").append(sp);
                qtySqlBuffer2.append("       (SELECT IsNull(T_SM_PurContractEntry.FTotalOrderQty,0) - Round(Decimal(IsNull(poe.FBaseQty,0),28,16),IsNull(munit.FQtyPrecision,0)) AS FTotalOrderQty ").append(sp);
                qtySqlBuffer2.append("       FROM T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer2.append("\t\tLeft outer join T_BD_MeasureUnit munit On poe.FUnitID = munit.FID").append(sp);
                qtySqlBuffer2.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer2.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer2.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer2.append("  \t\tand  T_SM_PurContractEntry.FMaterialID is Null").append(sp);
                qtySqlBuffer2.append("\t\t    And  T_SM_PurContractEntry.FMaterialGroupID is null").append(sp);
                qtySqlBuffer2.append(")  ").append(sp);
                qtySqlBuffer2.append("\tWHERE T_SM_PurContractEntry.FID IN  ").append(sp);
                qtySqlBuffer2.append("\t(").append(sp);
                qtySqlBuffer2.append("\tSELECT T_SM_PurContractEntry.FID  ").append(sp);
                qtySqlBuffer2.append("       FROM T_SM_PurContractEntry,T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer2.append("\t\tLeft outer join T_BD_MeasureUnit munit On poe.FUnitID = munit.FID").append(sp);
                qtySqlBuffer2.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer2.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer2.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer2.append("  \t\tand  T_SM_PurContractEntry.FMaterialID is Null").append(sp);
                qtySqlBuffer2.append("\t\t    And  T_SM_PurContractEntry.FMaterialGroupID is null").append(sp);
                qtySqlBuffer2.append("\t)").append(sp);
                statement.addBatch(qtySqlBuffer2.toString());
                StringBuffer qtySqlBuffer3 = new StringBuffer();
                qtySqlBuffer3.append("UPDATE T_SM_PurContractEntry  ").append(sp);
                qtySqlBuffer3.append("SET (FTotalOrderQty ) =  ").append(sp);
                qtySqlBuffer3.append("       (SELECT IsNull(T_SM_PurContractEntry.FTotalOrderQty,0) - IsNull(poe.FBaseQty,0) AS FTotalOrderQty ").append(sp);
                qtySqlBuffer3.append("       FROM T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer3.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer3.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer3.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer3.append("\t\t    And  T_SM_PurContractEntry.FMaterialGroupID is not null").append(sp);
                qtySqlBuffer3.append(")  ").append(sp);
                qtySqlBuffer3.append("\tWHERE T_SM_PurContractEntry.FID IN  ").append(sp);
                qtySqlBuffer3.append("\t(").append(sp);
                qtySqlBuffer3.append("\tSELECT T_SM_PurContractEntry.FID  ").append(sp);
                qtySqlBuffer3.append("       FROM T_SM_PurContractEntry,T_SM_PurOrderEntry poe  ").append(sp);
                qtySqlBuffer3.append("       WHERE poe.FSourceBillEntryID = T_SM_PurContractEntry.FID ").append(sp);
                qtySqlBuffer3.append("\t\tAND  poe.FParentID IN  ").append(params).append("  ").append(sp);
                qtySqlBuffer3.append("       and poe.Fseq=").append(rs.getString("fseq")).append(sp);
                qtySqlBuffer3.append("\t\t    And  T_SM_PurContractEntry.FMaterialGroupID is not null").append(sp);
                qtySqlBuffer3.append("\t)").append(sp);
                statement.addBatch(qtySqlBuffer3.toString());
            }
            if (hasRow) {
                StringBuffer entryBaseStatusSQL = new StringBuffer();
                entryBaseStatusSQL.append("update t_sm_purcontractEntry set FBaseStatus = 4  ").append(sp);
                entryBaseStatusSQL.append("where FQualityUnCtrl = 0 and FTotalOrderQty <= FQty and FBaseStatus ");
                entryBaseStatusSQL.append("not in (4,-2)  and fid in ");
                entryBaseStatusSQL.append(" (select FSourceBillEntryId from T_SM_PurOrderEntry where FParentID in  ");
                entryBaseStatusSQL.append(params).append(") ").append(sp);
                statement.addBatch(entryBaseStatusSQL.toString());
                StringBuffer sourceEntryID = new StringBuffer();
                for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                    if (i > 0) {
                        sourceEntryID.append(",");
                    }
                    sourceEntryID.append("'");
                    sourceEntryID.append(sourceEntryIdList.get(i).toString());
                    sourceEntryID.append("'");
                }
                StringBuffer updateCloseContractSQL = new StringBuffer();
                updateCloseContractSQL.append(" update ").append(" T_SM_PurContract set FBaseStatus = 4").append(" where fid in (select DISTINCT FParentId from T_SM_PurContractEntry where fid in(").append(sourceEntryID.toString()).append(")) and FBaseStatus <> -2");
                statement.addBatch(updateCloseContractSQL.toString());
                statement.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e.getMessage());
                catch (SQLDataException e2) {
                    throw new SQLException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void clearInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException {
        StringBuffer str = new StringBuffer();
        try {
            String params = SCMBizProcessorUtil.convertToString((Object[])pks);
            str.append(" delete ").append(" T_SM_PurInnerDealPrice ").append(" where FPurOrderId in(").append(params).append(")");
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        catch (BOSException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    private void writeBackToWantReq(Context ctx, IObjectPK[] pks, BizActionEnum enums) throws BOSException, EASBizException {
        int length = pks.length;
        StringBuffer paramQuestionMark = new StringBuffer();
        Object[] curIdArray = new String[length];
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                paramQuestionMark.append("?");
            } else {
                paramQuestionMark.append(",?");
            }
            curIdArray[i] = pks[i].toString();
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select ").append(" FSourceBillId, FSourceBillEntryID").append(" from t_sm_purorderentry ");
            sql.append(" where fparentid in (").append(paramQuestionMark.toString()).append(")");
            sql.append(" and FSourceBillTypeId = '").append("MmEE6VBsR0KaUDQmebwhP0Y+1VI=").append("' ");
            sql.append(" group by FSourceBillId, FSourceBillEntryID ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])curIdArray);
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> srcEntryIDList = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
                srcEntryIDList.add(rs.getString(2));
            }
            if (list.size() > 0) {
                String[] srcIdArr = new String[list.size()];
                list.toArray(srcIdArr);
                IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)new PurOrderInfo().getBOSType(), (String[])srcIdArr);
                for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
                    handlers[j].handle(ctx, enums, (String[])curIdArray, (String[][])null);
                }
                this.howCloseSourceBill(srcEntryIDList, ctx, enums);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private void writeSourceBillForPurPlan_unAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty,entry.FbaseQty ").append(" from T_SM_PurOrderEntry entry").append(" where entry.FSourceBillTypeId = 'Htzs+wEkEADgAAMJwKg9YtAMSuo='").append(" and entry.FParentID in ").append(params).append(" ");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,entry.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurOrderEntry entry").append(" on entry.FSourceBillTypeId = 'Htzs+wEkEADgAAMJwKg9YtAMSuo='").append(" and FParentID in ").append(params).append(" ").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in ").append(params).append(" ").append(") temp order by temp.fseq");
                destBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,tempOrder.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurOrderEntry entry").append(" inner join T_SM_PurPlanEntry requestEntry on requestEntry.fid = entry.FSourceBillEntryId").append(" where entry.FParentId in ").append(params).append(" ").append(")tempOrder on tempOrder.FMaterialID = unit.FMaterialID").append(" and tempOrder.destUnit = unit.FMeasureUnitID ").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurOrderEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in ").append(params).append(" ").append(") temp order by temp.fseq");
                String updateReqSql = "update T_SM_PurPlanEntry set FTotalOrderQty = FTotalOrderQty-?,FTotalOrderBaseQty = FTotalOrderBaseQty-?,  FTotalUnOrderQty = FQty - FTotalOrderQty+?,FTotalUnOrderBaseQty = FBaseQty-FTotalOrderBaseQty+? where Fid = ?";
                PreparedStatement updateStatement = con.prepareStatement(updateReqSql);
                IRowSet srcRateSet = DbUtil.executeQuery((Context)ctx, (String)srcBuffer.toString());
                IRowSet destRateSet = DbUtil.executeQuery((Context)ctx, (String)destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal qty = null;
                BigDecimal baseQty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                Object destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    if (result.getBigDecimal(2) != null) {
                        qty = result.getBigDecimal(2);
                    }
                    if (result.getBigDecimal(3) != null) {
                        baseQty = result.getBigDecimal(3);
                    }
                    srcRate = srcRateSet.getBigDecimal(1);
                    destRate = destRateSet.getBigDecimal(1);
                    destQty = this.exchangeQtyByUnit(srcRate, destRate, qty, baseQty);
                    if (destRate == null) {
                        destRate = new BigDecimal("1.00");
                    }
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, baseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, baseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
                SQLUtils.cleanup((ResultSet)srcRateSet);
                SQLUtils.cleanup((ResultSet)destRateSet);
                SQLUtils.cleanup((Statement)updateStatement);
            }
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(sourceEntryIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
                updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurPlanEntry set FBaseStatus =4").append(" where FTotalUnOrderQty >0 and fid in(").append(sqlParams.toString()).append(")");
                DbUtil.execute((Context)ctx, (String)updateCloseReqEntryBuffer.toString());
                StringBuffer updateCloseReqBuffer = new StringBuffer();
                updateCloseReqBuffer.append(" update ").append(" T_SM_PurPlan set FBaseStatus = 4").append(" where fid in (select FParentid from T_SM_PurPlanEntry where fparentid in (select DISTINCT FParentId from T_SM_PurPlanEntry where fid in(").append(sqlParams.toString()).append(")))");
                DbUtil.execute((Context)ctx, (String)updateCloseReqBuffer.toString());
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SQLDataException e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void writeBackTOSaleOrder(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer querySql = new StringBuffer();
            querySql.append("select poe.Fseq from T_SM_PurOrderEntry poe ");
            querySql.append("  Left outer join T_BD_MultiMeasureUnit mu On poe.FMaterialID = mu.FMaterialID");
            querySql.append("  Left outer join T_SD_SaleOrderEntry soe On soe.FID = poe.FSourceBillEntryID");
            querySql.append("\twhere  poe.FParentID IN ").append(params).append(" ");
            querySql.append("   And  soe.FMaterialID = poe.FMaterialID");
            querySql.append("   And  soe.FUnitID = mu.FMeasureUnitID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            StringBuffer strSQL = new StringBuffer();
            String sp = " \r\n";
            while (rs.next()) {
                strSQL.setLength(0);
                strSQL.append("UPDATE T_SD_SaleOrderEntry").append(sp);
                strSQL.append(" SET (FOrderedQty, FUnOrderedQty) =  ").append(sp);
                strSQL.append(" (SELECT T_SD_SaleOrderEntry.FOrderedQty - Round(Decimal(poe.FBaseQty/IsNull(FBaseConvsRate,1),28,16),mu.FQtyPrecision) AS FOrderedQty,").append(sp);
                strSQL.append(" (T_SD_SaleOrderEntry.FQty + (Round(Decimal(poe.FBaseQty/IsNull(FBaseConvsRate,1),28,16),mu.FQtyPrecision) - T_SD_SaleOrderEntry.FOrderedQty))").append(sp);
                strSQL.append(" AS FUnOrderedQty").append(sp);
                strSQL.append(" FROM T_SM_PurOrderEntry poe  ").append(sp);
                strSQL.append("\tLeft outer join T_BD_MultiMeasureUnit mu On poe.FMaterialID = mu.FMaterialID").append(sp);
                strSQL.append(" WHERE poe.FSourceBillEntryID = T_SD_SaleOrderEntry.FID ").append(sp);
                strSQL.append("\tAnd  poe.FParentID IN ").append(params).append(" ").append(sp);
                strSQL.append("\tAnd  T_SD_SaleOrderEntry.FMaterialID = poe.FMaterialID").append(sp);
                strSQL.append("\tAnd T_SD_SaleOrderEntry.FUnitID = mu.FMeasureUnitID").append(sp);
                strSQL.append(" And poe.fseq=").append(rs.getString("Fseq")).append(sp);
                strSQL.append(" )  ").append(sp);
                strSQL.append(" WHERE T_SD_SaleOrderEntry.FID IN  ").append(sp);
                strSQL.append("\t(").append(sp);
                strSQL.append("\tSELECT T_SD_SaleOrderEntry.FID  ").append(sp);
                strSQL.append(" FROM T_SD_SaleOrderEntry,T_SM_PurOrderEntry poe  ").append(sp);
                strSQL.append(" Left outer join T_BD_MultiMeasureUnit mu On poe.FMaterialID = mu.FMaterialID").append(sp);
                strSQL.append(" WHERE poe.FSourceBillEntryID = T_SD_SaleOrderEntry.FID ").append(sp);
                strSQL.append("\tAND  poe.FParentID IN ").append(params).append(" ").append(sp);
                strSQL.append("\tAnd  T_SD_SaleOrderEntry.FMaterialID = poe.FMaterialID").append(sp);
                strSQL.append("\tAnd T_SD_SaleOrderEntry.FUnitID = mu.FMeasureUnitID").append(sp);
                strSQL.append(" And poe.fseq=").append(rs.getString("Fseq")).append(sp);
                strSQL.append("\t)").append(sp);
                statement.addBatch(strSQL.toString());
            }
            statement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private BigDecimal exchangeQtyByUnit(BigDecimal srcRate, BigDecimal destRate, BigDecimal qty, BigDecimal baseQty) {
        if (srcRate == null) {
            srcRate = new BigDecimal("1.00");
        }
        if (destRate == null) {
            destRate = new BigDecimal("1.00");
        }
        if (destRate.equals(srcRate)) {
            return qty;
        }
        return baseQty.divide(destRate, baseQty.scale(), 0);
    }

    private void howCloseSourceBill(List srcEntryIDList, Context ctx, BizActionEnum enums) throws EASBizException, BOSException {
        boolean isAudit = true;
        if (enums.equals((Object)BizActionEnum.UNAUDIT)) {
            isAudit = false;
        }
        if (srcEntryIDList == null || srcEntryIDList.size() == 0) {
            return;
        }
        if (isAudit) {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoClose(srcEntryIDList);
        } else {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoUnClose(srcEntryIDList);
        }
    }
}

