/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorderchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeException;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeFactory;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurOrderChange2PurOrder4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1894785923729432269L;
    private static Logger logger = Logger.getLogger((String)PurOrderChange2PurOrder4AuditProcessor.class.getName());
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");

    public PurOrderChange2PurOrder4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderChange2PurOrder4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderChange2PurOrder4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        PurOrderChangeEntryCollection entries = null;
        String purOrderId = null;
        String purOrderEntryId = null;
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            PurOrderChangeInfo purOrderChangeInfo = (PurOrderChangeInfo)objCol.getObject(i);
            HashSet<String> oldPurOrderIdSet = new HashSet<String>();
            HashSet<String> oldPurOrderEntryIdSet = new HashSet<String>();
            HashMap<String, PurOrderEntryInfo> oldPurOrderEntryMap = new HashMap<String, PurOrderEntryInfo>();
            if (ChangeTypeEnum.fieldChange.equals((Object)purOrderChangeInfo.getChangeType())) {
                entries = purOrderChangeInfo.getEntries();
                int len = entries.size();
                for (int j = 0; j < len; ++j) {
                    PurOrderChangeEntryInfo changeEntry = entries.get(j);
                    purOrderId = changeEntry.getPurOrder().getId().toString();
                    purOrderEntryId = changeEntry.getPurOrderEntry().getId().toString();
                    oldPurOrderIdSet.add(purOrderId);
                    oldPurOrderEntryIdSet.add(purOrderEntryId);
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(PurBgCtrlUtil.getPurOrderEntryForBgSelector());
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", oldPurOrderEntryIdSet, CompareType.INCLUDE));
            evi.setFilter(filter);
            PurOrderEntryCollection oldPurOrderCol = PurOrderEntryFactory.getLocalInstance((Context)this.ctx).getPurOrderEntryCollection(evi);
            PurOrderEntryInfo purOrderEntryInfo = null;
            int ksize = oldPurOrderCol.size();
            for (int k = 0; k < ksize; ++k) {
                purOrderEntryInfo = oldPurOrderCol.get(k);
                if (purOrderEntryInfo.getParent().getSourceBillType() == null || !"510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(purOrderEntryInfo.getParent().getSourceBillType().getId().toString())) {
                    oldPurOrderEntryIdSet.remove(purOrderEntryInfo.getId().toString());
                    oldPurOrderIdSet.remove(purOrderEntryInfo.getParent().getId().toString());
                    continue;
                }
                oldPurOrderEntryMap.put(purOrderEntryInfo.getId().toString(), purOrderEntryInfo);
            }
            try {
                this.setQty(purOrderChangeInfo, batchResults);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (!ChangeTypeEnum.fieldChange.equals((Object)purOrderChangeInfo.getChangeType()) || !PurBgCtrlUtil.isNewPurBudget((Context)this.ctx).booleanValue()) continue;
            PurBgCtrlUtil.writeBgExecuteAmoutFromPurOrderChange((Context)this.ctx, oldPurOrderIdSet, oldPurOrderEntryIdSet, oldPurOrderEntryMap);
        }
    }

    private void setQty(PurOrderChangeInfo purOrderChangeInfo, BatchActionResults batchResults) throws EASBizException, BOSException, SQLException {
        HashSet<String> proIDs = new HashSet<String>();
        HashMap<String, String> porEntryIDMap = new HashMap<String, String>();
        String purOrderId = null;
        String purOrderEntryId = null;
        logger.error((Object)"\u5f00\u59cb\u53d8\u66f4\u4e86-----");
        if (ChangeTypeEnum.entryChange.equals((Object)purOrderChangeInfo.getChangeType())) {
            PurOrderChangeEntryCollection entries = purOrderChangeInfo.getEntries();
            for (int j = entries.size() - 1; j >= 0; --j) {
                PurOrderChangeEntryInfo changeEntry = entries.get(j);
                purOrderId = changeEntry.getPurOrder().getId().toString();
                purOrderEntryId = changeEntry.getPurOrderEntry().getId().toString();
                proIDs.add(purOrderId);
                logger.error((Object)("\u8ba2\u5355ID" + purOrderId));
                porEntryIDMap.put(purOrderEntryId, changeEntry.getId().toString());
                logger.error((Object)("\u8ba2\u5355\u5206\u5f55ID" + purOrderEntryId));
            }
        }
        logger.error((Object)("\u8ba2\u5355ID\u8fc7\u6ee4\u6761\u4ef6" + ((Object)proIDs).toString()));
        Map<String, PurOrderInfo> porMap = this.getPurCol(this.ctx, proIDs);
        logger.error((Object)("\u8ba2\u5355\u5206\u5f55ID\u8fc7\u6ee4\u6761\u4ef6" + porEntryIDMap.keySet().toString()));
        Map<String, PurOrderEntryInfo> proEntryMap = this.getPurOrderEntryCol(this.ctx, porEntryIDMap.keySet());
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        if (purOrderChangeInfo.getSourceBillType() != null) {
            this.dealOrderAndPre(this.ctx, params.toString(), pks.length, purOrderChangeInfo);
        } else if (ChangeTypeEnum.entryChange == purOrderChangeInfo.getChangeType()) {
            this.dealPurOrderByEntryChange(this.ctx, params.toString(), pks.length, purOrderChangeInfo, porMap, proEntryMap);
        } else {
            try {
                this.dealPurOrder(this.ctx, params.toString(), pks.length, purOrderChangeInfo);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void dealOrderAndPre(Context ctx, String params, int length, PurOrderChangeInfo purOrderChangeInfo) throws SQLException, EASBizException, BOSException {
        Connection con = null;
        Statement srcRateStatement = null;
        Object statement = null;
        Statement destRateStatement = null;
        con = SCMBizProcessorUtil.getConnection((Context)ctx);
        srcRateStatement = con.createStatement();
        destRateStatement = con.createStatement();
        PurOrderChangeEntryCollection purcol = purOrderChangeInfo.getEntries();
        StringBuffer srcBuffer = new StringBuffer();
        HashMap<String, BigDecimal> changeQtyMap = new HashMap<String, BigDecimal>();
        StringBuffer purOrderIDBuffer = new StringBuffer();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> changeQtyReqCMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> seqMap = new HashMap<String, String>();
        HashMap<String, Integer> changeDaysMap = new HashMap<String, Integer>();
        ArrayList<String> porIDList = new ArrayList<String>();
        HashMap<String, String> sourceBillId = new HashMap<String, String>();
        srcBuffer.append(" select entry.FPURORDERENTRYID,entry.FChangeQty,entry.FID ,entry.fpurOrderId, entry.FSOURCEBILLENTRYID,entry.Fseq,entry.FChangeDays").append(" from T_SM_PurOrderChangeEntry entry").append(" where entry.FPurOrderEntryID is not null").append(" and entry.FParentID in(").append(params).append(")");
        ResultSet srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
        StringBuffer OrderIDBuffer = new StringBuffer();
        StringBuffer preEntryIDBuffer = new StringBuffer();
        while (srcRateSet.next()) {
            if (srcRateSet.getString(1) == null || srcRateSet.getBigDecimal(2) == null) continue;
            changeQtyMap.put(srcRateSet.getString(1), srcRateSet.getBigDecimal(2));
            idMap.put(srcRateSet.getString(1), srcRateSet.getString(3));
            sourceBillId.put(srcRateSet.getString(1), srcRateSet.getString(4));
            if (changeQtyReqCMap.get(srcRateSet.getString(5)) == null) {
                changeQtyReqCMap.put(srcRateSet.getString(5), srcRateSet.getBigDecimal(2));
            } else {
                BigDecimal oldchangeQty = (BigDecimal)changeQtyReqCMap.get(srcRateSet.getString(5));
                BigDecimal newChangeQty = srcRateSet.getBigDecimal(2).add(oldchangeQty);
                changeQtyReqCMap.put(srcRateSet.getString(5), newChangeQty);
            }
            seqMap.put(srcRateSet.getString(1), srcRateSet.getString(6));
            changeDaysMap.put(srcRateSet.getString(1), srcRateSet.getInt(7));
            if (purOrderIDBuffer.length() != 0) {
                purOrderIDBuffer.append(",");
                OrderIDBuffer.append(",");
                preEntryIDBuffer.append(",");
            }
            purOrderIDBuffer.append("'");
            purOrderIDBuffer.append(srcRateSet.getString(1));
            purOrderIDBuffer.append("'");
            OrderIDBuffer.append("'");
            OrderIDBuffer.append(srcRateSet.getString(4));
            OrderIDBuffer.append("'");
            preEntryIDBuffer.append("'");
            preEntryIDBuffer.append(srcRateSet.getString(5));
            preEntryIDBuffer.append("'");
            porIDList.add(srcRateSet.getString(4));
        }
        HashMap<String, String> preMap = new HashMap<String, String>();
        HashMap changeQtyReqMap = new HashMap();
        String preSql = "SELECT fid,FPurRequestEntryID FROM T_SM_purrequestChangeentry where fid in ( " + preEntryIDBuffer.toString() + " )";
        ResultSet preRateSet = srcRateStatement.executeQuery(preSql);
        while (preRateSet.next()) {
            preMap.put(preRateSet.getString(2), preRateSet.getString(1));
            changeQtyReqMap.put(preRateSet.getString(2), changeQtyReqCMap.get(preRateSet.getString(1)));
        }
        Map<String, PurOrderEntryInfo> purEntryMap = this.getPurOrderEntryCol(ctx, idMap.keySet());
        StringBuffer destBuffer = new StringBuffer();
        destBuffer.append("select entry.FSOURCEBILLID,entry.Fid,entry.Fqty,entry.FtotalReceiveQty,entry.FTotalReceiptQty,entry.FTotalReturnedQty,entry.FTotalCancelledStockQty,entry.FMaterialID,entry.FUnitID,entry.FBaseUnitID,entry.FSOURCEBILLENTRYID,entry.FPARENTID,entry.FDISCOUNTRATE,entry.FTAXPRICE,entry.ftaxRate,entry.FPRICE,entry.FASSISTUNITID,entry.FDELIVERYDATE").append(" from T_SM_PurOrderEntry entry").append(" where entry.FbaseStatus = 4").append(" and entry.FID in(").append(purOrderIDBuffer.toString()).append(")");
        ResultSet destRateSet = destRateStatement.executeQuery(destBuffer.toString());
        String updateOrderEntrySql = "update T_SM_PurOrderEntry set FQty =FQty+ ?,FBaseQty = FBaseQty+?,FAMOUNT = FAMOUNT+?,FTAX = FTAX+?,FDISCOUNTAMOUNT = FDISCOUNTAMOUNT+?,FTAXAMOUNT = FTAXAMOUNT+?,FLOCALTAX = FLOCALTAX+?,FLOCALTAXAMOUNT=FLOCALTAXAMOUNT+?,FLOCALAMOUNT=FLOCALAMOUNT+?,FASSOCIATEQTY = FASSOCIATEQTY+? ,FACTUALTAXPRICE  = FACTUALTAXPRICE+? ,FACTUALPRICE = FACTUALPRICE+?,FASSISTQTY = FASSISTQTY+?,FDELIVERYDATE = ADD_DAYS(FDELIVERYDATE, ?),FBaseStatus = ? where FID = ?";
        PreparedStatement updatOrderEntryStatement = con.prepareStatement(updateOrderEntrySql);
        String updateOrderSql = "UPDATE T_SM_PurOrder SET FTOTALAMOUNT =FTOTALAMOUNT + ?,FTOTALTAX = FTOTALTAX + ?,FTOTALTAXAMOUNT = FTOTALTAXAMOUNT +?  WHERE  FID = ?";
        PreparedStatement updatOrderStatement = con.prepareStatement(updateOrderSql);
        String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty =FOrderedQty+ ?,ForderedBaseQty =ForderedBaseQty+ ? where Fid = ?";
        PreparedStatement updateReqStatement = con.prepareStatement(updateReqSql);
        String updateOrderChangeSql = "update T_SM_PurOrderChangeEntry set FrealChangeQty = ?,FrealChangeBaseQty = ?,FAfterChangeQty = ?,FAfterChangeBaseQty = ? , FRealChangeDays = ? where Fid = ?";
        PreparedStatement updateOrderChangeStatement = con.prepareStatement(updateOrderChangeSql);
        boolean isExistpre = false;
        HashMap<String, String> reqAndEntry = new HashMap<String, String>();
        ArrayList<String> reqIDList = new ArrayList<String>();
        while (destRateSet.next()) {
            String sourceBill = destRateSet.getString(1);
            String orderID = destRateSet.getString(12);
            String orderEntryID = destRateSet.getString(2);
            BigDecimal qty = destRateSet.getBigDecimal(3);
            BigDecimal totalReceiveQty = destRateSet.getBigDecimal(4);
            BigDecimal totalReceiptQty = destRateSet.getBigDecimal(5);
            BigDecimal totalReturnedQty = destRateSet.getBigDecimal(6);
            BigDecimal totalSupplyStockQty = destRateSet.getBigDecimal(7);
            BigDecimal allowChangeQty = BIGZERO;
            BigDecimal afterChangeQty = null;
            BigDecimal afterChangeBaseQty = null;
            BigDecimal changeQty = (BigDecimal)changeQtyMap.get(destRateSet.getString(2));
            BigDecimal realChangeQty = (BigDecimal)changeQtyMap.get(destRateSet.getString(2));
            BigDecimal realChangeBaseQty = null;
            BigDecimal changeBaseQty = null;
            allowChangeQty = qty.compareTo(totalReceiveQty) == -1 ? BIGZERO : (totalReceiveQty.compareTo(totalReceiptQty.subtract(totalSupplyStockQty)) == -1 ? qty.subtract(totalReceiptQty.subtract(totalSupplyStockQty)) : qty.subtract(totalReceiveQty));
            int changeDays = 0;
            if (null != changeDaysMap.get(destRateSet.getString(2))) {
                changeDays = (Integer)changeDaysMap.get(destRateSet.getString(2));
            }
            int realChangeDays = changeDays;
            boolean flag = false;
            if (changeQty.add(allowChangeQty).compareTo(BIGZERO) == -1) {
                if (allowChangeQty.compareTo(BIGZERO) == 0) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"ENTRY_FIELD_CANNOT_ZERO_QTY", (Object[])new Object[]{seqMap.get(destRateSet.getString(2)), allowChangeQty});
                    throw new PurOrderChangeException(PurOrderChangeException.ENTRY_FIELD_CANNOT_QTY, (Object[])new String[]{msg});
                }
                realChangeQty = changeQty = allowChangeQty.multiply(new BigDecimal("-1"));
                realChangeDays = changeDays;
                flag = true;
            } else if (changeQty.compareTo(BIGZERO) == 0) {
                realChangeQty = BIGZERO;
                realChangeDays = changeDays;
            } else if (changeQty.compareTo(BIGZERO) == 1) {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
            } else if (changeQty.add(allowChangeQty).compareTo(BIGZERO) <= 0) {
                realChangeQty = changeQty = allowChangeQty.multiply(new BigDecimal("-1"));
                realChangeDays = changeDays;
                flag = true;
            } else {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
            }
            String materialID = destRateSet.getString(8);
            BigDecimal assistQty = BIGZERO;
            String unitID = destRateSet.getString(9);
            String baseUnitID = destRateSet.getString(10);
            String assistUnitID = destRateSet.getString(17);
            if (null != materialID) {
                if (assistUnitID != null) {
                    assistQty = this.getBaseUnitQty(materialID, unitID, assistUnitID, realChangeQty);
                }
                realChangeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, realChangeQty);
                changeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, changeQty);
            } else {
                realChangeBaseQty = realChangeQty;
                changeBaseQty = changeQty;
            }
            PurOrderEntryInfo entry = purEntryMap.get(destRateSet.getString(2));
            afterChangeQty = entry.getQty().add(realChangeQty);
            afterChangeBaseQty = entry.getBaseQty().add(changeBaseQty);
            entry.setQty(realChangeQty);
            entry.setBaseQty(realChangeBaseQty);
            this.handRelationParams(ctx, entry);
            updatOrderEntryStatement.setBigDecimal(1, changeQty);
            updatOrderEntryStatement.setBigDecimal(2, changeBaseQty);
            updatOrderEntryStatement.setBigDecimal(3, entry.getAmount());
            updatOrderEntryStatement.setBigDecimal(4, entry.getTax());
            updatOrderEntryStatement.setBigDecimal(5, entry.getDiscountAmount());
            updatOrderEntryStatement.setBigDecimal(6, entry.getTaxAmount());
            updatOrderEntryStatement.setBigDecimal(7, entry.getLocalTax());
            updatOrderEntryStatement.setBigDecimal(8, entry.getLocalTaxAmount());
            updatOrderEntryStatement.setBigDecimal(9, entry.getLocalAmount());
            updatOrderEntryStatement.setBigDecimal(10, changeQty);
            updatOrderEntryStatement.setBigDecimal(11, entry.getActualTaxPrice());
            updatOrderEntryStatement.setBigDecimal(12, entry.getActualPrice());
            updatOrderEntryStatement.setBigDecimal(13, assistQty);
            updatOrderEntryStatement.setInt(14, changeDays);
            if (flag) {
                updatOrderEntryStatement.setInt(15, 7);
            } else {
                updatOrderEntryStatement.setInt(15, 4);
            }
            updatOrderEntryStatement.setString(16, destRateSet.getString(2));
            updatOrderEntryStatement.addBatch();
            updatOrderStatement.setBigDecimal(1, entry.getAmount());
            updatOrderStatement.setBigDecimal(2, entry.getTax());
            updatOrderStatement.setBigDecimal(3, entry.getTaxAmount());
            updatOrderStatement.setString(4, entry.getParent().getId().toString());
            updatOrderStatement.addBatch();
            updateOrderChangeStatement.setBigDecimal(1, realChangeQty);
            updateOrderChangeStatement.setBigDecimal(2, realChangeBaseQty);
            updateOrderChangeStatement.setBigDecimal(3, afterChangeQty);
            updateOrderChangeStatement.setBigDecimal(4, afterChangeBaseQty);
            updateOrderChangeStatement.setInt(5, realChangeDays);
            updateOrderChangeStatement.setString(6, idMap.get(destRateSet.getString(2)).toString());
            updateOrderChangeStatement.addBatch();
            if (sourceBill != null) {
                updateReqStatement.setBigDecimal(1, changeQty);
                updateReqStatement.setBigDecimal(2, changeBaseQty);
                updateReqStatement.setString(3, destRateSet.getString(11));
                updateReqStatement.addBatch();
                isExistpre = true;
            }
            if (flag) {
                if (!reqIDList.contains(orderID)) {
                    String ids = reqAndEntry.get(orderID) == null ? "" : (String)reqAndEntry.get(orderID);
                    ids = ids.equalsIgnoreCase("") ? "'" + orderEntryID + "'" : ids + ",'" + orderEntryID + "'";
                    reqAndEntry.put(orderID, ids);
                    continue;
                }
                reqAndEntry.remove(orderID);
                continue;
            }
            reqIDList.add(orderID);
            reqAndEntry.remove(orderID);
        }
        updatOrderEntryStatement.executeBatch();
        updatOrderStatement.executeBatch();
        this.writreBackPrepayment(ctx, porIDList);
        String updateOrderStatusSql = "update T_SM_PurOrder set FBaseStatus = ?  where Fid = ?";
        PreparedStatement updateOrderStatusStatement = con.prepareStatement(updateOrderStatusSql);
        Statement notCloseEntryStatement = con.createStatement();
        for (String key : reqAndEntry.keySet()) {
            StringBuffer notCloseEntryBuffer = new StringBuffer();
            int reqStatus = 4;
            String ids = (String)reqAndEntry.get(key);
            notCloseEntryBuffer.append("select FID from T_SM_PurOrderEntry where FParentID = '").append(key).append("' and FBaseStatus = 4").append(" and FID not in(").append(ids).append(")");
            ResultSet notCloseEntryRateSet = notCloseEntryStatement.executeQuery(notCloseEntryBuffer.toString());
            if (!notCloseEntryRateSet.next()) {
                reqStatus = 7;
            }
            updateOrderStatusStatement.setInt(1, reqStatus);
            updateOrderStatusStatement.setString(2, key);
            updateOrderStatusStatement.addBatch();
        }
        updateOrderStatusStatement.executeBatch();
        if (isExistpre) {
            updateReqStatement.executeBatch();
        }
        updateOrderChangeStatement.executeBatch();
        PurRequestChangeFactory.getLocalInstance((Context)ctx).handleWriteBackForPurReq(changeQtyReqMap, preMap, null, false);
    }

    private void dealPurOrder(Context ctx, String params, int length, PurOrderChangeInfo purOrderChangeInfo) throws SQLException, BOSException, EASBizException {
        Connection con = null;
        Statement srcRateStatement = null;
        Object statement = null;
        Statement destRateStatement = null;
        con = SCMBizProcessorUtil.getConnection((Context)ctx);
        srcRateStatement = con.createStatement();
        destRateStatement = con.createStatement();
        StringBuffer srcBuffer = new StringBuffer();
        PurOrderChangeEntryCollection purcol = purOrderChangeInfo.getEntries();
        HashMap<String, BigDecimal> changeQtyMap = new HashMap<String, BigDecimal>();
        StringBuffer purOrderIDBuffer = new StringBuffer();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, String> seqMap = new HashMap<String, String>();
        HashMap<String, Integer> changeDaysMap = new HashMap<String, Integer>();
        HashMap<String, String> reqAndEntry = new HashMap<String, String>();
        ArrayList<String> reqIDList = new ArrayList<String>();
        ArrayList<String> porIDList = new ArrayList<String>();
        HashMap<String, String> sourceBillId = new HashMap<String, String>();
        srcBuffer.append(" select entry.FPURORDERENTRYID,entry.FChangeQty,entry.FID ,entry.fpurOrderId,entry.FSEQ,entry.FChangeDays").append(" from T_SM_PurOrderChangeEntry entry").append(" where entry.FPurOrderEntryID is not null").append(" and entry.FParentID in(").append(params).append(")");
        ResultSet srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
        StringBuffer OrderIDBuffer = new StringBuffer();
        while (srcRateSet.next()) {
            if (srcRateSet.getString(1) == null || srcRateSet.getBigDecimal(2) == null) continue;
            changeQtyMap.put(srcRateSet.getString(1), srcRateSet.getBigDecimal(2));
            idMap.put(srcRateSet.getString(1), srcRateSet.getString(3));
            sourceBillId.put(srcRateSet.getString(1), srcRateSet.getString(4));
            seqMap.put(srcRateSet.getString(1), srcRateSet.getString(5));
            changeDaysMap.put(srcRateSet.getString(1), srcRateSet.getInt(6));
            if (purOrderIDBuffer.length() != 0) {
                purOrderIDBuffer.append(",");
                OrderIDBuffer.append(",");
            }
            purOrderIDBuffer.append("'");
            purOrderIDBuffer.append(srcRateSet.getString(1));
            purOrderIDBuffer.append("'");
            OrderIDBuffer.append("'");
            OrderIDBuffer.append(srcRateSet.getString(4));
            OrderIDBuffer.append("'");
            porIDList.add(srcRateSet.getString(4));
        }
        Map<String, PurOrderEntryInfo> purEntryMap = this.getPurOrderEntryCol(ctx, idMap.keySet());
        HashMap<String, String> taxMap = new HashMap<String, String>();
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        StringBuffer OrderBuffer = new StringBuffer();
        OrderBuffer.append("SELECT FISINTAX,FID,FCURRENCYID  FROM T_SM_purOrder where FID in(" + OrderIDBuffer.toString() + ")");
        ResultSet orderIDRateSet = srcRateStatement.executeQuery(OrderBuffer.toString());
        while (orderIDRateSet.next()) {
            taxMap.put(orderIDRateSet.getString(2), orderIDRateSet.getString(1));
            currencyMap.put(orderIDRateSet.getString(2), orderIDRateSet.getString(3));
        }
        StringBuffer destBuffer = new StringBuffer();
        destBuffer.append("select entry.FSOURCEBILLID,entry.Fid,entry.Fqty,entry.FtotalReceiveQty,entry.FTotalReceiptQty,entry.FTotalReturnedQty,entry.FTotalCancelledStockQty,entry.FMaterialID,entry.FUnitID,entry.FBaseUnitID,entry.FSOURCEBILLENTRYID,entry.FPARENTID,entry.FDISCOUNTRATE,entry.FTAXPRICE,entry.ftaxRate,entry.FPRICE,entry.FASSISTUNITID,entry.FDELIVERYDATE").append(" from T_SM_PurOrderEntry entry").append(" where (entry.FbaseStatus = 4 or entry.FbaseStatus = 7)").append(" and entry.FID in(").append(purOrderIDBuffer.toString()).append(")");
        ResultSet destRateSet = destRateStatement.executeQuery(destBuffer.toString());
        String updateOrderEntrySql = "update T_SM_PurOrderEntry set FQty =FQty+ ?,FBaseQty = FBaseQty+?,FAMOUNT = FAMOUNT+?,FTAX = FTAX+?,FDISCOUNTAMOUNT = FDISCOUNTAMOUNT+?,FTAXAMOUNT = FTAXAMOUNT+?,FLOCALTAX = FLOCALTAX+?,FLOCALTAXAMOUNT=FLOCALTAXAMOUNT+?,FLOCALAMOUNT=FLOCALAMOUNT+?,FASSOCIATEQTY = FASSOCIATEQTY+? ,FACTUALTAXPRICE  = ? ,FACTUALPRICE = ?,FASSISTQTY = FASSISTQTY+?,FDELIVERYDATE = ADD_DAYS(FDELIVERYDATE, ?),FBaseStatus = ?,FTOTALUNRETURNBASEQTY = FTOTALUNRETURNBASEQTY+?,FTOTALUNRECEIVEBASEQTY = FTOTALUNRECEIVEBASEQTY+?,FTOTALUNRECEIVEQTY = FTOTALUNRECEIVEQTY+?,FCANINVMOVEQTY = FCANINVMOVEQTY+?,FUNORDEREDQTY = FUNORDEREDQTY+? where FID = ?";
        PreparedStatement updatOrderEntryStatement = con.prepareStatement(updateOrderEntrySql);
        String updateOrderSql = "UPDATE T_SM_PurOrder SET FTOTALAMOUNT =FTOTALAMOUNT + ?,FTOTALTAX = FTOTALTAX + ?,FTOTALTAXAMOUNT = FTOTALTAXAMOUNT +?  WHERE  FID = ?";
        PreparedStatement updatOrderStatement = con.prepareStatement(updateOrderSql);
        String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty =FOrderedQty+ ?,ForderedBaseQty =ForderedBaseQty+ ? where Fid = ?";
        PreparedStatement updateReqStatement = con.prepareStatement(updateReqSql);
        String updateOrderChangeSql = "update T_SM_PurOrderChangeEntry set FrealChangeQty = ?,FrealChangeBaseQty = ?,FAfterChangeQty = ?,FAfterChangeBaseQty = ?,FRealChangeDays = ?  where Fid = ?";
        PreparedStatement updateOrderChangeStatement = con.prepareStatement(updateOrderChangeSql);
        boolean i = true;
        boolean isExistpre = false;
        while (destRateSet.next()) {
            String sourceBill = destRateSet.getString(1);
            BigDecimal qty = destRateSet.getBigDecimal(3);
            String orderID = destRateSet.getString(12);
            String orderEntryID = destRateSet.getString(2);
            BigDecimal totalReceiveQty = destRateSet.getBigDecimal(4);
            BigDecimal totalReceiptQty = destRateSet.getBigDecimal(5);
            BigDecimal totalReturnedQty = destRateSet.getBigDecimal(6);
            BigDecimal totalSupplyStockQty = destRateSet.getBigDecimal(7);
            BigDecimal allowChangeQty = BIGZERO;
            BigDecimal afterChangeQty = null;
            BigDecimal afterChangeBaseQty = null;
            BigDecimal changeQty = (BigDecimal)changeQtyMap.get(destRateSet.getString(2));
            int entryStatus = 4;
            BigDecimal realChangeQty = (BigDecimal)changeQtyMap.get(destRateSet.getString(2));
            BigDecimal realChangeBaseQty = null;
            BigDecimal changeBaseQty = null;
            int changeDays = 0;
            if (null != changeDaysMap.get(destRateSet.getString(2))) {
                changeDays = (Integer)changeDaysMap.get(destRateSet.getString(2));
            }
            int realChangeDays = changeDays;
            boolean flag = false;
            allowChangeQty = qty.compareTo(totalReceiveQty) == -1 ? BIGZERO : (totalReceiveQty.compareTo(totalReceiptQty.subtract(totalSupplyStockQty)) == -1 ? qty.subtract(totalReceiptQty.subtract(totalSupplyStockQty)) : qty.subtract(totalReceiveQty));
            if (changeQty.add(allowChangeQty).compareTo(BIGZERO) == -1) {
                if (allowChangeQty.compareTo(BIGZERO) == 0) {
                    if (changeDays == 0) {
                        String msg = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"ENTRY_FIELD_CANNOT_ZERO_QTY", (Object[])new Object[]{(String)seqMap.get(destRateSet.getString(2)), allowChangeQty});
                        throw new PurOrderChangeException(PurOrderChangeException.ENTRY_FIELD_CANNOT_QTY, (Object[])new String[]{msg});
                    }
                    realChangeQty = BIGZERO;
                } else {
                    realChangeQty = changeQty = allowChangeQty.multiply(new BigDecimal("-1"));
                    realChangeDays = changeDays;
                    flag = true;
                    entryStatus = 7;
                }
            } else if (changeQty.compareTo(BIGZERO) == 0) {
                realChangeQty = BIGZERO;
                realChangeDays = changeDays;
            } else if (changeQty.compareTo(BIGZERO) == 1) {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
                flag = true;
            } else if (changeQty.add(allowChangeQty).compareTo(BIGZERO) <= 0) {
                realChangeQty = changeQty = allowChangeQty.multiply(new BigDecimal("-1"));
                realChangeDays = changeDays;
                flag = true;
                entryStatus = 7;
            } else {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
            }
            String materialID = destRateSet.getString(8);
            BigDecimal assistQty = BIGZERO;
            String unitID = destRateSet.getString(9);
            String baseUnitID = destRateSet.getString(10);
            String assistUnitID = destRateSet.getString(17);
            if (null != materialID) {
                if (assistUnitID != null) {
                    assistQty = this.getBaseUnitQty(materialID, unitID, assistUnitID, realChangeQty);
                }
                realChangeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, realChangeQty);
                changeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, changeQty);
            } else {
                realChangeBaseQty = realChangeQty;
                changeBaseQty = changeQty;
            }
            PurOrderEntryInfo entry = purEntryMap.get(destRateSet.getString(2));
            afterChangeQty = entry.getQty().add(realChangeQty);
            afterChangeBaseQty = entry.getBaseQty().add(realChangeBaseQty);
            entry.setQty(realChangeQty);
            entry.setBaseQty(realChangeBaseQty);
            this.handRelationParams(ctx, entry);
            updatOrderEntryStatement.setBigDecimal(1, realChangeQty);
            updatOrderEntryStatement.setBigDecimal(2, realChangeBaseQty);
            updatOrderEntryStatement.setBigDecimal(3, entry.getAmount());
            updatOrderEntryStatement.setBigDecimal(4, entry.getTax());
            updatOrderEntryStatement.setBigDecimal(5, entry.getDiscountAmount());
            updatOrderEntryStatement.setBigDecimal(6, entry.getTaxAmount());
            updatOrderEntryStatement.setBigDecimal(7, entry.getLocalTax());
            updatOrderEntryStatement.setBigDecimal(8, entry.getLocalTaxAmount());
            updatOrderEntryStatement.setBigDecimal(9, entry.getLocalAmount());
            updatOrderEntryStatement.setBigDecimal(10, changeQty);
            updatOrderEntryStatement.setBigDecimal(11, entry.getActualTaxPrice());
            updatOrderEntryStatement.setBigDecimal(12, entry.getActualPrice());
            updatOrderEntryStatement.setBigDecimal(13, assistQty);
            updatOrderEntryStatement.setInt(14, changeDays);
            updatOrderEntryStatement.setInt(15, entryStatus);
            updatOrderEntryStatement.setBigDecimal(16, realChangeBaseQty);
            updatOrderEntryStatement.setBigDecimal(17, realChangeBaseQty);
            updatOrderEntryStatement.setBigDecimal(18, realChangeQty);
            updatOrderEntryStatement.setBigDecimal(19, realChangeQty);
            updatOrderEntryStatement.setBigDecimal(20, realChangeQty);
            updatOrderEntryStatement.setString(21, destRateSet.getString(2));
            updatOrderEntryStatement.addBatch();
            updatOrderStatement.setBigDecimal(1, entry.getAmount());
            updatOrderStatement.setBigDecimal(2, entry.getTax());
            updatOrderStatement.setBigDecimal(3, entry.getTaxAmount());
            updatOrderStatement.setString(4, entry.getParent().getId().toString());
            updatOrderStatement.addBatch();
            updateOrderChangeStatement.setBigDecimal(1, realChangeQty);
            updateOrderChangeStatement.setBigDecimal(2, realChangeBaseQty);
            updateOrderChangeStatement.setBigDecimal(3, afterChangeQty);
            updateOrderChangeStatement.setBigDecimal(4, afterChangeBaseQty);
            updateOrderChangeStatement.setInt(5, realChangeDays);
            updateOrderChangeStatement.setString(6, idMap.get(destRateSet.getString(2)).toString());
            updateOrderChangeStatement.addBatch();
            if (sourceBill != null) {
                updateReqStatement.setBigDecimal(1, changeQty);
                updateReqStatement.setBigDecimal(2, changeBaseQty);
                updateReqStatement.setString(3, destRateSet.getString(11));
                updateReqStatement.addBatch();
                isExistpre = true;
            }
            if (flag) {
                if (!reqIDList.contains(orderID)) {
                    String ids = reqAndEntry.get(orderID) == null ? "" : (String)reqAndEntry.get(orderID);
                    ids = ids.equalsIgnoreCase("") ? "'" + orderEntryID + "'" : ids + ",'" + orderEntryID + "'";
                    reqAndEntry.put(orderID, ids);
                    continue;
                }
                reqAndEntry.remove(orderID);
                continue;
            }
            reqIDList.add(orderID);
            reqAndEntry.remove(orderID);
        }
        updatOrderEntryStatement.executeBatch();
        updatOrderStatement.executeBatch();
        this.writreBackPrepayment(ctx, porIDList);
        String updateOrderStatusSql = "update T_SM_PurOrder set FBaseStatus = ?  where Fid = ?";
        PreparedStatement updateOrderStatusStatement = con.prepareStatement(updateOrderStatusSql);
        Statement notCloseEntryStatement = con.createStatement();
        for (String key : reqAndEntry.keySet()) {
            StringBuffer notCloseEntryBuffer = new StringBuffer();
            int reqStatus = 4;
            String ids = (String)reqAndEntry.get(key);
            notCloseEntryBuffer.append("select FID from T_SM_PurorderEntry where FParentID = '").append(key).append("' and FBaseStatus = 4");
            ResultSet notCloseEntryRateSet = notCloseEntryStatement.executeQuery(notCloseEntryBuffer.toString());
            if (!notCloseEntryRateSet.next()) {
                reqStatus = 7;
            }
            updateOrderStatusStatement.setInt(1, reqStatus);
            updateOrderStatusStatement.setString(2, key);
            updateOrderStatusStatement.addBatch();
        }
        updateOrderStatusStatement.executeBatch();
        if (isExistpre) {
            updateReqStatement.executeBatch();
        }
        updateOrderChangeStatement.executeBatch();
    }

    private void dealPurOrderByEntryChange(Context ctx, String params, int length, PurOrderChangeInfo purOrderChangeInfo, Map<String, PurOrderInfo> porMap, Map<String, PurOrderEntryInfo> porEntryMap) throws SQLException, BOSException, EASBizException {
        PurOrderChangeEntryInfo changEntry;
        int i;
        Connection con = null;
        con = SCMBizProcessorUtil.getConnection((Context)ctx);
        PurOrderChangeEntryCollection purEntrycol = purOrderChangeInfo.getEntries();
        StringBuffer purOrderIDBuffer = new StringBuffer();
        ArrayList<String> porIDList = new ArrayList<String>();
        HashMap<String, String> reqAndEntry = new HashMap<String, String>();
        ArrayList<String> reqIDList = new ArrayList<String>();
        boolean isExistpre = false;
        String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty =FOrderedQty+ ?,ForderedBaseQty =ForderedBaseQty+ ? where Fid = ?";
        PreparedStatement updateReqStatement = con.prepareStatement(updateReqSql);
        String updateOrderChangeSql = "update T_SM_PurOrderChangeEntry set FrealChangeQty = ?,FrealChangeBaseQty = ?,FAfterChangeQty = ?,FAfterChangeBaseQty = ?,FRealChangeDays = ?  where Fid = ?";
        PreparedStatement updateOrderChangeStatement = con.prepareStatement(updateOrderChangeSql);
        StringBuffer OrderIDBuffer = new StringBuffer();
        for (i = 0; i < purEntrycol.size(); ++i) {
            changEntry = purEntrycol.get(i);
            String porEid = changEntry.getPurOrderEntry().getId().toString();
            if (purOrderIDBuffer.length() != 0) {
                purOrderIDBuffer.append(",");
                OrderIDBuffer.append(",");
            }
            purOrderIDBuffer.append("'");
            purOrderIDBuffer.append(porEid);
            purOrderIDBuffer.append("'");
            OrderIDBuffer.append("'");
            OrderIDBuffer.append(changEntry.getPurOrder().getId().toString());
            OrderIDBuffer.append("'");
            porIDList.add(changEntry.getPurOrder().getId().toString());
        }
        for (i = 0; i < purEntrycol.size(); ++i) {
            changEntry = purEntrycol.get(i);
            String porId = changEntry.getPurOrder().getId().toString();
            String porEid = changEntry.getPurOrderEntry().getId().toString();
            PurOrderInfo info = porMap.get(porId);
            PurOrderEntryInfo entry = porEntryMap.get(porEid);
            PurOrderEntryInfo newEntry = (PurOrderEntryInfo)entry.clone();
            String sourceBill = entry.getSourceBillId();
            BigDecimal qty = entry.getQty();
            BigDecimal totalReceiveQty = entry.getTotalReceiveQty();
            BigDecimal totalReceiptQty = entry.getTotalReceiptQty();
            BigDecimal totalSupplyStockQty = entry.getTotalSupplyStockQty();
            BigDecimal allowChangeQty = BIGZERO;
            BigDecimal afterChangeQty = null;
            BigDecimal afterChangeBaseQty = null;
            BigDecimal changeQty = changEntry.getChangeQty();
            BigDecimal realChangeQty = changEntry.getChangeQty();
            BigDecimal realChangeBaseQty = null;
            BigDecimal changeBaseQty = null;
            EntryBaseStatusEnum entryStatus = EntryBaseStatusEnum.AUDITED;
            int changeDays = 0;
            if (null != changEntry.getChangeDays()) {
                changeDays = changEntry.getChangeDays().intValue();
            }
            int realChangeDays = changeDays;
            boolean flag = false;
            allowChangeQty = qty.compareTo(totalReceiveQty) == -1 ? BIGZERO : (totalReceiveQty.compareTo(totalReceiptQty) == -1 ? qty.subtract(totalReceiptQty) : qty.subtract(totalReceiveQty));
            if (changeQty.compareTo(allowChangeQty) > 0) {
                if (allowChangeQty.compareTo(BIGZERO) == 0) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"ENTRY_FIELD_CANNOT_ZERO_QTY", (Object[])new Object[]{changEntry.getSeq(), allowChangeQty});
                    throw new PurOrderChangeException(PurOrderChangeException.ENTRY_FIELD_CANNOT_QTY, (Object[])new String[]{msg});
                }
                realChangeQty = allowChangeQty;
                realChangeDays = changeDays;
                if (totalSupplyStockQty.compareTo(BIGZERO) == 0) {
                    entryStatus = EntryBaseStatusEnum.CLOSED;
                }
                flag = true;
            } else if (changeQty.compareTo(allowChangeQty) == 0) {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
                if (totalSupplyStockQty.compareTo(BIGZERO) == 0) {
                    entryStatus = EntryBaseStatusEnum.CLOSED;
                }
                flag = true;
            } else {
                realChangeQty = changeQty;
                realChangeDays = changeDays;
            }
            BigDecimal assistQty = BIGZERO;
            if (null != changEntry.getMaterial().getId()) {
                String materialID = changEntry.getMaterial().getId().toString();
                String unitID = changEntry.getUnit().getId().toString();
                String baseUnitID = changEntry.getBaseUnit().getId().toString();
                String assistUnitID = null;
                if (null != changEntry.getAssistUnit()) {
                    assistUnitID = changEntry.getAssistUnit().getId().toString();
                }
                if (assistUnitID != null) {
                    assistQty = this.getBaseUnitQty(materialID, unitID, assistUnitID, realChangeQty);
                }
                realChangeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, realChangeQty);
                changeBaseQty = this.getBaseUnitQty(materialID, unitID, baseUnitID, changeQty);
            } else {
                realChangeBaseQty = realChangeQty;
                changeBaseQty = changeQty;
            }
            afterChangeQty = entry.getQty().subtract(realChangeQty);
            afterChangeBaseQty = entry.getBaseQty().subtract(realChangeBaseQty);
            entry.setBaseStatus(entryStatus);
            entry.setQty(afterChangeQty);
            entry.setBaseQty(afterChangeBaseQty);
            this.handRelationParams(ctx, entry);
            entry.setAssociateQty(entry.getAssociateQty().subtract(realChangeQty));
            entry.setAssistQty(entry.getAssistQty().add(assistQty));
            entry.setCanInvMoveQty(afterChangeQty);
            if (null != entry.getTotalUnReturnBaseQty()) {
                entry.setTotalUnReturnBaseQty(entry.getTotalUnReturnBaseQty().subtract(realChangeBaseQty));
                entry.setTotalUnReceiveBaseQty(entry.getTotalUnReceiveBaseQty().subtract(realChangeBaseQty));
                entry.setTotalUnReceiveQty(entry.getTotalUnReceiveQty().subtract(realChangeQty));
                entry.setUnOrderedQty(entry.getUnOrderedQty().subtract(realChangeQty));
            }
            newEntry.setId(BOSUuid.create((String)"26041CC5"));
            newEntry.setQty(realChangeQty);
            newEntry.setBaseQty(realChangeBaseQty);
            this.handRelationParams(ctx, newEntry);
            newEntry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            newEntry.setAssociateQty(realChangeQty);
            newEntry.setAssistQty(assistQty);
            newEntry.setDeliveryDate(this.calchangeDate(entry.getDeliveryDate(), changeDays));
            newEntry.setSeq(info.getEntries().size() + 1);
            newEntry.setPreReceived(BIGZERO);
            newEntry.setParent(info);
            newEntry.setUnOrderedQty(realChangeQty);
            newEntry.setTotalMoveQty(BIGZERO);
            newEntry.setTotalCacelledStockQty(BIGZERO);
            newEntry.setTotalSupplyStockQty(BIGZERO);
            newEntry.setTotalSupplyStockBaseQty(BIGZERO);
            newEntry.setTotalReceiveQty(BIGZERO);
            newEntry.setTotalReceiptQty(BIGZERO);
            newEntry.setTotalReceiptBaseQty(BIGZERO);
            newEntry.setTotalReceiveBaseQty(BIGZERO);
            newEntry.setCanInvMoveQty(realChangeQty);
            newEntry.setTotalUnReturnBaseQty(realChangeQty);
            newEntry.setTotalUnReceiveBaseQty(realChangeQty);
            newEntry.setTotalUnReceiveQty(realChangeQty);
            updateOrderChangeStatement.setBigDecimal(1, realChangeQty);
            updateOrderChangeStatement.setBigDecimal(2, realChangeBaseQty);
            updateOrderChangeStatement.setBigDecimal(3, afterChangeQty);
            updateOrderChangeStatement.setBigDecimal(4, afterChangeBaseQty);
            updateOrderChangeStatement.setInt(5, realChangeDays);
            updateOrderChangeStatement.setString(6, changEntry.getId().toString());
            updateOrderChangeStatement.addBatch();
            if (sourceBill != null) {
                updateReqStatement.setBigDecimal(1, realChangeQty);
                updateReqStatement.setBigDecimal(2, changeBaseQty);
                updateReqStatement.setString(3, entry.getSourceBillEntryId().toString());
                updateReqStatement.addBatch();
                isExistpre = true;
            }
            if (flag) {
                if (!reqIDList.contains(porId)) {
                    String ids = reqAndEntry.get(porId) == null ? "" : (String)reqAndEntry.get(porId);
                    ids = ids.equalsIgnoreCase("") ? "'" + porEid + "'" : ids + ",'" + porEid + "'";
                    reqAndEntry.put(porId, ids);
                } else {
                    reqAndEntry.remove(porId);
                }
            } else {
                reqIDList.add(porId);
                reqAndEntry.remove(porId);
            }
            PurOrderEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(entry.getId()), (CoreBaseInfo)entry);
            PurOrderEntryFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)newEntry);
        }
        String updateOrderStatusSql = "update T_SM_PurOrder set FBaseStatus = ?  where Fid = ?";
        PreparedStatement updateOrderStatusStatement = con.prepareStatement(updateOrderStatusSql);
        Statement notCloseEntryStatement = con.createStatement();
        for (String key : reqAndEntry.keySet()) {
            StringBuffer notCloseEntryBuffer = new StringBuffer();
            int reqStatus = 4;
            String ids = (String)reqAndEntry.get(key);
            notCloseEntryBuffer.append("select FID from T_SM_PurOrderEntry where FParentID = '").append(key).append("' and FBaseStatus = 4");
            ResultSet notCloseEntryRateSet = notCloseEntryStatement.executeQuery(notCloseEntryBuffer.toString());
            if (!notCloseEntryRateSet.next()) {
                reqStatus = 7;
            }
            updateOrderStatusStatement.setInt(1, reqStatus);
            updateOrderStatusStatement.setString(2, key);
            updateOrderStatusStatement.addBatch();
        }
        updateOrderStatusStatement.executeBatch();
        this.writreBackPrepayment(ctx, porIDList);
        if (isExistpre) {
            updateReqStatement.executeBatch();
        }
        updateOrderChangeStatement.executeBatch();
    }

    public void writreBackPrepayment(Context ctx, List<String> porid) throws SQLException, BOSException {
        Connection con = null;
        ResultSet rs = null;
        Statement stmtPorid = null;
        Statement stmtup = null;
        Statement stmtEntryup = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            StringBuffer entryPrepayment = new StringBuffer();
            StringBuffer updatePrepayment = new StringBuffer();
            StringBuffer updateEntryPrepayment = new StringBuffer();
            entryPrepayment.append("select p.FPREPAYMENTRATE,entry.FTaxAmount,entry.FPRERECEIVED,entry.FID  from T_SM_PurOrderEntry as entry  INNER JOIN T_SM_PurOrder as p ON ENTRY.FPARENTID = P.FID ");
            entryPrepayment.append("where p.FID = ? ");
            updatePrepayment.append("UPDATE T_SM_PurOrder SET  FPREPAYMENT = ? WHERE FID = ?");
            updateEntryPrepayment.append("UPDATE T_SM_PurOrderEntry SET FPREPAYMENT =?,FUNPRERECEIVEDAM = ? ");
            updateEntryPrepayment.append("WHERE FID=?");
            for (int i = 0; i < porid.size(); ++i) {
                BigDecimal prepayment = BIGZERO;
                BigDecimal prepaymentEntry = BIGZERO;
                BigDecimal unPrereceiveDam = BIGZERO;
                stmtPorid = con.prepareStatement(entryPrepayment.toString());
                stmtPorid.setString(1, porid.get(i));
                rs = stmtPorid.executeQuery();
                stmtup = con.prepareStatement(updatePrepayment.toString());
                stmtEntryup = con.prepareStatement(updateEntryPrepayment.toString());
                while (rs.next()) {
                    prepaymentEntry = rs.getBigDecimal("FTaxAmount").multiply(rs.getBigDecimal("FPREPAYMENTRATE").divide(new BigDecimal("100")));
                    prepayment = prepayment.add(prepaymentEntry);
                    unPrereceiveDam = prepaymentEntry.subtract(rs.getBigDecimal("FPRERECEIVED"));
                    stmtEntryup.setBigDecimal(1, prepaymentEntry);
                    stmtEntryup.setBigDecimal(2, unPrereceiveDam);
                    stmtEntryup.setString(3, rs.getString("FID"));
                    stmtEntryup.addBatch();
                }
                stmtup.setBigDecimal(1, prepayment);
                stmtup.setString(2, porid.get(i));
                stmtup.addBatch();
            }
            if (stmtEntryup != null) {
                stmtEntryup.executeBatch();
            }
            if (stmtup != null) {
                stmtup.executeBatch();
            }
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            if (null != stmtPorid && null != stmtup && null != stmtEntryup) {
                stmtPorid.close();
                stmtup.close();
                stmtEntryup.close();
            }
        }
    }

    public Date calchangeDate(Date date, int changeDays) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, changeDays);
        date = ca.getTime();
        return date;
    }

    private Map<String, PurOrderEntryInfo> getPurOrderEntryCol(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("totalReceiveQty"));
        sic.add(new SelectorItemInfo("totalReceiptQty"));
        sic.add(new SelectorItemInfo("totalReturnedQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockQty"));
        sic.add(new SelectorItemInfo("associateQty"));
        sic.add(new SelectorItemInfo("assistQty"));
        sic.add(new SelectorItemInfo("assistUnit.id"));
        sic.add(new SelectorItemInfo("assistUnit.name"));
        sic.add(new SelectorItemInfo("assistUnit.number"));
        sic.add(new SelectorItemInfo("parent.exchangeRate"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("parent.currency.id"));
        sic.add(new SelectorItemInfo("parent.currency.name"));
        sic.add(new SelectorItemInfo("parent.currency.precision"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("parent.isInTax"));
        sic.add(new SelectorItemInfo("parent.isPriceInTax"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("deliveryDate"));
        sic.add(new SelectorItemInfo("isPresent"));
        sic.add(new SelectorItemInfo("supplierMaterialNumber"));
        sic.add(new SelectorItemInfo("supplierMaterialName"));
        sic.add(new SelectorItemInfo("supplierMaterialModel"));
        sic.add(new SelectorItemInfo("assetNumber"));
        sic.add(new SelectorItemInfo("demandQty"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("actualTaxPrice"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo("taxAmount"));
        sic.add(new SelectorItemInfo("discountAmount"));
        sic.add(new SelectorItemInfo("receiveOverRate"));
        sic.add(new SelectorItemInfo("receiveOwingRate"));
        sic.add(new SelectorItemInfo("deliverAdvanceDay"));
        sic.add(new SelectorItemInfo("deliverDeferralDay"));
        sic.add(new SelectorItemInfo("trackNumber"));
        sic.add(new SelectorItemInfo("totalInvoicedQty"));
        sic.add(new SelectorItemInfo("totalInvoicedAmount"));
        sic.add(new SelectorItemInfo("totalReqPayAmt"));
        sic.add(new SelectorItemInfo("totalPaidAmount"));
        sic.add(new SelectorItemInfo("totalExpense"));
        sic.add(new SelectorItemInfo("quantityUnCtrl"));
        sic.add(new SelectorItemInfo("timeUnCtrl"));
        sic.add(new SelectorItemInfo("totalReceiveBaseQty"));
        sic.add(new SelectorItemInfo("totalReceiptBaseQty"));
        sic.add(new SelectorItemInfo("totalReturnedBaseQty"));
        sic.add(new SelectorItemInfo("totalInvoicedBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReturnBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReceiveBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReceiveQty"));
        sic.add(new SelectorItemInfo("deliveryAddress"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("isSupInfo"));
        sic.add(new SelectorItemInfo("curSeOrderQty"));
        sic.add(new SelectorItemInfo("localTax"));
        sic.add(new SelectorItemInfo("localTaxAmount"));
        sic.add(new SelectorItemInfo("saleOrderNumber"));
        sic.add(new SelectorItemInfo("prepaidAmount"));
        sic.add(new SelectorItemInfo("requestOrgUnit.id"));
        sic.add(new SelectorItemInfo("requestCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("reason"));
        sic.add(new SelectorItemInfo("isRequestToReceived"));
        sic.add(new SelectorItemInfo("totalMoveQty"));
        sic.add(new SelectorItemInfo("totalInvoicedAmt"));
        sic.add(new SelectorItemInfo("totalPrePayAmt"));
        sic.add(new SelectorItemInfo("prepayment"));
        sic.add(new SelectorItemInfo("preReceived"));
        sic.add(new SelectorItemInfo("unPrereceivedAm"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("oldID"));
        sic.add(new SelectorItemInfo("oldStatus"));
        sic.add(new SelectorItemInfo("canInvMoveQty"));
        sic.add(new SelectorItemInfo("unOrderedQty"));
        sic.add(new SelectorItemInfo("isBetweenCompanyRec"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.projectType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("wareHouse.id"));
        sic.add(new SelectorItemInfo("materialName"));
        sic.add(new SelectorItemInfo("isReqComEqlRecCom"));
        sic.add(new SelectorItemInfo("planReceiveQty"));
        sic.add(new SelectorItemInfo("totalCacelledStockQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockBaseQty"));
        sic.add(new SelectorItemInfo("isReqPrePayGTprePay"));
        sic.add(new SelectorItemInfo("noNumMaterialModel"));
        sic.add(new SelectorItemInfo("qcStandard"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("purContractID.id"));
        sic.add(new SelectorItemInfo("matchedAmount"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit"));
        sic.add(new SelectorItemInfo("purRequestID"));
        sic.add(new SelectorItemInfo("purRequestEntryID"));
        sic.add(new SelectorItemInfo("netQuotationItemId"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getSCMBillBaseEntrySelector((String)""));
        view.setSelector(sic);
        view.setFilter(tmpFilter);
        PurOrderEntryCollection col = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(view);
        HashMap<String, PurOrderEntryInfo> entryMap = new HashMap<String, PurOrderEntryInfo>();
        for (int i = 0; i < col.size(); ++i) {
            entryMap.put(col.get(i).getId().toString(), col.get(i));
        }
        return entryMap;
    }

    private Map<String, PurOrderInfo> getPurCol(Context ctx, Set<String> poIDs) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("id", poIDs, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        view.setSelector(sic);
        view.setFilter(tmpFilter);
        PurOrderCollection col = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(view);
        HashMap<String, PurOrderInfo> porMap = new HashMap<String, PurOrderInfo>();
        for (int i = 0; i < col.size(); ++i) {
            porMap.put(col.get(i).getId().toString(), col.get(i));
        }
        return porMap;
    }

    private void handRelationParams(Context ctx, PurOrderEntryInfo entry) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRateinfo = this.getExchangeRateInfo(ctx, entry);
        if (entry.getParent().isIsInTax()) {
            this.calDiscountAmountByTaxPrice(entry);
            this.calTaxAmountByTaxPrice(entry);
            this.calLocalTaxAmount(entry, exchangeRateinfo);
            this.calTax(entry);
            this.calLocalTax(entry, exchangeRateinfo);
            this.calAmount(entry);
            this.calLocalAmount(entry, exchangeRateinfo);
            this.calActualTaxPrice(entry, exchangeRateinfo);
            this.calActualPrice(entry);
        } else {
            this.calAmount(entry);
            this.calLocalAmount(entry, exchangeRateinfo);
            this.calTax(entry);
            this.calLocalTax(entry, exchangeRateinfo);
            this.calTaxAmountByTaxPrice(entry);
            this.calLocalTaxAmount(entry, exchangeRateinfo);
            this.calDiscountAmountByTaxPrice(entry);
            this.calActualTaxPrice(entry, exchangeRateinfo);
            this.calActualPrice(entry);
        }
    }

    public void calActualPrice(PurOrderEntryInfo entry) {
        if (entry.getPrice() == null || entry.getAmount() == null || entry.getQty() == null || entry.getActualPrice() == null || entry.getDiscountAmount() == null) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.0");
        int scale = entry.getParent().getCurrency().getPrecision();
        BigDecimal amount = entry.getAmount();
        BigDecimal qty = entry.getQty();
        amount = this.validateNullValue(amount);
        qty = this.validateNullValue(qty);
        BigDecimal discountRate = entry.getDiscountRate();
        if (discountRate == null || discountRate.compareTo(zero) == 0) {
            BigDecimal price = entry.getPrice();
            price = this.validateNullValue(price);
            entry.setActualPrice(price);
        } else if (amount != null && qty != null && qty.compareTo(zero) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            entry.setActualPrice(actualPrice);
        }
    }

    public void calActualTaxPrice(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        if (entry.getPrice() == null || entry.getTaxPrice() == null || entry.getActualTaxPrice() == null || entry.getTaxAmount() == null || entry.getQty() == null) {
            return;
        }
        BigDecimal discountRate = entry.getDiscountAmount();
        BigDecimal zero = new BigDecimal("0.0");
        int scale = entry.getParent().getCurrency().getPrecision();
        if ((discountRate == null || discountRate.compareTo(zero) == 0) && entry.getTaxPrice() != null) {
            BigDecimal taxPrice = entry.getTaxPrice().abs();
            entry.setActualTaxPrice(taxPrice);
        } else {
            BigDecimal taxAmount = entry.getAmount();
            BigDecimal qty = entry.getQty();
            taxAmount = this.validateNullValue(taxAmount);
            qty = this.validateNullValue(qty);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                entry.setActualTaxPrice(actualTaxPrice);
            }
        }
    }

    public void calDiscountAmountByTaxPrice(PurOrderEntryInfo entry) {
        int amountPricision = entry.getParent().getCurrency().getPrecision();
        if (entry.getDiscountRate() == null) {
            return;
        }
        int scale = amountPricision;
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        entry.setDiscountAmount(discountAmount);
    }

    private BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return BIGZERO;
        }
        return value;
    }

    public void calAmount(PurOrderEntryInfo entry) {
        int scale = entry.getParent().getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal tax = entry.getTax();
            taxAmount = this.validateNullValue(taxAmount);
            tax = this.validateNullValue(tax);
            entry.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                entry.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entry.getPrice();
            BigDecimal discountRate = entry.getDiscountRate();
            BigDecimal qty = entry.getQty();
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            price = this.validateNullValue(price);
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            entry.setAmount(amount);
        }
    }

    public void calLocalAmount(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal amount = entry.getAmount();
        BigDecimal exchangerate = entry.getParent().getExchangeRate();
        amount = this.validateNullValue(amount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalAmount(amount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalAmount(amount);
        }
    }

    public void calLocalTax(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = entry.getParent().getExchangeRate();
        tax = this.validateNullValue(tax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTax(tax);
        }
    }

    public void calTax(PurOrderEntryInfo entry) {
        int scale = entry.getParent().getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal taxRate = entry.getTaxRate();
            taxAmount = this.validateNullValue(taxAmount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (!entry.getParent().isIsPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            entry.setTax(tax);
        } else {
            BigDecimal amount = entry.getAmount();
            amount = this.validateNullValue(amount);
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = this.validateNullValue(taxRate)), (int)scale);
            if (tax != null) {
                entry.setTax(tax);
            } else {
                entry.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public void calTaxAmountByTaxPrice(PurOrderEntryInfo entry) {
        int scale = entry.getParent().getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal qty = entry.getQty();
            BigDecimal discountAmount = entry.getDiscountAmount();
            taxPrice = this.validateNullValue(taxPrice);
            qty = this.validateNullValue(qty);
            discountAmount = this.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        } else {
            BigDecimal amount = entry.getAmount();
            BigDecimal tax = entry.getTax();
            amount = this.validateNullValue(amount);
            tax = this.validateNullValue(tax);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        }
    }

    public void calLocalTaxAmount(PurOrderEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal exchangerate = entry.getParent().getExchangeRate();
        taxAmount = this.validateNullValue(taxAmount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTaxAmount(taxAmount);
        }
    }

    private ExchangeRateInfo getExchangeRateInfo(Context ctx, PurOrderEntryInfo entry) throws EASBizException, BOSException {
        CurrencyInfo srcCurrInfo = entry.getParent().getCurrency();
        CompanyOrgUnitInfo ficompanyOrgInfo = entry.getParent().getCompanyOrgUnit();
        CurrencyInfo baseCurrInfo = entry.getParent().getCompanyOrgUnit().getBaseCurrency();
        if (ficompanyOrgInfo != null && srcCurrInfo != null && baseCurrInfo != null && !srcCurrInfo.equals((Object)baseCurrInfo)) {
            String key = ficompanyOrgInfo.getId().toString() + srcCurrInfo.getId().toString() + baseCurrInfo.getId().toString();
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrInfo.getId());
            destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }

    private BigDecimal getBaseUnitQty(String materialID, String unitID, String baseUnitID, BigDecimal qty) throws EASBizException, BOSException {
        MeasureUnitInfo unit = new MeasureUnitInfo();
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)unitID));
        baseUnit.setId(BOSUuid.read((String)baseUnitID));
        return SCMUtil.getExchangeQtyForClient((Context)this.ctx, (String)materialID, (MeasureUnitInfo)unit, (MeasureUnitInfo)baseUnit, (BigDecimal)qty);
    }
}

