/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorderchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.SDSMBizDataCheckProcessor;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeException;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequirementException;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;

public class PurOrderChangeBizDataCheckProcessor
extends SDSMBizDataCheckProcessor {
    private static final long serialVersionUID = 6664930633327211556L;

    public PurOrderChangeBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderChangeBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        this.doCheck(batchResults);
    }

    private void doCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null) {
            return;
        }
        int len = collection[0].toArray().length;
        int nrow = 0;
        int size = len;
        for (int i = 0; i < size; ++i) {
            int j;
            PurOrderChangeInfo info;
            if (!(collection[0].toArray()[i] instanceof PurOrderChangeInfo) || (info = (PurOrderChangeInfo)collection[0].toArray()[i]) == null) continue;
            PurOrderChangeEntryCollection entries = info.getEntries();
            PurOrderChangeEntryInfo entry = null;
            if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
                // empty if block
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) continue;
            if (info.getBaseStatus().getValue() != 0 && info.getBaseStatus().getValue() != 1 && info.getBaseStatus().getValue() != 2 && info.getBaseStatus().getValue() != -2 && info.getBaseStatus().getValue() != 3) {
                throw new PurOrderChangeException(PurOrderChangeException.CANNOT_UPDATE, (Object[])new String[]{info.getBaseStatus().toString()});
            }
            if (info.getPurchaseOrgUnit() == null) {
                throw new PurOrderChangeException(PurOrderChangeException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_PURCHASEORGUNIT", (Context)this.ctx)});
            }
            if (info.getAlterrationReason() == null) {
                throw new PurOrderChangeException(PurOrderChangeException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"CHANGEREASON", (Context)this.ctx)});
            }
            if (info.getBizDate() == null) {
                throw new PurOrderChangeException(PurOrderChangeException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"CHANGEDATE", (Context)this.ctx)});
            }
            for (j = entries.size() - 1; j >= 0; --j) {
                PurOrderChangeEntryInfo entryInfo = entries.get(j);
                if (null != entryInfo.getPurOrderEntry()) continue;
                entries.removeObject(j);
            }
            if (entries == null || entries.size() == 0) {
                throw new PurReqException(PurReqException.PURREQC_ALL_EMPTY_ENTRY);
            }
            nrow = info.getEntries().size();
            if (nrow <= 0) {
                throw new PurRequirementException(PurOrderChangeException.ENTRY_CANNOT_EMPTY);
            }
            if (entries == null) continue;
            int count = entries.size();
            for (j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry == null) continue;
                if (entry.getPurOrderEntry() == null) {
                    throw new PurOrderChangeException(PurOrderChangeException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"com.kingdee.eas.scm.sm.pur.PurOrderChangeResource", (String)"ENTRY_PURORDERNUMBER", (Context)this.ctx)});
                }
                if (info.getChangeType().equals((Object)ChangeTypeEnum.fieldChange)) {
                    if (entry.getChangeQty() != null && entry.getChangeQty().compareTo(SysConstant.BIGZERO) != 0 || null != entry.getChangeDays() && entry.getChangeDays().compareTo(SysConstant.BIGZERO) != 0) continue;
                    throw new PurOrderChangeException(PurOrderChangeException.QTY_DATE_CANNOT_EMPTY);
                }
                if (entry.getChangeQty() != null && entry.getChangeQty().compareTo(SysConstant.BIGZERO) != 0) continue;
                throw new PurOrderChangeException(PurOrderChangeException.QTY_CANNOT_EMPTY);
            }
        }
    }
}

