/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorderchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeException;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class PurOrderChangeDefaultValue4SubmitProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -6076728046740402620L;

    public PurOrderChangeDefaultValue4SubmitProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurOrderChangeDefaultValue4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderChangeDefaultValue4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() <= 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
        }
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurOrderChangeInfo info = (PurOrderChangeInfo)model;
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurOrderChangeException(PurOrderChangeException.DELETED_NOT_SUBMIT);
        }
        info.setBizDate(info.getBizDate());
        if (info.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("uH2EQ39zT1yvvG7D+kbkk0Y+1VI="), sic);
            info.setBillType(billTypeInfo);
        }
        if (info.getBizType() == null) {
            BizTypeInfo staticBizTypeInfo = new BizTypeInfo();
            staticBizTypeInfo.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
            staticBizTypeInfo.setNumber("110");
            staticBizTypeInfo.setName(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ORDER_FIELD_PURCHASEORGUNIT"));
            info.setBizType(staticBizTypeInfo);
        }
        if (info.getModifier() == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
            info.setModifier(userInfo);
        }
        if (info.getModificationTime() == null) {
            Calendar cal = Calendar.getInstance();
            Date curDate = cal.getTime();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            info.setModificationTime(ts);
        }
        PurOrderChangeEntryInfo entry = null;
        PurOrderChangeEntryCollection entries = info.getEntries();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            this.setEntryDefaultValue(info, entry, formatter);
        }
    }

    private void setEntryDefaultValue(PurOrderChangeInfo info, PurOrderChangeEntryInfo entry, SimpleDateFormat formatter) throws BOSException {
        if (entry == null) {
            return;
        }
        if (entry.getBaseQty() == null) {
            entry.setBaseQty(BigDecimal.ZERO);
        }
        if (entry.getApprovalQty() == null) {
            entry.setApprovalQty(BigDecimal.ZERO);
        }
        if (entry.getChangeBaseQty() == null) {
            entry.setChangeBaseQty(BigDecimal.ZERO);
        }
        if (entry.getChangeQty() == null) {
            entry.setChangeQty(BigDecimal.ZERO);
        }
        if (entry.getRealChangeBaseQty() == null) {
            entry.setRealChangeBaseQty(BigDecimal.ZERO);
        }
        if (entry.getRealChangeQty() == null) {
            entry.setRealChangeQty(BigDecimal.ZERO);
        }
        if (entry.getDeliverTime() != null) {
            entry.setDeliverTime(entry.getDeliverTime());
        }
    }

    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"uH2EQ39zT1yvvG7D+kbkk0Y+1VI="));
        info.setNumber("uH2EQ39zT1yvvG7D+kbkk0Y+1VI=");
        return info;
    }

    protected PurchaseOrgUnitInfo getPurchaseOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurOrderChangeInfo info = (PurOrderChangeInfo)model;
        return info.getPurchaseOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }
}

