/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PurReqDefaultValue4SaveProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = 8331871670339760369L;

    public PurReqDefaultValue4SaveProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqDefaultValue4SaveProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurReqDefaultValue4SaveProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
            if (!objVal.getBoolean("isMergeBill") || objVal.get("mergeSrcBillId") == null) continue;
            String entryids = objVal.get("mergeSrcBillId").toString();
            StringBuilder sql = new StringBuilder();
            String number = objVal.getString("number");
            sql.append(" update T_sm_purrequestentry set FMergeBillNumber = '").append(number).append("'");
            sql.append(" where fid in ").append(entryids);
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        int i;
        int len;
        PeriodInfo pInfo;
        PurRequestInfo info = (PurRequestInfo)model;
        boolean isAddNew = true;
        isAddNew = info.getId() == null;
        if (null != info.getEntries() && info.getEntries().size() > 0 && info.getEntries().get(0).getStorageOrgUnit() != null) {
            info.setStorageOrgUnit(info.getEntries().get(0).getStorageOrgUnit());
        }
        if (null != info.getEntries() && info.getEntries().size() > 0 && info.getEntries().get(0).getReqAdminOrgUnit() != null) {
            info.setReqAdminOrgUnit(info.getEntries().get(0).getAdminOrgUnit());
        }
        info.setBizDate(info.getBizDate());
        if (info.getDemandType() != null && info.getDemandType().getRowType() == null) {
            info.setDemandType(PurUtil.getDemandType((Context)this.ctx, (String)info.getDemandType().getId().toString()));
        }
        if (info.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
            info.setBillType(billType);
        }
        if (info.getYear() == 0 && (pInfo = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)info.getCompanyOrgUnit())) != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
            info.setYear(pInfo.getPeriodYear());
            info.setPeriod(pInfo.getPeriodNumber());
        }
        PurRequestEntryInfo entry = null;
        PurRequestEntryCollection entries = info.getEntries();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        if (isAddNew) {
            len = entries.size();
            for (i = 0; i < len; ++i) {
                entry = entries.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                entry.setUnOrderedQty(entry.getQty());
                entry.setUnOrderedBaseQty(entry.getBaseQty());
                entry.setTotalReqQty(new BigDecimal("0"));
                entry.setTotalRequQty(new BigDecimal("0"));
                entry.setUnTotalReqQty(entry.getQty());
                this.setEntryDefaultValue(entry, info, formatter);
            }
        } else {
            boolean isfrompurreq = SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-0107c0a812fd463ED552");
            int len2 = entries.size();
            for (int i2 = 0; i2 < len2; ++i2) {
                entry = entries.get(i2);
                if (!isfrompurreq || !info.isIsMergeBill()) {
                    entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                }
                this.setEntryDefaultValue(entry, info, formatter);
            }
        }
        if (SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)info, (String)"9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
            len = entries.size();
            for (i = 0; i < len; ++i) {
                entry = entries.get(i);
                if (entry.getAssistUnit() == null || entry.getAssistQty() != null && entry.getAssistQty().compareTo(SysConstant.BIGZERO) != 0) continue;
                BigDecimal assistQty = this.getExchangeQtyForClient(this.ctx, entry.getMaterial().getId().toString(), entry.getUnit(), entry.getAssistUnit(), entry.getQty());
                entry.setAssistQty(assistQty);
            }
        }
        BigDecimal totalTax = new BigDecimal("0.0");
        BigDecimal totalTaxAmount = new BigDecimal("0.0");
        BigDecimal localTotalTaxAmount = new BigDecimal("0.0");
        BigDecimal totalAmount = new BigDecimal("0.0");
        BigDecimal localTotalAmount = new BigDecimal("0.0");
        int len3 = entries.size();
        for (int i3 = 0; i3 < len3; ++i3) {
            entry = entries.get(i3);
            totalTax = totalTax.add(entry.getTax());
            totalTaxAmount = totalTaxAmount.add(entry.getTaxAmount());
            localTotalTaxAmount = localTotalTaxAmount.add(entry.getLocalTaxAmount());
            totalAmount = totalAmount.add(entry.getAmount());
            localTotalAmount = localTotalAmount.add(entry.getLocalAmount());
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
        info.setLocalTotalAmount(localTotalAmount);
        info.setLocalTotalTaxAmount(totalTaxAmount);
    }

    private void setEntryDefaultValue(PurRequestEntryInfo entry, PurRequestInfo info, SimpleDateFormat formatter) throws BOSException {
        if (entry != null && info != null) {
            if (info.getBizDate() != null) {
                entry.setBizDate(info.getBizDate());
            }
            if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
                entry.setCompanyOrgUnit(info.getCompanyOrgUnit().getId().toString());
            }
            if (entry.getBaseQty() == null) {
                entry.setBaseQty(BigDecimal.ZERO);
            }
            if (entry.getQty() == null) {
                entry.setQty(BigDecimal.ZERO);
            }
            if (entry.getRequestQty() == null) {
                entry.setRequestQty(SysConstant.BIGZERO);
            }
            if (entry.getAssistQty() == null) {
                entry.setAssistQty(BigDecimal.ZERO);
            }
            try {
                if (entry.getRequirementDate() != null) {
                    entry.setRequirementDate(formatter.parse(formatter.format(entry.getRequirementDate())));
                }
                if (entry.getProposeDeliveryDate() != null) {
                    entry.setProposeDeliveryDate(formatter.parse(formatter.format(entry.getProposeDeliveryDate())));
                }
                if (entry.getProposePurchaseDate() != null) {
                    entry.setProposePurchaseDate(formatter.parse(formatter.format(entry.getProposePurchaseDate())));
                }
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            if (info.getDemandType() != null && entry.getRowType() == null) {
                entry.setRowType(info.getDemandType().getRowType());
            }
            if (entry.getDestinationType() == null) {
                if (entry.getRowType().getDestinationType() != null) {
                    entry.setDestinationType(entry.getRowType().getDestinationType());
                } else if (entry.getRowType().getRequestOrgType() != null) {
                    if (entry.getRowType().getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT) {
                        entry.setDestinationType(DestinationTypeEnum.STORAGE);
                    } else {
                        entry.setDestinationType(DestinationTypeEnum.COSTS);
                    }
                }
            }
            if (entry.getReqAdminOrgUnit() == null) {
                entry.setReqAdminOrgUnit(info.getAdminOrg());
            }
            if (entry.getPrice() == null) {
                entry.setPrice(BigDecimal.ZERO);
            }
            if (entry.getLocalAmount() == null) {
                entry.setLocalAmount(BigDecimal.ZERO);
            }
            if (entry.getAmount() == null) {
                entry.setAmount(BigDecimal.ZERO);
            }
            if (entry.getLocalTaxAmount() == null) {
                entry.setLocalTaxAmount(BigDecimal.ZERO);
            }
            if (entry.getTaxAmount() == null) {
                entry.setTaxAmount(BigDecimal.ZERO);
            }
            if (entry.getTaxPrice() == null) {
                entry.setTaxPrice(BigDecimal.ZERO);
            }
            if (entry.getTax() == null) {
                entry.setTax(BigDecimal.ZERO);
            }
        }
    }

    private BigDecimal getExchangeQtyForClient(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        return SCMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnifInfo, (MultiMeasureUnitInfo)othermultiUnifInfo, (BigDecimal)qty);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        info.setNumber("210");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurRequestInfo info = (PurRequestInfo)model;
        return info.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }
}

