/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PurReqDefaultValue4SubmitProcessor
extends SCMDefaultValueProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest.PurReqDefaultValue4SubmitProcessor");
    private static final long serialVersionUID = 2416741475305245384L;

    public PurReqDefaultValue4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqDefaultValue4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqDefaultValue4SubmitProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        long time11 = System.currentTimeMillis();
        super.doProcessing(batchResults);
        long time21 = System.currentTimeMillis();
        logger.error((Object)("@@@@@@@@@@@PurReqDefaultValue4SubmitProcessor\u603b\u8ba1\u8017\u65f611\uff1a" + (time21 - time11)));
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
        }
        long time31 = System.currentTimeMillis();
        logger.error((Object)("@@@@@@@@@@@PurReqDefaultValue4SubmitProcessor\u603b\u8ba1\u8017\u65f621\uff1a" + (time31 - time21)));
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        PeriodInfo pInfo;
        PurRequestInfo info = (PurRequestInfo)model;
        info.setBizDate(info.getBizDate());
        if (info.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)info.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)info.getBaseStatus())) {
            // empty if block
        }
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            throw new PurOrderException(PurOrderException.ENTRY_CANNOT_EMPTY);
        }
        if (info.getEntries().get(0).getStorageOrgUnit() != null) {
            info.setStorageOrgUnit(info.getEntries().get(0).getStorageOrgUnit());
        }
        if (info.getEntries().get(0).getReqAdminOrgUnit() != null) {
            info.setReqAdminOrgUnit(info.getEntries().get(0).getReqAdminOrgUnit());
        }
        if (info.getDemandType() != null && info.getDemandType().getRowType() == null) {
            info.setDemandType(PurUtil.getDemandType((Context)this.ctx, (String)info.getDemandType().getId().toString()));
        }
        if (info.getCU() == null) {
            info.setCU(this.getCU(this.ctx, info));
        }
        PurRequestEntryCollection entries = info.getEntries();
        PurRequestEntryInfo entry = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            if (null != entry.getBaseStatus() && entry.getBaseStatus() != EntryBaseStatusEnum.ADD && entry.getBaseStatus() != EntryBaseStatusEnum.TEMPORARILYSAVED && entry.getBaseStatus() != EntryBaseStatusEnum.SUBMITED) continue;
            entry.setUnOrderedQty(entry.getQty());
            entry.setUnOrderedBaseQty(entry.getBaseQty());
            if (entry.getReqAdminOrgUnit() == null) {
                entry.setReqAdminOrgUnit(info.getAdminOrg());
            }
            if (entry.getPerson() == null) {
                entry.setPerson(info.getPerson());
            }
            if (entry.getReceivedOrgUnit() == null) {
                entry.setReceivedOrgUnit(info.getStorageOrgUnit());
            }
            if (entry.getUseAdminOrgUnit() == null) {
                entry.setUseAdminOrgUnit(info.getReqAdminOrgUnit());
            }
            if (info.getDemandType() != null && entry.getRowType() == null) {
                entry.setRowType(info.getDemandType().getRowType());
            }
            if (entry.getDestinationType() == null) {
                if (entry.getRowType().getDestinationType() != null) {
                    entry.setDestinationType(entry.getRowType().getDestinationType());
                } else if (entry.getRowType().getRequestOrgType() != null) {
                    if (entry.getRowType().getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT) {
                        entry.setDestinationType(DestinationTypeEnum.STORAGE);
                    } else {
                        entry.setDestinationType(DestinationTypeEnum.COSTS);
                    }
                }
            }
            if (!(entry.getRowType() == null || entry.getRowType().isIsHasMaterialNumber() && entry.getMaterialGroup1() == null || entry.getBaseQty() != null && SysConstant.BIGZERO.compareTo(entry.getBaseQty()) != 0)) {
                entry.setBaseQty(entry.getQty());
                entry.setUnOrderedBaseQty(entry.getQty());
            }
            entry.setOrderedBaseQty(SysConstant.BIGZERO);
            entry.setOrderedQty(SysConstant.BIGZERO);
            entry.setTotalReqQty(SysConstant.BIGZERO);
            entry.setTotalRequQty(SysConstant.BIGZERO);
            entry.setUnTotalReqQty(entry.getQty());
            entry.setAssociateQty(entry.getQty());
            if (entry.getRequestQty() == null) {
                entry.setRequestQty(SysConstant.BIGZERO);
            }
            if (entry.getBaseQty() == null) {
                entry.setBaseQty(SysConstant.BIGZERO);
            }
            if (entry.getQty() == null) {
                entry.setQty(SysConstant.BIGZERO);
            }
            if (entry.getBaseStatus() != null && (EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus()))) {
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            this.setEntryDefaultValue(entry, info);
            try {
                if (entry.getRequirementDate() != null) {
                    entry.setRequirementDate(formatter.parse(formatter.format(entry.getRequirementDate())));
                }
                if (entry.getProposeDeliveryDate() != null) {
                    entry.setProposeDeliveryDate(formatter.parse(formatter.format(entry.getProposeDeliveryDate())));
                }
                if (entry.getProposePurchaseDate() != null) {
                    entry.setProposePurchaseDate(formatter.parse(formatter.format(entry.getProposePurchaseDate())));
                }
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            if (entry.getPrice() == null) {
                entry.setPrice(BigDecimal.ZERO);
            }
            if (entry.getAmount() != null) continue;
            entry.setAmount(BigDecimal.ZERO);
        }
        if (info.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0107c0a812fd463ED552"), sic);
            info.setBillType(billTypeInfo);
        }
        if (info.getYear() == 0 && (pInfo = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)info.getCompanyOrgUnit())) != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
            info.setYear(pInfo.getPeriodYear());
            info.setPeriod(pInfo.getPeriodNumber());
        }
        BigDecimal totalTax = new BigDecimal("0.0");
        BigDecimal totalTaxAmount = new BigDecimal("0.0");
        BigDecimal localTotalTaxAmount = new BigDecimal("0.0");
        BigDecimal totalAmount = new BigDecimal("0.0");
        BigDecimal localTotalAmount = new BigDecimal("0.0");
        int len2 = entries.size();
        for (int i = 0; i < len2; ++i) {
            entry = entries.get(i);
            totalTax = entry.getTax() == null ? totalTax.add(BigDecimal.ZERO) : totalTax.add(entry.getTax());
            totalTaxAmount = entry.getTaxAmount() == null ? totalTaxAmount.add(BigDecimal.ZERO) : totalTaxAmount.add(entry.getTaxAmount());
            localTotalTaxAmount = entry.getLocalTaxAmount() == null ? localTotalTaxAmount.add(BigDecimal.ZERO) : localTotalTaxAmount.add(entry.getLocalTaxAmount());
            totalAmount = entry.getAmount() == null ? totalAmount.add(BigDecimal.ZERO) : totalAmount.add(entry.getAmount());
            localTotalAmount = entry.getLocalAmount() == null ? localTotalAmount.add(BigDecimal.ZERO) : localTotalAmount.add(entry.getLocalAmount());
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
        info.setLocalTotalAmount(localTotalAmount);
        info.setLocalTotalTaxAmount(totalTaxAmount);
    }

    private void setEntryDefaultValue(PurRequestEntryInfo entry, PurRequestInfo info) {
        if (entry != null && info != null) {
            if (info.getBizDate() != null) {
                entry.setBizDate(info.getBizDate());
            }
            if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
                entry.setCompanyOrgUnit(info.getCompanyOrgUnit().getId().toString());
            }
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    protected CtrlUnitInfo getCU(Context ctx, PurRequestInfo model) {
        CompanyOrgUnitInfo mainOrg = model.getCompanyOrgUnit();
        if (mainOrg != null && mainOrg.getCU() == null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("CU.id"));
                mainOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrg.getId().toString()), sic);
            }
            catch (Exception e) {
                return ContextUtil.getCurrentCtrlUnit((Context)ctx);
            }
            return mainOrg.getCU();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        info.setNumber("210");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurRequestInfo info = (PurRequestInfo)model;
        return info.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }
}

