/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PurReqGatherWriteBack
extends AbstractBusinessProcessor {
    public PurReqGatherWriteBack(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqGatherWriteBack(ProcessorConstructParam param) {
        super(param);
    }

    public PurReqGatherWriteBack(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        this.writeBackMergeBillEntry(objCol);
    }

    private void writeBackMergeBillEntry(IObjectCollection objCol) throws BOSException {
        PurRequestEntryInfo tmpEntryInfo;
        PurRequestEntryCollection tmpEntryInfoColl;
        HashSet<ObjectUuidPK> newBillPkSet = new HashSet<ObjectUuidPK>();
        HashMap<String, PurRequestEntryInfo> newEntryMap = new HashMap<String, PurRequestEntryInfo>();
        HashMap<String, Integer> lineChangeEntryMap = new HashMap<String, Integer>();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            PurRequestInfo tmpInfo = (PurRequestInfo)objCol.getObject(i);
            if (null == tmpInfo.getId() || !tmpInfo.isIsMergeBill()) continue;
            ObjectUuidPK tmpPk = new ObjectUuidPK(tmpInfo.getId().toString());
            newBillPkSet.add(tmpPk);
            tmpEntryInfoColl = tmpInfo.getEntries();
            for (int j = 0; j < tmpEntryInfoColl.size(); ++j) {
                tmpEntryInfo = tmpEntryInfoColl.get(j);
                tmpEntryInfo.setSeq(j + 1);
                if (tmpEntryInfo.getId() == null) continue;
                newEntryMap.put(tmpEntryInfo.getId().toString(), tmpEntryInfo);
            }
        }
        if (newBillPkSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", newBillPkSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            PurRequestCollection oldInfoColl = PurRequestFactory.getLocalInstance((Context)this.ctx).getPurRequestCollection(view);
            HashMap<String, Integer> deleteEntryMap = new HashMap<String, Integer>();
            for (int i = 0; i < oldInfoColl.size(); ++i) {
                tmpEntryInfoColl = oldInfoColl.get(i).getEntries();
                for (int j = 0; j < tmpEntryInfoColl.size(); ++j) {
                    tmpEntryInfo = tmpEntryInfoColl.get(j);
                    if (tmpEntryInfo.getId() == null) continue;
                    deleteEntryMap.put(tmpEntryInfo.getId().toString(), tmpEntryInfo.getSeq());
                }
            }
            for (String id : newEntryMap.keySet()) {
                deleteEntryMap.remove(id);
                int newSeq = ((PurRequestEntryInfo)newEntryMap.get(id)).getSeq();
                lineChangeEntryMap.put(id, newSeq);
            }
            try {
                if (deleteEntryMap.size() > 0) {
                    this.updateSrcEntryStatus(deleteEntryMap.keySet());
                }
                if (lineChangeEntryMap.size() > 0) {
                    this.updateSrcEntryLineNum(lineChangeEntryMap);
                }
            }
            catch (SQLException e) {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
        }
    }

    private void updateSrcEntryLineNum(Map<String, Integer> lineChangeEntryMap) throws BOSException {
        String updateEntryLineNum = "update T_SM_PurRequestEntry set FMergeBillSeq = ? where FMergeBillEntryId = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String key : lineChangeEntryMap.keySet()) {
            params.add(new Object[]{lineChangeEntryMap.get(key), key});
        }
        DbUtil.executeBatch((Context)this.ctx, (String)updateEntryLineNum, params);
    }

    private void updateSrcEntryStatus(Set<String> entryIdSet) throws BOSException, SQLException {
        String selectMergeBillSql = "select FID, FPARENTID from T_SM_PurRequestEntry where FMergeBillEntryId in (" + this.generateQuestionMark(entryIdSet.size()) + ")";
        IRowSet resultSet = DbUtil.executeQuery((Context)this.ctx, (String)selectMergeBillSql, (Object[])entryIdSet.toArray());
        HashSet<String> entryIds = new HashSet<String>();
        HashSet<String> billIds = new HashSet<String>();
        while (resultSet.next()) {
            entryIds.add(resultSet.getString("FID"));
            billIds.add(resultSet.getString("FPARENTID"));
        }
        if (entryIds.size() > 0 && billIds.size() > 0) {
            String updateEntryBillSql = "update T_SM_PurRequestEntry set FBASESTATUS = 4, FMergeBillSeq = 0, FMergeBillEntryId = null, FMergeBillNumber = null where FID in (" + this.generateQuestionMark(entryIds.size()) + ")";
            DbUtil.execute((Context)this.ctx, (String)updateEntryBillSql, (Object[])entryIds.toArray());
            String updateBillSql = "update T_SM_PurRequest set FBASESTATUS = 4 where FID in (" + this.generateQuestionMark(billIds.size()) + ")";
            DbUtil.execute((Context)this.ctx, (String)updateBillSql, (Object[])billIds.toArray());
            ArrayList<String> params = new ArrayList<String>();
            params.addAll(billIds);
            params.addAll(billIds);
            String delBotpSql = "delete from t_bot_relation where fsrcentityid = '25428F2E' and fdestentityid = '25428F2E'  and fsrcobjectid in (" + this.generateQuestionMark(billIds.size()) + ") and fsrcobjectid in (select bill.fid from T_SM_PurRequest bill   where bill.FId in (" + this.generateQuestionMark(billIds.size()) + ")  and Not exists (select FParentId from T_SM_PurRequestEntry entry where entry.fparentid = bill.fid and entry.FMergeBillEntryId is not null))";
            DbUtil.execute((Context)this.ctx, (String)delBotpSql, (Object[])params.toArray());
        }
    }

    private String generateQuestionMark(int length) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            result.append("?");
            if (i == length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }
}

