/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class PurReqSetBillStatus4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -7904788911499480536L;

    public PurReqSetBillStatus4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqSetBillStatus4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqSetBillStatus4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        this.setBillStatus(objCol);
    }

    private void setBillStatus(IObjectCollection objCol) throws BOSException, EASBizException {
        String updateSql = "update T_SM_PurRequest set FBaseStatus = 1,FAuditorId=null,FAuditTime = null where fid = ?";
        String updateEntrySql = "update T_SM_PurRequestEntry set FBaseStatus = 1 where FParentID =?";
        Connection con = null;
        PreparedStatement batchStatement = null;
        PreparedStatement batchStatemententry = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)this.ctx);
            batchStatement = con.prepareStatement(updateSql.toString());
            batchStatemententry = con.prepareStatement(updateEntrySql.toString());
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                PurRequestInfo info = (PurRequestInfo)objCol.getObject(i);
                if (info == null) continue;
                batchStatement.setString(1, info.getId().toString());
                batchStatemententry.setString(1, info.getId().toString());
                batchStatement.addBatch();
                batchStatemententry.addBatch();
            }
            batchStatement.executeBatch();
            batchStatemententry.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup(batchStatemententry);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatemententry);
        SQLUtils.cleanup((Connection)con);
    }
}

