/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest.PurReqBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurReqWriteBackPlanOrder4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -7874338532842839109L;
    private static final Logger logger = CoreUIObject.getLogger(PurReqWriteBackPlanOrder4AuditProcessor.class);

    public PurReqWriteBackPlanOrder4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqWriteBackPlanOrder4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqWriteBackPlanOrder4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        ArrayList<IObjectPK> list = new ArrayList<IObjectPK>();
        String tmpTable = null;
        try {
            tmpTable = this.insertdata(this.ctx, pks);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("basestatus"));
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("isMergeBill"));
            sic.add(new SelectorItemInfo("purchaseType"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.name"));
            sic.add(new SelectorItemInfo("companyOrgUnit.number"));
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("billType.number"));
            sic.add(new SelectorItemInfo("billType.name"));
            sic.add(new SelectorItemInfo("sourceBillType.id"));
            sic.add(new SelectorItemInfo("sourceBillType.name"));
            sic.add(new SelectorItemInfo("sourceBillType.number"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.qty"));
            sic.add(new SelectorItemInfo("entries.baseQty"));
            sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
            sic.add(new SelectorItemInfo("entries.basestatus"));
            sic.add(new SelectorItemInfo("entries.unit.id"));
            sic.add(new SelectorItemInfo("entries.material.id"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            String sqlstr = " select fid from " + tmpTable;
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sqlstr, CompareType.INNER));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)this.ctx);
            PurRequestCollection col = iPurRequest.getPurRequestCollection(viewInfo);
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PurRequestInfo purRequestInfo = (PurRequestInfo)col.getObject(i);
                if (purRequestInfo != null && purRequestInfo.getSourceBillType() != null && purRequestInfo.getSourceBillType().equals((Object)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                    list.add((IObjectPK)new ObjectUuidPK(purRequestInfo.getId()));
                }
                if (purRequestInfo.getSourceBillType() != null && "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=".equals(purRequestInfo.getSourceBillType().getId().toString())) {
                    this.batchCheck(this.ctx, batchResults);
                    this.writeBackPurRequirement(purRequestInfo);
                }
                this.requestBudgetForPurReqest(purRequestInfo);
            }
            if (list.size() > 0) {
                this.writeBackPlanOrder(list);
            }
        }
        finally {
            if (tmpTable != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tmpTable);
            }
        }
        long time2 = System.currentTimeMillis();
        logger.info((Object)("@@PurReqWriteBackPlanOrder4AuditProcessor\uff1a" + (time2 - time1)));
    }

    private void writeBackPurRequirement(PurRequestInfo purRequestInfo) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        Statement unitStatement = null;
        PreparedStatement updateStatement = null;
        String updateSql = "update T_SM_PurRequirementEntry set FAssociateQty = FQty-FTotalPurRequestQty-?,FTotalPurRequestQty = FTotalPurRequestQty+?,FassociateBaseQty = FassociateBaseQty-? where FID = ?";
        PurRequestEntryCollection entries = null;
        PurRequestEntryInfo entryInfo = null;
        BigDecimal qty = BigDecimal.ZERO;
        String sourceBillEntryId = null;
        ArrayList<String> sourceEntryIdList = new ArrayList<String>();
        try {
            con = SCMBizProcessorUtil.getConnection((Context)this.ctx);
            statement = con.createStatement();
            unitStatement = con.createStatement();
            updateStatement = con.prepareStatement(updateSql);
            entries = purRequestInfo.getEntries();
            StringBuffer srcIds = new StringBuffer();
            for (int i = 0; i < entries.size(); ++i) {
                if (entries.get(i).getSourceBillEntryId() == null) continue;
                srcIds.append("'").append(entries.get(i).getSourceBillEntryId()).append("',");
            }
            if (srcIds.length() <= 0) {
                return;
            }
            srcIds.setLength(srcIds.length() - 1);
            StringBuffer selSql = new StringBuffer();
            selSql.append("SELECT fid,FUnitID FROM T_SM_PurRequirementEntry where FID in (").append(srcIds).append(")");
            ResultSet unitSet = unitStatement.executeQuery(selSql.toString());
            HashMap<String, String> srcBillEntryUnitMap = new HashMap<String, String>();
            while (unitSet.next()) {
                srcBillEntryUnitMap.put(unitSet.getString(1), unitSet.getString(2));
            }
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.get(i);
                if (!EntryBaseStatusEnum.AUDITED.equals((Object)entryInfo.getBaseStatus())) continue;
                qty = entryInfo.getQty();
                sourceBillEntryId = entryInfo.getSourceBillEntryId();
                if (sourceBillEntryId == null) continue;
                String materialID = null;
                MeasureUnitInfo unit = new MeasureUnitInfo();
                MeasureUnitInfo reqUnit = entryInfo.getUnit();
                unit.setId(BOSUuid.read((String)((String)srcBillEntryUnitMap.get(sourceBillEntryId))));
                if (null != entryInfo.getMaterial()) {
                    materialID = entryInfo.getMaterial().getId().toString();
                    qty = SCMUtil.getExchangeQtyForClient((Context)this.ctx, (String)materialID, (MeasureUnitInfo)reqUnit, (MeasureUnitInfo)unit, (BigDecimal)qty);
                }
                updateStatement.setBigDecimal(1, qty);
                updateStatement.setBigDecimal(2, qty);
                updateStatement.setBigDecimal(3, entryInfo.getBaseQty());
                updateStatement.setString(4, sourceBillEntryId);
                updateStatement.addBatch();
                sourceEntryIdList.add(sourceBillEntryId);
            }
            updateStatement.executeBatch();
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(((String)sourceEntryIdList.get(i)).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateClosePRMEntryBuffer = new StringBuffer();
                updateClosePRMEntryBuffer.append(" update ").append(" T_SM_PurRequirementEntry set FBaseStatus =7").append(" where FTotalPurRequestQty >= FQty and fid in(").append(sqlParams.toString()).append(")");
                statement.execute(updateClosePRMEntryBuffer.toString());
                StringBuffer updateClosePRMBuffer = new StringBuffer();
                updateClosePRMBuffer.append(" update T_SM_PurRequirement set FBaseStatus = 7");
                updateClosePRMBuffer.append(" where fid not in (select FParentID from T_SM_PurRequirementEntry where FBaseStatus <>7 and  ");
                updateClosePRMBuffer.append("FParentID in (select DISTINCT FParentID from T_SM_PurRequirementEntry where fid in(").append(sqlParams.toString()).append(")))");
                updateClosePRMBuffer.append(" and fid in(select DISTINCT FParentID from T_SM_PurRequirementEntry where fid in (").append(sqlParams.toString()).append("))");
                statement.execute(updateClosePRMBuffer.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void writeBackPlanOrder(List<IObjectPK> list) throws BOSException, EASBizException {
        if (list.size() > 0) {
            IObjectPK[] updatePks = new IObjectPK[list.size()];
            System.arraycopy(list.toArray(), 0, updatePks, 0, list.size());
            PurReqBizProcessorUtil.writePlanOrder(this.ctx, updatePks, BizActionEnum.AUDIT);
        }
    }

    private void requestBudgetForPurReqest(PurRequestInfo purRequestInfo) throws BOSException, EASBizException {
        if (!PurBgCtrlUtil.isNewPurBudget((Context)this.ctx).booleanValue()) {
            BgControlCaller caller;
            IControlResult result;
            if (purRequestInfo != null && purRequestInfo.getCompanyOrgUnit() != null && !purRequestInfo.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == purRequestInfo.getPurchaseType() && SCMBizProcessorUtil.isControlBudget((Context)this.ctx, (SCMBillBaseInfo)purRequestInfo, (String)purRequestInfo.getCompanyOrgUnit().getId().toString(), (int)1) && (result = (caller = new BgControlCaller()).requestBudget(this.ctx, purRequestInfo.getId())).getResult() != 1) {
                if (result.getCause() instanceof List) {
                    throw new BOSException(((String)result.getCause().get(0)).toString());
                }
                throw new BOSException(result.getCause().toString());
            }
        } else {
            PurBgCtrlUtil.requestBudgetForPurRequest((Context)this.ctx, (PurRequestInfo)purRequestInfo, null);
        }
    }

    public void batchCheck(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        Set bizFlowIdSet = new HashSet();
        String tableName = "T_SM_PurRequestEntry";
        String[] ids = batchResults.getToDoIdsArray();
        Set idsSet = batchResults.getToDoIdsSet();
        if (ids != null && ids.length > 0 && SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName)) {
            bizFlowIdSet = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (String[])ids);
        }
        HashSet<String> prmSet = new HashSet<String>();
        PurRequestInfo purRequestInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillType.id", (Object)"U5fWOTkYRA2hXGJ+KZy/wkY+1VI=", CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("baseStatus");
        view.getSelector().add("sourceBillType.id");
        view.getSelector().add("sourceBillType.number");
        view.getSelector().add("sourceBillType.name");
        view.getSelector().add("entries.sourceBillEntryID");
        PurRequestCollection col = PurRequestFactory.getLocalInstance((Context)ctx).getPurRequestCollection(view);
        if (col == null || col.size() < 0) {
            return;
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            purRequestInfo = col.get(i);
            if (purRequestInfo == null) continue;
            prmSet.add(purRequestInfo.getId().toString());
        }
        HashMap<String, String> hsSeq = new HashMap<String, String>();
        HashMap<String, String> hsError = new HashMap<String, String>();
        StringBuffer errorBf = new StringBuffer();
        String sqlIds = "";
        String id = "";
        ObjectStringPK strPK = null;
        for (Object obj : idsSet) {
            if (obj instanceof ObjectStringPK) {
                strPK = (ObjectStringPK)obj;
                id = strPK.getKeyValue();
            } else {
                id = obj.toString();
            }
            if (bizFlowIdSet.contains(id) || !prmSet.contains(id)) continue;
            sqlIds = sqlIds + ",'" + id + "'";
        }
        if (sqlIds.length() == 0) {
            return;
        }
        String SorceBillEntryIDs = this.getSourceIDsStr(sqlIds = sqlIds.substring(1), ctx);
        if (null == SorceBillEntryIDs || SorceBillEntryIDs.equals("")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select isNull(bdmm.fqtyPrecision,2) as fqtyPrecision, purentry.fsourcebillentryid as fsourcebillentryid,purentry.fseq as fseq ,purentry.fmaterialid as fmaterialid,purentry.fmaterialname as fmaterialname,  bdmu.FName_l2 as funitname, bdmm.Fbaseconvsrate ,");
        sql.append("(isNull(purentry.fbaseqty,0) - isNull(prmentry.FASSOCIATEBASEQTY,0)) as foverBaseQty,purentry.fqty,prmentry.Fqty");
        sql.append(" from T_SM_PurRequestEntry as purentry  inner join T_SM_PurRequirementEntry as prmentry on purentry.fsourcebillentryid = prmentry.fid ");
        sql.append("left join t_bd_multimeasureunit as bdmm on bdmm.fmaterialid = purentry.fmaterialid and bdmm.fmeasureunitid = purentry.funitid ");
        sql.append("left join t_bd_multimeasureunit as bdmm2 on bdmm2.fmaterialid = prmentry.fmaterialid and  bdmm2.fmeasureunitid = prmentry.funitid ");
        sql.append("left join t_bd_measureunit as bdmu on bdmu.fid = bdmm.fmeasureunitid");
        sql.append(" where prmentry.FisQuantityUnCtrl=0 and prmentry.FID in (");
        sql.append(SorceBillEntryIDs);
        sql.append(") and purentry.FParentID in (");
        sql.append(sqlIds);
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fseq;
                String sourceBillEntryID = rs.getString("fsourcebillentryid");
                if (hsSeq.containsKey(sourceBillEntryID)) {
                    fseq = (String)hsSeq.get(sourceBillEntryID);
                    fseq = fseq + "," + String.valueOf(rs.getInt("fseq"));
                    hsSeq.put(sourceBillEntryID, fseq);
                    continue;
                }
                fseq = String.valueOf(rs.getInt("fseq"));
                hsSeq.put(sourceBillEntryID, fseq);
                BigDecimal foverBaseqty = rs.getBigDecimal("foverBaseQty");
                BigDecimal baseconvsrate = rs.getBigDecimal("Fbaseconvsrate");
                if (baseconvsrate == null) {
                    baseconvsrate = BigDecimal.ONE;
                }
                int precision = rs.getInt("fqtyPrecision");
                BigDecimal qty = foverBaseqty.divide(baseconvsrate, precision, RoundingMode.HALF_UP);
                hsError.put(sourceBillEntryID, rs.getString("fmaterialname") + PurUtil.getBizResource((String)"OVERQTY", (Context)ctx) + qty + rs.getString("funitname") + "\n");
            }
            rs.beforeFirst();
            String laistId = null;
            String currentId = null;
            while (rs.next()) {
                if (rs.getBigDecimal("foverBaseQty").compareTo(BigDecimal.ZERO) <= 0) continue;
                currentId = rs.getString("fsourcebillentryid");
                if (laistId != null && currentId.equals(laistId)) continue;
                if (errorBf.toString().trim().length() == 0) {
                    errorBf.append("\n");
                }
                errorBf.append(PurUtil.getBizResource((String)"Entrynumber", (Context)ctx) + (String)hsSeq.get(currentId) + PurUtil.getBizResource((String)"EntryRow", (Context)ctx));
                errorBf.append((String)hsError.get(currentId));
                laistId = currentId;
            }
            if (errorBf.length() > 0) {
                throw new PurReqException(PurReqException.PURREQ_QTY_NOMATHCH, (Object[])new String[]{errorBf.toString()});
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getSourceIDsStr(String ids, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FSourceBillEntryID from T_SM_PurRequestEntry where FParentID in (").append(ids).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet == null || rowSet.size() == 0) {
            return "";
        }
        StringBuffer SorceBillEntryIDs = new StringBuffer();
        try {
            while (rowSet.next()) {
                SorceBillEntryIDs.append("'").append(rowSet.getString("FSourceBillEntryID")).append("'").append(",");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return SorceBillEntryIDs.substring(0, SorceBillEntryIDs.length() - 1);
    }

    private String insertdata(Context ctx, IObjectPK[] pks) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table purorder (fid varchar(44) ");
        sql.append(",CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" insert into ").append(table);
        sql.append(" (fid) values (?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            int size = pks.length;
            for (int i = 0; i < size; ++i) {
                if (pks[i] == null) continue;
                stmt.setString(1, pks[i].toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return table;
    }
}

