/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequest.PurReqBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PurReqWriteBackPlanOrder4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 409189695058972734L;

    public PurReqWriteBackPlanOrder4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqWriteBackPlanOrder4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqWriteBackPlanOrder4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            PurRequestInfo info = (PurRequestInfo)objVal;
            String id = info.getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("CU"));
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("auditor.id"));
            sic.add(new SelectorItemInfo("isMergeBill"));
            sic.add(new SelectorItemInfo("purchaseType"));
            sic.add(new SelectorItemInfo("basestatus"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.name"));
            sic.add(new SelectorItemInfo("companyOrgUnit.number"));
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("billType.number"));
            sic.add(new SelectorItemInfo("billType.name"));
            sic.add(new SelectorItemInfo("sourceBillType.id"));
            sic.add(new SelectorItemInfo("sourceBillType.name"));
            sic.add(new SelectorItemInfo("sourceBillType.number"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.qty"));
            sic.add(new SelectorItemInfo("entries.baseQty"));
            sic.add(new SelectorItemInfo("entries.basestatus"));
            sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
            sic.add(new SelectorItemInfo("entries.unit.id"));
            sic.add(new SelectorItemInfo("entries.material.id"));
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance((Context)this.ctx);
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)new ObjectUuidPK(id), sic);
            if (purRequestInfo.getSourceBillType() != null && "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(purRequestInfo.getSourceBillType().getId().toString())) {
                this.writeBackPlanOrder(purRequestInfo);
            }
            if (purRequestInfo.getSourceBillType() != null && "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=".equals(purRequestInfo.getSourceBillType().getId().toString())) {
                this.writeBackPurRequirement(purRequestInfo);
            }
            this.returnBudgetForPurReqest(purRequestInfo);
        }
    }

    private void writeBackPurRequirement(PurRequestInfo purRequestInfo) throws BOSException, EASBizException {
        String updateSql = "update T_SM_PurRequirementEntry set FAssociateQty = FQty-FTotalPurRequestQty+?,FTotalPurRequestQty = FTotalPurRequestQty-?,FassociateBaseQty = FassociateBaseQty+? where FID = ?";
        Connection con = null;
        Statement statement = null;
        Statement unitStatement = null;
        PreparedStatement updateStatement = null;
        PurRequestEntryCollection entries = null;
        PurRequestEntryInfo entryInfo = null;
        BigDecimal qty = BigDecimal.ZERO;
        String sourceBillEntryId = null;
        ArrayList<String> sourceEntryIdList = new ArrayList<String>();
        try {
            con = SCMBizProcessorUtil.getConnection((Context)this.ctx);
            statement = con.createStatement();
            unitStatement = con.createStatement();
            updateStatement = con.prepareStatement(updateSql);
            entries = purRequestInfo.getEntries();
            StringBuffer srcIds = new StringBuffer();
            for (int i = 0; i < entries.size(); ++i) {
                if (entries.get(i).getSourceBillEntryId() == null) continue;
                srcIds.append("'").append(entries.get(i).getSourceBillEntryId()).append("',");
            }
            if (srcIds.length() <= 0) {
                return;
            }
            srcIds.setLength(srcIds.length() - 1);
            StringBuffer selSql = new StringBuffer();
            selSql.append("SELECT fid,FUnitID FROM T_SM_PurRequirementEntry where FID in (").append(srcIds).append(")");
            ResultSet unitSet = unitStatement.executeQuery(selSql.toString());
            HashMap<String, String> srcBillEntryUnitMap = new HashMap<String, String>();
            while (unitSet.next()) {
                srcBillEntryUnitMap.put(unitSet.getString(1), unitSet.getString(2));
            }
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.get(i);
                qty = entryInfo.getQty();
                sourceBillEntryId = entryInfo.getSourceBillEntryId();
                if (sourceBillEntryId == null) continue;
                String materialID = null;
                MeasureUnitInfo unit = new MeasureUnitInfo();
                MeasureUnitInfo reqUnit = entryInfo.getUnit();
                unit.setId(BOSUuid.read((String)((String)srcBillEntryUnitMap.get(sourceBillEntryId))));
                if (null != entryInfo.getMaterial()) {
                    materialID = entryInfo.getMaterial().getId().toString();
                    qty = SCMUtil.getExchangeQtyForClient((Context)this.ctx, (String)materialID, (MeasureUnitInfo)reqUnit, (MeasureUnitInfo)unit, (BigDecimal)qty);
                }
                updateStatement.setBigDecimal(1, qty);
                updateStatement.setBigDecimal(2, qty);
                updateStatement.setBigDecimal(3, entryInfo.getBaseQty());
                updateStatement.setString(4, sourceBillEntryId);
                updateStatement.addBatch();
                sourceEntryIdList.add(sourceBillEntryId);
            }
            updateStatement.executeBatch();
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(((String)sourceEntryIdList.get(i)).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateUnClosePRMEntryBuffer = new StringBuffer();
                updateUnClosePRMEntryBuffer.append(" update ").append(" T_SM_PurRequirementEntry set FBaseStatus =4").append(" where fid in(").append(sqlParams.toString()).append(")");
                statement.execute(updateUnClosePRMEntryBuffer.toString());
                StringBuffer updateUnClosePRMBuffer = new StringBuffer();
                updateUnClosePRMBuffer.append(" update ").append(" T_SM_PurRequirement set FBaseStatus = 4");
                updateUnClosePRMBuffer.append(" where fid in (select FParentID from T_SM_PurRequirementEntry where FParentID in (select DISTINCT FParentID from T_SM_PurRequirementEntry where fid in(");
                updateUnClosePRMBuffer.append(sqlParams.toString()).append(")))");
                statement.execute(updateUnClosePRMBuffer.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void writeBackPlanOrder(PurRequestInfo purRequestInfo) throws BOSException, EASBizException {
        if (purRequestInfo == null) {
            return;
        }
        String id = purRequestInfo.getId().toString();
        ArrayList<ObjectUuidPK> list = new ArrayList<ObjectUuidPK>();
        if (purRequestInfo.getSourceBillType() != null && purRequestInfo.getSourceBillType().equals((Object)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            list.add(new ObjectUuidPK(purRequestInfo.getId()));
        }
        ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(id)};
        if (list.size() > 0) {
            IObjectPK[] updatePks = new IObjectPK[list.size()];
            System.arraycopy(list.toArray(), 0, updatePks, 0, list.size());
            PurReqBizProcessorUtil.writePlanOrder(this.ctx, (IObjectPK[])pks, BizActionEnum.UNAUDIT);
        }
    }

    private void returnBudgetForPurReqest(PurRequestInfo purRequestInfo) throws BOSException, EASBizException {
        if (!PurBgCtrlUtil.isNewPurBudget((Context)this.ctx).booleanValue()) {
            BgControlCaller caller;
            IControlResult result;
            if (purRequestInfo != null && purRequestInfo.getCompanyOrgUnit() != null && !purRequestInfo.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == purRequestInfo.getPurchaseType() && SCMBizProcessorUtil.isControlBudget((Context)this.ctx, (SCMBillBaseInfo)purRequestInfo, (String)purRequestInfo.getCompanyOrgUnit().getId().toString(), (int)1) && (result = (caller = new BgControlCaller()).returnBudget(this.ctx, purRequestInfo.getId())).getResult() != 1) {
                if (result.getCause() instanceof List) {
                    throw new BOSException(((String)result.getCause().get(0)).toString());
                }
                throw new BOSException(result.getCause().toString());
            }
        } else {
            PurBgCtrlUtil.requestBudgetForPurRequest((Context)this.ctx, (PurRequestInfo)purRequestInfo, null);
        }
    }
}

