/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequestchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeInfo;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PurReqChange2PurReq4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1894785923729432269L;

    public PurReqChange2PurReq4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReqChange2PurReq4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReqChange2PurReq4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        IObjectCollection col = batchResults.getObjCollection();
        HashSet<String> reqIdSet = new HashSet<String>();
        Connection con = null;
        Statement srcRateStatement = null;
        Statement destRateStatement = null;
        HashMap<String, BigDecimal> changeQtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        try {
            con = SCMBizProcessorUtil.getConnection((Context)this.ctx);
            srcRateStatement = con.createStatement();
            destRateStatement = con.createStatement();
            StringBuffer srcBuffer = new StringBuffer();
            StringBuffer purReqIDBuffer = new StringBuffer();
            srcBuffer.append(" select entry.FPurRequestEntryID,entry.FChangeQty,entry.FID,entry.FPurRequestID").append(" from T_SM_PurRequestChangeEntry entry").append(" where entry.FPurRequestEntryID is not null").append(" and entry.FParentID in(").append(params).append(")");
            ResultSet rs = srcRateStatement.executeQuery(srcBuffer.toString());
            while (rs.next()) {
                if (rs.getString(1) == null || rs.getBigDecimal(2) == null) continue;
                reqIdSet.add(rs.getString(4));
                changeQtyMap.put(rs.getString(1), rs.getBigDecimal(2));
                idMap.put(rs.getString(1), rs.getString(3));
                if (purReqIDBuffer.length() != 0) {
                    purReqIDBuffer.append(",");
                }
                purReqIDBuffer.append("'");
                purReqIDBuffer.append(rs.getString(1));
                purReqIDBuffer.append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        catch (SQLDataException e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        this.dealPurReq(this.ctx, col, changeQtyMap, idMap);
        PurRequestChangeInfo changeInfo = (PurRequestChangeInfo)col.getObject(0);
        if (ChangeTypeEnum.fieldChange.equals((Object)changeInfo.getChangeType()) && PurBgCtrlUtil.isNewPurBudget((Context)this.ctx).booleanValue()) {
            PurBgCtrlUtil.requestBudgetForPurReqest((Context)this.ctx, reqIdSet, null, (boolean)true);
        }
    }

    private void dealPurReq(Context ctx, IObjectCollection col, Map changeQtyMap, Map idMap) throws BOSException, EASBizException {
        PurRequestChangeFactory.getLocalInstance((Context)ctx).handleWriteBackForPurReq(changeQtyMap, idMap, col, true);
    }
}

