/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequestchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.SDSMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeInfo;
import java.math.BigDecimal;

public class PurRequestChangeDefaultValue4SaveProcessor
extends SDSMDefaultValueProcessor {
    private static final long serialVersionUID = -5299698921184084863L;

    public PurRequestChangeDefaultValue4SaveProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurRequestChangeDefaultValue4SaveProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() <= 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
        }
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurRequestChangeInfo info = (PurRequestChangeInfo)model;
        if (info.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"+QOcupW6S8yzVP/aipU1DkY+1VI="));
            info.setBillType(billType);
        }
        if (info.getBizType() == null) {
            BizTypeInfo bizType = new BizTypeInfo();
            bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
            info.setBizType(bizType);
        }
        info.setBizDate(info.getBizDate());
        PurRequestChangeEntryInfo entry = null;
        PurRequestChangeEntryCollection entries = info.getEntries();
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            this.setEntryDefaultValue(info, entry);
        }
    }

    private void setEntryDefaultValue(PurRequestChangeInfo info, PurRequestChangeEntryInfo entry) throws BOSException {
        if (entry == null) {
            return;
        }
        if (entry.getChangeQty() == null) {
            entry.setChangeQty(BigDecimal.ZERO);
        }
        if (entry.getRealChangeQty() == null) {
            entry.setRealChangeQty(BigDecimal.ZERO);
        }
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"+QOcupW6S8yzVP/aipU1DkY+1VI="));
        info.setNumber("215");
        return info;
    }

    @Override
    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurRequestChangeInfo info = (PurRequestChangeInfo)model;
        return info.getCompanyOrgUnit();
    }

    @Override
    protected String getEntryName() {
        return "entries";
    }
}

