/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequestchange;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeException;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import java.math.BigDecimal;

public class PurRequestChangeDefaultValue4SubmitProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -8795206259142509394L;

    public PurRequestChangeDefaultValue4SubmitProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurRequestChangeDefaultValue4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurRequestChangeDefaultValue4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() <= 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
        }
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        PurRequestChangeEntryInfo entry;
        int i;
        if (model == null) {
            return;
        }
        PurRequestChangeInfo info = (PurRequestChangeInfo)model;
        if (null == info.getAlterrationReason() || info.getAlterrationReason().equalsIgnoreCase("")) {
            throw new PurReqException(PurReqException.REQCHANGE_REASON_NULL);
        }
        PurRequestChangeEntryCollection entries = info.getEntries();
        for (i = entries.size() - 1; i >= 0; --i) {
            entry = entries.get(i);
            if (null != entry.getPurRequest()) continue;
            entries.removeObject(i);
        }
        if (entries == null || entries.size() == 0) {
            throw new PurReqException(PurReqException.PURREQC_ALL_EMPTY_ENTRY);
        }
        for (i = 0; i < entries.size(); ++i) {
            entry = entries.get(i);
            if (null == entry.getPurRequest()) {
                throw new PurReqException(PurReqException.PURREQC_EMPTY_ENTRY, new Object[]{i + 1});
            }
            if (info.getChangeType().equals((Object)ChangeTypeEnum.fieldChange)) {
                if (entry.getChangeQty().compareTo(new BigDecimal("0.0")) != 0 || null != entry.getChangeDays() && entry.getChangeDays().compareTo(SysConstant.BIGZERO) != 0 || null == entry.getPurRequestEntry()) continue;
                ObjectUuidPK entryId = new ObjectUuidPK(entry.getPurRequestEntry().getId());
                PurRequestEntryInfo purRequestEntryInfo = PurRequestEntryFactory.getLocalInstance((Context)this.ctx).getPurRequestEntryInfo((IObjectPK)entryId);
                PurchaseGroupInfo oldPurchaseGroup = purRequestEntryInfo.getPurchaseGroup();
                PersonInfo oldPurchasePerson = purRequestEntryInfo.getPurchasePerson();
                PurchaseGroupInfo newPurchaseGroup = entry.getPurchaseGroup();
                PersonInfo newPurchasePerson = entry.getPurchasePerson();
                if (!this.comparePurchaseGroup(oldPurchaseGroup, newPurchaseGroup) || !this.comparePurchasePerson(oldPurchasePerson, newPurchasePerson) || !this.compareStr(purRequestEntryInfo.getRemark(), entry.getRemark())) continue;
                throw new PurRequestChangeException(PurRequestChangeException.QTY_DATE_GROUP_PERSON_CANNOT_EMPTY, new Object[]{i + 1});
            }
            if (entry.getChangeQty().compareTo(new BigDecimal("0.0")) != 0) continue;
            throw new PurRequestChangeException(PurRequestChangeException.QTY_CANNOT_EMPTY);
        }
        if (info.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"+QOcupW6S8yzVP/aipU1DkY+1VI="));
            info.setBillType(billType);
        }
        if (info.getBizType() == null) {
            BizTypeInfo bizType = new BizTypeInfo();
            bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
            info.setBizType(bizType);
        }
        info.setBizDate(info.getBizDate());
        PurRequestChangeEntryInfo entry2 = null;
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        int len = entries.size();
        for (int i2 = 0; i2 < len; ++i2) {
            entry2 = entries.get(i2);
            entry2.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            this.setEntryDefaultValue(info, entry2);
        }
    }

    private boolean comparePurchaseGroup(PurchaseGroupInfo oldPurchaseGroup, PurchaseGroupInfo newPurchaseGroup) {
        if (null == oldPurchaseGroup && newPurchaseGroup != null) {
            return false;
        }
        if (null != oldPurchaseGroup) {
            if (newPurchaseGroup == null) {
                return false;
            }
            return oldPurchaseGroup.getId().equals((Object)newPurchaseGroup.getId());
        }
        return true;
    }

    private boolean comparePurchasePerson(PersonInfo oldPurchasePerson, PersonInfo newPurchasePerson) {
        if (null == oldPurchasePerson && newPurchasePerson != null) {
            return false;
        }
        if (null != oldPurchasePerson) {
            if (newPurchasePerson == null) {
                return false;
            }
            return oldPurchasePerson.getId().equals((Object)newPurchasePerson.getId());
        }
        return true;
    }

    private boolean compareStr(String oldStr, String newStr) {
        if (null == oldStr && newStr != null) {
            return false;
        }
        if (null != oldStr) {
            if (newStr == null) {
                return false;
            }
            return oldStr.equals(newStr);
        }
        return true;
    }

    private void setEntryDefaultValue(PurRequestChangeInfo info, PurRequestChangeEntryInfo entry) throws BOSException {
        if (entry == null) {
            return;
        }
        if (entry.getChangeQty() == null) {
            entry.setChangeQty(BigDecimal.ZERO);
        }
        if (entry.getRealChangeQty() == null) {
            entry.setRealChangeQty(BigDecimal.ZERO);
        }
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"+QOcupW6S8yzVP/aipU1DkY+1VI="));
        info.setNumber("215");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurRequestChangeInfo info = (PurRequestChangeInfo)model;
        return info.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }
}

