/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequirement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;

public class MatReqWriteBackPurRequirementProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 5297643946525947462L;
    private static String strMaterialRequestBillEntry = "T_IM_MaterialRequestBillEntry";

    public MatReqWriteBackPurRequirementProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public MatReqWriteBackPurRequirementProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public MatReqWriteBackPurRequirementProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue info = objCol.getObject(i);
            if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)"t_im_materialrequestbill") && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)"t_im_materialrequestbillentry", (String)info.get("id").toString()) || !(info instanceof MaterialRequestBillInfo)) continue;
            this.writeBackPurRequirement(this.ctx, info);
        }
    }

    private void writeBackPurRequirement(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)model;
        if (info.getSourceBillType() == null || !info.getSourceBillType().getId().toString().equals("U5fWOTkYRA2hXGJ+KZy/wkY+1VI=")) {
            return;
        }
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            this.checkWriteBackQty(ctx, strMaterialRequestBillEntry, info.getId().toString());
        }
        StringBuffer sqlBuff = new StringBuffer();
        String entryId = null;
        String sourceBillEntryId = null;
        String strOpt = "+";
        StringBuffer sqlBuff2 = new StringBuffer();
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            strOpt = "-";
        }
        for (int j = 0; j < info.getEntry().size(); ++j) {
            entryId = info.getEntry().get(j).getId().toString();
            sourceBillEntryId = info.getEntry().get(j).getSourceBillEntryId();
            sqlBuff.append("update T_SM_PurRequirementEntry set FTotalPurRequestQty=isnull(FTotalPurRequestQty,0)").append(strOpt);
            sqlBuff.append(MatReqWriteBackPurRequirementProcessor.getQtySql(entryId, strMaterialRequestBillEntry));
            sqlBuff.append(" where fid='").append(sourceBillEntryId).append("';");
        }
        if (sqlBuff.length() > 0) {
            KsqlUtil.executeBatch((Context)ctx, (String[])sqlBuff.toString().split(";"));
        }
    }

    private void checkWriteBackQty(Context ctx, String TableName, String id) throws BOSException, EASBizException {
        StringBuffer sqlBuff = new StringBuffer();
        String totalReqFiledName = "FTotalPurRequestQty";
        String writeBackFiledName = "FApprovedQty";
        sqlBuff.append("select entry.").append(writeBackFiledName).append(" from ").append(TableName).append(" entry");
        sqlBuff.append(" left join T_BD_MultiMeasureUnit unit on entry.FMaterialID = unit.FMaterialID and entry.FUnitId = unit.FMeasureUnitID");
        sqlBuff.append(" left join T_SM_PurRequirementEntry imBill on imbill.FID=entry.fCorebillentryid");
        sqlBuff.append(" left join  T_BD_MultiMeasureUnit imunit on imBill.FMaterialID =imunit.FMaterialID and imBill.FUnitId = imunit.FMeasureUnitID");
        sqlBuff.append(" where imBill.FisQuantityUnCtrl=0 and  entry.fparentid='").append(id).append("' ");
        sqlBuff.append(" and isnull(entry.").append(writeBackFiledName).append(",0)").append("/isnull(imunit.FBaseConvsRate,1)*isnull(unit.FBaseConvsRate,1)+");
        sqlBuff.append("imBill.");
        sqlBuff.append(totalReqFiledName).append(">imbill.FQty;");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        if (rowSet.size() > 0) {
            throw new PurRequirementException(PurRequirementException.NOT_AUDIT_MATERIALREQ_FORPURREQUIMENTQTY);
        }
    }

    private static StringBuffer getQtySql(String fid, String TableName) {
        StringBuffer qtySql = new StringBuffer();
        qtySql.append("(select isnull(entry.FApprovedQty,0)/isnull(imunit.FBaseConvsRate,1)*isnull(unit.FBaseConvsRate,1) from ").append(TableName).append(" entry ");
        qtySql.append(" left join  T_BD_MultiMeasureUnit unit on entry.FMaterialID = unit.FMaterialID and entry.FUnitId = unit.FMeasureUnitID");
        qtySql.append(" left join T_SM_PurRequirementEntry imBill on imbill.FID=entry.fCorebillentryid");
        qtySql.append(" left join  T_BD_MultiMeasureUnit imunit on imBill.FMaterialID =imunit.FMaterialID and imBill.FUnitId = imunit.FMeasureUnitID");
        qtySql.append(" where  entry.fid='").append(fid).append("') ");
        return qtySql;
    }
}

