/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequirement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.SDSMBizDataCheckProcessor;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementException;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PurRequirementBizDataCheckProcessor
extends SDSMBizDataCheckProcessor {
    private static final long serialVersionUID = 6664930633327211556L;

    public PurRequirementBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurRequirementBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        this.doCheck(batchResults);
    }

    private void doCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null) {
            return;
        }
        Map materialPlanMap = new HashMap();
        if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
            materialPlanMap = this.batchFetchMatPlanCol(this.ctx, collection);
        }
        PurRequirementInfo info = null;
        PurRequirementEntryCollection entries = null;
        PurRequirementEntryInfo entry = null;
        RowTypeInfo rowTypeInfo = null;
        MaterialPlanInfo mpInfo = null;
        int len = collection[0].toArray().length;
        int nrow = 0;
        int size = len;
        for (int i = 0; i < size; ++i) {
            if (!(collection[0].toArray()[i] instanceof PurRequirementInfo) || (info = (PurRequirementInfo)collection[0].toArray()[i]) == null) continue;
            entries = info.getEntries();
            entry = null;
            if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
                if (info.getCompanyOrgUnit() == null) {
                    throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_COMPANYORGUNIT", (Context)this.ctx)});
                }
                if (info.getBaseStatus().getValue() != 0 && info.getBaseStatus().getValue() != 1) {
                    throw new PurRequirementException(PurRequirementException.ORDER_ONLYTEMP_CANBE_SAVE);
                }
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) continue;
            if (info.getBaseStatus().getValue() != 0 && info.getBaseStatus().getValue() != 1 && info.getBaseStatus().getValue() != 2 && info.getBaseStatus().getValue() != -2) {
                throw new PurRequirementException(PurRequirementException.CANNOT_UPDATE, (Object[])new String[]{info.getBaseStatus().toString()});
            }
            if (info.getCompanyOrgUnit() == null) {
                throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_COMPANYORGUNIT", (Context)this.ctx)});
            }
            if (info.getBizDate() == null) {
                throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"REQUEST_FIELD_REQDATE", (Context)this.ctx)});
            }
            if (info.getDemandType() == null) {
                throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"FIELD_DEMANDTYPE", (Context)this.ctx)});
            }
            if (info.getPerson() == null) {
                throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"FIELD_PERSON", (Context)this.ctx)});
            }
            if (info.getAdminOrg() == null) {
                throw new PurRequirementException(PurRequirementException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"FIELD_ADMINORGUNIT", (Context)this.ctx)});
            }
            boolean isBotp = false;
            if (info != null && info.getSourceBillType() != null) {
                isBotp = true;
            }
            if ((nrow = info.getEntries().size()) <= 0) {
                throw new PurRequirementException(PurRequirementException.ENTRY_CANNOT_EMPTY);
            }
            if (entries == null) continue;
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry == null) continue;
                rowTypeInfo = entry.getRowType();
                if (rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterial() == null && entry.getMaterialGroup() == null) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_MATERIAL", (Context)this.ctx)});
                }
                if (!rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterialName() == null) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"batchSumbit_checkMaterialName", (Context)this.ctx)});
                }
                if (entry.getUnit() == null) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_UNIT", (Context)this.ctx)});
                }
                if (entry.getRequestQty() == null || SysConstant.BIGZERO.compareTo(entry.getRequestQty()) == 0) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_RequestQty", (Context)this.ctx)});
                }
                if (rowTypeInfo != null && rowTypeInfo.getDestinationType() == null) {
                    rowTypeInfo = RowTypeFactory.getLocalInstance((Context)this.ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK(rowTypeInfo.getId().toString()));
                }
                if ("10".equals(rowTypeInfo.getDestinationType().getValue()) && entry.getReceivedOrgUnit() == null) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_STORAGEORGUNIT_R", (Context)this.ctx)});
                }
                if (entry.getRequirementDate() == null) {
                    throw new PurRequirementException(PurRequirementException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ENTRY_FIELD_REQDATE", (Context)this.ctx)});
                }
                if (entry != null && entry.getReceivedOrgUnit() != null && entry.getReceivedOrgUnit().getId() != null && entry.getMaterial() != null && entry.getMaterial().getId() != null && (mpInfo = (MaterialPlanInfo)materialPlanMap.get(entry.getMaterial().getId().toString() + entry.getReceivedOrgUnit().getId().toString())) != null) {
                    InvServerUtils.checkProjectTrackIsNotNull((Context)this.ctx, (boolean)isBotp, (int)(j + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNo());
                }
                if (null == entry.getMaterial() || null == info.getCompanyOrgUnit()) continue;
                boolean flag = this.isEnableAssistAttr(info.getCompanyOrgUnit().getId().toString());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)entry.getMaterial().getId().toString(), CompareType.INCLUDE));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("assistAttr.id"));
                sic.add(new SelectorItemInfo("assistAttr.name"));
                sic.add(new SelectorItemInfo("assistAttr.number"));
                view.setSelector(sic);
                MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialCollection(view);
                if (null == materialCol || materialCol.size() <= 0 || materialCol.get(0).getAssistAttr() == null || flag || entry.getAssistProperty() != null) continue;
                throw new PurRequirementException(PurRequirementException.ENTRY_ASSISTUNIT_NULL, (Object[])new String[]{String.valueOf(j + 1)});
            }
        }
    }

    public boolean isEnableAssistAttr(String companyOrgUnitId) throws EASBizException, BOSException {
        boolean isEnableAssistAttr = false;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)this.ctx);
        String isAssistAttr = scmParam.getParamByBillTypeID("SM_PRM_01", 1, companyOrgUnitId, "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=");
        if (isAssistAttr != null && isAssistAttr.trim().equalsIgnoreCase("1")) {
            isEnableAssistAttr = true;
        }
        return isEnableAssistAttr;
    }

    private Map batchFetchMatPlanCol(Context ctx, BatchExecuteParamsEntry[] collection) throws BOSException {
        PurRequirementInfo info = null;
        PurRequirementEntryCollection entries = null;
        PurRequirementEntryInfo entry = null;
        int len = collection[0].toArray().length;
        Map materialPlanMap = new HashMap();
        HashSet<String> storageIDs = new HashSet<String>();
        HashSet<String> materialIDs = new HashSet<String>();
        int size = len;
        for (int i = 0; i < size; ++i) {
            if (!(collection[0].toArray()[i] instanceof PurRequirementInfo) || (info = (PurRequirementInfo)collection[0].toArray()[i]) == null) continue;
            entries = info.getEntries();
            entry = null;
            if (entries == null) continue;
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                    materialIDs.add(entry.getMaterial().getId().toString());
                }
                if (entry == null || entry.getReceivedOrgUnit() == null || entry.getReceivedOrgUnit().getId() == null) continue;
                storageIDs.add(entry.getReceivedOrgUnit().getId().toString());
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("manufactureStrategy"));
        sic.add(new SelectorItemInfo("isolatedRule"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isolatedRule"));
        materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)ctx, materialIDs, storageIDs, (SelectorItemCollection)sic);
        return materialPlanMap;
    }
}

