/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequirement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PurRequirementDefaultValue4SubmitProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -6076728046740402620L;

    public PurRequirementDefaultValue4SubmitProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurRequirementDefaultValue4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurRequirementDefaultValue4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() <= 0) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue(objVal);
        }
    }

    private void setDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        PeriodInfo pInfo;
        DemandTypeInfo demandType;
        if (model == null) {
            return;
        }
        PurRequirementInfo info = (PurRequirementInfo)model;
        if (info.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)info.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)info.getBaseStatus())) {
            // empty if block
        }
        if (info.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"U5fWOTkYRA2hXGJ+KZy/wkY+1VI="));
            info.setBillType(billType);
        }
        if ((demandType = info.getDemandType()) != null && (demandType.getRowType() == null || demandType.getPurchanseType() == null)) {
            demandType = PurUtil.getDemandType((Context)this.ctx, (String)info.getDemandType().getId().toString());
            info.setDemandType(demandType);
        }
        if (info.getBizType() == null) {
            BizTypeInfo bizType = new BizTypeInfo();
            if (demandType != null && PurchaseType.SUBCONTRACT.equals((Object)demandType.getPurchanseType())) {
                bizType.setId(BOSUuid.read((String)"1x7KMBq4mUmpj58T4jNPqiQHQ1w="));
            } else {
                bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
            }
            info.setBizType(bizType);
        }
        info.setBizDate(info.getBizDate());
        if (info.getYear() == 0 && (pInfo = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)info.getCompanyOrgUnit())) != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
            info.setYear(pInfo.getPeriodYear());
            info.setPeriod(pInfo.getPeriodNumber());
        }
        PurRequirementEntryInfo entry = null;
        PurRequirementEntryCollection entries = info.getEntries();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            this.setEntryDefaultValue(info, entry, formatter);
        }
    }

    private void setEntryDefaultValue(PurRequirementInfo info, PurRequirementEntryInfo entry, SimpleDateFormat formatter) throws BOSException {
        if (entry == null) {
            return;
        }
        if (entry.getMaterial() != null && StringUtil.isEmpty((String)entry.getMaterialName())) {
            entry.setMaterialName(entry.getMaterial().getName());
        }
        if (entry.getBaseStatus() != null && (EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus()))) {
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        if (info.getDemandType() != null && entry.getRowType() == null) {
            entry.setRowType(info.getDemandType().getRowType());
        }
        if (entry.getBaseQty() == null) {
            entry.setBaseQty(BigDecimal.ZERO);
        }
        if (entry.getRequestQty() == null) {
            entry.setRequestQty(BigDecimal.ZERO);
        }
        if (entry.getQty() == null) {
            entry.setQty(BigDecimal.ZERO);
        }
        if (entry.getAssistQty() == null) {
            entry.setAssistQty(BigDecimal.ZERO);
        }
        entry.setAssociateQty(entry.getQty());
        entry.setAssociateBaseQty(entry.getBaseQty());
        try {
            if (entry.getRequirementDate() != null) {
                entry.setRequirementDate(formatter.parse(formatter.format(entry.getRequirementDate())));
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"U5fWOTkYRA2hXGJ+KZy/wkY+1VI="));
        info.setNumber("205");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurRequirementInfo info = (PurRequirementInfo)model;
        return info.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }
}

