/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purrequirement;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseCollection;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processor.Submit2AuditProcessor;
import com.kingdee.eas.scm.sm.pur.PurRequirementException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurRequirementSubmit2AuditProcessor
extends Submit2AuditProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PurRequirementSubmit2AuditProcessor.class);
    private static final long serialVersionUID = 567490604580446139L;

    public PurRequirementSubmit2AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public PurRequirementSubmit2AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurRequirementSubmit2AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected IObjectCollection getAutoAuditBillCollection(IObjectCollection objCollection) throws BOSException, EASBizException {
        String orgUnitID;
        OrgUnitInfo orgTypeInfo;
        if (null == objCollection || objCollection.size() == 0) {
            return null;
        }
        HashSet<String> orgIdSet = new HashSet<String>(objCollection.size());
        SCMBillBaseInfo info = null;
        int size = objCollection.size();
        for (int i = 0; i < size; ++i) {
            info = (SCMBillBaseInfo)objCollection.getObject(i);
            orgTypeInfo = (OrgUnitInfo)info.get(info.getBizOrgPropertyName());
            if (null == orgTypeInfo) continue;
            orgIdSet.add(orgTypeInfo.getId().toString());
        }
        int orgIdSize = orgIdSet.size();
        SCMBillBaseCollection objCol = new SCMBillBaseCollection();
        if (orgIdSize == 0) {
            return objCol;
        }
        if (orgIdSize > 3) {
            logger.warn("\u6279\u91cf\u63d0\u4ea4\u65f6\uff0c\u4e0d\u540c\u7684\u4e1a\u52a1\u7ec4\u7ec7\u6570\u91cf\u8d85\u8fc73\u4e2a\uff0c\u53d6\u53c2\u6570\u65f6\uff0c\u9700\u4fee\u6539\u4e3a\u6279\u91cf\u53d6\u6570\uff01");
        }
        if (this.getMainOrgType(info) == null) {
            throw new PurRequirementException(PurRequirementException.MUSTCOVER_GETMAINORGTYPE);
        }
        int orgType = this.getMainOrgType(info).getValue();
        String billTypeId = ((SCMBillBaseInfo)objCollection.getObject(0)).getBillType().getId().toString();
        Iterator iterator = orgIdSet.iterator();
        HashMap<String, Boolean> autoAuditOrgMap = new HashMap<String, Boolean>(orgIdSet.size());
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)this.ctx);
        while (iterator.hasNext()) {
            orgUnitID = (String)iterator.next();
            String strAutoAudit = iSCMBillParam.getParamByBillTypeID("SCM_Submit_01", orgType, orgUnitID, billTypeId);
            if (null == strAutoAudit || !"1".equals(strAutoAudit.trim())) continue;
            autoAuditOrgMap.put(orgUnitID, Boolean.TRUE);
        }
        int size2 = objCollection.size();
        for (int i = 0; i < size2; ++i) {
            info = (SCMBillBaseInfo)objCollection.getObject(i);
            orgTypeInfo = (OrgUnitInfo)info.get(info.getBizOrgPropertyName());
            if (null == orgTypeInfo || !autoAuditOrgMap.containsKey(orgUnitID = orgTypeInfo.getId().toString())) continue;
            objCol.addObject((IObjectValue)info);
        }
        return objCol;
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (this.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }
}

