/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purreturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import java.math.BigDecimal;

public class PRTBizProcessorUtil {
    public static void negateValueForWriteBack(Context ctx, PurReturnsInfo info) throws BOSException, EASBizException {
        int size = info.getEntries().size();
        for (int j = 0; j < size; ++j) {
            BigDecimal negateBaseQty = info.getEntries().get(j).getBaseQty().negate();
            info.getEntries().get(j).setBaseQty(negateBaseQty);
            BigDecimal negateQty = info.getEntries().get(j).getQty().negate();
            info.getEntries().get(j).setQty(negateQty);
            BigDecimal negateAmount = info.getEntries().get(j).getTaxAmount().negate();
            info.getEntries().get(j).setTaxAmount(negateAmount);
        }
        PurReturnsFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    public static boolean updatePurInWarehsToOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        boolean flagInWares = true;
        PurReturnsInfo returnInfo = (PurReturnsInfo)info;
        PurReturnsEntryCollection p = returnInfo.getEntries();
        IPurInWarehsEntry iWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        int size = p.size();
        for (int i = 0; i < size; ++i) {
            BigDecimal qty;
            PurReturnsEntryInfo pEntryInfo = p.get(i);
            if (pEntryInfo.getSourceBillEntryId() == null) continue;
            ObjectStringPK warehsEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            PurInWarehsEntryInfo warehsEntryInfo = iWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)warehsEntryPK);
            BigDecimal returnsQty = pEntryInfo.getBaseQty();
            if (returnsQty.compareTo(qty = warehsEntryInfo.getBaseQty().subtract(warehsEntryInfo.getReturnBaseQty())) != 1) continue;
            flagInWares = false;
            return flagInWares;
        }
        BigDecimal returnQty = null;
        IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo returnUnit = null;
        MeasureUnitInfo orderUnit = null;
        int size2 = p.size();
        for (int i = 0; i < size2; ++i) {
            PurReturnsEntryInfo pEntryInfo = p.get(i);
            if (pEntryInfo.getSourceBillEntryId() == null) continue;
            ObjectStringPK warehsEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            PurInWarehsEntryInfo warehsEntryInfo = iWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)warehsEntryPK);
            ObjectStringPK orderEntryPK = new ObjectStringPK(warehsEntryInfo.getPurOrderEntry());
            PurOrderEntryInfo orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            if (orderEntryInfo != null) {
                BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
                BigDecimal baseQty = orderEntryInfo.getTotalReturnedBaseQty();
                returnQty = pEntryInfo.getQty();
                returnUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pEntryInfo.getUnit().getId()));
                if (!returnUnit.equals((Object)(orderUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getUnit().getId()))))) {
                    returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
                }
                if (qty.compareTo(BigDecimal.ZERO) == 0) {
                    orderEntryInfo.setTotalReturnedQty(returnQty);
                    orderEntryInfo.setTotalReturnedBaseQty(pEntryInfo.getBaseQty());
                } else {
                    orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                    orderEntryInfo.setTotalReturnedBaseQty(baseQty.add(pEntryInfo.getBaseQty()));
                }
                iPurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
            }
            returnQty = pEntryInfo.getQty();
            MeasureUnitInfo warehsUnit = null;
            if (warehsEntryInfo.getUnit() != null) {
                warehsUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(warehsEntryInfo.getUnit().getId()));
            }
            if (warehsUnit != null && !warehsUnit.equals(returnUnit)) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)warehsEntryInfo.getMaterial().getId().toString(), (String)warehsEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)warehsEntryInfo.getUnit().getId().toString());
            }
            warehsEntryInfo.setReturnsQty(warehsEntryInfo.getReturnsQty().add(returnQty));
            warehsEntryInfo.setUnReturnedBaseQty((warehsEntryInfo.getUnReturnedBaseQty() == null ? warehsEntryInfo.getBaseQty() : warehsEntryInfo.getUnReturnedBaseQty()).subtract(pEntryInfo.getBaseQty()).abs());
            iWarehsEntry.update((IObjectPK)warehsEntryPK, (CoreBaseInfo)warehsEntryInfo);
        }
        return flagInWares;
    }

    public static boolean updateOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PurOrderEntryInfo orderEntryInfo;
        ObjectStringPK orderEntryPK;
        PurReturnsEntryInfo pEntryInfo;
        int i;
        boolean flagOrder = true;
        PurReturnsInfo returnInfo = (PurReturnsInfo)info;
        PurReturnsEntryCollection p = returnInfo.getEntries();
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
        int size = p.size();
        for (i = 0; i < size; ++i) {
            BigDecimal qty;
            pEntryInfo = p.get(i);
            if (pEntryInfo.getSourceBillEntryId() == null) continue;
            orderEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal returnedQty = pEntryInfo.getBaseQty();
            if (returnedQty.compareTo(qty = orderEntryInfo.getTotalReceiptBaseQty().subtract(orderEntryInfo.getTotalReturnedBaseQty())) != 1) continue;
            flagOrder = false;
            return flagOrder;
        }
        size = p.size();
        for (i = 0; i < size; ++i) {
            MeasureUnitInfo orderUnit;
            pEntryInfo = p.get(i);
            if (pEntryInfo.getSourceBillEntryId() == null) continue;
            orderEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
            BigDecimal baseQty = orderEntryInfo.getTotalReturnedBaseQty();
            BigDecimal returnQty = pEntryInfo.getQty();
            IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitInfo returnUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pEntryInfo.getUnit().getId()));
            if (!returnUnit.equals((Object)(orderUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getUnit().getId()))))) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
            }
            if (qty.compareTo(BigDecimal.ZERO) == 0) {
                orderEntryInfo.setTotalReturnedQty(returnQty);
                orderEntryInfo.setTotalReturnedBaseQty(pEntryInfo.getBaseQty());
            } else {
                orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                orderEntryInfo.setTotalReturnedBaseQty(baseQty.add(pEntryInfo.getBaseQty()));
            }
            iPurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
        return flagOrder;
    }
}

