/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purreturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PRTDefaultValueProcessor
extends SCMDefaultValueProcessor {
    public PRTDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PRTDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PRTDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e006-6152c0a812fd463ED552"));
        info.setNumber("250");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PurReturnsInfo info = (PurReturnsInfo)model;
        PurReturnsEntryCollection col = info.getEntries();
        PurReturnsEntryInfo entry = null;
        if (col != null && col.size() > 0) {
            entry = col.get(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = entry.getCompanyOrgUnit();
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected String getEntryName() {
        return "entries";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block6: {
            IObjectCollection collection;
            block7: {
                block5: {
                    super.doProcessing(batchResults);
                    if (batchResults == null) {
                        return;
                    }
                    collection = batchResults.getObjCollection();
                    if (collection == null || collection.size() <= 0) {
                        return;
                    }
                    if (!BatchActionEnum.SAVE.equals((Object)this.batchAction)) break block5;
                    int size = collection.size();
                    for (int i = 0; i < size; ++i) {
                        IObjectValue model = collection.getObject(i);
                        this.saveDefaultValue(model);
                    }
                    break block6;
                }
                if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) break block7;
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    IObjectValue model = collection.getObject(i);
                    this.submitDefaultValue(model);
                }
                break block6;
            }
            if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) break block6;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue model = collection.getObject(i);
                this.auditDefaultValue(model);
            }
        }
    }

    private void saveDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        PurReturnsInfo purReturnsInfo = (PurReturnsInfo)model;
        purReturnsInfo.setIsSysBill(false);
        if (purReturnsInfo.getCU() == null) {
            purReturnsInfo.setCU(purReturnsInfo.getPurchaseOrgUnit().getCU());
        }
        if (purReturnsInfo.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)purReturnsInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)purReturnsInfo.getBaseStatus())) {
            // empty if block
        }
        PurReturnsEntryCollection entryInfos = purReturnsInfo.getEntries();
        PurReturnsEntryInfo entry = null;
        BigDecimal localTotalAmount = SysConstant.BIGZERO;
        BigDecimal localTotalTaxAmount = SysConstant.BIGZERO;
        BigDecimal localTotalTax = SysConstant.BIGZERO;
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        BigDecimal totalTax = SysConstant.BIGZERO;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            if (entry.getBaseStatus() == null || EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus())) {
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
            if (SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)purReturnsInfo)) {
                BigDecimal baseQty = SCMUtils.getExchangeQtyForServer((Context)this.ctx, (String)entry.getMaterial().getId().toString(), (String)entry.getUnit().getId().toString(), (BigDecimal)entry.getQty(), (String)entry.getBaseUnit().getId().toString());
                entry.setBaseQty(baseQty);
                BigDecimal assistQty = entry.getAssistUnit() != null ? SCMUtils.getExchangeQtyForServer((Context)this.ctx, (String)entry.getMaterial().getId().toString(), (String)entry.getUnit().getId().toString(), (BigDecimal)entry.getQty(), (String)entry.getAssistUnit().getId().toString()) : entry.getAssistQty();
                entry.setAssistQty(assistQty);
                entry.setUnReturnedBaseQty(baseQty);
                entry.setUnReturnedQty(entry.getQty());
            }
            this.setZero(entry);
            localTotalAmount = localTotalAmount.add(entry.getLocalAmount());
            localTotalTaxAmount = localTotalTaxAmount.add(entry.getLocalTaxAmount());
            localTotalTax = localTotalTax.add(entry.getLocalTax());
            totalAmount = totalAmount.add(entry.getAmount());
            totalTaxAmount = totalTaxAmount.add(entry.getTaxAmount());
            totalTax = totalTax.add(entry.getTax());
        }
        purReturnsInfo.setLocalTotalAmount(localTotalAmount);
        purReturnsInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        purReturnsInfo.setTotalTax(localTotalTax);
        purReturnsInfo.setTotalAmount(totalAmount);
        purReturnsInfo.setTotalTaxAmount(totalTaxAmount);
        purReturnsInfo.setTotalTax(totalTax);
    }

    private void submitDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurReturnsInfo purReturnsInfo = (PurReturnsInfo)model;
        if (purReturnsInfo.getCU() == null) {
            purReturnsInfo.setCU(purReturnsInfo.getPurchaseOrgUnit().getCU());
        }
        if (purReturnsInfo.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("50957179-0105-1000-e006-6152c0a812fd463ED552"));
            purReturnsInfo.setBillType(billTypeInfo);
        }
        if (purReturnsInfo.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)purReturnsInfo.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)purReturnsInfo.getBaseStatus())) {
            // empty if block
        }
        PurReturnsEntryCollection entryInfos = purReturnsInfo.getEntries();
        PurReturnsEntryInfo entry = null;
        BigDecimal localTotalAmount = SysConstant.BIGZERO;
        BigDecimal localTotalTaxAmount = SysConstant.BIGZERO;
        BigDecimal localTotalTax = SysConstant.BIGZERO;
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        BigDecimal totalTax = SysConstant.BIGZERO;
        PurEntryDataVO vo = new PurEntryDataVO();
        vo.setIsLoadingMmuPrecision(true);
        int length = entryInfos.size();
        MaterialInfo[] materialInfos = new MaterialInfo[length];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[length];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[length];
        MeasureUnitInfo[] measureAssistUnitInfos = new MeasureUnitInfo[length];
        boolean isBotp = false;
        if (purReturnsInfo != null && purReturnsInfo.getSourceBillType() != null) {
            isBotp = true;
        }
        HashSet<String> storageIDs = new HashSet<String>();
        HashSet<String> materialIDs = new HashSet<String>();
        int num = length;
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            materialInfos[i] = entry.getMaterial();
            measureUnitInfos[i] = entry.getUnit();
            measureBaseUnitInfos[i] = entry.getBaseUnit();
            measureAssistUnitInfos[i] = entry.getAssistUnit();
            if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                materialIDs.add(entry.getMaterial().getId().toString());
            }
            if (entry == null || entry.getStorageOrgUnit() == null || entry.getStorageOrgUnit().getId() == null) continue;
            storageIDs.add(entry.getStorageOrgUnit().getId().toString());
        }
        Map materialPlanMap = new HashMap();
        materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)this.ctx, materialIDs, storageIDs);
        vo.setMeasureUnitInfos(measureUnitInfos);
        vo.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        vo.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        vo.setMaterialInfos(materialInfos);
        vo.setOldMeasureUnitInfos(measureUnitInfos);
        PurEntryDataVO outVO = SCMGroupFacadeFactory.getLocalInstance((Context)this.ctx).loadPurComplexData(vo);
        String voUnitKey = null;
        BigDecimal baseQty = null;
        BigDecimal baseExchangeRate1 = null;
        int num2 = entryInfos.size();
        for (int i = 0; i < num2; ++i) {
            MaterialPlanInfo mpInfo;
            entry = entryInfos.get(i);
            if (entry == null) continue;
            if (entry != null && entry.getStorageOrgUnit() != null && entry.getStorageOrgUnit().getId() != null && entry.getMaterial() != null && entry.getMaterial().getId() != null && (mpInfo = (MaterialPlanInfo)materialPlanMap.get(entry.getMaterial().getId().toString() + entry.getStorageOrgUnit().getId().toString())) != null) {
                InvServerUtils.checkProjectTrackIsNotNull((Context)this.ctx, (boolean)isBotp, (int)(i + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNumber());
            }
            if (!SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)purReturnsInfo)) {
                if (entry.getMaterial() == null) continue;
                voUnitKey = entry.getMaterial().getId().toString() + entry.getUnit().getId().toString();
                baseExchangeRate1 = outVO.getMmuConvsRate().get(voUnitKey) != null ? (BigDecimal)outVO.getMmuConvsRate().get(voUnitKey) : SCMConstant.BIGDECIMAL_ONE;
                baseQty = entry.getQty().multiply(baseExchangeRate1).setScale(16, 4);
                entry.setBaseQty(baseQty);
            }
            if (!purReturnsInfo.getBizType().getId().toString().equals("3IS1Qaa0R32+3JPxlVZg5iQHQ1w=") && !entry.isIsPresent()) {
                if (purReturnsInfo.isIsInTax()) {
                    if (entry.getTaxPrice() == null || entry.getTaxPrice().compareTo(BigDecimal.ZERO) == 0) {
                        throw new PurReturnsException(PurReturnsException.ENTRY_TAXPRICE_NOTNULL, (Object[])new String[]{String.valueOf(i + 1)});
                    }
                } else if (entry.getPrice() == null || entry.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                    throw new PurReturnsException(PurReturnsException.ENTRY_PRICE_NOTNULL, (Object[])new String[]{String.valueOf(i + 1)});
                }
            }
            baseQty = SCMUtils.effectualNumeric((BigDecimal)entry.getBaseQty());
            entry.setUnReturnedBaseQty(baseQty);
            entry.setUnReturnedQty(entry.getQty());
            if (entry.getBaseStatus() == null || EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus())) {
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            entry.setAssociateQty(baseQty);
            if (entry.getQty() != null) {
                if (entry.getInvoicedQty() == null) {
                    entry.setInvoicedQty(BigDecimal.ZERO);
                }
                entry.setUnInvoicedQty(entry.getQty().subtract(entry.getInvoicedQty()));
            }
            if (entry.getBaseQty() != null) {
                if (entry.getInvoicedBaseQty() == null) {
                    entry.setInvoicedBaseQty(BigDecimal.ZERO);
                }
                entry.setUninvoicedBaseQty(entry.getBaseQty().subtract(entry.getInvoicedBaseQty()));
            }
            this.setZero(entry);
            localTotalAmount = localTotalAmount.add(entry.getLocalAmount());
            localTotalTaxAmount = localTotalTaxAmount.add(entry.getLocalTaxAmount());
            localTotalTax = localTotalTax.add(entry.getLocalTax());
            totalAmount = totalAmount.add(entry.getAmount());
            totalTaxAmount = totalTaxAmount.add(entry.getTaxAmount());
            totalTax = totalTax.add(entry.getTax());
        }
        purReturnsInfo.setLocalTotalAmount(localTotalAmount);
        purReturnsInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        purReturnsInfo.setTotalTax(localTotalTax);
        purReturnsInfo.setTotalAmount(totalAmount);
        purReturnsInfo.setTotalTaxAmount(totalTaxAmount);
        purReturnsInfo.setTotalTax(totalTax);
        purReturnsInfo.setIsSysBill(false);
    }

    private void auditDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        PurReturnsInfo info = (PurReturnsInfo)model;
        PurReturnsEntryCollection entryCol = info.getEntries();
        if (entryCol != null) {
            int size = entryCol.size();
            for (int j = 0; j < size; ++j) {
                PurReturnsEntryInfo entryInfo = entryCol.get(j);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                if (entryInfo.getPurOrderNumber() != null) continue;
                entryInfo.setCoreBillType(info.getBillType());
                entryInfo.setCoreBillId(info.getId().toString());
                entryInfo.setCoreBillNumber(info.getNumber());
                entryInfo.setCoreBillEntryId(entryInfo.getId().toString());
                entryInfo.setCoreBillEntrySeq(entryInfo.getSeq());
            }
            PurReturnsFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    private void setZero(PurReturnsEntryInfo entry) throws BOSException {
        String[] fields = new String[]{"price", "qty", "assistQty", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "invoicedQty", "unInvoicedQty", "invoicedAmount", "returnedQty", "baseQty", "invoicedBaseQty", "uninvoicedBaseQty", "uninvoicedBaseQty", "uninvoicedBaseQty", "associateQty", "totalReturnAmt", "localAmount", "localTax", "localTaxAmount", "totalInvoicedAmt"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(PurReturnsEntryInfo entry, String[] fields) throws BOSException {
        Object[] zeros = new BigDecimal[]{BigDecimal.ZERO};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = PurReturnsEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = PurReturnsEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                throw new BOSException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

