/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purreturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.purreturns.PRTBizProcessorUtil;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;

public class PRTWriteBackPO4UnAuditProcessor
extends AbstractBusinessProcessor {
    public PRTWriteBackPO4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PRTWriteBackPO4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PRTWriteBackPO4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        IObjectValue model = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            model = col.getObject(i);
            this.writeBackPO(model);
        }
    }

    private void writeBackPO(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurReturnsInfo info = (PurReturnsInfo)model;
        String id = info.getId().toString();
        String billTypeid = info.getBillType().getId().toString();
        String billTable = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)billTypeid);
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)billTable) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)billTable, (String)id)) {
            return;
        }
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            boolean orderFlag = true;
            PRTBizProcessorUtil.negateValueForWriteBack(this.ctx, info);
            if (SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                orderFlag = PRTBizProcessorUtil.updateOrder(this.ctx, (IObjectValue)info);
            }
            PRTBizProcessorUtil.negateValueForWriteBack(this.ctx, info);
            if (!orderFlag) {
                throw new PurReturnsException(PurReturnsException.UPDATE_ORDER_QTY);
            }
        }
    }
}

