/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;

public class SCOrder2PurReq4UnAuditProcessor
extends AbstractBusinessProcessor {
    public SCOrder2PurReq4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrder2PurReq4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCOrder2PurReq4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        this.writeBackAtUnAudit(this.ctx, pks);
    }

    protected void writeBackAtUnAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        block8: {
            StringBuffer sb = new StringBuffer();
            StringBuilder idStrs = new StringBuilder();
            String entryTable = "T_SM_SubContractOrderEntry";
            boolean isExistsBizFlowField = SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)entryTable);
            int n = pks.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(pks[i].toString());
                sb.append("'");
                if (isExistsBizFlowField && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)entryTable, (String)pks[i].toString())) continue;
                if (idStrs.length() > 0) {
                    idStrs.append(",");
                }
                idStrs.append("'");
                idStrs.append(pks[i].toString());
                idStrs.append("'");
            }
            String billIDsStr = sb.toString();
            String idsStr = idStrs.toString();
            String sql = null;
            String tableName = null;
            try {
                sql = SCOrder2PurReq4UnAuditProcessor.getCreateTempTableSQL("T_SM_SubContractOrderEntry_0");
                tableName = KsqlUtil.createTempTable((Context)ctx, (String)sql);
                sql = SCOrder2PurReq4UnAuditProcessor.getInsertTempTableSQL(tableName, billIDsStr);
                DbUtil.execute((Context)ctx, (String)sql);
                sql = "select distinct FSourceBillID,FSourceBillEntryID from " + tableName + " where FSourceBillEntryID is not null";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                HashSet<String> sourceBillIDSet = new HashSet<String>();
                HashSet<String> sourceBillEntryIDSet = new HashSet<String>();
                while (rs.next()) {
                    String sourceBillID = rs.getString("FSourceBillID");
                    String sourceBillEntryID = rs.getString("FSourceBillEntryID");
                    if (sourceBillID == null || sourceBillEntryID == null) continue;
                    sourceBillIDSet.add(sourceBillID);
                    sourceBillEntryIDSet.add(sourceBillEntryID);
                }
                if (sourceBillEntryIDSet.size() <= 0) {
                    return;
                }
                String sourceBillIDs = SCMUtils.getSqlFromHashSet(sourceBillIDSet);
                String sourceBillEntryIDs = SCMUtils.getSqlFromHashSet(sourceBillEntryIDSet);
                if (idsStr != null && idsStr.length() > 0) {
                    sb.delete(0, sb.length());
                    sb.append("update T_SM_PurRequestEntry as aa");
                    sb.append(" set (FOrderedQty,FUnOrderedQty,FOrderedBaseQty,FUnOrderedBaseQty)=");
                    sb.append(" (select (case when scoe.FUnitID=pre.FUnitID then pre.FOrderedQty-scoe.FQty");
                    sb.append(" else pre.FOrderedQty-ROUND(DECIMAL(scoe.FBaseQty/ISNULL(mmu.FBaseConvsRate,1.00),21,8),mmu.FQtyPrecision) end) as FOrderedQty,");
                    sb.append(" (case when scoe.FUnitID=pre.FUnitID then pre.FUnOrderedQty+scoe.FQty");
                    sb.append(" else pre.FUnOrderedQty+ROUND(DECIMAL(scoe.FBaseQty/ISNULL(mmu.FBaseConvsRate,1.00),21,8),mmu.FQtyPrecision) end) as FUnOrderedQty,");
                    sb.append(" pre.FOrderedBaseQty-scoe.FBaseQty as FOrderedBaseQty,");
                    sb.append(" pre.FUnOrderedBaseQty+scoe.FBaseQty as FUnOrderedBaseQty");
                    sb.append(" from ").append(tableName).append(" scoe");
                    sb.append(" inner join T_SM_PurRequestEntry pre on pre.FID = scoe.FSourceBillEntryID");
                    sb.append(" left join T_BD_MultiMeasureUnit mmu on mmu.FMaterialID = pre.FMaterialID and mmu.FMeasureUnitID = pre.FUnitID");
                    sb.append(" where scoe.FParentID in (").append(idsStr).append(")");
                    sb.append(" and pre.FID = aa.FID");
                    sb.append(" )");
                    sql = sb.toString();
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                sb.delete(0, sb.length());
                sb.append("update T_SM_PurRequestEntry");
                sb.append(" set FBaseStatus=4");
                sb.append(" where FID in (").append(sourceBillEntryIDs).append(")");
                sb.append(" and FBaseStatus=7");
                sb.append(" and FUnOrderedQty>0");
                sql = sb.toString();
                DbUtil.execute((Context)ctx, (String)sql);
                sb.delete(0, sb.length());
                sb.append("update T_SM_PurRequest set FBaseStatus=4");
                sb.append(" where FID in(").append(sourceBillIDs).append(")");
                sb.append(" and FBaseStatus=7");
                sb.append(" and FID not in");
                sb.append(" (select distinct FParentID from T_SM_PurRequestEntry where FID in (").append(sourceBillEntryIDs).append(")");
                sb.append("    and FBaseStatus<>4");
                sb.append(" )");
                sql = sb.toString();
                DbUtil.execute((Context)ctx, (String)sql);
                sb.delete(0, sb.length());
                sb.append("update T_SM_PurRequestEntryML preml set (FBaseQty,FStandardQty,FQty,FScrapQty) = ( select ");
                sb.append("case t.FSCRAPRATEEXPRESSION ");
                sb.append("when 10610 then ");
                sb.append("round(decimal(pre.FUnOrderedBaseQty * t.FUnitQty /(1-to_number(t.FLossRatio/100)),21,8),8) ");
                sb.append(" else ");
                sb.append("round(decimal(pre.FUnOrderedBaseQty * t.FUnitQty *(1+to_number(t.FLossRatio/100)),21,8),8) ");
                sb.append(" end,");
                sb.append("round(decimal((pre.FUnOrderedBaseQty/ unit.FBaseConvsRate)* t.FUnitQty,21,8),8),");
                sb.append("case t.FSCRAPRATEEXPRESSION ");
                sb.append("when 10610 then ");
                sb.append(" round(decimal((pre.FUnOrderedBaseQty/ unit.FBaseConvsRate)* t.FUnitQty/(1-to_number(t.FLossRatio/100)),21,8),8)");
                sb.append(" else ");
                sb.append("round(decimal((pre.FUnOrderedBaseQty/ unit.FBaseConvsRate)* t.FUnitQty*(1+to_number(t.FLossRatio/100)),21,8),8)");
                sb.append(" end,");
                sb.append("case t.FSCRAPRATEEXPRESSION ");
                sb.append(" when 10610 then ");
                sb.append("round(decimal((pre.FUnOrderedBaseQty/ unit.FBaseConvsRate)* t.FUnitQty*(1/(1-to_number(t.FLossRatio/100))-1),21,8),8)");
                sb.append(" else ");
                sb.append("round(decimal((pre.FUnOrderedBaseQty/ unit.FBaseConvsRate)* t.FUnitQty * to_number(t.FLossRatio/100),21,8),8)");
                sb.append(" end ");
                sb.append(" from T_SM_PurRequestEntryML t ");
                sb.append("inner join T_SM_PurRequestEntry pre on t.Fparent1Id = pre.FID ");
                sb.append("inner join T_SM_SubContractOrderEntry soe on soe.FSourceBillEntryID=pre.FID ");
                sb.append("inner join T_SM_SubContractOrder so on so.FID=soe.FParentID ");
                sb.append("inner join t_bd_multimeasureunit unit on t.FUnitID = unit.fmeasureunitid ");
                sb.append("and t.fmaterialid = unit.fmaterialid ");
                sb.append("inner join t_bd_multimeasureunit unit2 on t.FUnitID = unit2.fmeasureunitid ");
                sb.append("and t.fmaterialid = unit2.fmaterialid ");
                sb.append(" where preml.FID=t.FID and so.FID in (").append(billIDsStr).append("))");
                sql = sb.toString();
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sb.delete(0, sb.length());
                sb.append("update T_SM_PurRequestEntryML preml set (FQty,FBaseQty,FStandardQty,FScrapQty) = (select ");
                sb.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.fqty)/to_number(power(10,unit.FQTYPRECISION))),");
                sb.append("to_number(CEILING(power(10,unit2.FQTYPRECISION) * t.fbaseqty)/to_number(power(10,unit2.FQTYPRECISION))),");
                sb.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.FStandardQty)/to_number(power(10,unit.FQTYPRECISION))),");
                sb.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.fqty)/to_number(power(10,unit.FQTYPRECISION))) -  ");
                sb.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.FStandardQty)/to_number(power(10,unit.FQTYPRECISION))) ");
                sb.append("from T_SM_PurRequestEntryML t ");
                sb.append("inner join T_SM_PurRequestEntry pre on t.FParent1Id = pre.FID ");
                sb.append("inner join T_SM_SubContractOrderEntry soe on soe.FSourceBillEntryID=pre.FID ");
                sb.append("inner join T_SM_SubContractOrder so on so.FID=soe.FParentID ");
                sb.append("inner join t_bd_multimeasureunit unit on t.FUnitID = unit.fmeasureunitid ");
                sb.append("and t.fmaterialid = unit.fmaterialid ");
                sb.append("inner join t_bd_multimeasureunit unit2 on t.FBaseUnitID = unit2.fmeasureunitid ");
                sb.append("and t.fmaterialid = unit2.fmaterialid ");
                sb.append("where preml.FID=t.FID and so.FID in (");
                sb.append(billIDsStr).append("))");
                sql = sb.toString();
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            catch (Exception e) {
                if (tableName == null) break block8;
                KsqlUtil.releaseTempTable((Context)ctx, (String)tableName);
            }
        }
    }

    public static String getCreateTempTableSQL(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tableName);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillId VARCHAR(44),");
        sql.append("FSourceBillEntryId VARCHAR(44),");
        sql.append("FCoreBillId VARCHAR(44),");
        sql.append("FCoreBillEntryId VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("FQty DECIMAL(21,8),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8))");
        return sql.toString();
    }

    public static String getInsertTempTableSQL(String tableName, String billIDsStr) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" SELECT FParentID,FSourceBillId,FSourceBillEntryId,FSourceBillId,FSourceBillEntryId,FUnitID,FQty,FBaseUnitID,FBaseQty");
        sql.append(" FROM T_SM_SubContractOrderEntry");
        sql.append(" WHERE FParentID IN (").append(billIDsStr).append(")");
        return sql.toString();
    }
}

