/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SCOrderCheckMoveAveMat4SubmitProcessor
extends AbstractBusinessProcessor {
    public SCOrderCheckMoveAveMat4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrderCheckMoveAveMat4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCOrderCheckMoveAveMat4SubmitProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = null;
        col = batchResults.getObjCollection();
        String id = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            if (model == null) {
                return;
            }
            id = model.get("id").toString();
            this.checkMoveAveMatForSubmit(id, model);
            this.checkMaterialPurSup(model);
        }
    }

    private void checkMoveAveMatForSubmit(String pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> matNumList = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct mi.FNumber ");
        sb.append(" from T_SM_SubContractOrderEntry entry ");
        sb.append(" left join T_SM_SubContractOrder bill on entry.FParentID = bill.FID ");
        sb.append(" left join T_BD_MaterialCompanyInfo mc on entry.FMaterialID = mc.FMaterialID ");
        sb.append(" inner join T_BD_Material mi on entry.FMaterialID = mi.FID ");
        sb.append(" where bill.FID = '").append(pk.toString()).append("'");
        sb.append(" and mi.FIsOutsourcedPart = 1 ");
        sb.append(" and mc.FAccountType = ").append(1);
        sb.append(" and mc.FCompanyID in ");
        sb.append(" (select top 1 FToUnitID from T_ORG_UnitRelation ur ");
        sb.append(" inner join T_ORG_TypeRelation tr on ur.FTypeRelationID = tr.FID ");
        sb.append(" where FFromUnitID = (select FPurchaseOrgUnitID from T_SM_SubContractOrder where FID ='").append(pk.toString()).append("') ");
        sb.append(" and tr.FFromType = ").append(3);
        sb.append(" and tr.FToType = ").append(1).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                matNumList.add(rs.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sb.setLength(0);
        sb.append("\n");
        int count = matNumList.size();
        for (int i = 0; i < count; ++i) {
            sb.append(matNumList.get(i)).append("\r\n");
        }
        if (count > 0) {
            throw new SCMBillException(SCMBillException.CANNOT_BE_MOVEAGEMAT_IN_SUBCONSTRACT, new Object[]{sb.toString()});
        }
    }

    public void checkMaterialPurSup(IObjectValue model) throws BOSException, EASBizException {
        String paramValue;
        if (model == null) {
            return;
        }
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        SubContractOrderEntryCollection entries = info.getEntries();
        boolean isUsePurSup = false;
        if (info.getPurchaseOrgUnit() != null && (paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getPurchaseOrgUnit().getId().toString()), "PURSUP001")) != null) {
            isUsePurSup = "true".equalsIgnoreCase(paramValue);
        }
        Map<String, MaterialPurchasingInfo> matPurchaseMap = this.getMaterialPurchaseCollec(model);
        StringBuffer errMaterials = new StringBuffer();
        errMaterials.append("\n");
        boolean flag = false;
        for (int i = 0; i < entries.size(); ++i) {
            SubContractOrderEntryInfo entry = entries.get(i);
            flag = this.checkIsInApprovedSupplier(info, entry, isUsePurSup, matPurchaseMap, errMaterials, flag);
        }
        if (flag) {
            throw new PurOrderException(PurOrderException.SUPPLYLIST_REQUIRED, (Object[])new String[]{errMaterials.toString()});
        }
    }

    private boolean checkIsInApprovedSupplier(SubContractOrderInfo info, SubContractOrderEntryInfo entry, boolean isUsePurSup, Map matPurchaseMap, StringBuffer errMaterials, boolean flag) throws BOSException, EASBizException {
        boolean isInApprovedSupplier = false;
        String key = entry.getMaterial().getId().toString() + info.getPurchaseOrgUnit().getId().toString();
        MaterialPurchasingInfo materialPurchaseInfo = (MaterialPurchasingInfo)matPurchaseMap.get(key);
        if (isUsePurSup && materialPurchaseInfo.isUseSupplyList()) {
            IApprovedSupplier iApprovedSupplier = ApprovedSupplierFactory.getLocalInstance((Context)this.ctx);
            FilterInfo tempfilter = new FilterInfo();
            tempfilter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)info.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
            tempfilter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)info.getSupplier().getId().toString(), CompareType.EQUALS));
            tempfilter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)entry.getMaterial().getId().toString(), CompareType.EQUALS));
            tempfilter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)"1", CompareType.EQUALS));
            isInApprovedSupplier = iApprovedSupplier.exists(tempfilter);
            if (!isInApprovedSupplier) {
                errMaterials.append(entry.getMaterial().getNumber().toString()).append("\n");
                flag = true;
                return true;
            }
        }
        flag = false;
        return false;
    }

    private Map<String, MaterialPurchasingInfo> getMaterialPurchaseCollec(IObjectValue bean) throws BOSException, EASBizException {
        HashMap<String, MaterialPurchasingInfo> matPurchase = new HashMap<String, MaterialPurchasingInfo>();
        if (bean == null) {
            return matPurchase;
        }
        SubContractOrderInfo info = (SubContractOrderInfo)bean;
        if (info.getPurchaseOrgUnit() == null) {
            return matPurchase;
        }
        SubContractOrderEntryCollection entries = info.getEntries();
        SubContractOrderEntryInfo entry = null;
        MaterialInfo material = null;
        MaterialPurchasingInfo matPurchaseInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            material = entry.getMaterial();
            if (material == null) continue;
            materialSet.add(material.getId().toString());
        }
        IMaterialPurchasing iMaterialPurchase = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getPurchaseOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        selector.add("material.id");
        selector.add("orgUnit.id");
        selector.add("useSupplyList");
        entityViewInfo.setSelector(selector);
        MaterialPurchasingCollection col = iMaterialPurchase.getMaterialPurchasingCollection(entityViewInfo);
        for (int i = 0; i < col.size(); ++i) {
            matPurchaseInfo = col.get(i);
            String key = matPurchaseInfo.getMaterial().getId().toString() + matPurchaseInfo.getOrgUnit().getId().toString();
            matPurchase.put(key, matPurchaseInfo);
        }
        return matPurchase;
    }
}

