/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SDSMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.sm.sc.ISubContractOrder;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

public class SCOrderDealAlter4AuditProcessor
extends AbstractBusinessProcessor {
    public SCOrderDealAlter4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrderDealAlter4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCOrderDealAlter4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.dealAlter(batchResults);
    }

    private void dealAlter(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        Map statusAlterMap = null;
        if (this.ctx.get((Object)"statusAlterMap") != null) {
            statusAlterMap = (Map)this.ctx.get((Object)"statusAlterMap");
        }
        Object baseStatus = null;
        String selectSql = "SELECT FID,FBaseStatus FROM T_SM_SubContractOrder WHERE FID IN (" + KsqlUtil.getBindMarks((int)pks.length) + ")";
        IRowSet rowset = KsqlUtil.executeQuery((Context)this.ctx, (String)selectSql, (Object[])batchResults.getToDoIdsArray());
        try {
            ISubContractOrder iSubOrder = SubContractOrderFactory.getLocalInstance((Context)this.ctx);
            while (rowset.next()) {
                ObjectUuidPK pk = new ObjectUuidPK(rowset.getString("FID"));
                SubContractOrderInfo subContractOrderInfo = iSubOrder.getSubContractOrderInfo((IObjectPK)pk);
                if (statusAlterMap != null) {
                    baseStatus = statusAlterMap.get(subContractOrderInfo.getId().toString());
                }
                if (baseStatus != null && (BillBaseStatusEnum)baseStatus == BillBaseStatusEnum.ALTERING) {
                    BizBillValueChangeUtil.handleBillAlter((Context)this.ctx, (IObjectValue)subContractOrderInfo, (String)"version", (String)"oldBillID", (String)"oldBillEntryID");
                    SCMServerUtils.executeBizFlow((Context)this.ctx, (IObjectValue)subContractOrderInfo, (BatchActionEnum)BatchActionEnum.ALTER);
                    this.ctx.put((Object)subContractOrderInfo.getId().toString(), (Object)"alterAudit");
                    try {
                        BizBillValueChangeUtil.resetBillChange((Context)this.ctx, (IObjectValue)subContractOrderInfo, (String)"version", (String)"oldBillID", (String)"oldBillEntryID");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.getAlterAutoCloseInfo(this.ctx, (IObjectPK)pk, subContractOrderInfo);
                iSubOrder.update((IObjectPK)pk, (SDSMBillBaseInfo)subContractOrderInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected SubContractOrderInfo getAlterAutoCloseInfo(Context ctx, IObjectPK pk, SubContractOrderInfo scoInfo) throws EASBizException, BOSException {
        if (!this.canAutoClose(ctx, pk, scoInfo)) {
            return scoInfo;
        }
        SubContractOrderEntryCollection entryCollection = scoInfo.getEntries();
        SubContractOrderEntryInfo entryInfo = null;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCollection.get(i);
            this.alterAutoCloseEntryInfo(entryInfo, scoInfo);
        }
        this.alterAutoClose(scoInfo);
        return scoInfo;
    }

    protected SubContractOrderEntryInfo alterAutoCloseEntryInfo(SubContractOrderEntryInfo entryInfo, SubContractOrderInfo subContractOrderInfo) {
        if (entryInfo.getBaseStatus().getValue() == 4) {
            BigDecimal downQty;
            BigDecimal checkQty = BigDecimal.ZERO;
            BigDecimal qty = entryInfo.getQty();
            checkQty = entryInfo.getTotalReceiptQty().subtract(entryInfo.getTotalInStockNeedQty());
            if (checkQty.compareTo(downQty = qty.multiply(SCMConstant.BIGDECIMAL_ONE.subtract(entryInfo.getReceiveOwingRate().divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4)))) >= 0) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            }
        }
        return entryInfo;
    }

    protected boolean canAutoClose(Context ctx, IObjectPK pk, SubContractOrderInfo newSubContractOrderInfo) throws EASBizException, BOSException {
        if (newSubContractOrderInfo.getBaseStatus().getValue() == 4) {
            SubContractOrderEntryCollection newEntryCollection = newSubContractOrderInfo.getEntries();
            SubContractOrderEntryInfo newEntryInfo = null;
            int num = newEntryCollection.size();
            for (int i = 0; i < num; ++i) {
                newEntryInfo = newEntryCollection.get(i);
                if (newEntryInfo.getBaseStatus().getValue() != 4) continue;
                return true;
            }
        }
        return false;
    }

    protected SubContractOrderInfo alterAutoClose(SubContractOrderInfo subContractOrderInfo) {
        if (subContractOrderInfo.getBaseStatus().getValue() == 4) {
            SubContractOrderEntryCollection entryCollection = subContractOrderInfo.getEntries();
            SubContractOrderEntryInfo entryInfo = null;
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = entryCollection.get(i);
                if (entryInfo.getBaseStatus().getValue() == 7) continue;
                return subContractOrderInfo;
            }
            subContractOrderInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        }
        return subContractOrderInfo;
    }
}

