/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryExpenseInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListCollection;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class SCOrderDefaultValueProcessor
extends SCMDefaultValueProcessor {
    public SCOrderDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrderDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCOrderDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block4: {
            IObjectValue model;
            IObjectCollection collection;
            block3: {
                super.doProcessing(batchResults);
                collection = batchResults.getObjCollection();
                if (CollectionUtil.isEmpty((IObjectCollection)collection)) {
                    return;
                }
                model = null;
                if (!BatchActionEnum.SAVE.equals((Object)this.batchAction)) break block3;
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    model = collection.getObject(i);
                    this.saveDefaultValue(model);
                }
                break block4;
            }
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) break block4;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                model = collection.getObject(i);
                this.submitDefaultValue(model);
            }
        }
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"kvQieV/4TJ+1ipJVFBlPx0Y+1VI="));
        info.setNumber("901");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SubContractOrderInfo sc = (SubContractOrderInfo)model;
        if (sc != null) {
            return sc.getCompanyOrgUnit();
        }
        return null;
    }

    protected String getEntryName() {
        return "entries";
    }

    private void saveDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SubContractOrderInfo sc = (SubContractOrderInfo)model;
        if (sc.getEntries().size() == 0) {
            sc.getEntries().add((SubContractOrderEntryInfo)this.createNewDetailData(0));
        }
        this.setNullNumberToZero(model);
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)this.getBillTypeId()));
        sc.setBillType(billTypeInfo);
        SubContractOrderEntryInfo entry = null;
        SubContractOrderEntryCollection entries = sc.getEntries();
        if (sc.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)sc.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)sc.getBaseStatus())) {
            sc.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            if (entry.getBaseStatus() != null && !EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) && !EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus())) continue;
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
    }

    private void setNullNumberToZero(IObjectValue model) {
        if (model != null) {
            Method[] methods = model.getClass().getMethods();
            Method method2 = null;
            String methodName = null;
            String key = null;
            for (Method method2 : methods) {
                methodName = method2.getName();
                if (method2 == null || methodName == null || !methodName.startsWith("get")) continue;
                key = methodName.substring(3).toLowerCase(Locale.ENGLISH);
                if (model.containsKey(key) && model.get(key) == null && method2.getReturnType() == BigDecimal.class) {
                    model.put(key, (Object)BigDecimal.ZERO);
                    continue;
                }
                if (!model.containsKey(key) || model.get(key) == null || !key.startsWith("entry") && !key.startsWith("entries") || !IObjectCollection.class.isAssignableFrom(method2.getReturnType())) continue;
                IObjectCollection entries = (IObjectCollection)model.get(key);
                int count = entries.size();
                for (int index = 0; index < count; ++index) {
                    this.setNullNumberToZero(entries.getObject(index));
                }
            }
        }
    }

    private String getBillTypeId() {
        return "kvQieV/4TJ+1ipJVFBlPx0Y+1VI=";
    }

    protected IObjectValue createNewDetailData(int detailIndex) {
        SubMaterialListInfo detailData = null;
        if (detailIndex == 0) {
            SubContractOrderEntryInfo entryInfo = new SubContractOrderEntryInfo();
            entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
            entryInfo.setDosingType(DosingTypeEnum.MANUAL);
            entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
            entryInfo.setIsTimeUnCtrl(true);
            entryInfo.setIsQtyUnCtrl(true);
            Date curDate = new Date();
            entryInfo.setDeliveryDate(curDate);
            detailData = entryInfo;
        } else if (detailIndex == 1) {
            SubMaterialListInfo subMLInfo;
            detailData = subMLInfo = new SubMaterialListInfo();
        } else if (detailIndex == 2) {
            SubContractOrderEntryExpenseInfo expenseInfo = new SubContractOrderEntryExpenseInfo();
            detailData = expenseInfo;
        }
        return detailData;
    }

    private void submitDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        boolean isEnableAssistAttr = false;
        if (info != null && info.getPurchaseOrgUnit() != null) {
            isEnableAssistAttr = this.isEnableOrderAssistAttr(this.ctx, info.getPurchaseOrgUnit().getId().toString());
        }
        if (info.getBaseStatus() == null || BillBaseStatusEnum.ADD.equals((Object)info.getBaseStatus()) || BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)info.getBaseStatus())) {
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        SubContractOrderEntryCollection collection = info.getEntries();
        SubContractOrderEntryInfo entryInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = collection.get(i);
            if (entryInfo.getBaseStatus() == null || EntryBaseStatusEnum.ADD.equals((Object)entryInfo.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entryInfo.getBaseStatus())) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            BigDecimal qty = entryInfo.getQty();
            BigDecimal baseQty = entryInfo.getBaseQty();
            entryInfo.setAssociateQty(baseQty);
            entryInfo.setPrepaidAmount(BigDecimal.ZERO);
            entryInfo.setUnPrepaidAmount(entryInfo.getPrepaymentAmount());
            entryInfo.setTotalReceiveQty(BigDecimal.ZERO);
            entryInfo.setTotalReceiveBaseQty(BigDecimal.ZERO);
            entryInfo.setUnReceiveQty(qty);
            entryInfo.setUnReceiveBaseQty(baseQty);
            entryInfo.setTotalReceiptQty(BigDecimal.ZERO);
            entryInfo.setTotalReceiptBaseQty(BigDecimal.ZERO);
            entryInfo.setUnReceiptQty(qty);
            entryInfo.setUnReceiptBaseQty(baseQty);
            entryInfo.setTotalApQty(BigDecimal.ZERO);
            entryInfo.setTotalApBaseQty(BigDecimal.ZERO);
            entryInfo.setUnApQty(qty);
            entryInfo.setUnApBaseQty(baseQty);
            entryInfo.setTotalApAmount(BigDecimal.ZERO);
            entryInfo.setTotalPaidAmount(BigDecimal.ZERO);
            entryInfo.setTotalInvoicedQty(BigDecimal.ZERO);
            entryInfo.setTotalInvoicedBaseQty(BigDecimal.ZERO);
            entryInfo.setUnInvoicedQty(qty);
            entryInfo.setUnInvoicedBaseQty(baseQty);
            entryInfo.setTotalInvoicedAmount(BigDecimal.ZERO);
            entryInfo.setTotalReturnQty(BigDecimal.ZERO);
            entryInfo.setTotalReturnBaseQty(BigDecimal.ZERO);
            entryInfo.setUnReturnQty(qty);
            entryInfo.setUnReturnBaseQty(baseQty);
            entryInfo.setTotalReturnStockQty(BigDecimal.ZERO);
            entryInfo.setTotalReturnStockBaseQty(BigDecimal.ZERO);
            SubMaterialListCollection entries1 = entryInfo.getEntries1();
            int k = entries1.size();
            for (int j = 0; j < k; ++j) {
                SubMaterialListInfo subMLInfo = entries1.get(j);
                if (subMLInfo != null) {
                    this.checkSubMLInfo(this.ctx, subMLInfo, isEnableAssistAttr, i, j);
                }
                subMLInfo.setTotalIssueQty(BigDecimal.ZERO);
                subMLInfo.setTotalIssueBaseQty(BigDecimal.ZERO);
                subMLInfo.setUnIssueQty(subMLInfo.getQty());
                subMLInfo.setUnIssueBaseQty(subMLInfo.getBaseQty());
            }
        }
        this.setNullNumberToZero((IObjectValue)info);
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)this.getBillTypeId()));
        info.setBillType(billTypeInfo);
    }

    private boolean isEnableOrderAssistAttr(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURORDER100")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private void checkSubMLInfo(Context ctx, SubMaterialListInfo subMLInfo, boolean isEnableAssistAttr, int entryIndex, int subMLIndex) throws SubContractOrderException {
        if (subMLInfo.getMaterial() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ORDER_FIELD_MATERIAL", (Context)ctx), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
        if (subMLInfo.getMaterial().getAssistAttr() != null && !isEnableAssistAttr && subMLInfo.getAssistProperty() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ASSISTPRO", (Context)ctx), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
        if (subMLInfo.getUnit() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ORDER_FIELD_UNIT", (Context)ctx), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
        if (subMLInfo.getQty() == null || subMLInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_QTY_CANNOT_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1)});
        }
        if (subMLInfo.getQtyRate() == null || subMLInfo.getQtyRate().compareTo(BigDecimal.ZERO) == 0) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"SubContractOrder_QtyRate", (Context)ctx), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
        if (subMLInfo.getStorageOrgUnit() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"STORAGE", (Context)ctx), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
        if (subMLInfo.getLossRate() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), this.getResource(ctx, "LOSSRATE"), PurUtil.getServerResource((String)"batchSumbit_checkEmpty", (Context)ctx)});
        }
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.sm.sc.SubContractResource", (String)key, (Locale)ctx.getOriginLocale());
    }
}

