/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SCOrderExpandBom4SaveProcessor
extends AbstractBusinessProcessor {
    public SCOrderExpandBom4SaveProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrderExpandBom4SaveProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCOrderExpandBom4SaveProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.expandBom(model);
        }
    }

    private void expandBom(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        boolean isInBotpProcess = false;
        if (info.get("Request") != null && "Request".equals(info.get("Request"))) {
            isInBotpProcess = true;
            info.remove("Request");
        }
        if (SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-0107c0a812fd463ED552") && isInBotpProcess) {
            SubContractOrderEntryCollection scoEntryCollection = info.getEntries();
            ArrayList<String> entryIds = new ArrayList<String>();
            SubContractOrderEntryInfo scoEntryInfo = null;
            int m = scoEntryCollection.size();
            for (int j = 0; j < m; ++j) {
                scoEntryInfo = scoEntryCollection.get(j);
                if (scoEntryInfo == null || scoEntryInfo.size() <= 0 || scoEntryInfo.getEntries1().size() >= 1) continue;
                entryIds.add(scoEntryInfo.getId().toString());
            }
            if (entryIds != null && entryIds.size() > 0) {
                this.getSubMaterialListByRequestML(this.ctx, entryIds);
            }
        }
    }

    private void getSubMaterialListByRequestML(Context ctx, List entryIds) throws BOSException {
        Connection con = null;
        Statement batchStatement = null;
        StringBuffer idParams = new StringBuffer();
        if (entryIds == null) {
            return;
        }
        for (int i = 0; i < entryIds.size(); ++i) {
            if (i > 0) {
                idParams.append(",");
            }
            idParams.append("'");
            idParams.append(entryIds.get(i).toString());
            idParams.append("'");
        }
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            batchStatement = con.createStatement();
            if (idParams.length() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("insert into T_SM_SubMaterialList (FID,FSeq,FParentID,FStorageOrgUnitID,FMaterialID,FUnitID,FBaseUnitID,");
                sql.append("FAssistUnitID,FQty,FBaseQty,FAssistQty,FQtyRate,FLossRate,FIssueDate, FStandardQty,FLossRateExp)");
                sql.append("select newbosid('7A6F6098'),peml.FSeq,so.FID,peml.FStorageOrgUnitID,");
                sql.append("peml.FMaterialID,peml.FUnitID,peml.FBaseUnitID,peml.FAssistUnitID,");
                sql.append("peml.FQty,peml.FBaseQty,peml.FAssistQty,");
                sql.append("round(decimal(peml.FUnitQty*(purunit.FBaseConvsRate/mlunit.FBaseConvsRate),21,8),8),");
                sql.append("peml.FLossRatio, ADD_DAYS(so.FDeliveryDate,(0-so.FPurAdvanceDays)), ");
                sql.append("peml.FStandardQty,peml.FSCRAPRATEEXPRESSION ");
                sql.append("from T_SM_PurRequestEntryML peml inner join T_SM_SubContractOrderEntry so on ");
                sql.append("so.FSourceBillEntryID=peml.FParent1ID ");
                sql.append("inner join T_SM_PurRequestEntry pre on peml.FParent1id=pre.fid \n");
                sql.append("inner join t_bd_multimeasureunit purunit on pre.funitid=purunit.fmeasureunitid ");
                sql.append(" and pre.fmaterialid=purunit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit mlunit on peml.funitid=mlunit.fmeasureunitid ");
                sql.append(" and peml.fmaterialid=mlunit.fmaterialid ");
                sql.append("where so.fid in (").append(idParams.toString()).append(")");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("update T_SM_SubMaterialList t set (FBaseQtyRate,FScrapQty) = (select ");
                sql.append("case t.FLossRateExp ");
                sql.append("when 10610 then round(decimal(decimal(t.FBaseQty * (1-t.FLossRate/100),21,8) / soe.FBaseQty,21,8),8) ");
                sql.append("else round(decimal(t.FBaseQty / (decimal((soe.FBaseQty * (1+t.FLossRate/100)),21,8)),21,8),8) ");
                sql.append("end,t.FQty-t.FStandardQty ");
                sql.append("from T_SM_SubContractOrderEntry soe where soe.FID=t.FParentID and soe.FID in (");
                sql.append(idParams.toString()).append("))");
                batchStatement.addBatch(sql.toString());
                batchStatement.executeBatch();
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }
}

