/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.subcontractorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialScrapRateExpressionEnum;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.IBOMExtend2Facade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SDSMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListCollection;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;

public class SCOrderMaterialList4SubmitProcessor
extends AbstractBusinessProcessor {
    public SCOrderMaterialList4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCOrderMaterialList4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCOrderMaterialList4SubmitProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.dealMaterialList(model);
        }
    }

    private void dealMaterialList(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SubContractOrderInfo info = (SubContractOrderInfo)model;
        boolean isEnableAssistAttr = false;
        if (info != null && info.getPurchaseOrgUnit() != null) {
            isEnableAssistAttr = this.isEnableOrderAssistAttr(this.ctx, info.getPurchaseOrgUnit().getId().toString());
        }
        SubContractOrderEntryCollection collection = info.getEntries();
        SubContractOrderEntryInfo entryInfo = null;
        DosingTypeEnum doThingType = null;
        boolean flag = false;
        if (info.get("PlannedOrder") != null && "PlannedOrder".equals(info.get("PlannedOrder"))) {
            flag = true;
        }
        if (SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)info, (String)"9XXvbVGlRtym/0qtqeIXXrhE1B8=") && !flag) {
            String entryId = "";
            StringBuffer params = new StringBuffer();
            ArrayList<String> idList = new ArrayList<String>();
            ArrayList<String> neIdList = new ArrayList<String>();
            HashMap<String, SubContractOrderEntryInfo> entryMap = new HashMap<String, SubContractOrderEntryInfo>();
            for (int i = 0; i < collection.size(); ++i) {
                entryInfo = collection.get(i);
                if (entryInfo == null) continue;
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(entryInfo.getId().toString());
                params.append("'");
                entryMap.put(entryInfo.getId().toString(), entryInfo);
                if (entryInfo.getAssistUnit() == null || entryInfo.getAssistQty() != null && entryInfo.getAssistQty().compareTo(SysConstant.BIGZERO) != 0) continue;
                BigDecimal assistQty = this.getExchangeQtyForClient(this.ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit(), entryInfo.getAssistUnit(), entryInfo.getQty());
                entryInfo.setAssistQty(assistQty);
            }
            try {
                if (params != null && params.length() > 0) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT soe.fid as fid,plo.FIsAfreshExtend as FIsAfreshExtend FROM T_SM_SubContractOrderEntry soe ");
                    sql.append("INNER JOIN T_MM_PlannedOrder plo ON soe.fsourcebillid=plo.fid where soe.fid in (");
                    sql.append(params.toString()).append(")");
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                    if (rowSet != null) {
                        while (rowSet.next()) {
                            if (rowSet.getString("fid") != null && !"".equals(rowSet.getString("fid"))) {
                                entryId = rowSet.getString("fid");
                            }
                            if (!"".equals(entryId) && rowSet.getInt("FIsAfreshExtend") == 1) {
                                idList.add(entryId);
                                continue;
                            }
                            if ("".equals(entryId) || rowSet.getInt("FIsAfreshExtend") != 0) continue;
                            neIdList.add(entryId);
                        }
                    }
                    if (idList != null && idList.size() > 0 && entryMap != null) {
                        int i;
                        SubContractOrderEntryInfo scoEntryInfo = null;
                        int size = idList.size();
                        for (i = 0; i < size; ++i) {
                            if (idList.get(i) == null || entryMap.get(idList.get(i)) == null) continue;
                            scoEntryInfo = (SubContractOrderEntryInfo)entryMap.get(idList.get(i));
                            scoEntryInfo.setDosingType(DosingTypeEnum.BOM);
                            info.setSourceFunction("isBOMEdit");
                            scoEntryInfo.getEntries1().clear();
                            scoEntryInfo.getEntries1().addCollection((SubMaterialListCollection)this._getSubMaterialListByBOM(this.ctx, (IObjectValue)scoEntryInfo));
                        }
                        int n = collection.size();
                        for (i = 0; i < n; ++i) {
                            entryInfo = collection.get(i);
                            SubMaterialListCollection entries1 = entryInfo.getEntries1();
                            int k = entries1.size();
                            for (int j = 0; j < k; ++j) {
                                SubMaterialListInfo subMLInfo = entries1.get(j);
                                if (subMLInfo != null) {
                                    this.checkSubMLInfo(this.ctx, subMLInfo, isEnableAssistAttr, i, j);
                                }
                                subMLInfo.setTotalIssueQty(BigDecimal.ZERO);
                                subMLInfo.setTotalIssueBaseQty(BigDecimal.ZERO);
                                subMLInfo.setUnIssueQty(subMLInfo.getQty());
                                subMLInfo.setUnIssueBaseQty(subMLInfo.getBaseQty());
                            }
                        }
                        SubContractOrderFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (SDSMBillBaseInfo)info);
                    }
                    if (neIdList != null && neIdList.size() > 0) {
                        this.getSubMaterialListByPlanOrder(this.ctx, neIdList);
                        collection = ((SubContractOrderInfo)SubContractOrderFactory.getLocalInstance((Context)this.ctx).getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(info.getId()))).getEntries();
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            int j;
            entryInfo = collection.get(i);
            doThingType = entryInfo.getDosingType();
            if (!DosingTypeEnum.BOM.equals((Object)doThingType) && !DosingTypeEnum.HISTORY.equals((Object)doThingType) && !DosingTypeEnum.MANUAL.equals((Object)doThingType)) continue;
            for (j = 0; j < entryInfo.getEntries1().size() && entryInfo.getEntries1().get(j).getMaterial() == null; ++j) {
            }
            if (entryInfo.getEntries1().size() != 0 && j != entryInfo.getEntries1().size()) continue;
            throw new SubContractOrderException(SubContractOrderException.ENTRY1_CANNOT_NULL, new Object[]{entryInfo.getSeq()});
        }
    }

    private BigDecimal getExchangeQtyForClient(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        return SCMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnifInfo, (MultiMeasureUnitInfo)othermultiUnifInfo, (BigDecimal)qty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectCollection _getSubMaterialListByBOM(Context ctx, IObjectValue scoeInfo) throws BOSException, EASBizException {
        SubContractOrderEntryInfo scoEntryInfo = (SubContractOrderEntryInfo)scoeInfo;
        SubMaterialListCollection subMLCollection = new SubMaterialListCollection();
        BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
        BigDecimal baseQtyRate = SCMConstant.BIGDECIMAL_ZERO;
        if (scoEntryInfo != null && scoEntryInfo.getBom() != null) {
            String entryID = null;
            String materialID = null;
            String storageOrgUnitID = null;
            String bomID = null;
            BigDecimal qty = null;
            String unit = null;
            String baseUnit = null;
            BigDecimal baseQty = null;
            String deliveryDate = null;
            String projectID = null;
            String trackNo = null;
            entryID = scoEntryInfo.getId() != null ? scoEntryInfo.getId().toString() : BOSUuid.create((BOSObjectType)scoEntryInfo.getBOSType()).toString();
            if (scoEntryInfo.getMaterial() != null) {
                materialID = scoEntryInfo.getMaterial().getId().toString();
            }
            if (scoEntryInfo.getUnit() != null) {
                unit = scoEntryInfo.getUnit().getId().toString();
            }
            if (scoEntryInfo.getBaseUnit() != null) {
                baseUnit = scoEntryInfo.getBaseUnit().getId().toString();
            }
            if (scoEntryInfo.getRequestOrgUnit() != null) {
                storageOrgUnitID = scoEntryInfo.getRequestOrgUnit().getId().toString();
            }
            if (scoEntryInfo.getBom() != null) {
                bomID = scoEntryInfo.getBom().getId().toString();
            }
            if (scoEntryInfo.getQty() == null) {
                scoEntryInfo.setQty(BigDecimal.ZERO);
            }
            qty = scoEntryInfo.getQty();
            if (scoEntryInfo.getBaseQty() == null) {
                scoEntryInfo.setBaseQty(BigDecimal.ZERO);
            }
            baseQty = scoEntryInfo.getBaseQty();
            if (scoEntryInfo.getDeliveryDate() != null) {
                deliveryDate = new SimpleDateFormat("yyyy-MM-dd").format(scoEntryInfo.getDeliveryDate());
            }
            if (materialID == null || storageOrgUnitID == null || bomID == null || deliveryDate == null) {
                return subMLCollection;
            }
            if (scoEntryInfo.getProject() != null && scoEntryInfo.getProject().getId() != null) {
                projectID = scoEntryInfo.getProject().getId().toString().trim();
            }
            if (scoEntryInfo.getTrackNo() != null && scoEntryInfo.getTrackNo().getId() != null) {
                trackNo = scoEntryInfo.getTrackNo().getId().toString().trim();
            }
            String inTempTableName = null;
            StringBuffer sql = new StringBuffer();
            sql.append("create table inTempTableName (");
            sql.append(" FStorageOrgUnitID varchar(44),");
            sql.append(" FMaterialID varchar(44) ,");
            sql.append(" FBaseQty NUMERIC(21,8) NOT NULL DEFAULT 0, ");
            sql.append(" FID varchar(44) ,");
            sql.append(" FTraceID varchar(44) ,");
            sql.append(" FBomID varchar(44) ,");
            sql.append(" FDate DATETIME ,");
            sql.append(" FDaySeq int,");
            sql.append(" FProjectID VARCHAR(44) NULL, ");
            sql.append(" FTrackNumberID VARCHAR(44) NULL ");
            sql.append(")");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                inTempTableName = pool.createTempTable(sql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            projectID = projectID == null ? null : "'" + projectID + "'";
            trackNo = trackNo == null ? null : "'" + trackNo + "'";
            sql.setLength(0);
            sql.append("insert into ").append(inTempTableName);
            sql.append(" (FStorageOrgUnitID,FMaterialID,FBaseQty,FID,FTraceID,FBomID,FDate,FDaySeq,FProjectID,FTrackNumberID)");
            sql.append(" select '").append(storageOrgUnitID).append("' as FStorageOrgUnitID,");
            sql.append("        '").append(materialID).append("' as FMaterialID,");
            sql.append("        ").append(baseQty.toPlainString()).append(" as FBaseQty,");
            sql.append("        '").append(entryID).append("' as FID,");
            sql.append("        '").append(entryID).append("' as FTraceID,");
            sql.append("        '").append(bomID).append("' as FBomID,");
            sql.append("        TO_DATE('").append(deliveryDate).append(" 00:00:00') as FDate,");
            sql.append("        (select ISNULL(MAX(caentry.fworkdateseq),0) from T_MM_FactoryCalendar as ca");
            sql.append("        inner join T_MM_FactoryCalendarEntry as caentry on ca.FID = caentry.FParentID");
            sql.append("        where ca.FStorageOrgUnitID = '").append(storageOrgUnitID).append("' and caentry.FWorkDate<=TO_DATE('").append(deliveryDate).append(" 00:00:00') and caentry.fworkdateseq>0) as FDaySeq, ");
            sql.append("        ").append(projectID).append(" as FProjectID,");
            sql.append("        ").append(trackNo).append(" as FTrackNumberID ");
            sql.append(" from t_bd_materialplan as mp");
            sql.append(" left join t_bd_multimeasureunit as mmu on mp.FProductUnitID = mmu.fmeasureunitid and mp.fmaterialid = mmu.fmaterialid ");
            sql.append(" where mp.fmaterialid='").append(materialID).append("' and mp.forgunit='").append(storageOrgUnitID).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String bomTempTableName = null;
            try {
                IBOMExtend2Facade bomExtend2Facade = BOMExtend2FacadeFactory.getLocalInstance((Context)ctx);
                bomTempTableName = bomExtend2Facade.bomExtend(inTempTableName);
                if (bomTempTableName == null) {
                    SubMaterialListCollection subMaterialListCollection = subMLCollection;
                    return subMaterialListCollection;
                }
            }
            finally {
                pool.releaseTable(inTempTableName);
            }
            sql.setLength(0);
            sql.append("select FMATERIALID,FSTORAGEORGUNITID,FUNITID,FPREC,FBASEUNITID,FbaseUNITQTY,FSCRAPRATE,FSCRAPRATEEXPRESSION,FDEMANDTIME");
            sql.append(" from ").append(bomTempTableName);
            sql.append(" where FTRACEID='").append(entryID).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                rs.last();
                int rowCount = rs.getRow();
                if (rowCount <= 0) {
                    return subMLCollection;
                }
                String[] materialIDs = new String[rowCount];
                String[] storageOrgUnitIDs = new String[rowCount];
                String[] unitIDs = new String[rowCount * 3];
                rs.beforeFirst();
                int index = 0;
                while (rs.next()) {
                    materialIDs[index] = rs.getString(1);
                    storageOrgUnitIDs[index] = rs.getString(2);
                    unitIDs[index * 3] = rs.getString(3);
                    unitIDs[index * 3 + 1] = rs.getString(5);
                    ++index;
                }
                Map materialMap = this.fetchMaterialInfos(ctx, materialIDs);
                Map storageOrgUnitMap = this.fetchStorageOrgUnitInfos(ctx, storageOrgUnitIDs);
                MaterialInfo materialInfo = null;
                for (int i = 0; i < rowCount; ++i) {
                    if (materialIDs[i] == null || materialMap == null || (materialInfo = (MaterialInfo)materialMap.get(materialIDs[i])) == null || materialInfo.getAssistUnit() == null) continue;
                    unitIDs[i * 3 + 2] = materialInfo.getAssistUnit().getId().toString();
                }
                Map unitMap = this.fetchUnitInfos(ctx, unitIDs);
                SubMaterialListInfo subMLInfo = null;
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                MeasureUnitInfo measureUnitInfo = null;
                int precision = 2;
                BigDecimal qtyRate = null;
                BigDecimal lossRate = null;
                int lossRateCalExp = 0;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(scoEntryInfo.getDeliveryDate());
                int purAdvanceDays = scoEntryInfo.getPurAdvanceDays();
                calendar.add(5, -1 * purAdvanceDays);
                Date issueDate = calendar.getTime();
                rs.beforeFirst();
                index = 0;
                while (rs.next()) {
                    subMLInfo = new SubMaterialListInfo();
                    materialInfo = (MaterialInfo)materialMap.get(materialIDs[index]);
                    subMLInfo.setMaterial(materialInfo);
                    if (storageOrgUnitIDs[index] != null && storageOrgUnitMap != null) {
                        storageOrgUnitInfo = (StorageOrgUnitInfo)storageOrgUnitMap.get(storageOrgUnitIDs[index]);
                        subMLInfo.setStorageOrgUnit(storageOrgUnitInfo);
                    }
                    if (unitIDs[index * 3] != null && unitMap != null) {
                        measureUnitInfo = (MeasureUnitInfo)unitMap.get(unitIDs[index * 3]);
                        subMLInfo.setUnit(measureUnitInfo);
                    }
                    if (unitIDs[index * 3 + 1] != null && unitMap != null) {
                        measureUnitInfo = (MeasureUnitInfo)unitMap.get(unitIDs[index * 3 + 1]);
                        subMLInfo.setBaseUnit(measureUnitInfo);
                    }
                    if (unitIDs[index * 3 + 2] != null && unitMap != null) {
                        measureUnitInfo = (MeasureUnitInfo)unitMap.get(unitIDs[index * 3 + 2]);
                        subMLInfo.setAssistUnit(measureUnitInfo);
                    }
                    subMLInfo.setSeq(index);
                    precision = rs.getInt(4);
                    baseQtyRate = rs.getBigDecimal(6);
                    subMLInfo.setBaseQtyRate(baseQtyRate.setScale(precision, 2));
                    lossRate = rs.getBigDecimal(7);
                    if (lossRate != null) {
                        lossRate = lossRate.multiply(new BigDecimal("1.0")).setScale(4, 4);
                    }
                    subMLInfo.setLossRate(lossRate);
                    lossRateCalExp = rs.getInt(8);
                    subMLInfo.setLossRateExp(MaterialScrapRateExpressionEnum.getEnum((int)lossRateCalExp));
                    subMLInfo.setIssueDate(issueDate);
                    String key2 = "";
                    BigDecimal tempQty = BigDecimal.ZERO;
                    this.calSubMLInfo(subMLInfo, baseQty, precision, lossRate, lossRateCalExp);
                    IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
                    BigDecimal multiUninInfo1 = multiUnit.getMultiUnit(materialID, unit).getBaseConvsRate();
                    BigDecimal multiUninInfo2 = multiUnit.getMultiUnit(materialInfo.getId().toString(), subMLInfo.getUnit().getId().toString()).getBaseConvsRate();
                    MultiMeasureUnitInfo unitInfo = multiUnit.getMultiUnit(materialInfo.getId().toString(), subMLInfo.getUnit().getId().toString());
                    qtyRate = baseQtyRate.multiply(multiUninInfo1).divide(multiUninInfo2, unitInfo.getQtyPrecision(), 4);
                    subMLInfo.setQtyRate(qtyRate);
                    tempQty = qty.multiply(qtyRate).setScale(precision, 2);
                    subMLInfo.setStandardQty(tempQty);
                    this.calSubMLInfoForQty(subMLInfo, tempQty, precision, lossRate, lossRateCalExp);
                    if (subMLInfo.getQty() != null && subMLInfo.getStandardQty() != null) {
                        subMLInfo.setScrapQty(subMLInfo.getQty().subtract(subMLInfo.getStandardQty()).setScale(precision, 2));
                    }
                    this.setEXSubMaterialListInfo(subMLInfo, (RowSet)rs);
                    subMLCollection.add(subMLInfo);
                    ++index;
                }
                SCMEntryDataVO scmEntryDataVO = SCMBizProcessorUtil.initSCMBizDataVO((Context)ctx, (SCMBizDataVO)new SCMBizDataVO(), (AbstractObjectCollection)subMLCollection, (OrgType)OrgType.Purchase).getScmEntryDataVO();
                scmEntryDataVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(scmEntryDataVO);
                try {
                    SCMBizProcessorUtil.formatQtyPrecision((AbstractObjectCollection)subMLCollection, (Method)SubMaterialListInfo.class.getMethod("getQty", null), (Method)SubMaterialListInfo.class.getMethod("setBaseQty", BigDecimal.class), (Method)SubMaterialListInfo.class.getMethod("setAssistQty", BigDecimal.class), (Method)SubMaterialListInfo.class.getMethod("setAssistUnit", MeasureUnitInfo.class), (Method)SubMaterialListInfo.class.getMethod("getAssistQty", null), (SCMEntryDataVO)scmEntryDataVO);
                    int basePrecision = 2;
                    String key2 = "";
                    BigDecimal lossRateValue = BigDecimal.ZERO;
                    if (subMLInfo != null && subMLInfo.getMaterial() != null && subMLInfo.getBaseUnit() != null) {
                        key2 = subMLInfo.getMaterial().getId().toString() + subMLInfo.getBaseUnit().getId().toString();
                        if (scmEntryDataVO.getMmuPrecisions() != null) {
                            basePrecision = (Integer)scmEntryDataVO.getMmuPrecisions().get(key2);
                        }
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            pool.releaseTable(inTempTableName);
            pool.releaseTable(bomTempTableName);
        }
        return subMLCollection;
    }

    private boolean isEnableOrderAssistAttr(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURORDER100")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private void checkSubMLInfo(Context ctx, SubMaterialListInfo subMLInfo, boolean isEnableAssistAttr, int entryIndex, int subMLIndex) throws SubContractOrderException {
        if (subMLInfo.getMaterial() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ORDER_FIELD_MATERIAL", (Context)ctx)});
        }
        if (subMLInfo.getMaterial().getAssistAttr() != null && !isEnableAssistAttr && subMLInfo.getAssistProperty() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ASSISTPRO", (Context)ctx)});
        }
        if (subMLInfo.getUnit() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"ORDER_FIELD_UNIT", (Context)ctx)});
        }
        if (subMLInfo.getQty() == null || subMLInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_QTY_CANNOT_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1)});
        }
        if (subMLInfo.getQtyRate() == null || subMLInfo.getQtyRate().compareTo(BigDecimal.ZERO) == 0) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"SubContractOrder_QtyRate", (Context)ctx)});
        }
        if (subMLInfo.getStorageOrgUnit() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), PurUtil.getServerResource((String)"STORAGE", (Context)ctx)});
        }
        if (subMLInfo.getLossRate() == null) {
            throw new SubContractOrderException(SubContractOrderException.SUBML_FIELD_NULL, (Object[])new String[]{String.valueOf(entryIndex + 1), String.valueOf(subMLIndex + 1), this.getResource(ctx, "LOSSRATE")});
        }
    }

    private void getSubMaterialListByPlanOrder(Context ctx, List entryIds) throws BOSException {
        Connection con = null;
        Statement batchStatement = null;
        StringBuffer idParams = new StringBuffer();
        if (entryIds == null) {
            return;
        }
        for (int i = 0; i < entryIds.size(); ++i) {
            if (i > 0) {
                idParams.append(",");
            }
            idParams.append("'");
            idParams.append(entryIds.get(i).toString());
            idParams.append("'");
        }
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            batchStatement = con.createStatement();
            if (idParams.length() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("delete from T_SM_SubMaterialList where FParentID in (").append(idParams.toString()).append(")");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("insert into T_SM_SubMaterialList (FID,FParentID,FSeq,FStorageOrgUnitID,FMaterialID,FUnitID,FBaseUnitID,");
                sql.append("FAssistUnitID,FQty,FBaseQty,FAssistQty,FQtyRate,FLossRate,FIssueDate,FStandardQty,FLossRateExp,FWareHouseID,FSourceBillEntryID,FSourceBillEntrySeq,FScrapQty)");
                sql.append(" select newbosid('7A6F6098'),soe.FID,1,mpoe.FStorageOrgUnitID,mpoe.FMaterialID,mpoe.FUnitID,");
                sql.append("mpoe.FBaseUnitID,m.FAssistUnit,");
                sql.append(" case mp.FScrapRateExpression ");
                sql.append(" when 10610 then round(decimal(soe.FBASEQTY * decimal((mpoe.FStandardQty/mpo.FQty)*(1/pounit.FBaseConvsRate),21,8) / (1-decimal(mpoe.FScrapRate/100,21,8)),21,8),8) ");
                sql.append(" else round(decimal(soe.FBASEQTY * decimal((mpoe.FStandardQty/mpo.FQty)*(1/pounit.FBaseConvsRate),21,8) * (1+decimal(mpoe.FScrapRate/100,21,8)),21,8),8) ");
                sql.append(" end ,");
                sql.append(" case mp.FSCRAPRATEEXPRESSION ");
                sql.append(" when 10610 then round(decimal(soe.FBASEQTY * decimal((mpoe.FStandardQty/mpo.FQty)*(unit2.FBaseConvsRate/pounit.FBaseConvsRate),21,8) / (1-decimal(mpoe.FScrapRate/100,21,8)),21,8),8) ");
                sql.append(" else round(decimal(soe.FBASEQTY * decimal((mpoe.FStandardQty/mpo.FQty)*(unit2.FBaseConvsRate/pounit.FBaseConvsRate),21,8) * (1+decimal(mpoe.FScrapRate/100,21,8)),21,8),8)");
                sql.append(" end ,");
                sql.append("0 as FAssistQty,1 as FQtyRate,");
                sql.append(" mpoe.FScrapRate,add_days(soe.FDeliveryDate,(0-soe.FPurAdvanceDays)), ");
                sql.append("decimal(soe.FBASEQTY * decimal((mpoe.FStandardQty/mpo.FQty)*(1/pounit.FBaseConvsRate),21,8),21,8),mp.FSCRAPRATEEXPRESSION,mpoe.FDEFAULTWAREHOUSEID,mpoe.fid,mpoe.fseq,mpoe.FScrapQty ");
                sql.append("from T_SM_SubContractOrderEntry soe ");
                sql.append("inner join T_MM_PlannedOrder mpo on soe.FSourceBillID=mpo.FID ");
                sql.append("inner join T_MM_PlannedOrderEntry mpoe on mpoe.FParentID=mpo.FID ");
                sql.append("inner join T_BD_Material m on mpoe.FMaterialID = m.FID ");
                sql.append("inner join T_BD_MaterialPlan mp on mpoe.FMaterialID = mp.FMaterialID and ");
                sql.append("soe.FReceiveOrgUnitID = mp.FOrgUnit ");
                sql.append("inner join t_bd_multimeasureunit unit on soe.FUnitID = unit.fmeasureunitid ");
                sql.append("and soe.fmaterialid = unit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit pounit on mpo.FproductUnitID = pounit.fmeasureunitid ");
                sql.append("and mpo.fmaterialid = pounit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit prdunit on mpo.FProductUnitID = prdunit.fmeasureunitid ");
                sql.append("and mpo.fmaterialid = prdunit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit unit2 on mpoe.FUnitID = unit2.fmeasureunitid ");
                sql.append("and mpoe.fmaterialid = unit2.fmaterialid ");
                sql.append("where soe.FID in (").append(idParams.toString()).append(")");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("update T_SM_SubMaterialList t set (FBaseQtyRate) = (select ");
                sql.append("case t.FLossRateExp ");
                sql.append("when 10610 then round(decimal(decimal(t.FBaseQty * decimal((1-t.FLossRate/100),21,8)) / soe.FBaseQty,21,8),8) ");
                sql.append("else round(decimal(t.FBaseQty / decimal((soe.FBaseQty * decimal((1+t.FLossRate/100),21,8)),21,8),21,8),8) ");
                sql.append("end ");
                sql.append("from T_SM_SubContractOrderEntry soe where soe.FID=t.FParentID and soe.FID in (");
                sql.append(idParams.toString()).append("))");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("update T_SM_SubMaterialList smt set (FQtyRate, FAssistQty) = (select ");
                sql.append("round(decimal(decimal(t.FBaseQtyRate / unit2.FBaseConvsRate,21,8) * unit.FBaseConvsRate,21,8),8), ");
                sql.append("case when unit3.FBaseConvsRate is null then 0 else round(decimal(t.FBaseQty/unit3.FBaseConvsRate, 21,8), 8) end ");
                sql.append("from T_SM_SubContractOrderEntry soe ");
                sql.append("inner join  T_SM_SubMaterialList t on t.FParentID = soe.fid ");
                sql.append("inner join t_bd_multimeasureunit unit on soe.FUnitID = unit.fmeasureunitid ");
                sql.append("and soe.fmaterialid = unit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit unit2 on t.FUnitID = unit2.fmeasureunitid ");
                sql.append("and t.fmaterialid = unit2.fmaterialid ");
                sql.append("left outer join t_bd_multimeasureunit unit3 on t.FMaterialID=unit3.FMaterialID and t.FAssistUnitId=unit3.fmeasureunitid ");
                sql.append("where smt.fid = t.fid and soe.FID in (");
                sql.append(idParams.toString()).append("))");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("update T_SM_SubMaterialList smt set ( FUnIssueQty, FUnIssueBaseQty) = (select ");
                sql.append(" t.fqty,t.fbaseqty");
                sql.append(" ");
                sql.append("from T_SM_SubContractOrderEntry soe ");
                sql.append("inner join  T_SM_SubMaterialList t on t.FParentID = soe.fid ");
                sql.append("where smt.fid = t.fid and soe.FID in (");
                sql.append(idParams.toString()).append("))");
                batchStatement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append("update T_SM_SubMaterialList subML set (FQty,FBaseQty,FUnIssueBaseQty,FUnIssueQty,FQtyRate,FBaseQtyRate,FStandardQty,FScrapQty,FAssistQty) = (select ");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.fqty)/to_number(power(10,unit.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit2.FQTYPRECISION) * t.fbaseqty)/to_number(power(10,unit2.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit2.FQTYPRECISION) * t.FUnIssueBaseQty)/to_number(power(10,unit2.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.FUnIssueQty)/to_number(power(10,unit.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.fqtyrate)/to_number(power(10,unit.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit2.FQTYPRECISION) * t.fbaseqtyrate)/to_number(power(10,unit2.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.FStandardQty)/to_number(power(10,unit.FQTYPRECISION))),");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.fqty)/to_number(power(10,unit.FQTYPRECISION))) -  ");
                sql.append("to_number(CEILING(power(10,unit.FQTYPRECISION) * t.FStandardQty)/to_number(power(10,unit.FQTYPRECISION))), ");
                sql.append("to_number(CEILING(power(10,isnull(unit3.FQTYPRECISION,0)) * t.FAssistQty)/to_number(power(10,isnull(unit3.FQTYPRECISION,0)))) ");
                sql.append("from T_SM_SubMaterialList t ");
                sql.append("inner join T_SM_SubContractOrderEntry soe on t.FParentId = soe.FID ");
                sql.append("inner join t_bd_multimeasureunit unit on t.FUnitID = unit.fmeasureunitid ");
                sql.append("and t.fmaterialid = unit.fmaterialid ");
                sql.append("inner join t_bd_multimeasureunit unit2 on t.FBaseUnitID = unit2.fmeasureunitid ");
                sql.append("and t.fmaterialid = unit2.fmaterialid ");
                sql.append("left join t_bd_multimeasureunit unit3 on t.FMaterialID=unit3.FMaterialID and t.FAssistUnitId=unit3.fmeasureunitid ");
                sql.append("where subML.FID=t.FID and soe.FID in (");
                sql.append(idParams.toString()).append("))");
                batchStatement.addBatch(sql.toString());
                batchStatement.executeBatch();
            }
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
            SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        }
    }

    private Map fetchStorageOrgUnitInfos(Context ctx, String[] storageOrgUnitIDs) throws BOSException, EASBizException {
        Set idSet = this.convertArrayToSet(storageOrgUnitIDs);
        HashMap<String, StorageOrgUnitInfo> map = new HashMap<String, StorageOrgUnitInfo>();
        if (idSet != null && idSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            StorageOrgUnitCollection collection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(evi);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    map.put(collection.get(i).getId().toString(), collection.get(i));
                }
            }
        }
        return map;
    }

    private Map fetchMaterialInfos(Context ctx, String[] materialIDs) throws BOSException, EASBizException {
        Set idSet = this.convertArrayToSet(materialIDs);
        HashMap<String, MaterialInfo> map = new HashMap<String, MaterialInfo>();
        if (idSet != null && idSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(evi);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    map.put(collection.get(i).getId().toString(), collection.get(i));
                }
            }
        }
        return map;
    }

    private Map fetchUnitInfos(Context ctx, String[] unitIDs) throws BOSException, EASBizException {
        Set idSet = this.convertArrayToSet(unitIDs);
        HashMap<String, MeasureUnitInfo> map = new HashMap<String, MeasureUnitInfo>();
        if (idSet != null && idSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            MeasureUnitCollection collection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(evi);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    map.put(collection.get(i).getId().toString(), collection.get(i));
                }
            }
        }
        return map;
    }

    private Set convertArrayToSet(String[] ids) {
        HashSet<String> idSet = new HashSet<String>();
        if (ids != null && ids.length > 0) {
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                if (ids[i] == null) continue;
                idSet.add(ids[i]);
            }
        }
        return idSet;
    }

    private void calSubMLInfo(SubMaterialListInfo subsubMLInfo, BigDecimal qty, int precision, BigDecimal lossRate, int lossRateCalExp) throws BOSException, EASBizException {
        BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
        BigDecimal qtyRate = subsubMLInfo.getBaseQtyRate();
        lossRate = lossRate == null ? BigDecimal.ZERO : lossRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 6, 4);
        if (qty != null && qtyRate != null) {
            if (lossRateCalExp == 10610) {
                qty = qty.multiply(qtyRate).divide(ONE.subtract(lossRate), precision, 2);
                subsubMLInfo.setBaseQty(qty);
            } else {
                qty = qty.multiply(qtyRate).multiply(ONE.add(lossRate)).setScale(precision, 2);
                subsubMLInfo.setBaseQty(qty);
            }
        }
    }

    private void calSubMLInfoForQty(SubMaterialListInfo subsubMLInfo, BigDecimal qty, int precision, BigDecimal lossRate, int lossRateCalExp) throws BOSException, EASBizException {
        BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
        lossRate = lossRate == null ? BigDecimal.ZERO : lossRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 6, 4);
        if (qty != null) {
            if (lossRateCalExp == 10610) {
                qty = qty.divide(ONE.subtract(lossRate), precision, 2);
                subsubMLInfo.setQty(qty);
            } else {
                qty = qty.multiply(ONE.add(lossRate)).setScale(precision, 2);
                subsubMLInfo.setQty(qty);
            }
        }
    }

    public SubMaterialListInfo setEXSubMaterialListInfo(SubMaterialListInfo subMLInfo, RowSet rs) {
        return subMLInfo;
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.sm.sc.SubContractResource", (String)key, (Locale)ctx.getOriginLocale());
    }
}

