/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.srm.supm.EvalClassCollection;
import com.kingdee.eas.scm.srm.supm.EvalClassFactory;
import com.kingdee.eas.scm.srm.supm.EvalClassInfo;
import com.kingdee.eas.scm.srm.supm.IEvalClass;
import com.kingdee.eas.scm.srm.supm.UsedStatesEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;

public class EvalClassDataTransmission
extends AbstractDataTransmission {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EvalClassFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("BOSException: getLocalInstance", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        EvalClassInfo info = new EvalClassInfo();
        String number = this.getStringFromhsData(hsData, "FNumber");
        if (StringUtils.isEmpty((String)number)) throw new TaskExternalException("\u7b49\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        info.setNumber(number);
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (mode == 16) {
            try {
                IEvalClass iEvalClass = (IEvalClass)this.getController(ctx);
                EvalClassCollection evalClass = iEvalClass.getEvalClassCollection("where number = '" + number + "'");
                if (evalClass != null && evalClass.size() > 0 && evalClass.get(0) != null) {
                    info.setId(evalClass.get(0).getId());
                }
            }
            catch (Exception e) {
                throw new TaskExternalException("BOSException: getCurrencyCollection", (Throwable)e);
            }
        }
        String name_l1 = this.getStringFromhsData(hsData, "FName_L1");
        String name_l2 = this.getStringFromhsData(hsData, "FName_L2");
        String name_l3 = this.getStringFromhsData(hsData, "FName_L3");
        String state = this.getStringFromhsData(hsData, "FUsedState");
        String content = this.getStringFromhsData(hsData, "FContent");
        String description_l1 = this.getStringFromhsData(hsData, "FDescription_L1");
        String description_l2 = this.getStringFromhsData(hsData, "FDescription_L2");
        String description_l3 = this.getStringFromhsData(hsData, "FDescription_L3");
        if (StringUtils.isEmpty((String)name_l1) && StringUtils.isEmpty((String)name_l2) && StringUtils.isEmpty((String)name_l3)) {
            throw new TaskExternalException("\u7b49\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (number.length() > 80) {
            throw new TaskExternalException("\u7b49\u7ea7\u7f16\u7801\u5b57\u7b26\u592a\u957f");
        }
        if (name_l1.length() > 80 || name_l2.length() > 80 || name_l2.length() > 80) {
            throw new TaskExternalException("\u7b49\u7ea7\u540d\u79f0\u5b57\u7b26\u592a\u957f");
        }
        if (content.length() > 255) {
            throw new TaskExternalException("\u7b49\u7ea7\u8bf4\u660e\u5b57\u7b26\u592a\u957f");
        }
        if (description_l1.length() > 80 || description_l1.length() > 80 || description_l1.length() > 80) {
            throw new TaskExternalException("\u7b49\u7ea7\u63cf\u8ff0\u5b57\u7b26\u592a\u957f");
        }
        if (state.equals("\u6838\u51c6")) {
            info.setUsedState(UsedStatesEnum.APPROVED);
        } else {
            if (!state.equals("\u4fdd\u5b58")) throw new TaskExternalException("\u72b6\u6001\u53ea\u80fd\u4e3a\u6838\u51c6\u548c\u4fdd\u5b58!");
            info.setUsedState(UsedStatesEnum.SAVE);
        }
        info.setName(name_l1, new Locale("L1"));
        info.setName(name_l2, new Locale("L2"));
        info.setName(name_l3, new Locale("L3"));
        info.setContent(content);
        info.setDescription(description_l1, new Locale("L1"));
        info.setDescription(description_l2, new Locale("L2"));
        info.setDescription(description_l3, new Locale("L3"));
        return info;
    }

    private String getStringFromhsData(Hashtable hsData, String key) {
        return (String)((DataToken)hsData.get((Object)key)).data;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String description;
            result.put("FNumber", rs.getString("number"));
            String name = rs.getString("name");
            if (!StringUtils.isEmpty((String)name)) {
                if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                    result.put("FName_L1", name);
                }
                if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                    result.put("FName_L2", name);
                }
                if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) {
                    result.put("FName_L3", name);
                }
            }
            if (rs.getString("usedState") != null) {
                result.put("FUsedState", rs.getString("usedState").equals("0") ? "\u4fdd\u5b58" : "\u6838\u51c6");
            }
            if (rs.getString("content") != null) {
                result.put("FContent", rs.getString("content"));
            }
            if (!StringUtils.isEmpty((String)(description = rs.getString("description")))) {
                if (LocaleUtils.getLocale((String)"l1").equals(ctx.getLocale())) {
                    result.put("FDescription_L1", description);
                }
                if (LocaleUtils.getLocale((String)"l2").equals(ctx.getLocale())) {
                    result.put("FDescription_L2", description);
                }
                if (LocaleUtils.getLocale((String)"l3").equals(ctx.getLocale())) {
                    result.put("FDescription_L3", description);
                }
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        return result;
    }
}

