/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.srm.supm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.common.util.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BOTPHelper {
    public static void saveBOTRelation(Context ctx, List srcIdList, String destBillId) throws BOSException {
        if (srcIdList == null || srcIdList.isEmpty() || StringUtil.isEmpty((String)destBillId)) {
            return;
        }
        String srcBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        int size = srcIdList.size();
        for (int i = 0; i < size; ++i) {
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            srcBillId = (String)srcIdList.get(i);
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void saveBOTRelation(Context ctx, Map idMap) throws BOSException {
        if (idMap == null || idMap.isEmpty()) {
            return;
        }
        BOTRelationInfo relateInfo = null;
        String srcBillId = null;
        String destBillId = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (Map.Entry entry : idMap.entrySet()) {
            srcBillId = (String)entry.getKey();
            destBillId = (String)entry.getValue();
            relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
            relateInfo.setSrcObjectID(srcBillId);
            relateInfo.setDestObjectID(destBillId);
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            iBOTRelation.addnew(relateInfo);
        }
    }

    public static void deleteBOTRelation(Context ctx, String srcID, String desID) throws BOSException {
        if (srcID == null || desID == null) {
            return;
        }
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)BOSUuid.read((String)srcID).getType().toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)BOSUuid.read((String)desID).getType().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcID));
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)desID));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        BOTRelationCollection coll = iBOTRelation.getCollection(view);
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            iBOTRelation.delete((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
        }
    }
}

