/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.basedatautil.assistant;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BillTypeUtil {
    private static HashMap SCMBillTypeHeadTableMap = new HashMap();
    private static HashMap SCMBillTypeEntryTableMap = new HashMap();
    private static HashMap<String, BillTable> SCMBillTypeTableMap = new HashMap();
    private static BillTypeUtil inst = null;

    public static String getBillHeadTableName(Context ctx, String billTypeID) throws BOSException, EASBizException {
        BillTypeUtil.staticInitial(ctx);
        String headTableName = (String)SCMBillTypeHeadTableMap.get(billTypeID);
        return headTableName;
    }

    public static String getBillEntryTableName(Context ctx, String billTypeID) throws BOSException, EASBizException {
        BillTypeUtil.staticInitial(ctx);
        String entryTableName = (String)SCMBillTypeEntryTableMap.get(billTypeID);
        return entryTableName;
    }

    public static Map getBillHeadTableName(Context ctx, Map billTypeID) throws BOSException, EASBizException {
        BillTypeUtil.staticInitial(ctx);
        Set set = billTypeID.keySet();
        Iterator ite = set.iterator();
        HashMap entryTableName = new HashMap();
        while (ite.hasNext()) {
            String next = ite.next().toString();
            if (!SCMBillTypeHeadTableMap.containsKey(next)) continue;
            entryTableName.put(next, SCMBillTypeHeadTableMap.get(next));
        }
        return entryTableName;
    }

    public static Map getBillEntryTableName(Context ctx, Map billTypeID) throws BOSException, EASBizException {
        BillTypeUtil.staticInitial(ctx);
        Set set = billTypeID.keySet();
        Iterator ite = set.iterator();
        HashMap entryTableName = new HashMap();
        while (ite.hasNext()) {
            String next = ite.next().toString();
            if (!SCMBillTypeEntryTableMap.containsKey(next)) continue;
            entryTableName.put(next, SCMBillTypeEntryTableMap.get(next));
        }
        return entryTableName;
    }

    public static void updateSCMTableNameMap(Context ctx, String billTypeID) throws BOSException, EASBizException {
        if (!SCMBillTypeTableMap.containsKey(billTypeID)) {
            try {
                String sql = "SELECT FID,FHEADTABLE,FENTRYTABLE FROM T_SCM_BILLTYPE T where t.fid=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billTypeID});
                while (rs.next()) {
                    BillTable table = new BillTable();
                    table.setHeadTable(rs.getString("FHEADTABLE"));
                    table.setEntryTable(rs.getString("FENTRYTABLE"));
                    SCMBillTypeTableMap.put(rs.getString("FID"), table);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void updateSCMTableNameMap(Context ctx, Map billTypeIDMap) throws BOSException, EASBizException {
        Set set = billTypeIDMap.keySet();
        Iterator ite = set.iterator();
        while (ite.hasNext()) {
            String next = ite.next().toString();
            BillTypeUtil.updateSCMTableNameMap(ctx, next);
        }
    }

    public static BillTable querySCMTableName(Context ctx, String billTypeID) throws BOSException, EASBizException {
        BillTypeUtil.updateSCMTableNameMap(ctx, billTypeID);
        return SCMBillTypeTableMap.get(billTypeID);
    }

    public static Map<String, BillTable> querySCMTableName(Context ctx, Map billTypeIDMap) throws BOSException, EASBizException {
        BillTypeUtil.updateSCMTableNameMap(ctx, billTypeIDMap);
        Set set = billTypeIDMap.keySet();
        Iterator ite = set.iterator();
        HashMap<String, BillTable> tableName = new HashMap<String, BillTable>();
        while (ite.hasNext()) {
            String next = ite.next().toString();
            if (!SCMBillTypeTableMap.containsKey(next)) continue;
            tableName.put(next, SCMBillTypeTableMap.get(next));
        }
        return tableName;
    }

    private static void initInvBillTableMap(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID,FHEADTABLE,FENTRYTABLE FROM T_SCM_BILLTYPE ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                SCMBillTypeHeadTableMap.put(rs.getString("FID"), rs.getString("FHEADTABLE"));
                SCMBillTypeEntryTableMap.put(rs.getString("FID"), rs.getString("FENTRYTABLE"));
                BillTable table = new BillTable();
                table.setHeadTable(rs.getString("FHEADTABLE"));
                table.setEntryTable(rs.getString("FENTRYTABLE"));
                SCMBillTypeTableMap.put(rs.getString("FID"), table);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static synchronized void staticInitial(Context ctx) throws BOSException {
        if (inst == null) {
            try {
                BillTypeUtil.initInvBillTableMap(ctx);
                inst = new BillTypeUtil();
            }
            catch (Throwable e) {
                throw new BOSException(e);
            }
        }
    }

    private BillTypeUtil() {
    }

    static class BillTable {
        private String headTable;
        private String entryTable;

        public String getHeadTable() {
            return this.headTable;
        }

        public void setHeadTable(String headTable) {
            this.headTable = headTable;
        }

        public String getEntryTable() {
            return this.entryTable;
        }

        public void setEntryTable(String entryTable) {
            this.entryTable = entryTable;
        }

        public BillTable() {
        }

        public BillTable(String headTable, String entryTable) {
            this.headTable = headTable;
            this.entryTable = entryTable;
        }
    }
}

