/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.basedatautil.master;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.collection.ListMap;
import com.kingdee.eas.scm.util.collection.ObjectListMap;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class BatchFetchDataUtil {
    public static Map getMeasureUnitInfos(Map unitIdMap) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        Iterator iter = unitIdMap.keySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        IMeasureUnit iunit = MeasureUnitFactory.getRemoteInstance();
        MeasureUnitCollection collection = iunit.getMeasureUnitCollection(view);
        if (collection != null) {
            MeasureUnitInfo unit = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                unit = collection.get(i);
                unitMap.put(unit.getId().toString(), unit);
            }
        }
        return unitMap;
    }

    public static void getUOM4Entries(MeasureUnitInfo[] baseUnits, MeasureUnitInfo[] units, MeasureUnitInfo[] assistUnits, int changeLevel) throws BOSException {
        Map unitVOMap;
        int i;
        int len;
        HashMap unitMap = new HashMap();
        if (changeLevel == 0) {
            len = baseUnits.length;
            for (i = 0; i < len; ++i) {
                if (baseUnits[i] != null) {
                    unitMap.put(baseUnits[i].getId().toString(), null);
                }
                if (assistUnits[i] == null) continue;
                unitMap.put(assistUnits[i].getId().toString(), null);
            }
        }
        len = baseUnits.length;
        for (i = 0; i < len; ++i) {
            if (units[i] == null) continue;
            unitMap.put(units[i].getId().toString(), null);
        }
        if (unitMap.size() > 0 && (unitVOMap = BatchFetchDataUtil.getMeasureUnitInfos(unitMap)) != null && unitVOMap.size() > 0) {
            int i2;
            int len2;
            if (changeLevel == 0) {
                len2 = baseUnits.length;
                for (i2 = 0; i2 < len2; ++i2) {
                    if (baseUnits[i2] != null) {
                        baseUnits[i2] = (MeasureUnitInfo)unitVOMap.get(baseUnits[i2].getId().toString());
                    }
                    if (assistUnits[i2] == null) continue;
                    assistUnits[i2] = (MeasureUnitInfo)unitVOMap.get(assistUnits[i2].getId().toString());
                }
            }
            len2 = baseUnits.length;
            for (i2 = 0; i2 < len2; ++i2) {
                if (units[i2] == null) continue;
                units[i2] = (MeasureUnitInfo)unitVOMap.get(units[i2].getId().toString());
            }
        }
    }

    public static void fetchUOMRates(ListMap convertMap) throws BOSException, EASBizException {
        if (convertMap != null && convertMap.size() > 0) {
            ObjectListMap map = new ObjectListMap(2);
            Object[] keys = convertMap.keySet().toArray();
            int len = keys.length;
            for (int i = 0; i < len; ++i) {
                String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                if (!map.containsKey(key)) {
                    map.put2(key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 1)});
                }
                if (convertMap.get(keys[i], 2) == null || map.containsKey(key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2))) continue;
                map.put2(key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 2)});
            }
            if (map.size() > 0) {
                String[] materialIds = new String[map.size()];
                String[] unitIds = new String[map.size()];
                Iterator iter = map.keySet().iterator();
                int idx = 0;
                while (iter.hasNext()) {
                    Object akey = iter.next();
                    materialIds[idx] = (String)map.get(akey, 0);
                    unitIds[idx] = (String)map.get(akey, 1);
                    ++idx;
                }
                IMultiMeasureUnit iMultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
                Map rateMap = iMultiUnit.getConvRatesByMaterial(materialIds, unitIds);
                if (rateMap != null && rateMap.size() > 0) {
                    BigDecimal zero = new BigDecimal(0.0);
                    int len2 = keys.length;
                    for (int i = 0; i < len2; ++i) {
                        String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                        BigDecimal value1 = (BigDecimal)rateMap.get(key);
                        if (convertMap.get(keys[i], 2) != null) {
                            key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2);
                            BigDecimal value2 = (BigDecimal)rateMap.get(key);
                            if (value1 == null || value2 == null || value2.compareTo(zero) == 0) continue;
                            BigDecimal value = NumericUtil.divideBigDecimal(value1, value2, 10);
                            convertMap.set(keys[i], 3, value);
                            continue;
                        }
                        convertMap.set(keys[i], 3, value1);
                    }
                }
            }
        }
    }
}

