/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.basedatautil.master;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitExtInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.Locale;

public abstract class OrgUnitUtil {
    public static final String ORG_DELEGATE_SALE_FI = "00000000-0000-0000-0000-0000000000050FE9F8B5";
    public static final String ORG_DELEGATE_PURCHARSE_FI = "00000000-0000-0000-0000-0000000000030FE9F8B5";
    public static final String ORG_DELEGATE_STORAGE_FI = "00000000-0000-0000-0000-0000000000070FE9F8B5";
    public static final String ORG_DELEGATE_ADMIN_FI = "00000000-0000-0000-0000-0000000000010FE9F8B5";
    public static final String ORG_DELEGATE_HR_FI = "00000000-0000-0000-0000-0000000000130FE9F8B5";
    public static final int ORG_OU_BIZUNIT = 1;
    public static final int ORG_OU_VIRTUAL = 2;
    public static final int ORG_OU_ALL = 3;
    public static final int ORG_OU_UP = 1;
    public static final int ORG_OU_DOWN = 2;

    public static final CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtil.readCompanyOrgUnitInfo(ctx, orgUnit, false);
    }

    public static final CompanyOrgUnitInfo readFullCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit) throws EASBizException, BOSException {
        return OrgUnitUtil.readCompanyOrgUnitInfo(ctx, orgUnit, true);
    }

    public static CompanyOrgUnitInfo readCompanyOrgUnitInfo(Context ctx, OrgUnitInfo orgUnit, boolean isFull) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        if (orgUnit != null) {
            if (orgUnit instanceof CompanyOrgUnitInfo && orgUnit.getId() != null) {
                company = (CompanyOrgUnitInfo)orgUnit;
                if (isFull && (company.getBaseCurrency() == null || company.getBaseCurrency().getName() == null || !company.getBaseCurrency().containsKey("precision") || company.getBaseExchangeTable() == null)) {
                    company = OrgUnitUtil.fullCompanyOrgUnitInfo(ctx, company.getId().toString());
                }
            } else {
                OrgUnitInfo ou = null;
                ou = ctx != null ? OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUint(OrgUnitUtil.getOrgRelationTypeByOU(orgUnit), orgUnit) : OrgUnitRelationFactory.getRemoteInstance().getToUint(OrgUnitUtil.getOrgRelationTypeByOU(orgUnit), orgUnit);
                if (ou != null && ou.getId() != null) {
                    if (isFull) {
                        company = OrgUnitUtil.fullCompanyOrgUnitInfo(ctx, ou.getId().toString());
                    } else {
                        company = new CompanyOrgUnitInfo();
                        company.setId(ou.getId());
                    }
                }
            }
        }
        return company;
    }

    public static CompanyOrgUnitInfo fullCompanyOrgUnitInfo(Context ctx, String Id) throws EASBizException, BOSException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("longNumber"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("baseCurrency.id"));
        selectors.add(new SelectorItemInfo("baseCurrency.name"));
        selectors.add(new SelectorItemInfo("baseCurrency.precision"));
        selectors.add(new SelectorItemInfo("baseExchangeTable.id"));
        ICompanyOrgUnit ie = null;
        ie = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return ie.getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(Id), selectors);
    }

    public static CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        String id = (String)ctx.get((Object)"CurCompanyId");
        if (id != null && id.trim().length() != 0) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
        }
        return company;
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtil.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 1);
    }

    public static CompanyOrgUnitCollection getSuperiorCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtil.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 1);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType) throws EASBizException, BOSException {
        return OrgUnitUtil.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, sortType, 2);
    }

    public static CompanyOrgUnitCollection getChildrenCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf) throws EASBizException, BOSException {
        return OrgUnitUtil.getThreadCompanyCollection(ctx, companyId, isBizUnit, isContainSelf, SortType.ASCEND, 2);
    }

    public static CompanyOrgUnitCollection getThreadCompanyCollection(Context ctx, String companyId, int isBizUnit, boolean isContainSelf, SortType sortType, int upOrDown) throws EASBizException, BOSException {
        if (ctx == null || companyId == null || companyId.trim().length() == 0) {
            return null;
        }
        String sp = " \r\n";
        String locale = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("SELECT b.FID, b.FNumber, b.FName").append(locale).append(" As FCompanyName, b.FLongNumber, b.FBaseExgTableID, ").append(sp);
        strSQL.append("  b.FBaseCurrencyID, c.FName").append(locale).append(" As FCurrencyName, c.FPrecision").append(sp);
        strSQL.append("FROM T_ORG_Company a, T_ORG_Company b, T_BD_Currency c").append(sp);
        strSQL.append("WHERE a.FID = ? And b.FBaseCurrencyID = c.FID ").append(sp);
        String operator = "";
        if (2 == upOrDown) {
            operator = ">";
        } else if (1 == upOrDown) {
            operator = "<";
        }
        strSQL.append("  And ( (SUBSTRING(b.FLongNumber, 0,LENGTH(a.FLongNumber) + 1) = a.FLongNumber || '!' AND b.FLevel " + operator + " a.FLevel) ").append(sp);
        if (isContainSelf) {
            strSQL.append(" OR (b.FLongNumber = a.FLongNumber) ").append(sp);
        }
        strSQL.append(" ) ");
        if (isBizUnit == 1) {
            strSQL.append("  And b.FIsBizUnit = 1").append(sp);
        } else if (isBizUnit == 2) {
            strSQL.append("  And b.FIsBizUnit = 0").append(sp);
        }
        if (sortType == null || sortType != null && SortType.ASCEND.getName().equalsIgnoreCase(sortType.getName())) {
            strSQL.append("Order By b.FLongNumber ASC");
        } else {
            strSQL.append("Order By b.FLongNumber DESC");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{companyId});
        CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
        if (rs != null) {
            try {
                CompanyOrgUnitInfo company = null;
                while (rs.next()) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("FID")));
                    company.setNumber(rs.getString("FNumber"));
                    company.setName(rs.getString("FCompanyName"));
                    company.setLongNumber(rs.getString("FLongNumber"));
                    if (rs.getString("FBaseExgTableID") != null) {
                        ExchangeTableInfo exchangeTable = new ExchangeTableInfo();
                        exchangeTable.setId(BOSUuid.read((String)rs.getString("FBaseExgTableID")));
                        company.setBaseExchangeTable(exchangeTable);
                    }
                    CurrencyInfo baseCurrency = new CurrencyInfo();
                    baseCurrency.setId(BOSUuid.read((String)rs.getString("FBaseCurrencyID")));
                    baseCurrency.setName(rs.getString("FCurrencyName"));
                    baseCurrency.setPrecision(rs.getInt("FPrecision"));
                    company.setBaseCurrency(baseCurrency);
                    companys.add(company);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return companys;
    }

    private static OrgTypeRelationInfo getOrgRelationTypeByOU(OrgUnitInfo orgUnit) {
        OrgTypeRelationInfo ri = null;
        if (orgUnit != null) {
            ri = new OrgTypeRelationInfo();
            if (orgUnit != null) {
                if (orgUnit instanceof PurchaseOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_PURCHARSE_FI));
                } else if (orgUnit instanceof SaleOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_SALE_FI));
                } else if (orgUnit instanceof StorageOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_STORAGE_FI));
                } else if (orgUnit instanceof AdminOrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_ADMIN_FI));
                } else if (orgUnit instanceof HROrgUnitInfo) {
                    ri.setId(BOSUuid.read((String)ORG_DELEGATE_HR_FI));
                }
            }
        }
        return ri;
    }

    public static OrgUnitInfo getOrgUnitInfoByNum(Context ctx, String orgNum) throws Exception {
        if (orgNum == null || orgNum.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        IFullOrgUnit orgCtrl = null;
        orgCtrl = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)orgNum));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("number"));
        ev.getSelector().add(new SelectorItemInfo("longNumber"));
        ev.getSelector().add(new SelectorItemInfo("name"));
        CoreBaseCollection col = orgCtrl.getCollection(ev);
        if (col.size() >= 1) {
            return (OrgUnitInfo)col.get(0);
        }
        return null;
    }

    public static OrgUnitCollection getBizOrgUnitInfosByType(OrgUnitCollection orgs, OrgType orgType) {
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        OrgUnitCollection results = new OrgUnitCollection();
        if (OrgType.Company.equals((Object)orgType) || OrgType.Sale.equals((Object)orgType) || OrgType.Purchase.equals((Object)orgType) || OrgType.Storage.equals((Object)orgType)) {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                if (!((OrgUnitExtInfo)orgs.get(i)).isIsBizUnit()) continue;
                results.add(orgs.get(i));
            }
        } else {
            int size = orgs.size();
            for (int i = 0; i < size; ++i) {
                results.add(orgs.get(i));
            }
        }
        return results;
    }

    public static CompanyOrgUnitInfo getCompanyFromStorage(Context ctx, StorageOrgUnitInfo storage) {
        try {
            if (storage == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = null;
            iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storage.getId().toString(), 4, 1);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static SaleOrgUnitInfo getSaleOrgFromStorage(Context ctx, StorageOrgUnitInfo storage) {
        try {
            if (storage == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = null;
            iUnitRel = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storage.getId().toString(), 4, 2);
            SaleOrgUnitInfo ret = (SaleOrgUnitInfo)orgCol.get(0);
            return ret;
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static CompanyOrgUnitInfo getCompanyOrgFromStorageOrg(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        return OrgUnitUtil.getToRelationOrg(ctx, (OrgUnitInfo)storageOrgUnitInfo, OrgType.Storage, OrgType.Company, CompanyOrgUnitInfo.class);
    }

    public static SaleOrgUnitInfo getSaleOrgFromStorageOrg(Context ctx, StorageOrgUnitInfo storageOrgUnitInfo) throws BOSException, EASBizException {
        return OrgUnitUtil.getToRelationOrg(ctx, (OrgUnitInfo)storageOrgUnitInfo, OrgType.Storage, OrgType.Sale, SaleOrgUnitInfo.class);
    }

    public static CompanyOrgUnitInfo getCompanyOrgFromPurchaseOrg(Context ctx, PurchaseOrgUnitInfo purchaseOrgUnitInfo) throws BOSException, EASBizException {
        return OrgUnitUtil.getToRelationOrg(ctx, (OrgUnitInfo)purchaseOrgUnitInfo, OrgType.Purchase, OrgType.Company, CompanyOrgUnitInfo.class);
    }

    public static <T extends OrgUnitInfo> T getToRelationOrg(Context ctx, OrgUnitInfo orgUnitInfo, OrgType fromType, OrgType toType, Class<T> resultType) throws BOSException, EASBizException {
        if (fromType == null || toType == null) {
            throw new IllegalArgumentException("param : fromType or toType is null");
        }
        if (orgUnitInfo == null) {
            return null;
        }
        IOrgUnitRelation unitRelation = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = unitRelation.getToUnit(orgUnitInfo.getId().toString(), fromType.getValue(), toType.getValue());
        if (CollectionUtil.isEmpty((AbstractObjectCollection)orgUnitCollection)) {
            return null;
        }
        return (T)((OrgUnitInfo)resultType.cast(orgUnitCollection.get(0)));
    }

    public static OrgUnitCollection getToRelationOrgCollection(Context ctx, OrgUnitInfo orgUnitInfo, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        if (fromType == null || toType == null) {
            throw new IllegalArgumentException("param : fromType or toType is null");
        }
        if (orgUnitInfo == null) {
            return null;
        }
        IOrgUnitRelation unitRelation = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        return unitRelation.getToUnit(orgUnitInfo.getId().toString(), fromType.getValue(), toType.getValue());
    }
}

