/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.im.inv.CountingTableEntryFactory;
import com.kingdee.eas.scm.im.inv.CountingTableEntryInfo;
import com.kingdee.eas.scm.im.inv.IInvStateAdjustBill;
import com.kingdee.eas.scm.im.inv.IMatAttrChangeBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueWebFacade;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillEntryCollection;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillEntryInfo;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillFactory;
import com.kingdee.eas.scm.im.inv.InvStateAdjustBillInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillFactory;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAttrChangeBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueWebFacadeFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvWebUtils {
    public static Map getCompanyInfoMapBySou(String souId) {
        HashMap<String, CompanyOrgUnitInfo> map = new HashMap<String, CompanyOrgUnitInfo>();
        if (StringUtils.isEmpty((String)souId)) {
            return map;
        }
        StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
        storage.setId(BOSUuid.read((String)souId));
        map.put("companyOrgUnit", OrgUnitUtil.getCompanyFromStorage(null, storage));
        return map;
    }

    public static CompanyOrgUnitInfo getCompanyInfoBySou(String souId) {
        if (StringUtils.isEmpty((String)souId)) {
            return null;
        }
        StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
        storage.setId(BOSUuid.read((String)souId));
        return OrgUnitUtil.getCompanyFromStorage(null, storage);
    }

    public static Map getInvUpdateIdsForFilter(Map param) throws EASBizException, BOSException {
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>(0);
        String transactionId = (String)param.get("transactionId");
        if (transactionId == null || transactionId.trim().length() == 0) {
            return result;
        }
        TransactionInvUpdateTypeCollection col = InvWebUtils.getTransactionInvUpdateTypeCol(InvWebUtils.buildInvUpdateTypeEntityView(param), transactionId);
        TransactionInvUpdateTypeInfo tscInvUpdate = null;
        ArrayList updateTypeIds = new ArrayList();
        InvUpdateTypeInfo defaultInvTypeInfo = null;
        StringBuffer idFiter = new StringBuffer();
        if (col != null && !col.isEmpty()) {
            idFiter.append("id in ( ");
            for (int i = 0; i < col.size(); ++i) {
                tscInvUpdate = col.get(i);
                if (i == 0) {
                    idFiter.append("'" + tscInvUpdate.getInvUpdateType().getId().toString() + "'");
                } else {
                    idFiter.append(",'" + tscInvUpdate.getInvUpdateType().getId().toString() + "'");
                }
                if (!tscInvUpdate.isDefaults()) continue;
                defaultInvTypeInfo = tscInvUpdate.getInvUpdateType();
            }
            idFiter.append(" ) ");
            result.put("idsFiter", idFiter);
            result.put("defaultUpdateType", (CharSequence)defaultInvTypeInfo);
        } else {
            result.put("idsFiter", "id in ('888888')");
        }
        return result;
    }

    public static TransactionInvUpdateTypeCollection getTransactionInvUpdateTypeCol(EntityViewInfo view, String transactionId) throws EASBizException, BOSException {
        if (view == null) {
            view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("transactiontype.id", (Object)transactionId, CompareType.EQUALS));
            view.setFilter(filterInfo);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("invUpdateType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeType.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeState.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.name"));
        sic.add(new SelectorItemInfo("invUpdateType.storeTypePre.storeFlag"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.id"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.number"));
        sic.add(new SelectorItemInfo("invUpdateType.storeStatePre.name"));
        return InvCommonUtils.getTransactionInvUpdateTypeCol(null, (EntityViewInfo)view);
    }

    public static EntityViewInfo buildInvUpdateTypeEntityView(Map param) throws EASBizException, BOSException {
        String transactionId = (String)param.get("transactionId");
        boolean isBotpBill = (Boolean)param.get("isBotpBill");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("transactionType.id", (Object)transactionId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("invUpdateType.status", (Object)1, CompareType.EQUALS));
        if (!isBotpBill || InvWebUtils.isBotpNotBuildFilter(param)) {
            ev.setFilter(filterInfo);
            return ev;
        }
        filterInfo.mergeFilter(InvWebUtils.buildInvUpdateTypeFilterInfo(param), "AND");
        ev.setFilter(filterInfo);
        return ev;
    }

    private static boolean isBotpNotBuildFilter(Map param) {
        String billTypeId = (String)param.get("billTypeId");
        String sourceBillTypeID = (String)param.get("sourceBillTypeID");
        return "50957179-0105-1000-e003-3152c0a812fd463ED552".equals(sourceBillTypeID) && ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeId) || "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeId)) || "50957179-0105-1000-e000-016ec0a812fd463ED552".equals(sourceBillTypeID) && "50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeId);
    }

    public static FilterInfo buildInvUpdateTypeFilterInfo(Map param) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String billTypeId = (String)param.get("billTypeId");
        String sourceBillID = (String)param.get("sourceBillID");
        String sourceBillEntryID = (String)param.get("sourceBillEntryID");
        String sourceBillTypeID = (String)param.get("sourceBillTypeID");
        String coreBillID = (String)param.get("coreBillID");
        String coreBillEntryID = (String)param.get("coreBillEntryID");
        String coreBillTypeID = (String)param.get("coreBillTypeID");
        if (SCMBaseCommonUtil.isInvBill((String)sourceBillTypeID)) {
            filterInfo = InvWebUtils.getInvUpdateFilterInfo(param, billTypeId, sourceBillID, sourceBillTypeID, sourceBillEntryID);
        } else if (SCMBaseCommonUtil.isInvBill((String)coreBillTypeID)) {
            filterInfo = InvWebUtils.getInvUpdateFilterInfo(param, billTypeId, coreBillID, coreBillTypeID, coreBillEntryID);
        }
        return filterInfo;
    }

    public static InvBillBaseInfo getBillInfo(String billID, String billTypeID) throws EASBizException, BOSException {
        InvBillBaseInfo billInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.id"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.name"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.id"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeType.name"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.id"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeState.name"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.id"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeTypePre.name"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.id"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.number"));
        sic.add(new SelectorItemInfo("entry.invUpdateType.storeStatePre.name"));
        if (InvWebUtils.getBizInterface(billTypeID) != null) {
            billInfo = (InvBillBaseInfo)InvWebUtils.getBizInterface(billTypeID).getValue((IObjectPK)pk, sic);
        }
        return billInfo;
    }

    public static FilterInfo getInvUpdateFilterInfo(Map param, String descBillTypeId, String billID, String billTypeID, String billEntryID) throws EASBizException, BOSException {
        SelectorItemCollection sic;
        ObjectUuidPK pk;
        ObjectUuidPK pk2;
        String destStorageOrgUnitID = (String)param.get("storageOrgUnitId");
        FilterInfo filterInfo = new FilterInfo();
        if (StringUtil.isEmpty(billID) || StringUtil.isEmpty(billTypeID) || StringUtil.isEmpty(billEntryID)) {
            return filterInfo;
        }
        StringBuffer mask = new StringBuffer(128);
        int maskIndex = 0;
        String prefix = "invUpdateType.";
        InvBillBaseInfo billInfo = InvWebUtils.getBillInfo(billID, billTypeID);
        AbstractObjectCollection billEntryCol = null;
        InvBillBaseEntryInfo billEntryInfo = null;
        if (billInfo != null) {
            String srcStorageOrgUnitID = null;
            if (null != billInfo.getStorageOrgUnit()) {
                srcStorageOrgUnitID = billInfo.getStorageOrgUnit().getId().toString();
            }
            CompanyOrgUnitInfo srcCompanyOrhUnit = InvWebUtils.getCompanyInfo(srcStorageOrgUnitID);
            CompanyOrgUnitInfo destCompanyOrhUnit = InvWebUtils.getCompanyInfo(destStorageOrgUnitID);
            if (srcCompanyOrhUnit == null || destCompanyOrhUnit == null || !destCompanyOrhUnit.getId().toString().equals(srcCompanyOrhUnit.getId().toString())) {
                return filterInfo;
            }
        }
        if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID) || SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) {
            InvUpdateTypeInfo soureInvUpdateTypeInfo;
            billEntryCol = (AbstractObjectCollection)billInfo.getEntries();
            if (CollectionUtil.isEmpty(billEntryCol)) {
                return filterInfo;
            }
            int sourceEntrySize = billEntryCol.size();
            for (int n = 0; n < sourceEntrySize; ++n) {
                if (billEntryCol.getObject(n) == null || !billEntryID.equals(((InvBillBaseEntryInfo)billEntryCol.getObject(n)).getId().toString())) continue;
                billEntryInfo = (InvBillBaseEntryInfo)billEntryCol.getObject(n);
                break;
            }
            InvUpdateTypeInfo invUpdateTypeInfo = soureInvUpdateTypeInfo = billEntryInfo == null ? null : billEntryInfo.getInvUpdateType();
            if (null != soureInvUpdateTypeInfo) {
                StoreTypeInfo storeType = soureInvUpdateTypeInfo.getStoreType();
                StoreStateInfo storeState = soureInvUpdateTypeInfo.getStoreState();
                StoreTypeInfo storeTypePre = soureInvUpdateTypeInfo.getStoreTypePre();
                StoreStateInfo storeStatePre = soureInvUpdateTypeInfo.getStoreStatePre();
                if (storeType != null && storeState != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
                if (storeTypePre != null && storeStatePre != null) {
                    if (maskIndex > 1) {
                        mask.append(" OR ");
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypePre.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStatePre.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypePre.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStatePre.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
            }
        } else if ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) {
            MatAttrChangeAfterEntryCollection afterChangeEntries;
            IMatAttrChangeBill iMatAttr = MatAttrChangeBillFactory.getRemoteInstance();
            pk2 = new ObjectUuidPK(billID);
            billInfo = iMatAttr.getMatAttrChangeBillInfo((IObjectPK)pk2);
            MatAttrChangeBeforeEntryInfo beforeChangeEntry = null;
            MatAttrChangeBeforeEntryCollection entries = (MatAttrChangeBeforeEntryCollection)billInfo.getEntries();
            if (CollectionUtil.isEmpty((AbstractObjectCollection)entries)) {
                return filterInfo;
            }
            int sourceEntrySize = entries.size();
            for (int n = 0; n < sourceEntrySize; ++n) {
                if (!billEntryID.equals(entries.get(n).getId().toString())) continue;
                beforeChangeEntry = entries.get(n);
                break;
            }
            StoreTypeInfo storeTypeBefore = null;
            StoreStateInfo storeStateBefore = null;
            if (beforeChangeEntry != null) {
                storeTypeBefore = beforeChangeEntry.getStoreType();
                storeStateBefore = beforeChangeEntry.getStoreStatus();
            }
            StoreTypeInfo storeTypeAfter = null;
            StoreStateInfo storeStateAfter = null;
            MatAttrChangeAfterEntryCollection matAttrChangeAfterEntryCollection = afterChangeEntries = beforeChangeEntry == null ? null : beforeChangeEntry.getEntry1();
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)afterChangeEntries)) {
                MatAttrChangeAfterEntryInfo afterChangeEntry = afterChangeEntries.get(0);
                storeTypeAfter = afterChangeEntry.getStoreType();
                storeStateAfter = afterChangeEntry.getStoreStatus();
            }
            if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(descBillTypeId)) {
                if (storeTypeBefore != null && storeStateBefore != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
            } else if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(descBillTypeId)) {
                if (storeTypeAfter != null && storeStateAfter != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
            } else {
                if (storeTypeBefore != null && storeStateBefore != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
                if (storeTypeAfter != null && storeStateAfter != null) {
                    if (maskIndex > 1) {
                        mask.append(" OR ");
                    }
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append("(#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" OR (#" + maskIndex++);
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                    mask.append(" AND #" + maskIndex++ + ")");
                }
            }
        } else if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            IInvStateAdjustBill iInvStateAdj = InvStateAdjustBillFactory.getRemoteInstance();
            pk2 = new ObjectUuidPK(billID);
            billInfo = (InvStateAdjustBillInfo)iInvStateAdj.getValue((IObjectPK)pk2);
            InvStateAdjustBillEntryInfo invAdjEntry = null;
            InvStateAdjustBillEntryCollection invAdjEntries = (InvStateAdjustBillEntryCollection)billInfo.getEntries();
            if (CollectionUtil.isEmpty((AbstractObjectCollection)invAdjEntries)) {
                return filterInfo;
            }
            int sourceEntrySize = invAdjEntries.size();
            for (int n = 0; n < sourceEntrySize; ++n) {
                if (!billEntryID.equals(invAdjEntries.get(n).getId().toString())) continue;
                invAdjEntry = invAdjEntries.get(n);
                break;
            }
            StoreTypeInfo storeTypeBefore = null;
            StoreStateInfo storeStateBefore = null;
            StoreTypeInfo storeTypeAfter = null;
            StoreStateInfo storeStateAfter = null;
            if (invAdjEntry != null) {
                storeTypeBefore = invAdjEntry.getStoreType();
                storeStateBefore = invAdjEntry.getSrcStoreStatus();
                storeTypeAfter = invAdjEntry.getStoreType();
                storeStateAfter = invAdjEntry.getDestStoreStatus();
            }
            if (storeTypeBefore != null && storeStateBefore != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                mask.append("(#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeBefore.getId().toString(), CompareType.EQUALS));
                mask.append(" OR (#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateBefore.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
            }
            if (storeTypeAfter != null && storeStateAfter != null) {
                if (maskIndex > 1) {
                    mask.append(" OR ");
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                mask.append("(#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeTypeAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" OR (#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeStateAfter.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
            }
        } else if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeID)) {
            pk = new ObjectUuidPK(billID);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.id"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.number"));
            sic.add(new SelectorItemInfo("issueCompanyOrgUnit.name"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.id"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.number"));
            sic.add(new SelectorItemInfo("issueStorageOrgUnit.name"));
            sic.add(new SelectorItemInfo("entry.id"));
            sic.add(new SelectorItemInfo("entry.number"));
            sic.add(new SelectorItemInfo("entry.storeType.id"));
            sic.add(new SelectorItemInfo("entry.storeType.number"));
            sic.add(new SelectorItemInfo("entry.storeType.name"));
            sic.add(new SelectorItemInfo("entry.storeState.id"));
            sic.add(new SelectorItemInfo("entry.storeState.number"));
            sic.add(new SelectorItemInfo("entry.storeState.name"));
            StockTransferBillInfo stockInfo = (StockTransferBillInfo)StockTransferBillFactory.getRemoteInstance().getValue((IObjectPK)pk);
            String srcStorageOrgUnitID = null;
            if (null != stockInfo.getIssueStorageOrgUnit()) {
                srcStorageOrgUnitID = stockInfo.getIssueStorageOrgUnit().getId().toString();
            }
            CompanyOrgUnitInfo srcCompanyOrhUnit = InvWebUtils.getCompanyInfo(srcStorageOrgUnitID);
            CompanyOrgUnitInfo destCompanyOrhUnit = InvWebUtils.getCompanyInfo(destStorageOrgUnitID);
            if (srcCompanyOrhUnit == null || destCompanyOrhUnit == null || !destCompanyOrhUnit.getId().toString().equals(srcCompanyOrhUnit.getId().toString())) {
                return filterInfo;
            }
            StockTransferBillEntryCollection stockEntries = stockInfo.getEntry();
            StockTransferBillEntryInfo stockEntry = null;
            int sourceEntrySize = stockEntries.size();
            for (int n = 0; n < sourceEntrySize; ++n) {
                if (!billEntryID.equals(stockEntries.get(n).getId().toString())) continue;
                stockEntry = stockEntries.get(n);
                break;
            }
            StoreTypeInfo storeType = null;
            StoreStateInfo storeState = null;
            if (stockEntry != null) {
                storeType = stockEntry.getStoreType();
                storeState = stockEntry.getStoreState();
            }
            if (storeType != null && storeState != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                mask.append("(#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                mask.append(" OR (#" + maskIndex++);
                filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                mask.append(" AND #" + maskIndex++ + ")");
            }
        } else if ("50957179-0105-1000-e004-4152c0a812fd463ED552".equals(billTypeID)) {
            pk = new ObjectUuidPK(billEntryID);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("storeType.id"));
            sic.add(new SelectorItemInfo("storeType.number"));
            sic.add(new SelectorItemInfo("storeType.name"));
            sic.add(new SelectorItemInfo("storeStatus.id"));
            sic.add(new SelectorItemInfo("storeStatus.number"));
            sic.add(new SelectorItemInfo("storeStatus.name"));
            CountingTableEntryInfo countTableEntry = CountingTableEntryFactory.getRemoteInstance().getCountingTableEntryInfo((IObjectPK)pk, sic);
            StoreTypeInfo storeType = null;
            StoreStateInfo storeState = null;
            if (countTableEntry != null) {
                storeType = countTableEntry.getStoreType();
                storeState = countTableEntry.getStoreStatus();
            }
            if (storeType != null && storeState != null) {
                if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(descBillTypeId)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", null, CompareType.EMPTY));
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeState.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                } else if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(descBillTypeId)) {
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeTypePre.id", (Object)storeType.getId().toString(), CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeType.id", null, CompareType.EMPTY));
                    filterInfo.getFilterItems().add(new FilterItemInfo(prefix + "storeStatePre.id", (Object)storeState.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (mask.length() > 0) {
            filterInfo.setMaskString(mask.toString());
        }
        return filterInfo;
    }

    public static ICoreBase getBizInterface(String billTypeID) throws EASBizException, BOSException {
        if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
            return PurInWarehsBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return PurReceivalBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
            return ManufactureRecBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
            return MoveInWarehsBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
            return OtherInWarehsBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
            return SaleIssueBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
            return MaterialReqBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) {
            return MoveIssueBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
            return OtherIssueBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-888880a812fd463ED552".equals(billTypeID)) {
            return MatAttrChangeBillFactory.getRemoteInstance();
        }
        if ("50957179-0105-1000-e000-0152c0a812fd463ED552".equals(billTypeID)) {
            return InvStateAdjustBillFactory.getRemoteInstance();
        }
        return null;
    }

    public static String takeConfigTypeByUI(Map configTypeMap, IUIObject ui, String configTypeValue) throws BOSException {
        SMSDBillConfigInfo aSMSDBillConfig = null;
        SMSDBillConfigInfo sMSDBillConfigInfo = aSMSDBillConfig = configTypeMap.get(configTypeValue) != null ? (SMSDBillConfigInfo)configTypeMap.get(configTypeValue) : null;
        if (aSMSDBillConfig != null) {
            return aSMSDBillConfig.getConfigValue();
        }
        return null;
    }

    public static Map splitBillByWrittenOff(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String billTypeId = (String)paramMap.get("billTypeId");
        Map msgMap = null;
        if (billTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            msgMap = InvWebUtils.splitBillByWrittenOffForPurIn(ctx, paramMap);
        } else if (billTypeId.equals("50957179-0105-1000-e000-015bc0a812fd463ED552")) {
            msgMap = InvWebUtils.splitBillByWrittenOffForSaleIssue(ctx, paramMap);
        }
        if (msgMap != null && msgMap.get("NotSplitMsg") != null) {
            String notSplitMsg = (String)msgMap.get("NotSplitMsg");
            notSplitMsg = notSplitMsg.replaceAll("\n", "<br>");
            msgMap.put("NotSplitMsg", notSplitMsg);
        }
        return msgMap;
    }

    public static Map splitBillByWrittenOffForPurIn(Context ctx, Map paramMap) throws EASBizException, BOSException {
        String idsStr = (String)paramMap.get("ids");
        String[] ids = idsStr.split(",");
        Date bizDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            bizDate = dateFormat.parse((String)paramMap.get("billBizDate"));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        HashMap msgMap = null;
        HashMap<String, Date> param = new HashMap<String, Date>();
        IPurInWarehsBill ipurWarehsBill = PurInWarehsBillFactory.getRemoteInstance();
        param.put("SplitDate", bizDate);
        msgMap = ipurWarehsBill.checkForSplitBill(ids, param);
        if (msgMap != null && msgMap.size() > 0) {
            PurInWarehsBillCollection collection;
            if (msgMap.get("collection") != null && (collection = (PurInWarehsBillCollection)msgMap.get("collection")) != null && collection.size() > 0) {
                if (bizDate != null) {
                    param.put("SplitDate", bizDate);
                }
                ipurWarehsBill.splitBill(collection, param);
            }
            if (msgMap.get("NotSplitMsg") != null) {
                return msgMap;
            }
        }
        return msgMap;
    }

    public static Map splitBillByWrittenOffForSaleIssue(Context ctx, Map paramMap) throws EASBizException, BOSException {
        ISaleIssueWebFacade SaleIssueWebFacade = SaleIssueWebFacadeFactory.getRemoteInstance();
        return SaleIssueWebFacade.splitBillByWrittenOff(paramMap);
    }

    public static void putConfigTypeByUI(String uiClassName, String userId, String configTypeValue, boolean isSelected) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configTypeValue, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        aSMSDBillConfig = aSMSDBillConfigCollection.size() > 0 ? aSMSDBillConfigCollection.get(0) : new SMSDBillConfigInfo();
        if (isSelected) {
            aSMSDBillConfig.setConfigValue("1");
        } else {
            aSMSDBillConfig.setConfigValue("0");
        }
        BOSUuid UserId = BOSUuid.read((String)userId);
        aSMSDBillConfig.setUserID(UserId);
        aSMSDBillConfig.setBillClassName(uiClassName);
        aSMSDBillConfig.setConfigType(configTypeValue);
        iSMSDBillConfig.submit((CoreBaseInfo)aSMSDBillConfig);
    }

    public static void putConfigTypeByUI(String uiClassName, String userId, String configType, String configValue) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configType, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        aSMSDBillConfig = aSMSDBillConfigCollection.size() > 0 ? aSMSDBillConfigCollection.get(0) : new SMSDBillConfigInfo();
        BOSUuid UserId = BOSUuid.read((String)userId);
        aSMSDBillConfig.setUserID(UserId);
        aSMSDBillConfig.setBillClassName(uiClassName);
        aSMSDBillConfig.setConfigType(configType);
        aSMSDBillConfig.setConfigValue(configValue);
        iSMSDBillConfig.submit((CoreBaseInfo)aSMSDBillConfig);
    }

    public static void putConfigTypeByUI(String uiClassName, String userId, String configType, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        FilterItemInfo configTypeFilter = new FilterItemInfo("configType", (Object)configType, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        filter.getFilterItems().add(configTypeFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        CoreBaseCollection addColl = new CoreBaseCollection();
        CoreBaseCollection tempColl = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> delList = new ArrayList<ObjectUuidPK>();
        SMSDBillConfigInfo aSMSDBillConfig = null;
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            String id = String.valueOf(it.next());
            if (aSMSDBillConfigCollection.containsKey((Object)BOSUuid.read((String)id))) {
                tempColl.add((CoreBaseInfo)aSMSDBillConfigCollection.get((Object)BOSUuid.read((String)id)));
                continue;
            }
            aSMSDBillConfig = new SMSDBillConfigInfo();
            BOSUuid UserId = BOSUuid.read((String)userId);
            aSMSDBillConfig.setUserID(UserId);
            aSMSDBillConfig.setBillClassName(uiClassName);
            aSMSDBillConfig.setConfigType(configType);
            aSMSDBillConfig.setConfigValue(id);
            addColl.add((CoreBaseInfo)aSMSDBillConfig);
        }
        int size = aSMSDBillConfigCollection.size();
        for (int i = 0; i < size; ++i) {
            if (tempColl.containsKey((Object)aSMSDBillConfigCollection.get(i).getId())) continue;
            delList.add(new ObjectUuidPK(aSMSDBillConfigCollection.get(i).getId()));
        }
        iSMSDBillConfig.submitBatchData(addColl);
        iSMSDBillConfig.deleteBatchData((IObjectPK[])delList.toArray(new ObjectUuidPK[delList.size()]));
    }

    public static Map takeConfigType(String uiClassName, String userId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)uiClassName, CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)userId, CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getRemoteInstance();
        SMSDBillConfigCollection aSMSDBillConfigCollection = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        HashMap<String, SMSDBillConfigInfo> configTypeMap = new HashMap<String, SMSDBillConfigInfo>();
        if (aSMSDBillConfigCollection.size() > 0) {
            int size = aSMSDBillConfigCollection.size();
            for (int i = 0; i < size; ++i) {
                aSMSDBillConfig = aSMSDBillConfigCollection.get(i);
                configTypeMap.put(aSMSDBillConfig.getConfigType(), aSMSDBillConfig);
            }
        }
        return configTypeMap;
    }

    public static boolean isSaleIssueBillSplitChangeDate(String billType, String companyInfoID) throws BOSException, EASBizException {
        boolean isChangeDate = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyInfoID);
        String per = "INM100";
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            per = "INM100";
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
            per = "INM101";
        }
        String strChangeDate = ipc.getParamValue((IObjectPK)pk, per);
        if (strChangeDate != null && strChangeDate.trim().length() != 0 && strChangeDate.trim().equalsIgnoreCase("true")) {
            isChangeDate = true;
        }
        return isChangeDate;
    }

    public static List<Map> getResultDataByRowSet(RptParams rpt) throws BOSException, EASBizException {
        RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
        List needShowFieldsList = (List)rpt.getObject("needShowFieldsList");
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (int i = 0; i < rs.getRowCount(); ++i) {
            HashMap<String, Object> responseMap = new HashMap<String, Object>();
            if (i != 0) {
                rs.moveTo(i - 1);
                rs.moveTo(i);
            } else {
                rs.moveTo(i);
            }
            responseMap.put("fOrgUnitIDpk_hide", rs.getString("FOrgUnitIDpk_hide"));
            responseMap.put("fOrgUnitID", rs.getString("FOrgUnitID"));
            responseMap.put("fUsableQty", rs.getBigDecimal("FUsableQty"));
            responseMap.put("fReservationQty", rs.getBigDecimal("FReservationQty"));
            responseMap.put("fUnReservationQty", rs.getBigDecimal("FUnReservationQty"));
            responseMap.put("fLockBaseQty", rs.getBigDecimal("FLockBaseQty"));
            responseMap.put("fWaitCheckQty", rs.getBigDecimal("FWaitCheckQty"));
            responseMap.put("fFreezeQty", rs.getBigDecimal("FFreezeQuery"));
            responseMap.put("fTotalQty", rs.getBigDecimal("FTotalQty"));
            responseMap.put("fTotalReservationQty", rs.getBigDecimal("FTotalReservationQty"));
            responseMap.put("fTotalUnReservationQty", rs.getBigDecimal("FTotalUnReservationQty"));
            responseMap.put("fAssiUsableQty", rs.getBigDecimal("FAssiUsableQty"));
            responseMap.put("fReservationAssistQty", rs.getBigDecimal("FReservationAssistQty"));
            responseMap.put("fUnReservationAssistQty", rs.getBigDecimal("FUnReservationAssistQty"));
            responseMap.put("fAssiLockQty", rs.getBigDecimal("FAssiLockQty"));
            responseMap.put("fAssiWaitCheckQty", rs.getBigDecimal("FAssiWaitCheckQty"));
            responseMap.put("fAssiFreezeQty", rs.getBigDecimal("FAssiFreezeQuery"));
            responseMap.put("fAssiTotalQty", rs.getBigDecimal("FAssiTotalQty"));
            responseMap.put("fTotalReservationAssistQty", rs.getBigDecimal("FTotalReservationAssistQty"));
            responseMap.put("fTotalUnReservationAssistQty", rs.getBigDecimal("FTotalUnReservationAssistQty"));
            responseMap.put("fStorageOrgUnitIDpk_hide", rs.getString("FStorageOrgUnitIDpk_hide"));
            responseMap.put("fWarehouseIDpk_hide", rs.getString("FWarehouseIDpk_hide"));
            responseMap.put("fParentID", rs.getString("FParentID"));
            responseMap.put("fisleaf", rs.getInt("Fisleaf"));
            responseMap.put("fLevel", rs.getInt("FLevel"));
            responseMap.put("fID", rs.getString("FID"));
            for (int j = 0; j < needShowFieldsList.size(); ++j) {
                responseMap.put(needShowFieldsList.get(j).toString(), rs.getObject(needShowFieldsList.get(j).toString()));
            }
            resultList.add(responseMap);
        }
        return resultList;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(String storgeId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo ret = null;
        if (storgeId != null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storgeId, 4, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }
}

