/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.AdvancedPermissionServiceFactory;
import com.kingdee.eas.base.permission.IAdvancedPermissionService;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class PermissionUtil {
    public static final String PERM_JOIN = "PERM_JOIN";
    public static final String PERM_WHERE = "PERM_WHERE";
    public static final String MATRAIL_VIEW_PERM = "bd_material_view";
    public static final String WAREHOUSE_VIEW_PERM = "warehous_view";
    public static final String LOCATION_VIEW_PERM = "location_view";
    public static final String INVENTORY_VIEW_PERM = "inventory";
    private static Map<String, EntityObjectInfo> entityObjCache = new HashMap<String, EntityObjectInfo>();

    public static Set<FullOrgUnitInfo> getAuthorizedf7Orgs(Context ctx, IObjectPK userPK, String permission) throws BOSException {
        return PermissionUtil.getAuthorizedf7Orgs(ctx, userPK, permission, false);
    }

    public static Set<String> getAuthorizedOrgIDSet(Context ctx, IObjectPK userPK, String permission) throws BOSException {
        return PermissionUtil.getAuthorizedOrgIDSetByType(ctx, userPK, permission, OrgViewType.STORAGE);
    }

    public static Set<String> getAuthorizedOrgIDSetByType(Context ctx, IObjectPK userPK, String permission, OrgViewType type) throws BOSException {
        OrgViewType[] orgViewTypes = new OrgViewType[]{type};
        OrgType orgType = NewOrgViewHelper.convert((OrgViewType)orgViewTypes[0]);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        HashSet<String> orgUnitSet = new HashSet<String>();
        FullOrgUnitCollection unitCol = null;
        IPermission iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        try {
            unitCol = iPermission.getAuthorizedOrg(userPK, orgType, (IObjectPK)treePK, permission);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            orgUnitSet.add(unitCol.get(i).getId().toString());
        }
        return orgUnitSet;
    }

    public static Set<FullOrgUnitInfo> getAuthorizedf7Orgs(Context ctx, IObjectPK userPK, String permission, boolean isOnlyCU) throws BOSException {
        HashSet<FullOrgUnitInfo> orgUnitSet = new HashSet<FullOrgUnitInfo>();
        FullOrgUnitCollection unitCol = null;
        IAdvancedPermissionService iPermission = ctx == null ? AdvancedPermissionServiceFactory.getRemoteInstance() : AdvancedPermissionServiceFactory.getLocalInstance((Context)ctx);
        try {
            unitCol = iPermission.getAuthorizedOrgsWithCU(userPK, OrgType.Storage, permission, isOnlyCU);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < unitCol.size(); ++i) {
            orgUnitSet.add(unitCol.get(i));
        }
        return orgUnitSet;
    }

    public static FullOrgUnitCollection getAuthorizedOrgs(Context ctx, IObjectPK userPK, String permission, boolean isOnlyCU) throws BOSException {
        FullOrgUnitCollection unitCol = null;
        IAdvancedPermissionService iPermission = ctx == null ? AdvancedPermissionServiceFactory.getRemoteInstance() : AdvancedPermissionServiceFactory.getLocalInstance((Context)ctx);
        try {
            unitCol = iPermission.getAuthorizedOrgsWithCU(userPK, OrgType.Storage, permission, isOnlyCU);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return unitCol;
    }

    private static Set<FullOrgUnitInfo> getFullOrgUnit(Context ctx, Set<String> orgUnitSet, boolean isOnlyCU) throws BOSException {
        FullOrgUnitCollection orgUnitCollection = null;
        LinkedHashSet<FullOrgUnitInfo> fullUnitSet = new LinkedHashSet<FullOrgUnitInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("longNumber");
        sic.add("isCU");
        sic.add("name");
        sic.add("cu.id");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("ID", orgUnitSet, CompareType.INCLUDE));
        if (isOnlyCU) {
            fi.getFilterItems().add(new FilterItemInfo("isCU", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        SorterItemInfo sortItem = new SorterItemInfo("level");
        sortItem.setSortType(SortType.ASCEND);
        SorterItemCollection sortColl = new SorterItemCollection();
        sortColl.add(sortItem);
        ev.setSorter(sortColl);
        ev.setSelector(sic);
        ev.setFilter(fi);
        IFullOrgUnit iFullOrgUnit = ctx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)ctx);
        orgUnitCollection = iFullOrgUnit.getFullOrgUnitCollection(ev);
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            fullUnitSet.add(orgUnitCollection.get(i));
        }
        return fullUnitSet;
    }

    private static EntityViewInfo getDataPermissionEntity(String oql) throws Exception {
        if (oql == null) {
            return null;
        }
        StringBuffer permision = new StringBuffer();
        permision.append(" select * ");
        permision.append(oql);
        oql = permision.toString();
        EntityViewInfo view = null;
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            return null;
        }
        if (view.getFilter() != null && view.getFilter().getFilterItems() != null && view.getFilter().getFilterItems().size() > 0) {
            return view;
        }
        return null;
    }

    private static Map<String, EntityViewInfo> getPermissionEntityViewMap(Context ctx, IObjectPK userPK, Set<OrgUnitInfo> orgUnitSet, String permissionItem) {
        EntityViewInfo dataPemissionViewInfo = null;
        String parentId = null;
        EntityViewInfo parentViewInfo = null;
        Object var7_7 = null;
        String orgId = null;
        HashMap<String, EntityViewInfo> permMap = new HashMap<String, EntityViewInfo>();
        LinkedHashSet<Object> allOrgUnit = new LinkedHashSet<Object>();
        HashMap<String, EntityViewInfo> entityViewMap = new HashMap<String, EntityViewInfo>();
        boolean isInventoryPerm = INVENTORY_VIEW_PERM.equals(permissionItem);
        try {
            if (!isInventoryPerm) {
                Set<FullOrgUnitInfo> fullOrgUnit = PermissionUtil.getAuthorizedf7Orgs(ctx, userPK, permissionItem, true);
                allOrgUnit.addAll(fullOrgUnit);
                if (CollectionUtil.isEmpty(allOrgUnit)) {
                    return permMap;
                }
            }
            if (orgUnitSet == null) {
                orgUnitSet = new HashSet<OrgUnitInfo>();
            } else {
                allOrgUnit.addAll(orgUnitSet);
            }
            for (OrgUnitInfo orgUnitInfo : allOrgUnit) {
                orgId = orgUnitInfo.getId().toString();
                parentId = orgUnitInfo.getObjectValue("parent") == null ? null : orgUnitInfo.getObjectValue("parent").getString("id");
                parentViewInfo = null;
                if (parentId != null && !isInventoryPerm) {
                    parentViewInfo = (EntityViewInfo)entityViewMap.get(parentId);
                }
                dataPemissionViewInfo = null;
                if (isInventoryPerm || orgUnitInfo.isIsCU()) {
                    dataPemissionViewInfo = PermissionUtil.getDataPermissionEntity("");
                }
                if (dataPemissionViewInfo != null && parentViewInfo != null) {
                    dataPemissionViewInfo.getFilter().mergeFilter(parentViewInfo.getFilter(), "and");
                } else if (parentViewInfo != null) {
                    dataPemissionViewInfo = parentViewInfo;
                }
                entityViewMap.put(orgId, dataPemissionViewInfo);
                if (dataPemissionViewInfo == null || dataPemissionViewInfo.getFilter() == null) continue;
                permMap.put(orgId, dataPemissionViewInfo);
            }
        }
        catch (Exception e) {
            return permMap;
        }
        return permMap;
    }

    public static Map<String, String> getDataPermissionSQL(Context ctx, IObjectPK userPK, Set<String> orgUnitIDSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgUnitIDSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("isCU");
        sic.add("parent.id");
        sic.add("cu.id");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        IStorageOrgUnit iStorageOrgUnit = ctx == null ? StorageOrgUnitFactory.getRemoteInstance() : StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        StorageOrgUnitCollection coll = iStorageOrgUnit.getStorageOrgUnitCollection(viewInfo);
        HashSet<OrgUnitInfo> orgUnitSet = new HashSet<OrgUnitInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            orgUnitSet.add((OrgUnitInfo)coll.get(i));
        }
        return PermissionUtil.getDataPermissionSQL(ctx, orgUnitSet, userPK);
    }

    private static Map<String, String> getDataPermissionSQL(Context ctx, Set<OrgUnitInfo> orgUnitSet, IObjectPK userPK) throws BOSException {
        StringBuilder sql = new StringBuilder();
        String dataPermissionSQL = null;
        String[] permissionItems = new String[]{MATRAIL_VIEW_PERM, WAREHOUSE_VIEW_PERM, LOCATION_VIEW_PERM, INVENTORY_VIEW_PERM};
        String mainTableAlias = "";
        BOSObjectType bosType = null;
        sql.append(" 1=1 ");
        HashMap<String, String> dataPermMap = null;
        HashSet<String> joinSQLSet = new HashSet<String>();
        String checkLocation = "false";
        int len = permissionItems.length;
        for (int i = 0; i < len; ++i) {
            if (MATRAIL_VIEW_PERM.equals(permissionItems[i])) {
                mainTableAlias = "material";
                bosType = BOSObjectType.create((String)"4409E7F0");
            } else if (WAREHOUSE_VIEW_PERM.equals(permissionItems[i])) {
                mainTableAlias = "warehouse";
                bosType = BOSObjectType.create((String)"BBE9F8AE");
            } else if (LOCATION_VIEW_PERM.equals(permissionItems[i])) {
                mainTableAlias = "location";
                bosType = BOSObjectType.create((String)"205FF86A");
            } else if (INVENTORY_VIEW_PERM.equals(permissionItems[i])) {
                bosType = BOSObjectType.create((String)"BA8AD747");
                mainTableAlias = INVENTORY_VIEW_PERM;
            }
            dataPermMap = PermissionUtil.getDataPermissionSQL(ctx, userPK, orgUnitSet, permissionItems[i], mainTableAlias, INVENTORY_VIEW_PERM, bosType);
            if (CollectionUtil.isEmpty(dataPermMap)) continue;
            if (LOCATION_VIEW_PERM.equals(permissionItems[i])) {
                checkLocation = "true";
            }
            dataPermissionSQL = (String)dataPermMap.get(PERM_WHERE);
            joinSQLSet.add((String)dataPermMap.get(PERM_JOIN));
            if (StringUtil.isEmpty(dataPermissionSQL)) continue;
            dataPermissionSQL = dataPermissionSQL.replaceAll("\"T12\"", "material");
            sql.append(" and ").append(dataPermissionSQL);
        }
        dataPermMap = new HashMap<String, String>();
        dataPermMap.put(PERM_WHERE, sql.toString());
        String joinSql = PermissionUtil.handleJoinSQL(joinSQLSet);
        if (joinSql != null) {
            joinSql = joinSql.replaceAll("\"T12\"", "material");
        }
        dataPermMap.put(PERM_JOIN, joinSql);
        dataPermMap.put("checkLocation", checkLocation);
        return dataPermMap;
    }

    public static Map<String, String> getDataPermissionSQL(Context ctx, IObjectPK userPK, Set<OrgUnitInfo> orgUnitSet, String permissionItem, String mainTableAlias, String orgUnitAlias) throws BOSException {
        BOSObjectType bosType = null;
        if (MATRAIL_VIEW_PERM.equals(permissionItem)) {
            bosType = BOSObjectType.create((String)"4409E7F0");
        } else if (WAREHOUSE_VIEW_PERM.equals(permissionItem)) {
            bosType = BOSObjectType.create((String)"BBE9F8AE");
        } else if (LOCATION_VIEW_PERM.equals(permissionItem)) {
            bosType = BOSObjectType.create((String)"205FF86A");
        } else if (INVENTORY_VIEW_PERM.equals(permissionItem)) {
            bosType = BOSObjectType.create((String)"BA8AD747");
        }
        return PermissionUtil.getDataPermissionSQL(ctx, userPK, orgUnitSet, permissionItem, mainTableAlias, orgUnitAlias, bosType);
    }

    private static Map<String, String> getDataPermissionSQL(Context ctx, IObjectPK userPK, Set<OrgUnitInfo> orgUnitSet, String permissionItem, String mainTableAlias, String orgUnitAlias, BOSObjectType bosType) throws BOSException {
        Map<String, EntityViewInfo> permMap = PermissionUtil.getPermissionEntityViewMapNew(ctx, userPK, orgUnitSet, permissionItem);
        if (CollectionUtil.isEmpty(permMap)) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        Iterator<OrgUnitInfo> it = orgUnitSet.iterator();
        OrgUnitInfo orgUnitInfo = null;
        String orgUnitId = null;
        EntityViewInfo dataPermissionViewInfo = null;
        String filterSQL = null;
        StringBuilder joinSQL = new StringBuilder();
        HashMap permSQLCache = new HashMap();
        Map<String, String> permSQLMap = null;
        String key = null;
        try {
            while (it.hasNext()) {
                orgUnitInfo = it.next();
                orgUnitId = orgUnitInfo.getId().toString();
                dataPermissionViewInfo = permMap.get(orgUnitId);
                permSQLMap = null;
                if (dataPermissionViewInfo != null) {
                    key = dataPermissionViewInfo.toString();
                    permSQLMap = permSQLCache.containsKey(key) ? (Map<String, String>)permSQLCache.get(key) : PermissionUtil.genPermSQL(ctx, bosType, dataPermissionViewInfo, mainTableAlias);
                }
                sql.append(" (").append(orgUnitAlias).append(".FStorageOrgUnitID = '").append(orgUnitId).append("' ");
                if (!CollectionUtil.isEmpty(permSQLMap)) {
                    if (permSQLMap.get(PERM_JOIN) != null) {
                        joinSQL.append(permSQLMap.get(PERM_JOIN));
                    }
                    if (!StringUtil.isEmpty(filterSQL = permSQLMap.get(PERM_WHERE))) {
                        sql.append(" and ").append(filterSQL);
                    }
                }
                sql.append(") or ");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuilder resultSQL = new StringBuilder();
        if (sql.length() > 0) {
            resultSQL.append(" (").append((CharSequence)sql).append(" 1 = 0) ");
        }
        HashMap<String, String> dataPermMap = new HashMap<String, String>();
        dataPermMap.put(PERM_JOIN, joinSQL.toString());
        dataPermMap.put(PERM_WHERE, resultSQL.toString());
        return dataPermMap;
    }

    private static Map<String, String> genPermSQL(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo, String mainTableAlias) throws Exception {
        HashMap<String, String> permSQLMap = new HashMap<String, String>();
        String sql = PermissionUtil.getSQLByEntityView(ctx, bosType, viewInfo);
        if (StringUtil.isEmpty(sql) || !sql.contains("JOIN") && !sql.contains("WHERE")) {
            return permSQLMap;
        }
        int pos = sql.indexOf("LEFT OUTER JOIN");
        if (pos > -1) {
            sql = sql.substring(pos);
        }
        if ((pos = (sql = sql.replaceAll("\"T0\"", mainTableAlias)).indexOf("WHERE")) != -1) {
            String whereSQL = sql.substring(pos + 5);
            sql = sql.substring(0, pos);
            permSQLMap.put(PERM_WHERE, whereSQL);
        }
        if (!StringUtil.isEmpty(sql) && sql.contains("LEFT OUTER JOIN")) {
            String ignoreSql = "INNER JOIN \"T_BD_MATERIAL\" \"T12\" ON inventory.\"FMATERIALID\" = \"T12\".\"FID\"";
            sql = sql.replace(ignoreSql, "");
            permSQLMap.put(PERM_JOIN, sql);
        }
        return permSQLMap;
    }

    private static String getSQLByEntityView(Context ctx, BOSObjectType bosType, EntityViewInfo viewInfo) throws DataAccessException {
        if (viewInfo == null || bosType == null) {
            return "";
        }
        EntityObjectInfo entityObj = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        entityObj = entityObjCache.get(bosType.toString()) != null ? entityObjCache.get(bosType.toString()) : loader.getEntity(bosType);
        if (entityObj == null) {
            return "";
        }
        try {
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)viewInfo.getEntryFilters())) {
                ImplUtils.processEntryFilter((EntityObjectInfo)entityObj, (EntityViewInfo)viewInfo, (Context)ctx);
            }
            SolutionInfo solution = loader.getSolution();
            return new ObjectReader(ctx, null, solution).getSelectSQL(entityObj, viewInfo);
        }
        catch (SQLException sqle) {
            throw new DataAccessException((Throwable)sqle);
        }
        catch (BOSException bose) {
            if (bose instanceof DataAccessException) {
                throw (DataAccessException)bose;
            }
            throw new DataAccessException((Throwable)bose);
        }
    }

    private static String handleJoinSQL(Set<String> joinSQLSet) {
        if (CollectionUtil.isEmpty(joinSQLSet)) {
            return null;
        }
        Iterator<String> itor = joinSQLSet.iterator();
        String joinSQL = null;
        String[] str = null;
        String token = "LEFT OUTER JOIN";
        HashSet<String> sqlSet = new HashSet<String>();
        ArrayList<String> sqlList = new ArrayList<String>();
        while (itor.hasNext()) {
            joinSQL = itor.next().trim();
            if (StringUtil.isEmpty(joinSQL) || joinSQL.indexOf(token) <= -1) continue;
            str = joinSQL.split(token);
            int len = str.length;
            for (int i = 0; i < len; ++i) {
                if (StringUtil.isEmpty(str[i]) || !sqlSet.add(token + str[i])) continue;
                sqlList.add(token + str[i]);
            }
        }
        StringBuilder sql = new StringBuilder();
        itor = sqlList.iterator();
        while (itor.hasNext()) {
            sql.append(itor.next()).append("\r\n");
        }
        return sql.toString();
    }

    private static Map<String, EntityViewInfo> getPermissionEntityViewMapNew(Context ctx, IObjectPK userPK, Set<OrgUnitInfo> orgUnitSet, String permissionItem) {
        EntityViewInfo dataPemissionViewInfo = null;
        OrgUnitInfo orgUnitInfo2 = null;
        String orgId = null;
        HashMap<String, EntityViewInfo> permMap = new HashMap<String, EntityViewInfo>();
        FullOrgUnitCollection authorizedOrgs = null;
        boolean isInventoryPerm = INVENTORY_VIEW_PERM.equals(permissionItem);
        HashSet<String> idSet = new HashSet<String>();
        try {
            if (!isInventoryPerm) {
                authorizedOrgs = PermissionUtil.getAuthorizedOrgs(ctx, userPK, permissionItem, true);
                if (CollectionUtil.isEmpty((AbstractObjectCollection)authorizedOrgs)) {
                    return permMap;
                }
                for (int i = 0; i < authorizedOrgs.size(); ++i) {
                    idSet.add(authorizedOrgs.get(i).getId().toString());
                }
            }
            if (orgUnitSet != null && orgUnitSet.size() > 0) {
                Iterator<OrgUnitInfo> it = orgUnitSet.iterator();
                while (it.hasNext()) {
                    idSet.add(it.next().getId().toString());
                }
            }
            IAdvancedPermissionService iPermission = ctx == null ? AdvancedPermissionServiceFactory.getRemoteInstance() : AdvancedPermissionServiceFactory.getLocalInstance((Context)ctx);
            Map orgDataPermissonRule = iPermission.getPermissionRule(userPK, idSet, permissionItem);
            Set dataRule = orgDataPermissonRule.entrySet();
            for (Map.Entry entry : dataRule) {
                dataPemissionViewInfo = PermissionUtil.getDataPermissionEntity((String)entry.getValue());
                if (dataPemissionViewInfo == null || dataPemissionViewInfo.getFilter() == null) continue;
                permMap.put((String)entry.getKey(), dataPemissionViewInfo);
            }
            for (OrgUnitInfo orgUnitInfo2 : orgUnitSet) {
                orgId = orgUnitInfo2.getId().toString();
                if (isInventoryPerm || orgUnitInfo2.isIsCU() || (dataPemissionViewInfo = (EntityViewInfo)permMap.get(orgUnitInfo2.getCU().getId().toString())) == null || dataPemissionViewInfo.getFilter() == null) continue;
                permMap.put(orgId, dataPemissionViewInfo);
            }
        }
        catch (Exception e) {
            return permMap;
        }
        return permMap;
    }
}

