/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.report.app.CreateTempTableResult;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SCMRptUtil {
    public static final String SCM_RPT_PARAMS = "scmrptparams";
    public static final String SCM_RPT_PARAMS2 = "scmrptparams2";
    public static final int SCM_RPT_QUERYSTART = 0;
    public static final int SCM_RPT_QUERYLEN = 100;

    public static String getFilterBeginDate(Date d) {
        return DateTimeUtil.getFmtDateAndTime(d);
    }

    public static String getFilterEndDate(Date d) {
        long dl = d.getTime();
        Date nDate = new Date(dl += 86399999L);
        return DateTimeUtil.getFmtDateAndTime(nDate);
    }

    public static String getFilterWeekBeforeDate(Date d) {
        long dl = d.getTime();
        Date nDate = new Date(dl -= 604800000L);
        return DateTimeUtil.getFmtDateAndTime(nDate);
    }

    public static CreateTempTableResult executeCreateAsSelectInto(Context ctx, String sql, SqlParams parameters) throws BOSException {
        Connection con = null;
        try {
            CreateTempTableResult result;
            con = EJBFactory.getConnection((Context)ctx);
            CreateTempTableResult createTempTableResult = result = DBUtil.executeSelectIntoForTempTable((Context)ctx, (String)sql, (SqlParams)parameters, (Connection)con);
            return createTempTableResult;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, null, (Connection)con);
        }
    }

    public static void setQueryHeader(KDTable tbl, ITablePreferenceHelper tHelper, Map<String, Boolean> queryHeaderMap) {
        if (!queryHeaderMap.isEmpty()) {
            for (Map.Entry<String, Boolean> entry : queryHeaderMap.entrySet()) {
                IColumn column = tbl.getColumn(entry.getKey());
                if (column == null) continue;
                column.getStyleAttributes().setHided(entry.getValue() == false);
            }
        }
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper) {
        SCMRptUtil.insertRows(rs, insertRowIndex, ui, table, tHelper, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs), true);
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper, KDTableInsertHandler handler, boolean refreshUI) {
        table.setRefresh(false);
        Object[] rowData = null;
        while (rs.next()) {
            IRow row = table.setRow(insertRowIndex++);
            rowData = SCMRptUtil.sortRowData(rs.toRowArray(), ui, table, tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    public static Object[] sortRowData(Object[] rowData, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper) {
        UserCustomConfigItemData defaultConfig = tHelper.getDefaultUserData(table);
        UserPreferenceData userDBData = tHelper.getUserDataFromUI();
        String key = ui.getClass().getName() + "." + table.getName();
        UserCustomConfigItemData curConfig = userDBData.getTableCurrentSetting(key);
        return SCMRptUtil.sortRowData(rowData, defaultConfig, curConfig);
    }

    private static Object[] sortRowData(Object[] rowData, UserCustomConfigItemData defaultConfig, UserCustomConfigItemData curConfig) {
        Object[] resultData = Arrays.copyOf((Object[])rowData, (int)rowData.length);
        List curColumnList = Arrays.asList((Object[])curConfig.getColumnData().keySet().toArray());
        ColumnItemData columnData = null;
        String key2 = null;
        int expectIndex = -1;
        int originalIndex = -1;
        Object temp = null;
        for (String key2 : curColumnList) {
            columnData = (ColumnItemData)curConfig.getColumnData().get(key2);
            if (columnData == null) continue;
            expectIndex = columnData.getIndex();
            columnData = (ColumnItemData)defaultConfig.getColumnData().get(key2);
            originalIndex = columnData != null ? columnData.getIndex() : expectIndex;
            resultData[expectIndex] = rowData[originalIndex];
        }
        return resultData;
    }

    public static void insertRowsAfterSort(RptRowSet rs, int insertRowIndex, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper, KDTableInsertHandler handler, boolean refreshUI) {
        table.setRefresh(false);
        Object[] rowData = null;
        while (rs.next()) {
            IRow row = table.addRow(insertRowIndex++);
            rowData = SCMRptUtil.sortRowDataWithSelecetd(rs.toRowArray(), ui, table, tHelper);
            handler.setTableRowData(row, rowData);
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }

    private static Object[] sortRowDataWithSelecetd(Object[] rowData, CoreUI ui, KDTable table, ITablePreferenceHelper tHelper) {
        UserCustomConfigItemData defaultConfig = tHelper.getDefaultUserData(table);
        UserPreferenceData userDBData = tHelper.getUserDataFromUI();
        String key = ui.getClass().getName() + "." + table.getName();
        UserCustomConfigItemData curConfig = userDBData.getTableCurrentSetting(key);
        return SCMRptUtil.sortRowDataWithSelected(rowData, defaultConfig, curConfig);
    }

    private static Object[] sortRowDataWithSelected(Object[] rowData, UserCustomConfigItemData defaultConfig, UserCustomConfigItemData curConfig) {
        Object[] resultData = new Object[rowData.length + 1];
        List curColumnList = Arrays.asList((Object[])curConfig.getColumnData().keySet().toArray());
        ColumnItemData columnData = null;
        String key2 = null;
        int expectIndex = -1;
        int originalIndex = -1;
        for (String key2 : curColumnList) {
            columnData = (ColumnItemData)curConfig.getColumnData().get(key2);
            if (columnData == null) continue;
            expectIndex = columnData.getIndex();
            if ("selected".equals(key2)) {
                resultData[expectIndex] = "selected";
                continue;
            }
            columnData = (ColumnItemData)defaultConfig.getColumnData().get(key2);
            originalIndex = columnData != null ? columnData.getIndex() : expectIndex;
            resultData[expectIndex] = rowData[originalIndex - 1];
        }
        return resultData;
    }
}

