/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.ide.utils.EntityObjectInfoHelp;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.reservation.InvReservationException;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.QueryInfoConstant;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class SCMUtil {
    public static BigDecimal getMaterialBaseQty(Context ctx, String materialID, String companyID, String storageOrgID, String warehouseID, String locationID) throws BOSException, EASBizException {
        if (null == ctx) {
            return null;
        }
        IRowSet rs = null;
        StringBuffer sqlBuffer = new StringBuffer();
        String companyWhere = "";
        String storageWhere = "";
        String warehouseWhere = "";
        String locationWhere = "";
        String itemWhere = "";
        companyWhere = companyID != null ? " AND FCompanyOrgUnitID = '" + companyID + "' " : "";
        storageWhere = storageOrgID != null ? " AND FStorageOrgUnitID = '" + storageOrgID + "' " : "";
        warehouseWhere = warehouseID != null ? " AND FWarehouseID = '" + warehouseID + "' " : "";
        locationWhere = locationID != null ? " AND FLocationID = '" + locationID + "' " : "";
        itemWhere = materialID != null ? " AND FMaterialID = '" + materialID + "' " : "";
        sqlBuffer.append("SELECT SUM(FBaseQty) AS Qty FROM T_IM_INVENTORY ");
        sqlBuffer.append("WHERE 1=1 " + companyWhere + storageWhere + warehouseWhere + locationWhere + itemWhere);
        String sql = sqlBuffer.toString();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            rs.next();
            if (rs.getBigDecimal("Qty") == null) {
                return NumericUtil.BIGDECIMAL_ZERO;
            }
            return rs.getBigDecimal("Qty");
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static OrgUnitCollection getStorageUnitInfo(CompanyOrgUnitInfo cou) {
        try {
            if (cou == null) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static OrgUnitCollection getStorageUnitInfo(String couId) {
        try {
            if (couId == null || "".equals(couId)) {
                return null;
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
            OrgUnitCollection orgCol = iUnitRel.getFromUnit(couId, 1, 4);
            return orgCol;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static Set getStoragesIDSet(CompanyOrgUnitInfo company) {
        HashSet<String> storageSet = new HashSet<String>();
        OrgUnitCollection storageColl = SCMUtil.getStorageUnitInfo(company);
        if (storageColl != null) {
            int size = storageColl.size();
            OrgUnitInfo org = null;
            for (int index = 0; index < size; ++index) {
                org = storageColl.get(index);
                storageSet.add(org.getId().toString());
            }
        }
        return storageSet;
    }

    public static void fmtTableAmt(KDTable table, String columnName, int scale) {
        table.getColumn(columnName).getStyleAttributes().setNumberFormat(SCMUtil.fmtTableString(scale).toString());
        table.getColumn(columnName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(KDTable table, String[] columnName, int scale) {
        int size = columnName.length;
        for (int i = 0; i < size; ++i) {
            table.getColumn(columnName[i]).getStyleAttributes().setNumberFormat(SCMUtil.fmtTableString(scale).toString());
            table.getColumn(columnName[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static void fmtTableAmt(IColumn column, int scale) {
        column.getStyleAttributes().setNumberFormat(SCMUtil.fmtTableString(scale).toString());
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void fmtTableAmt(ICell cell, int scale) {
        cell.getStyleAttributes().setNumberFormat(SCMUtil.fmtTableString(scale).toString());
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static StringBuffer fmtTableString(int scale) {
        return PrecisionUtil.fmtTableString(scale);
    }

    public static void setBizMaterialF7(KDBizPromptBox bizMaterialBox, Component owner, OrgType mainOrgType, boolean isMulSelect, String queryInfo) {
        if (bizMaterialBox == null) {
            return;
        }
        String className = "com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor";
        Class<?> clazz = null;
        Constructor<?> constructor = null;
        try {
            clazz = Class.forName(className);
            if (queryInfo != null) {
                bizMaterialBox.setQueryInfo(queryInfo);
            }
            bizMaterialBox.setEditable(true);
            Object selectorLisenterMaterial = null;
            if (queryInfo != null) {
                if (queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanGroupQuery") || queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery")) {
                    String query = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanNoGroupQuery";
                    if (queryInfo.equalsIgnoreCase("com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery")) {
                        query = "com.kingdee.eas.basedata.master.material.app.F7MaterialPlanForBOMGroupQuery";
                    }
                    constructor = clazz.getConstructor(KDPromptBox.class, String.class, Object.class, String.class, String.class, String.class, String.class, String.class);
                    selectorLisenterMaterial = constructor.newInstance(bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", owner, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", QueryInfoConstant.getMaterialQueryOrgId(mainOrgType), query);
                } else {
                    constructor = clazz.getConstructor(KDPromptBox.class, String.class, Object.class, String.class, String.class, String.class, String.class);
                    selectorLisenterMaterial = constructor.newInstance(bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", owner, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", QueryInfoConstant.getMaterialQueryOrgId(mainOrgType));
                }
            } else {
                constructor = clazz.getConstructor(KDPromptBox.class, String.class, Object.class, String.class, String.class, String.class, String.class, String.class);
                selectorLisenterMaterial = constructor.newInstance(bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", owner, MaterialGroupInfo.getBosType(), QueryInfoConstant.getMaterialQueryInfo(mainOrgType), "materialGroup.id", QueryInfoConstant.getMaterialQueryOrgId(mainOrgType), QueryInfoConstant.getMaterialNoGroupQueryInfo(mainOrgType));
            }
            bizMaterialBox.setSelector((KDPromptSelector)selectorLisenterMaterial);
            bizMaterialBox.addSelectorListener((SelectorListener)selectorLisenterMaterial);
            if (isMulSelect) {
                Method method = clazz.getDeclaredMethod("setIsMultiSelect", Boolean.TYPE);
                method.invoke(selectorLisenterMaterial, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setLog(Context ctx, Map map, String logItemName, String methodName, String bosType) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator it = map.keySet().iterator();
        String number = null;
        String name = null;
        while (it.hasNext()) {
            number = (String)it.next();
            name = (String)map.get(number);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)(number + " " + name), (String)logItemName);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    public static void setLog(Context ctx, Map map, Set set, String logItemName, String methodName, String bosType) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator it = map.keySet().iterator();
        String number = null;
        String name = null;
        while (it.hasNext()) {
            number = (String)it.next();
            name = (String)map.get(number);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)(number + " " + name), (String)logItemName);
            if (set.contains(number)) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    public static BigDecimal getExchangeQtyForClient(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(ctx, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("otherPrecision")) {
            scale = Integer.parseInt((String)map.get("otherPrecision"));
        }
        targetQty = NumericUtil.setScale(targetQty, scale);
        return targetQty;
    }

    public static BigDecimal getExchangeQtyForClient(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        int scale = 0;
        Map map = SCMUtil.getBaseQtyAndPrecision(null, materialID, unitInfo, otherUnitInfo, qty);
        if (null != map.get("targetQty")) {
            targetQty = (BigDecimal)map.get("targetQty");
        }
        if (null != map.get("basePrecision")) {
            scale = Integer.parseInt((String)map.get("basePrecision"));
        }
        targetQty = NumericUtil.setScale(targetQty, scale);
        return targetQty;
    }

    private static Map getBaseQtyAndPrecision(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        return SCMUtil.getBaseQtyAndPrecision(ctx, materialID, unitInfo.getId().toString(), otherUnitInfo.getId().toString(), qty);
    }

    private static Map getBaseQtyAndPrecision(Context ctx, String materialID, String unitInfoID, String otherUnitInfoID, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal targetQty = null;
        BigDecimal baseQty = null;
        IMultiMeasureUnit multiUnit = null;
        multiUnit = null == ctx ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfoID);
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfoID);
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = NumericUtil.BIGDECIMAL_ONE;
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = NumericUtil.BIGDECIMAL_ONE;
            }
            baseQty = qty.multiply(baseExchangeRate1);
            targetQty = NumericUtil.divideBigDecimal(baseQty, baseExchangeRate2, baseQty.scale() + qty.scale() + othermultiUnifInfo.getQtyPrecision());
            map.put("targetQty", targetQty);
            map.put("otherPrecision", String.valueOf(othermultiUnifInfo.getQtyPrecision()));
            map.put("basePrecision", String.valueOf(baseQty.scale()));
        }
        return map;
    }

    public static void requestMutex(Context ctx, String objectId) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = mutexService.requestObjIDForUpdate(objectId);
        if (!flag) {
            throw new InvReservationException(InvReservationException.OBJECT_ISLOCK);
        }
    }

    public static void releaseMutex(Context ctx, String objectId) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = null;
        mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.releaseObjIDForUpdate(objectId);
    }

    public static List<IObjectValue> getSelectEntryCollection(KDTable tblMain) throws BOSException, EASBizException {
        ArrayList<IObjectValue> entries = new ArrayList<IObjectValue>();
        if (tblMain == null || tblMain.getSelectManager() == null) {
            return entries;
        }
        int size = tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            IRow row = null;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = tblMain.getRow(i);
                if (row.getUserObject() == null) continue;
                entries.add((IObjectValue)row.getUserObject());
            }
        }
        return entries;
    }

    public static void succeedSourceBillReservationInfo(Context ctx, IObjectValue model) throws BOSException {
        if (null == model || null == model.getBOSType() || model.get("id") == null) {
            return;
        }
        String scmSrcBillEntryIdFieldName = "sourceBillEntryId";
        IObjectCollection entries = null;
        entries = (IObjectCollection)model.get("entry");
        if (entries == null) {
            entries = (IObjectCollection)model.get("entries");
        }
        if (CollectionUtil.isEmpty(entries)) {
            return;
        }
        IObjectValue entry = null;
        StringBuilder idWhere = new StringBuilder();
        String srcBillEntryId = "";
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.getObject(i);
            if (entry == null || entry.get("sourceBillEntryId") == null) continue;
            srcBillEntryId = entry.get("sourceBillEntryId").toString();
            if (i > 0) {
                idWhere.append(",");
            }
            idWhere.append("'").append(srcBillEntryId).append("'");
        }
        if (StringUtil.isEmpty(srcBillEntryId)) {
            return;
        }
        EntityObjectInfo billEntryEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)new ObjectUuidPK(srcBillEntryId).getObjectType());
        String tableName = billEntryEntity.getTable().getName();
        StringBuilder tempsql = new StringBuilder();
        tempsql.append("select * from ksql_usercolumns  where KSQL_COL_TABNAME = '").append(tableName.toUpperCase());
        tempsql.append("' and KSQL_COL_NAME ='FRESERVATIONBILLOBJECTID'  ");
        try {
            IRowSet temprs = DbUtil.executeQuery((Context)ctx, (String)tempsql.toString());
            if (!temprs.next()) {
                return;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("Select FID, FReservationBillObjectId from ").append(tableName);
        sql.append(" where FID in (").append((CharSequence)idWhere).append(")");
        sql.append(" and FReservationBillObjectId IS NOT NULL");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            while (rs.next()) {
                result.put(rs.getString("FID"), rs.getString("FReservationBillObjectId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!result.isEmpty()) {
            int size2 = entries.size();
            for (int i = 0; i < size2; ++i) {
                entry = entries.getObject(i);
                if (entry == null || entry.get("sourceBillEntryId") == null) continue;
                srcBillEntryId = entry.get("sourceBillEntryId").toString();
                entry.put("reservationBillObjectId", result.get(srcBillEntryId));
            }
        }
    }

    public static List<String> getSelectEntryIDSet(KDTable tblMain, String entryIdColunmName) throws BOSException, EASBizException {
        ArrayList<String> list = new ArrayList<String>();
        if (tblMain == null || tblMain.getSelectManager() == null || StringUtil.isEmpty(entryIdColunmName)) {
            return list;
        }
        if (tblMain.getColumn(entryIdColunmName) == null) {
            return list;
        }
        int size = tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            IRow row = null;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                row = tblMain.getRow(i);
                if (StringUtil.isEmpty(row.getCell(entryIdColunmName).getValue().toString())) continue;
                list.add(row.getCell(entryIdColunmName).getValue().toString());
            }
        }
        return list;
    }

    public static String getBillEntryPropertyName(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        String entryPropertyName = null;
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!SCMUtil.isEntryProperty(billEntity, property)) continue;
            return property.getName();
        }
        return entryPropertyName;
    }

    public static PropertyInfo getBillEntryProperty(EntityObjectInfo billEntity) {
        if (billEntity == null) {
            return null;
        }
        PropertyCollection col = billEntity.getEntityProperties();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return null;
        }
        PropertyInfo property = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            property = col.get(i);
            if (!SCMUtil.isEntryProperty(billEntity, property)) continue;
            return property;
        }
        return null;
    }

    public static boolean isEntryProperty(EntityObjectInfo parent, PropertyInfo property) {
        RelationshipInfo relation;
        return !(parent == null || property == null || !(property instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)property).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || !relation.getClientObject().getFullName().equals(parent.getFullName()) || relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED);
    }

    public static BOTMappingCollection getBotpMappingCollection(Context ctx, BOSObjectType srcType, BOSObjectType destType, String cuId) throws BOSException {
        BOTMappingCollection botMappingCollection = null;
        try {
            IBOTMapping botMapping = null;
            botMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.getSelector().add("*");
            entityViewInfo.getSelector().add("rules.ruleSegments.*");
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem1 = new FilterItemInfo("SRCENTITYNAME", (Object)srcType.toString());
            FilterItemInfo filterItem2 = new FilterItemInfo("DESTENTITYNAME", (Object)destType.toString());
            FilterItemInfo filterItem3 = new FilterItemInfo("extRule.isEffected", (Object)new Integer(1));
            FilterItemInfo filterItem4 = new FilterItemInfo("extRule.transMode", (Object)new Integer(10));
            FilterItemInfo filterItem5 = new FilterItemInfo("extRule.transMode", (Object)new Integer(30));
            FilterItemInfo filterItem6 = new FilterItemInfo("defineSys", (Object)new Integer(20));
            FilterItemInfo filterItem7 = new FilterItemInfo("cu.id", (Object)cuId);
            FilterItemInfo filterItem8 = new FilterItemInfo("cu.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4");
            FilterItemInfo filterItem9 = new FilterItemInfo("isTempSave", (Object)new Integer(2), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem1);
            filter.getFilterItems().add(filterItem2);
            filter.getFilterItems().add(filterItem3);
            filter.getFilterItems().add(filterItem4);
            filter.getFilterItems().add(filterItem5);
            filter.getFilterItems().add(filterItem6);
            filter.getFilterItems().add(filterItem7);
            filter.getFilterItems().add(filterItem8);
            filter.getFilterItems().add(filterItem9);
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and (#6 or #7) and #8");
            entityViewInfo.setFilter(filter);
            SorterItemInfo sii1 = new SorterItemInfo("LASTUPDATETIME");
            sii1.setSortType(SortType.DESCEND);
            SorterItemInfo sii2 = new SorterItemInfo("cu.id");
            sii2.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sii1);
            entityViewInfo.getSorter().add(sii2);
            botMappingCollection = botMapping.getBOTMappingCollection(entityViewInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return botMappingCollection;
    }

    public static void CheckControlQty(Context ctx, String infoID, String table) throws PurOrderException, BOSException {
        BigDecimal zero;
        BigDecimal diffBaseQty = zero = new BigDecimal("0.0");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer errorStr = new StringBuffer();
        Object[] errorArr = new String[1];
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append(" SELECT PR.FUnorderedBaseQty, case when MMU.FMaterialID is null then ");
            sqlBuff.append("decimal(PO.FBaseQty - PR.FUnorderedBaseQty,17,2) else ");
            sqlBuff.append("decimal((PO.FBaseQty - PR.FUnorderedBaseQty)/MMU.FBaseConvsRate,17,8) end as FoverQty, PO.FSeq, ");
            sqlBuff.append(" PO.FSourceBillEntryID, PO.FMaterialName, MMU.FMeasureUnitID,");
            sqlBuff.append(" MMU.FMaterialID, MMU.FBaseConvsRate, MMU.FQtyPrecision, MM.FName_L2 as FUnitName from ").append(table).append(" PO ");
            sqlBuff.append(" inner join T_SM_PURREQUESTENTRY PR on (PR.FID = PO.FSourceBillEntryID and PO.FBaseQty > PR.FUnorderedBaseQty) ");
            sqlBuff.append(" left join T_BD_MULTIMEASUREUNIT MMU on (PO.FUnitID=MMU.FMeasureUnitID and PR.FMaterialID = MMU.FMaterialID)");
            sqlBuff.append(" left join T_BD_MeasureUnit MM on MM.FID = PO.FUnitID");
            sqlBuff.append(" where PR.FIsQuantityUnCtrl = 0 and PO.FSOURCEBILLTYPEID = '").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
            sqlBuff.append("' and PO.FParentId = '").append(infoID).append("'").append(" order by PO.FSeq");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"QtyCheckError", (Context)ctx);
            while (rs.next()) {
                errorStr.append("\n");
                errorStr.append(MessageFormat.format(errorMsg, rs.getString("FSeq"), rs.getString("FMaterialName"), rs.getString("FoverQty"), rs.getString("FUnitName")));
            }
            if (!errorStr.toString().equals("")) {
                errorArr[0] = errorStr.toString();
                throw new PurOrderException(PurOrderException.PURORDER_QTY_NOMATHCH, errorArr);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (CollectionUtil.isEmpty(source)) {
            result.add(source);
            return result;
        }
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            result.add(value);
        }
        return result;
    }

    public static void checkSupplierEnable(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        SupplierInfo supplierInfo = (SupplierInfo)info.get("supplier");
        if (null == supplierInfo) {
            return;
        }
        supplierInfo = null == ctx ? SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId())) : SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierInfo.getId()));
        if (1 != supplierInfo.getUsedStatus().getValue()) {
            info.put("supplier", null);
        }
    }

    public static void getBtnInfo(CoreUI coreUI) {
        int total = coreUI.getUIToolBar().getComponentCount();
        System.out.println("-----------------btns-----------------");
        for (int i = total - 1; i > -1; --i) {
            Component btnCom = coreUI.getUIToolBar().getComponent(i);
            if (!(btnCom instanceof KDWorkButton)) continue;
            KDWorkButton btn = (KDWorkButton)coreUI.getUIToolBar().getComponent(i);
            System.out.println("text:" + btn.getText());
            System.out.println("btn:" + btn.getName());
            System.out.println("action:" + btn.getActionCommand());
        }
        System.out.println("-----------------btns-----------------");
    }
}

