/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.app.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class SysTempTableHelper
implements Serializable {
    private Logger logger = Logger.getLogger(SysTempTableHelper.class);
    private static final long serialVersionUID = 1L;
    private Connection conn = null;
    private TempTablePool pool = null;

    public SysTempTableHelper(Context ctx, Connection con) throws BOSException {
        try {
            this.conn = null == con ? EJBFactory.getConnection((Context)ctx) : con;
            this.pool = TempTablePool.getInstance((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException("pool init error!");
        }
    }

    public Connection getConn() throws BOSException {
        return this.conn;
    }

    public IRowSet executeQuery(String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)statement);
        return jdbcRowSet;
    }

    public IRowSet batchExecuteQuery(String sql, int start, int length) throws BOSException {
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        try {
            return this.getRowSetForRealPage(this.conn, sql, start, length);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public int getRowsCount(String tableName) throws BOSException {
        int n;
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        Statement statement = null;
        ResultSet rs = null;
        int count = 0;
        try {
            String sql = " select count(1) as rowsCount from " + tableName;
            statement = this.conn.createStatement();
            rs = statement.executeQuery(sql);
            if (rs.next()) {
                count = Integer.parseInt(rs.getString("rowsCount"));
            }
            n = count;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return n;
    }

    public void execute(String sql) throws BOSException {
        this.execute(new String[]{sql});
    }

    public void execute(List sql) throws BOSException {
        this.execute(sql.toArray(new String[sql.size()]));
        sql.clear();
    }

    public void execute(String[] sql) throws BOSException {
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            if (!ArrayUtil.isEmpty(sql)) {
                int len = sql.length;
                for (int i = 0; i < len; ++i) {
                    statement.addBatch(sql[i]);
                }
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != statement) {
                try {
                    statement.clearBatch();
                    statement.close();
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void releaseConnection() throws BOSException {
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        try {
            this.conn.close();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void releaseTempTable(String tempTableName) throws BOSException {
        if (null == this.conn) {
            throw new BOSException("conn init error!");
        }
        if (null == this.pool) {
            throw new BOSException("pool init error!");
        }
        if (tempTableName != null) {
            try {
                this.pool.releaseDBSystemTempTable(tempTableName, this.conn);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public String transCreateTable(Context ctx, String sql) {
        if (null != ctx.get((Object)"dbType")) {
            String dbType = (String)ctx.get((Object)"dbType");
            if ((dbType = dbType.toLowerCase()).indexOf("db2") > -1) {
                sql = sql.toLowerCase();
                sql = sql.replaceAll("numeric\\(28,16\\)", "numeric(21,8)");
                sql = sql.replaceAll("numeric\\(19,4\\)", "numeric(17,4)");
            }
        }
        return sql;
    }

    public static String getCreateSQl(String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append("TempTableName");
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql.toString();
    }

    public String createTempTable(Context ctx, String[][] tableFields) throws BOSException {
        if (null == this.pool) {
            throw new BOSException("pool init error!");
        }
        String tempTableName = null;
        String sql = this.transCreateTable(ctx, SysTempTableHelper.getCreateSQl(tableFields));
        try {
            tempTableName = this.pool.createTempTable(sql);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public void createTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        if (null == this.pool) {
            throw new BOSException("pool init error!");
        }
        try {
            this.pool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void analyzeTable(String table) throws BOSException {
        if (null == this.pool) {
            throw new BOSException("pool init error!");
        }
        try {
            this.pool.analyzeTable(this.conn, table);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRowSet getRowSetForRealPage(Connection cn, String sql, int start, int length) throws BOSException {
        JdbcRowSet jdbcRowSet;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int txIsolation = -1;
        try {
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            int top = start + length;
            int dbType = KSqlUtil.getDbType((Connection)cn);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
            }
            sql = this.getLimitForRealPage(dbType, sql, start, top);
            stmt = cn.prepareStatement(sql);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
            }
            rs = stmt.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException sqle) {
            try {
                this.logger.error((Object)("innerGetRowSet() sql: " + sql));
                this.logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowSet() occur error,The RealPageQuery sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    this.logger.error((Object)("innerGetRowSet() sql: " + sql));
                    this.logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return jdbcRowSet;
    }

    private String getLimitForRealPage(int dbType, String sql, int start, int top) throws BOSException, SqlTranslateException {
        if (dbType == 7 || dbType == 8 || dbType == 2) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            return sqlLimit.toString();
        }
        if (dbType == 3) {
            return this.getLimitStringForMSSqlSrv(sql, start, top);
        }
        if (dbType == 1 || dbType == 9) {
            return this.getLimitStringForDB2(sql, start, top);
        }
        return "";
    }

    private String getLimitStringForMSSqlSrv(String sql, int start, int top) {
        StringBuffer Sqllimit = new StringBuffer(sql.length() + 100);
        Sqllimit.append("SELECT * FROM (SELECT TOP ").append(top).append(" * FROM (").append(sql).append(")AS T1 ").append(")AS T2 ");
        return "/*dialect*/" + Sqllimit;
    }

    private String getLimitStringForDB2(String sql, int start, int top) {
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("SELECT * from ( SELECT tableA.*,").append(this.getRowNumberForDB2(sql));
        pagingSelect.append(sql.substring(startOfSelect + 6));
        pagingSelect.append(")AS tableA) as temp_ where rownumber_ ");
        pagingSelect.append("between ");
        pagingSelect.append(start);
        pagingSelect.append("+1 and ");
        pagingSelect.append(top);
        return "/*dialect*/" + pagingSelect;
    }

    private String getRowNumberForDB2(String sql) {
        StringBuffer rownumber = new StringBuffer(50);
        rownumber.append("rownumber() over(");
        rownumber.append(") as rownumber_ FROM (SELECT");
        return rownumber.toString();
    }
}

