/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.app.log;

import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class Log4j2Util {
    public static void addRollFileLogConfig(String appenderName, String loggerName, String fileName, Level logLevel, String fileSize, String fileCount) {
        String instHome = System.getProperty("EAS_INSTANCE_HOME");
        String fileFullName = instHome + "/logs/" + fileName;
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withCharset(Charset.forName("UTF-8")).withConfiguration(config).withPattern("[%d{yyyy-MM-dd HH:mm:ss.SSS} %-6p] %m %n").build();
        SizeBasedTriggeringPolicy sizePolicy = SizeBasedTriggeringPolicy.createPolicy((String)fileSize);
        DefaultRolloverStrategy indexPolicy = DefaultRolloverStrategy.newBuilder().withMax(fileCount).build();
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(appenderName)).setImmediateFlush(true)).withFileName(fileFullName).withFilePattern(fileName + ".%i").setLayout((Layout)layout)).withPolicy((TriggeringPolicy)sizePolicy).withStrategy((RolloverStrategy)indexPolicy).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef ref = AppenderRef.createAppenderRef((String)appenderName, (Level)logLevel, null);
        LoggerConfig logConfig = LoggerConfig.newBuilder().withLoggerName(loggerName).withAdditivity(false).withLevel(logLevel).withRefs(new AppenderRef[]{ref}).withConfig(config).build();
        logConfig.addAppender((Appender)appender, logLevel, null);
        config.addLogger(loggerName, logConfig);
        ctx.updateLoggers(config);
    }
}

