/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.array;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.util.Arrays;
import java.util.Comparator;

public class ArrayUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    private static final int MODEL_OBJECTSTRINGPK = 1;
    private static final int MODEL_OBJECTUUIDPK = 2;

    public static boolean isEmpty(Object[] arr) {
        return null == arr || arr.length == 0;
    }

    public static boolean isEmpty(Object arr) {
        if (null == arr) {
            return false;
        }
        if (arr instanceof int[]) {
            return 0 == ((int[])arr).length;
        }
        if (arr instanceof float[]) {
            return 0 == ((float[])arr).length;
        }
        if (arr instanceof double[]) {
            return 0 == ((double[])arr).length;
        }
        return false;
    }

    public static void main(String[] args) {
        ArrayUtil.isEmpty("");
    }

    public static String getNameSpaceFromSplits(String[] splits, int length) {
        return ArrayUtil.getStringFromArr((Object[])splits, ".", length);
    }

    public static String getKeyIdStr(Object[] ids) {
        return ArrayUtil.getStringFromArr(ids, ",", true);
    }

    public static String getKeyIdListWithOutQuotationMask(Object[] ids) {
        return ArrayUtil.getStringFromArr(ids, ",", false);
    }

    public static String getStringFromArr(Object[] ids) {
        return ArrayUtil.getStringFromArr(ids, ",", true);
    }

    public static String getStringFromArr(Object[] ids, String delim) {
        return ArrayUtil.getStringFromArr(ids, delim, true);
    }

    public static String getStringFromArr(Object[] ids, String delim, boolean hasQuotationMask) {
        if (ArrayUtil.isEmpty(ids) || StringUtil.isEmpty(delim)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(30);
        int len = ids.length;
        for (int i = 0; i < len; ++i) {
            sb.append(StringUtil.connectString(ids[i].toString(), delim, hasQuotationMask));
        }
        if (sb.length() > 0) {
            sb.delete(0, delim.length());
        }
        return sb.toString();
    }

    public static String getStringFromArr(Object[] ids, String delim, int length) {
        if (ArrayUtil.isEmpty(ids) || StringUtil.isEmpty(delim)) {
            return "";
        }
        if (ids.length < length) {
            length = ids.length;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(StringUtil.connectString(ids[i].toString(), delim));
        }
        if (sb.length() > 0) {
            sb.delete(0, delim.length());
        }
        return sb.toString();
    }

    public static String getStringFromArr(ObjectBaseInfo[] vos, String delim, boolean hasQuotationMask) {
        if (ArrayUtil.isEmpty(vos)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int len = vos.length;
        for (int i = 0; i < len; ++i) {
            if (null == vos[i].getId()) continue;
            sb.append(StringUtil.connectString(vos[i].getId().toString(), delim, hasQuotationMask));
        }
        if (sb.length() > 0) {
            sb.delete(0, delim.length());
        }
        return sb.toString();
    }

    public static String[] mergeArray(String[] a1, String[] a2) {
        if (a1 == null || a1.length == 0) {
            return a2 == null ? new String[]{} : a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static boolean isEquals(Object[] a1, Object[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null) {
            return false;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (ArrayUtil.isEquals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2) == 0;
        }
        return o1.equals(o2);
    }

    public static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] dataArr, boolean isAsc) {
        return (DataBaseInfo[])ArrayUtil.sortArray(dataArr, isAsc);
    }

    public static Object[] sortArrayByIntValue(Object[] dataArr, boolean isAsc) {
        return ArrayUtil.sortArray(dataArr, isAsc);
    }

    public static Object[] sortArray(Object[] dataArr, boolean isAsc) {
        if (dataArr == null || dataArr.length < 2) {
            return dataArr;
        }
        Arrays.sort(dataArr, new DataCompare(isAsc));
        return dataArr;
    }

    public static IObjectPK[] convertStringToObjectPK(String[] pkArr) {
        return ArrayUtil.converString2IObjectPK(pkArr, 2);
    }

    public static IObjectPK[] converStringtoIObjectPK(String[] pkArr) {
        return ArrayUtil.converString2IObjectPK(pkArr, 1);
    }

    public static IObjectPK[] converString2IObjectPK(String[] pkArr, int model) {
        IObjectPK[] objArr;
        block5: {
            block4: {
                objArr = new IObjectPK[]{};
                if (1 != model) break block4;
                if (ArrayUtil.isEmpty(pkArr)) {
                    return new ObjectStringPK[0];
                }
                int len = pkArr.length;
                objArr = new ObjectStringPK[len];
                for (int i = 0; i < len; ++i) {
                    objArr[i] = new ObjectStringPK(pkArr[i]);
                }
                break block5;
            }
            if (2 != model) break block5;
            if (ArrayUtil.isEmpty(pkArr)) {
                return new ObjectUuidPK[0];
            }
            int len = pkArr.length;
            objArr = new ObjectUuidPK[len];
            for (int i = 0; i < len; ++i) {
                objArr[i] = new ObjectUuidPK(pkArr[i]);
            }
        }
        return objArr;
    }

    public static ObjectUuidPK[] converString2IObjectPK(String[] pkArr) {
        if (ArrayUtil.isEmpty(pkArr)) {
            return new ObjectUuidPK[0];
        }
        int len = pkArr.length;
        ObjectUuidPK[] objArr = new ObjectUuidPK[len];
        for (int i = 0; i < len; ++i) {
            objArr[i] = new ObjectUuidPK(pkArr[i]);
        }
        return objArr;
    }

    public static boolean containsAllIsNull(Object[] objs) {
        if (objs == null) {
            return true;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            return false;
        }
        return true;
    }

    public static String getInStringFromArray(String[] arr) {
        if (ArrayUtil.isEmpty(arr)) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        for (int i = 0; i < arr.length; ++i) {
            in.append("'").append(arr[i]).append("'");
            if (i == arr.length - 1) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    static class DataCompare
    implements Comparator {
        private boolean isAsc = true;

        public DataCompare(boolean isAsc) {
            this.isAsc = isAsc;
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof DataBaseInfo && arg1 instanceof DataBaseInfo) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
            if (arg0 instanceof Integer && arg1 instanceof Integer) {
                return this.isAsc ? ((Integer)arg0).compareTo((Integer)arg1) : ((Integer)arg1).compareTo((Integer)arg0);
            }
            if (arg0 instanceof String && arg1 instanceof String) {
                return this.isAsc ? Integer.valueOf((String)arg0).compareTo(Integer.valueOf((String)arg1)) : Integer.valueOf((String)arg1).compareTo(Integer.valueOf((String)arg0));
            }
            return 0;
        }
    }
}

