/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.datetime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateTimeUtil {
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    public static final String DATE_FORMATE_PATTERN = "yyyy-MM-dd HH:mm:ss.000";
    public static final String DATE_FORMAT_PATTERN_1 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_2 = "yyyy-MM-dd 00:00:00";
    public static final String strTimeFormat = CtrlFormatUtilities.getDateTimeFormatString();
    public static final String strDateFormat = CtrlFormatUtilities.getDateFormatString();
    private static Map<String, Map<Object, Object>> nationMapCache = new HashMap<String, Map<Object, Object>>();

    public static Timestamp getSCMQueryTime(Date d, String s) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        } else {
            calendar.setTime(new Date());
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static String getFmtDate(Date date, String fmtStr) {
        SimpleDateFormat df = new SimpleDateFormat(fmtStr);
        return null == date ? null : df.format(date);
    }

    public static String getFmtDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return null == date ? null : df.format(date);
    }

    public static String getFmtDateAndTime(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_PATTERN_1);
        return null == date ? null : df.format(date);
    }

    public static Timestamp getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (null == d) {
            calendar.setTime(d);
        }
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date convertStrToDate(String strDate, String parttern) throws ParseException {
        if (strDate != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(parttern);
            return dateFormat.parse(strDate);
        }
        return null;
    }

    public static Date getFirstDayofMonth(Date d) {
        Date date = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        try {
            date = formater.parse(calendar.get(1) + "-" + calendar.get(2) + "-01");
        }
        catch (ParseException pex) {
            pex.printStackTrace();
            date = d;
        }
        return date;
    }

    public static Timestamp getTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        calendar.set(14, 0);
        Timestamp createtime = new Timestamp(calendar.getTimeInMillis());
        return createtime;
    }

    public static Timestamp getTime(String str) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMATE_PATTERN);
        Date date = sdf.parse(str);
        return DateTimeUtil.getTime(date);
    }

    public static Timestamp getTime(long millSeconde) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millSeconde);
        int hour = calendar.get(10);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int mill = calendar.get(14);
        System.out.println("h->" + hour);
        System.out.println("h->" + minute);
        System.out.println("h->" + second);
        System.out.println("h->" + mill);
        return null;
    }

    public static Date addDate(Date curDate, int dateField, int delta) {
        Calendar calender = Calendar.getInstance();
        if (curDate != null) {
            calender.setTime(curDate);
        }
        calender.add(dateField, delta);
        return calender.getTime();
    }

    public static DateFormat getDateFormat() {
        return BOSLocaleUtil.getDateFormat();
    }

    public static DateFormat getTimeFormat() {
        return BOSLocaleUtil.getTimeFormat();
    }

    public static DateFormat getDateTimeFormat() {
        return BOSLocaleUtil.getDateTimeFormat();
    }

    public static String getDateFmtString(Context ctx, String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String key = userId + orgId + ctx.getLocale().toString();
        try {
            if (nationMapCache.containsKey(key)) {
                DateFormat format = (DateFormat)nationMapCache.get(key).get("dateFormat");
                return format.format(dateFormat.parse(date));
            }
            HashMap nationMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userId, orgId, ctx.getLocale().toString());
            DateFormat format = (DateFormat)nationMap.get("dateFormat");
            nationMapCache.put(key, nationMap);
            return format.format(dateFormat.parse(date));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getFormatDate(Date date) {
        if (date == null) {
            return null;
        }
        try {
            return DateTimeUtil.getDateFormat().parse(date.toString());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDateFormatString() {
        String pattern = CtrlFormatUtilities.getDateFormatString();
        if (pattern == null) {
            pattern = strDateFormat;
        }
        return pattern;
    }

    public static String getTimeFormatString() {
        String pattern = CtrlFormatUtilities.getTimeFormatString();
        if (pattern == null) {
            pattern = strTimeFormat;
        }
        return pattern;
    }

    public static String getDateTimeFormatString() {
        String pattern = CtrlFormatUtilities.getDateTimeFormatString();
        if (pattern == null) {
            pattern = strTimeFormat;
        }
        return pattern;
    }
}

