/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.expression;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExpressionParser {
    public static final Pattern OPE_PATTERN = Pattern.compile("[\\+\\-\\*/\\(\\)\\s]+");
    public static final Pattern EXP_PATTERN = Pattern.compile("[\\+\\-\\*/]+");
    public static final Pattern VAR_PATTERN = Pattern.compile("[a-zA-Z_@][a-zA-Z_0-9\\.]*");
    public static final Pattern COM_PATTERN = Pattern.compile("([=><\\s]+)");
    public static final Pattern PRO_PATTERN = Pattern.compile("(\\[[^]]+\\]+)|\\(([^\\)]+)\\)|([^\\.]+)");
    public static final Pattern PAR_PATTERN = Pattern.compile("(#[0-9]+)");
    public static final Pattern FUN_PATTERN = Pattern.compile("([a-zA-Z]+)\\(");

    public String[] splitVariables(String expr) {
        String[] results = OPE_PATTERN.split(expr);
        ArrayList<String> list = new ArrayList<String>(results.length);
        for (int i = 0; i < results.length; ++i) {
            Matcher matcher = VAR_PATTERN.matcher(results[i]);
            if (!matcher.matches()) continue;
            list.add(results[i]);
        }
        if (list.size() < results.length) {
            results = list.toArray(new String[0]);
        }
        return results;
    }

    public FilterInfo parseFilterInfo(String expr) {
        if (expr == null) {
            return null;
        }
        String[] results = COM_PATTERN.split(expr);
        if (results.length < 1) {
            return null;
        }
        Matcher matcher = COM_PATTERN.matcher(expr);
        String operator = null;
        if (matcher.find()) {
            operator = matcher.group();
        }
        if (operator == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(results[0], (Object)results[1], CompareType.getEnum((String)operator)));
        return filterInfo;
    }

    public String[] splitPropertise(String expr) {
        Matcher matcher = PRO_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(1) != null ? matcher.group(1) : matcher.group(0));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public boolean isExpression(String expr) {
        if (expr.indexOf(".(") > 0) {
            return false;
        }
        Matcher matcher = EXP_PATTERN.matcher(expr);
        return matcher.find();
    }

    public String[] splitParameters(String expr) {
        Matcher matcher = PAR_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(1));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public String[] splitOperators(String expr) {
        Matcher matcher = EXP_PATTERN.matcher(expr);
        int start = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (start < expr.length()) {
            if (matcher.find(start)) {
                list.add(matcher.group(0));
                start = matcher.end();
                continue;
            }
            ++start;
        }
        return list.toArray(new String[0]);
    }

    public String parseFunctionName(String expr) {
        if (expr == null || expr.length() == 0) {
            return null;
        }
        Matcher matcher = FUN_PATTERN.matcher(expr);
        if (matcher.find()) {
            String name = matcher.group(0);
            if (name == null || name.length() < 2 || !name.endsWith("(")) {
                return null;
            }
            return name.substring(0, name.length() - 1);
        }
        return null;
    }
}

