/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.filehandle;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public final class ResourceUtil {
    public static final String RES_BATCH_ACTION = "com.kingdee.eas.scm.common.ActionResource";
    public static final String INV_ADD_RES = "com.kingdee.eas.scm.im.inv.InvAddResource";
    private static final String REGEX = "\\{\\d+\\}";
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    public static String getMessageInOrder(String resClassName, String resName, String[] parameters) {
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)ResourceUtil.getLocale());
        int len = parameters.length;
        for (int i = 0; i < len; ++i) {
            message = message.replaceFirst(REGEX, parameters[i]);
        }
        return message;
    }

    public static String getMessage(String resClassName, String resName, String[] parameters) {
        return ResourceUtil.getMessage(null, resClassName, resName, parameters);
    }

    public static String getMessage(Context ctx, String resClassName, String resName, String[] parameters) {
        Locale loc = ctx == null ? ResourceUtil.getLocale() : ctx.getLocale();
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)loc);
        if (null == parameters) {
            return message;
        }
        StringBuffer sb = new StringBuffer();
        int len = parameters.length;
        for (int i = 0; i < len; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    public static String getMessage(String resClassName, String resName) {
        return ResourceUtil.getMessage(resClassName, resName, null);
    }

    private static Locale getLocale() {
        try {
            return SysContext.getSysContext().getLocale();
        }
        catch (Throwable e) {
            return ContextUtils.getLocaleFromEnv();
        }
    }

    public static String getResource(String resClassName, String key, Context ctx) {
        return ResourceUtil.getString(resClassName, key, ctx.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
    }

    public static void main(String[] args) {
    }
}

