/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.numeric;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import java.math.BigDecimal;
import java.util.Date;

public class CurrencyExchangeRateUtil
extends NumericUtil {
    public static final BigDecimal EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE;
    public static final SelectorItemCollection exchangeRateSelectors;
    private static ExchangeRateInfo baseExchangeRateInfo;

    public static final ExchangeRateInfo baseExchangeRateInfo() {
        return baseExchangeRateInfo;
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo company, CurrencyInfo currency) throws EASBizException, BOSException {
        return CurrencyExchangeRateUtil.getExchangeRate(null, company, currency, new Date());
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currency, Date date) throws EASBizException, BOSException {
        if (company == null || null == currency) {
            return CurrencyExchangeRateUtil.baseExchangeRateInfo();
        }
        ExchangeRateInfo exchangeRate = CurrencyExchangeRateUtil.baseExchangeRateInfo();
        BOSUuid currencyID = currency.getId();
        if (currencyID != null) {
            BOSUuid bc;
            if ((company = OrgUnitUtil.readFullCompanyOrgUnitInfo(null, (OrgUnitInfo)company)).getBaseExchangeTable() != null && company.getBaseCurrency() != null) {
                BOSUuid bt = company.getBaseExchangeTable().getId();
                BOSUuid bc2 = company.getBaseCurrency().getId();
                if (bt != null && bc2 != null && !currencyID.toString().equals(bc2.toString())) {
                    IExchangeRate ie = CurrencyExchangeRateUtil.getExechangeRateInstance(ctx);
                    exchangeRate = ie.getExchangeRate((IObjectPK)new ObjectUuidPK(bt), (IObjectPK)new ObjectUuidPK(currencyID), (IObjectPK)new ObjectUuidPK(bc2), date);
                }
            } else if (company.getBaseExchangeTable() != null || company.getBaseCurrency() == null || (bc = company.getBaseCurrency().getId()) == null || !currencyID.toString().equals(bc.toString())) {
                // empty if block
            }
        }
        return exchangeRate;
    }

    private static IExchangeRate getExechangeRateInstance(Context ctx) throws BOSException {
        return ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
    }

    public static ExchangeRateInfo fullExchangeRateInfo(Context ctx, ExchangeRateInfo rate) throws EASBizException, BOSException {
        if (rate == null || rate.getId() == null) {
            return rate;
        }
        IExchangeRate ie = CurrencyExchangeRateUtil.getExechangeRateInstance(ctx);
        return ie.getExchangeRateInfo((IObjectPK)new ObjectStringPK(rate.getId().toString()), exchangeRateSelectors);
    }

    public static boolean isBaseExchangeRate(ExchangeRateInfo rate) {
        BigDecimal convertRate;
        boolean isTrue = false;
        if (rate != null && !CurrencyExchangeRateUtil.isEqualsZero(convertRate = rate.getConvertRate())) {
            isTrue = CurrencyExchangeRateUtil.baseExchangeRateInfo().getConvertRate().compareTo(convertRate) == 0;
        }
        return isTrue;
    }

    public static boolean isBaseCurrency(CompanyOrgUnitInfo company, CurrencyInfo currency) {
        CurrencyInfo baseCurrency;
        boolean isTrue = false;
        if (company != null && currency != null && (baseCurrency = company.getBaseCurrency()) != null && baseCurrency.getId() != null && currency.getId() != null) {
            isTrue = baseCurrency.getId().toString().equals(currency.getId().toString());
        }
        return isTrue;
    }

    public static BigDecimal visitExchangeRate(ExchangeRateInfo info) {
        return info == null ? CurrencyExchangeRateUtil.effectualExchangeRate(null) : CurrencyExchangeRateUtil.effectualExchangeRate(info.getConvertRate());
    }

    public static int visitCovertMode(ExchangeRateInfo info) {
        return info == null ? 0 : info.getConvertMode().getValue();
    }

    public static int visitExchangeRatePrecision(ExchangeRateInfo info) {
        return info == null ? 2 : CurrencyExchangeRateUtil.effectualPrecision(info.getPrecision());
    }

    static {
        baseExchangeRateInfo = null;
        exchangeRateSelectors = new SelectorItemCollection();
        exchangeRateSelectors.add(new SelectorItemInfo("id"));
        exchangeRateSelectors.add(new SelectorItemInfo("number"));
        exchangeRateSelectors.add(new SelectorItemInfo("name"));
        exchangeRateSelectors.add(new SelectorItemInfo("convertRate"));
        exchangeRateSelectors.add(new SelectorItemInfo("exchangeAux.convertMode"));
        exchangeRateSelectors.add(new SelectorItemInfo("exchangeAux.precision"));
        baseExchangeRateInfo = new ExchangeRateInfo();
        baseExchangeRateInfo.setConvertRate(BIGDECIMAL_ONE);
        ExchangeAuxInfo exchangeAux = new ExchangeAuxInfo();
        exchangeAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        exchangeAux.setPrecision(2);
        baseExchangeRateInfo.setExchangeAux(exchangeAux);
    }
}

