/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.numeric;

import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumericUtil {
    public static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0.00");
    public static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1.0");
    public static final BigDecimal BIGDECIMAL_ONEHUNDRED = new BigDecimal("100.0");
    public static final BigDecimal EXCHANGERATE_DEFAULT = BIGDECIMAL_ONE;
    public static final int PRECISION_DEFAUL = 2;
    public static final int BIGDECIMAL_ROUND_MODE = 4;

    public static BigDecimal getNagtiveValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(BIGDECIMAL_ZERO) <= 0) {
            return value;
        }
        return BIGDECIMAL_ZERO.subtract(value);
    }

    public static boolean isGreaterthanZero(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) > 0;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return NumericUtil.isGreaterthanZero(exchangeRate) ? exchangeRate : EXCHANGERATE_DEFAULT;
    }

    public static int effectualPrecision(int scale) {
        return scale >= 0 ? scale : 2;
    }

    public static BigDecimal effectualNumeric(BigDecimal v) {
        return NumericUtil.isEqualsZero(v) ? SysConstant.BIGZERO : v;
    }

    public static boolean isEqualsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    private static int getScale(BigDecimal rateNum) {
        return rateNum.scale() + 2;
    }

    private static BigDecimal getFactRateNum(BigDecimal rateNum) {
        return NumericUtil.getFactRateNum(rateNum, NumericUtil.getScale(rateNum));
    }

    private static BigDecimal getFactRateNum(BigDecimal rateNum, int scale) {
        return rateNum.divide(new BigDecimal("100.00"), scale, 4);
    }

    public static BigDecimal setScale(BigDecimal num, int scale) {
        return num.setScale(scale < 0 ? 2 : scale, 4);
    }

    public static BigDecimal addBigDecimal(BigDecimal addend, BigDecimal augend) {
        return addend.add(augend);
    }

    public static BigDecimal addBigDecimal(BigDecimal addend, BigDecimal augend, int scale) {
        return NumericUtil.setScale(NumericUtil.addBigDecimal(addend, augend), scale);
    }

    public static BigDecimal subtractBigDecimal(BigDecimal minuend, BigDecimal subtractor) {
        return minuend.subtract(subtractor);
    }

    public static BigDecimal subtractBigDecimal(BigDecimal minuend, BigDecimal subtractor, int scale) {
        return NumericUtil.setScale(NumericUtil.subtractBigDecimal(minuend, subtractor), scale);
    }

    public static BigDecimal multiplyBigDecimal(BigDecimal multiplicand, BigDecimal multiplicator) {
        return multiplicand.multiply(multiplicator);
    }

    public static BigDecimal multiplyBigDecimal(BigDecimal multiplicand, BigDecimal multiplicator, int scale) {
        return NumericUtil.setScale(NumericUtil.multiplyBigDecimal(multiplicand, multiplicator), scale);
    }

    public static BigDecimal divideBigDecimal(BigDecimal dividend, BigDecimal divisor, int scale) {
        return dividend.divide(divisor, scale, 4);
    }

    public static BigDecimal calDiscountAmountByPercent(BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discount == null || qty == null || taxPrice == null) {
            return null;
        }
        return NumericUtil.setScale(taxPrice.multiply(qty).multiply(NumericUtil.getFactRateNum(discount)), scale);
    }

    public static BigDecimal calDiscountByPercent(BigDecimal discountAmount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discountAmount == null || qty == null || taxPrice == null) {
            return null;
        }
        BigDecimal discount = null;
        if (qty.compareTo(BIGDECIMAL_ZERO) > 0 && taxPrice.compareTo(BIGDECIMAL_ZERO) > 0) {
            discount = NumericUtil.setScale(taxPrice.multiply(qty).multiply(NumericUtil.getFactRateNum(discount)), scale);
        }
        return discount;
    }

    public static BigDecimal calDiscountByPerunit(BigDecimal discountAmount, BigDecimal qty, BigDecimal taxRate, int scale, boolean isInTax) {
        if (discountAmount == null || qty == null) {
            return null;
        }
        BigDecimal discount = null;
        discount = NumericUtil.divideBigDecimal(discountAmount, qty, scale);
        if (!isInTax) {
            discount = NumericUtil.divideBigDecimal(discount, BIGDECIMAL_ONE.add(NumericUtil.getFactRateNum(taxRate, 10)), scale);
        }
        return discount;
    }

    public static BigDecimal calDiscountAmountByPerunit(BigDecimal discount, BigDecimal qty, BigDecimal taxRate, int scale, boolean isInTax) {
        if (taxRate == null) {
            taxRate = BIGDECIMAL_ZERO;
        }
        if (discount == null || qty == null || taxRate == null) {
            return null;
        }
        BigDecimal discountAmount = null;
        discountAmount = qty.multiply(discount);
        discountAmount = NumericUtil.multiplyBigDecimal(qty, discount, scale);
        if (!isInTax) {
            discountAmount = NumericUtil.multiplyBigDecimal(discountAmount, BIGDECIMAL_ONE.add(NumericUtil.getFactRateNum(taxRate, 10)), scale);
        }
        return discountAmount;
    }

    public static BigDecimal calDiscountAmount(DiscountModeEnum discounMode, BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, BigDecimal taxRate, int scale, boolean isInTax) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return NumericUtil.calDiscountAmountByPercent(discount, qty, taxPrice, scale);
        }
        return NumericUtil.calDiscountAmountByPerunit(discount, qty, taxRate, scale, isInTax);
    }

    public static BigDecimal calDiscountAmountByTaxAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal taxAmount, int scale) {
        return NumericUtil.subtractBigDecimal(NumericUtil.multiplyBigDecimal(NumericUtil.effectualNumeric(taxPrice), NumericUtil.effectualNumeric(qty)), NumericUtil.effectualNumeric(taxAmount), scale);
    }

    public static BigDecimal calDiscountRateByActualTaxPrice(BigDecimal actualTaxPrice, BigDecimal taxPrice, int scale) {
        BigDecimal discountRate = SysConstant.BIGZERO;
        if (!NumericUtil.isEqualsZero(taxPrice)) {
            discountRate = NumericUtil.subtractBigDecimal(BIGDECIMAL_ONE, NumericUtil.divideBigDecimal(NumericUtil.effectualNumeric(actualTaxPrice), NumericUtil.effectualNumeric(taxPrice), 10));
        }
        discountRate = NumericUtil.multiplyBigDecimal(discountRate, SCMConstant.BIGDECIMAL_ONEHUNDRED, scale);
        return discountRate;
    }

    public static BigDecimal calUnitDiscountByActualTaxPrice(BigDecimal actualTaxPrice, BigDecimal taxPrice, int scale) {
        return NumericUtil.subtractBigDecimal(NumericUtil.effectualNumeric(taxPrice), NumericUtil.effectualNumeric(actualTaxPrice), scale);
    }

    public static BigDecimal calTaxPrice(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return null;
        }
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : taxRate;
        return NumericUtil.multiplyBigDecimal(price, BIGDECIMAL_ONE.add(NumericUtil.getFactRateNum(taxRate)), scale);
    }

    public static BigDecimal calActualPriceByPercent(BigDecimal discount, BigDecimal price, int scale) {
        if (price == null) {
            return null;
        }
        discount = discount == null ? BIGDECIMAL_ZERO : discount;
        return NumericUtil.multiplyBigDecimal(price, BIGDECIMAL_ONE.subtract(NumericUtil.getFactRateNum(discount)), scale);
    }

    public static BigDecimal calActualPriceByPerunit(BigDecimal discount, BigDecimal price, BigDecimal taxRate, int scale) {
        if (discount == null && price == null) {
            return null;
        }
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(taxRate);
        discount = discount == null ? BIGDECIMAL_ZERO : discount;
        price = price == null ? BIGDECIMAL_ZERO : price;
        return NumericUtil.subtractBigDecimal(price, NumericUtil.divideBigDecimal(discount, BIGDECIMAL_ONE.add(taxRate), scale + 1), scale);
    }

    public static BigDecimal calActualPrice(DiscountModeEnum discounMode, BigDecimal discount, BigDecimal price, BigDecimal taxRate, int scale) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return NumericUtil.calActualPriceByPercent(discount, price, scale);
        }
        return NumericUtil.calActualPriceByPerunit(discount, price, taxRate, scale);
    }

    public static BigDecimal calActualPrice(BigDecimal amount, BigDecimal qty, int scale) {
        if (NumericUtil.isEqualsZero(qty)) {
            return BIGDECIMAL_ZERO;
        }
        amount = amount == null ? BIGDECIMAL_ZERO : amount;
        return NumericUtil.divideBigDecimal(amount, qty, scale);
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxAmount, BigDecimal qty, int scale) {
        if (NumericUtil.isEqualsZero(qty)) {
            return BIGDECIMAL_ZERO;
        }
        taxAmount = taxAmount == null ? BIGDECIMAL_ZERO : taxAmount;
        return NumericUtil.divideBigDecimal(taxAmount, qty, scale);
    }

    public static BigDecimal calActualTaxPrice(DiscountModeEnum discounMode, BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (discounMode == null || discounMode.getValue() == 0) {
            return NumericUtil.calActualTaxPriceByPercent(taxPrice, discount, scale);
        }
        return NumericUtil.calActualTaxPriceByPerunit(taxPrice, discount, scale);
    }

    public static BigDecimal calActualTaxPriceByPercent(BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (null == taxPrice) {
            return null;
        }
        discount = discount == null ? BIGDECIMAL_ZERO : discount;
        return NumericUtil.multiplyBigDecimal(taxPrice, BIGDECIMAL_ONE.subtract(NumericUtil.getFactRateNum(discount)), scale);
    }

    public static BigDecimal calActualTaxPriceByPerunit(BigDecimal taxPrice, BigDecimal discount, int scale) {
        if (null == taxPrice && null == discount) {
            return null;
        }
        taxPrice = taxPrice == null ? BIGDECIMAL_ZERO : taxPrice;
        discount = discount == null ? BIGDECIMAL_ZERO : discount;
        return NumericUtil.subtractBigDecimal(taxPrice, discount, scale);
    }

    public static BigDecimal calAmount(BigDecimal qty, BigDecimal actualPrice, int scale) {
        if (null == qty || null == actualPrice) {
            return null;
        }
        return NumericUtil.multiplyBigDecimal(qty, actualPrice, scale);
    }

    public static BigDecimal calAmountInTax(BigDecimal taxAmount, BigDecimal tax, int scale) {
        taxAmount = taxAmount == null ? BIGDECIMAL_ZERO : taxAmount;
        tax = tax == null ? BIGDECIMAL_ZERO : tax;
        return NumericUtil.subtractBigDecimal(taxAmount, tax, scale);
    }

    public static BigDecimal calAmountByDiscountPercent(BigDecimal qty, BigDecimal price, BigDecimal discountPercent, int scale) {
        qty = qty == null ? BIGDECIMAL_ZERO : qty;
        price = price == null ? BIGDECIMAL_ZERO : price;
        discountPercent = discountPercent == null ? BIGDECIMAL_ZERO : discountPercent;
        return NumericUtil.multiplyBigDecimal(NumericUtil.multiplyBigDecimal(qty, price), BIGDECIMAL_ONE.subtract(NumericUtil.getFactRateNum(discountPercent)), scale);
    }

    public static BigDecimal calAmountByDiscountAmount(BigDecimal qty, BigDecimal price, BigDecimal discountAmount, int scale) {
        qty = qty == null ? BIGDECIMAL_ZERO : qty;
        price = price == null ? BIGDECIMAL_ZERO : price;
        discountAmount = discountAmount == null ? BIGDECIMAL_ZERO : discountAmount;
        return NumericUtil.multiplyBigDecimal(qty, price.subtract(discountAmount), scale);
    }

    public static BigDecimal calExpenseAmount(BigDecimal qty, BigDecimal unitExpense, int scale) {
        if (null == qty || null == unitExpense) {
            return null;
        }
        return NumericUtil.multiplyBigDecimal(qty, unitExpense, scale);
    }

    public static BigDecimal calTax(BigDecimal amount, BigDecimal taxRate, int scale) {
        if (null == amount || null == taxRate) {
            return null;
        }
        return NumericUtil.multiplyBigDecimal(amount, NumericUtil.getFactRateNum(taxRate), scale);
    }

    public static BigDecimal calTaxWhenPriceExludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        taxAmount = taxAmount == null ? BIGDECIMAL_ZERO : taxAmount;
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(taxRate, scale);
        BigDecimal tax = NumericUtil.setScale(BIGDECIMAL_ZERO, scale);
        if (taxRate.compareTo(BIGDECIMAL_ONE) != 0) {
            tax = NumericUtil.multiplyBigDecimal(taxRate, NumericUtil.divideBigDecimal(taxAmount, BIGDECIMAL_ONE.subtract(taxRate), scale), scale);
        }
        return tax;
    }

    public static BigDecimal calTaxWhenPriceInludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        taxAmount = taxAmount == null ? BIGDECIMAL_ZERO : taxAmount;
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(taxRate, scale);
        return NumericUtil.multiplyBigDecimal(taxAmount, taxRate, scale);
    }

    public static BigDecimal calTotalTaxAmount(BigDecimal amount, BigDecimal tax, int scale) {
        amount = amount == null ? BIGDECIMAL_ZERO : amount;
        tax = tax == null ? BIGDECIMAL_ZERO : tax;
        return NumericUtil.addBigDecimal(amount, tax, scale);
    }

    public static BigDecimal calTotalTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountPercent, int scale) {
        qty = qty == null ? BIGDECIMAL_ZERO : qty;
        taxPrice = taxPrice == null ? BIGDECIMAL_ZERO : taxPrice;
        discountPercent = discountPercent == null ? BIGDECIMAL_ZERO : discountPercent;
        return NumericUtil.multiplyBigDecimal(NumericUtil.multiplyBigDecimal(qty, taxPrice), BIGDECIMAL_ONE.subtract(NumericUtil.getFactRateNum(discountPercent, scale)), scale);
    }

    public static BigDecimal calTotalTaxAmountByDiscountAmount(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountAmount, int scale) {
        qty = qty == null ? BIGDECIMAL_ZERO : qty;
        taxPrice = taxPrice == null ? BIGDECIMAL_ZERO : taxPrice;
        discountAmount = discountAmount == null ? BIGDECIMAL_ZERO : discountAmount;
        return NumericUtil.multiplyBigDecimal(qty, taxPrice.subtract(discountAmount), scale);
    }

    public static BigDecimal calPrepayment(BigDecimal totalTaxAmount, BigDecimal prepaymentRate, int scale) {
        BigDecimal rate = NumericUtil.getFactRateNum(NumericUtil.effectualNumeric(prepaymentRate));
        BigDecimal prepayment = SysConstant.BIGZERO;
        if (!NumericUtil.isEqualsZero(totalTaxAmount) && !NumericUtil.isEqualsZero(rate)) {
            prepayment = NumericUtil.multiplyBigDecimal(NumericUtil.effectualNumeric(rate), NumericUtil.effectualNumeric(totalTaxAmount), scale);
        }
        return prepayment;
    }

    public static BigDecimal calPrepayment(BigDecimal[] totalTaxAmounts, BigDecimal prepaymentRate, int scale) {
        if (prepaymentRate == null || totalTaxAmounts == null || totalTaxAmounts.length == 0) {
            return null;
        }
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        int num = totalTaxAmounts.length;
        for (int i = 0; i < num; ++i) {
            if (totalTaxAmounts[i] == null) continue;
            totalTaxAmount = totalTaxAmount.add(totalTaxAmounts[i]);
        }
        return NumericUtil.multiplyBigDecimal(totalTaxAmount, NumericUtil.getFactRateNum(prepaymentRate), scale);
    }

    public static BigDecimal calPrice(BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        if (null == taxPrice) {
            return null;
        }
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(taxRate, 4);
        return NumericUtil.divideBigDecimal(taxPrice, BIGDECIMAL_ONE.add(taxRate), scale);
    }

    public static BigDecimal calPriceByDiscountAmount(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        if (null == amount || NumericUtil.isEqualsZero(qty)) {
            return null;
        }
        discount = discount == null ? BIGDECIMAL_ZERO : discount;
        return NumericUtil.addBigDecimal(NumericUtil.divideBigDecimal(amount, qty, 10), discount, scale);
    }

    public static BigDecimal calPrice(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        if (null == amount || NumericUtil.isEqualsZero(qty)) {
            return null;
        }
        if (discount != null && discount.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) == 0) {
            discount = BIGDECIMAL_ZERO;
        }
        discount = discount == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(discount);
        return NumericUtil.divideBigDecimal(NumericUtil.divideBigDecimal(amount, qty, scale + 2), BIGDECIMAL_ONE.subtract(discount), scale + 2);
    }

    public static BigDecimal calPriceIsPriceInTax(BigDecimal taxRate, BigDecimal taxPrice, int scale) {
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : NumericUtil.getFactRateNum(taxRate, 4);
        taxPrice = taxPrice == null ? BIGDECIMAL_ZERO : taxPrice;
        return NumericUtil.multiplyBigDecimal(taxPrice, BIGDECIMAL_ONE.subtract(taxRate), scale);
    }

    public static BigDecimal calLocalAmount(BigDecimal amount, BigDecimal exchangerate, int scale) {
        if (null == amount || null == exchangerate) {
            return null;
        }
        return NumericUtil.multiplyBigDecimal(amount, exchangerate, scale);
    }

    public static BigDecimal calcByExchangeRate(ExchangeAuxInfo auxInfo, BigDecimal rate, BigDecimal numeric, int scale) {
        if (auxInfo != null && rate != null && numeric != null) {
            if (auxInfo.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                return NumericUtil.multiplyBigDecimal(numeric, rate, scale);
            }
            return NumericUtil.divideBigDecimal(numeric, rate, scale);
        }
        return numeric;
    }

    public static BigDecimal calTaxPriceByPurchaseCost(BigDecimal price, BigDecimal taxRate, int scale) {
        if (null == price) {
            return null;
        }
        taxRate = taxRate == null ? BIGDECIMAL_ZERO : taxRate;
        return NumericUtil.divideBigDecimal(price, BIGDECIMAL_ONE.subtract(NumericUtil.getFactRateNum(taxRate)), scale);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        String str;
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if ((obj instanceof String || obj instanceof StringBuffer) && (str = obj.toString().trim()).matches("-?\\d+\\.?\\d*")) {
            return new BigDecimal(str);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(new BigDecimal("12.4667457").multiply(new BigDecimal("32.999")));
        System.out.println(new BigDecimal("32.999").multiply(new BigDecimal("12.4667457")));
        System.out.println(new BigDecimal("12.4667457").add(new BigDecimal("32.999")));
        System.out.println(new BigDecimal("32.999999999").add(new BigDecimal("12.4667457")));
        System.out.println(NumericUtil.getFactRateNum(new BigDecimal("32.999")));
        System.out.println(NumericUtil.divideBigDecimal(new BigDecimal("32.999"), new BigDecimal("1.9"), 5));
        System.out.println(NumericUtil.setScale(NumericUtil.divideBigDecimal(new BigDecimal("32.999"), new BigDecimal("1.9"), 5), 5));
        double d = 1.0;
        System.out.println(Double.valueOf(d) instanceof Object);
        System.out.println(new BigDecimal("15.00").multiply(new BigDecimal("10.0")).subtract(new BigDecimal("5.00")).divide(BIGDECIMAL_ONE, 5, 4));
    }

    public static BigDecimal null2Zero(BigDecimal bigDecimal) {
        return null == bigDecimal ? BIGDECIMAL_ZERO : bigDecimal;
    }

    public static String getDecimalFormatString(BigDecimal dec, int scale) {
        if (dec == null) {
            return null;
        }
        dec = dec.setScale(scale, 4);
        DecimalFormat df = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        df.applyPattern(PrecisionUtil.getFmtString(scale));
        return df.format(dec);
    }
}

