/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.numeric;

import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;

public class PrecisionUtil
extends NumericUtil {
    public static final int DEFAULT_PRICISION = 2;
    public static final String FORMAT_STRING_WITHOUT_E = "%r-[=]{#,##0.############}f";
    public static final String FORMAT_STRING_1 = "%r-[]{#,###.###}10.6f";
    public static final String FORMAT_STRING_2 = "%r-[=]{#,##0}f";
    public static final String strTakeOutZeroFormat = "%{0.##########}f";

    private static StringBuffer getFormatString2(int precision) {
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getQtyPrecision(IObjectPK materialPK, IObjectPK unitPK) {
        int precision = 0;
        if (materialPK == null || unitPK == null) {
            throw new IllegalArgumentException();
        }
        IMultiMeasureUnit multiUnit = null;
        try {
            multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            precision = multiUnit.getQtyPrecision(materialPK.toString(), unitPK.toString());
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtil.getResource("GetMultiMeasureUnitError"));
            SysUtil.abort();
        }
        finally {
            if (null != multiUnit) {
                multiUnit = null;
            }
        }
        return precision;
    }

    public static String getCurrencyFormatString(CurrencyInfo currencyInfo) {
        CurrencyInfo info = null;
        if (currencyInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            ICurrency icur = CurrencyFactory.getRemoteInstance();
            info = icur.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()));
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtil.getResource("GetCurrencyError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        int precision = info.getPrecision();
        StringBuffer buffer = PrecisionUtil.getFormatString2(precision);
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getQtyFormatString(IObjectPK materialPK, IObjectPK unitPK) {
        int precision = PrecisionUtil.getQtyPrecision(materialPK, unitPK);
        StringBuffer buffer = PrecisionUtil.getFormatString2(precision);
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getQtyFormatString(MaterialInfo materialInfo) {
        return PrecisionUtil.getQtyFormatString(materialInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getQtyFormatString(MaterialInfo materialInfo, ObjectBaseInfo baseInfo) {
        int precision = 2;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        IMaterial imaterial = null;
        MaterialInfo info = null;
        IMultiMeasureUnit multiUnit = null;
        MultiMeasureUnitInfo multiUnifInfo = null;
        try {
            MaterialPurchasingInfo materialPurchaseInfo;
            imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            if (null == info) {
                String string = "%R-{#,##0.00}f";
                return string;
            }
            multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            if (null == baseInfo) {
                multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), info.getBaseUnit().getId().toString());
            } else if (baseInfo instanceof MaterialPurchasingInfo) {
                materialPurchaseInfo = (MaterialPurchasingInfo)baseInfo;
                multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), materialPurchaseInfo.getUnit().getId().toString());
            } else if (baseInfo instanceof MaterialSalesInfo) {
                materialPurchaseInfo = (MaterialSalesInfo)baseInfo;
                multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), materialPurchaseInfo.getUnit().getId().toString());
            }
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtil.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        finally {
            multiUnifInfo = null;
            multiUnit = null;
            info = null;
            imaterial = null;
        }
        StringBuffer buffer = PrecisionUtil.getFormatString2(precision);
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getPriceFormatString(MaterialInfo materialInfo) {
        MaterialInfo info = null;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtil.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        if (info == null) {
            return "%R-{#,##0.00}f";
        }
        int precision = info.getPricePrecision();
        StringBuffer buffer = PrecisionUtil.getFormatString2(precision);
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("0.");
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static String getFormatStringWithoutMinus(int precision) {
        if (precision == 0) {
            return "%R_{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("0.");
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r_[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    public static BigDecimal formatCurrencyPrecision(BigDecimal money, CurrencyInfo currencyInfo) {
        int scale = currencyInfo == null ? 2 : currencyInfo.getPrecision();
        return PrecisionUtil.setScale(money, scale);
    }

    public static BigDecimal formatQtyPrecision(BigDecimal qty, IObjectPK materialPK, IObjectPK unitPK) {
        int precision = PrecisionUtil.getQtyPrecision(materialPK, unitPK);
        return PrecisionUtil.setScale(qty, precision);
    }

    public static BigDecimal formatQtyPrecision(BigDecimal qty, MaterialInfo materialInfo) {
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        MaterialInfo info = null;
        int precision = 2;
        try {
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            info = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(info.getId().toString(), info.getBaseUnit().getId().toString());
            if (multiUnifInfo != null) {
                precision = multiUnifInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)SCMClientUtil.getResource("GetMaterielError"));
            SysUtil.abort();
        }
        return PrecisionUtil.setScale(qty, precision);
    }

    public static BigDecimal formatPricePrecision(BigDecimal price, MaterialInfo materialInfo) {
        int scale = materialInfo == null ? 2 : materialInfo.getPricePrecision();
        return PrecisionUtil.setScale(price, scale);
    }

    public static int getCurrencyPrecisionByCompany(CompanyOrgUnitInfo company) {
        int scale = 2;
        if (company != null && company.getBaseCurrency() != null) {
            scale = PrecisionUtil.effectualPrecision(company.getBaseCurrency().getPrecision());
        }
        return scale;
    }

    public static StringBuffer fmtTableString(int scale) {
        StringBuffer strassetAmtFormat = new StringBuffer();
        if (scale > 0) {
            strassetAmtFormat.append("%r{#,##0.");
            for (int i = 0; i < scale; ++i) {
                strassetAmtFormat.append("0");
            }
            strassetAmtFormat.append("}f");
        } else {
            strassetAmtFormat.append("%r{#,###}f");
        }
        return strassetAmtFormat;
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";";
        return pattern;
    }

    public static String getFormatPattern(int scale, boolean takeOutZero) {
        if (takeOutZero) {
            String pattern = null;
            String temp = "#############";
            String scaleStr = temp.substring(0, scale);
            pattern = scale == 0 ? "%{#,##0}f" : "%{#,##0." + scaleStr + "}f";
            return pattern;
        }
        return PrecisionUtil.getFormatPattern(scale);
    }

    public static String getFmtString(int scale) {
        if (scale > 0) {
            StringBuffer fmtString = new StringBuffer();
            fmtString.append("#,##0.");
            for (int i = 0; i < scale; ++i) {
                fmtString.append("0");
            }
            return fmtString.toString();
        }
        return "#,###";
    }

    public static String getFormatStringForMultiL(int precision) {
        return CtrlFormatUtilities.getDecimalFormatString();
    }

    public static BigDecimal subNoNeedZero(BigDecimal value) {
        if (value == null) {
            return value;
        }
        return TypeConversionUtils.objToBigDecimal((Object)StringUtil.subZeroAndDot(value.toPlainString()));
    }

    public static String getFormatIntForHideZero() {
        return "[=0]\"\"";
    }
}

