/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.string;

import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class StringUtil {
    public static boolean isNumber(String numStr) {
        if (null == numStr || numStr.trim().length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(numStr);
        }
        catch (Exception nex) {
            Logger.error((Throwable)nex);
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    public static String bigDecimal2String(BigDecimal dec) {
        return null == dec ? null : dec.toPlainString();
    }

    public static LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public static LinkedHashSet getKeyIdList(String ids) {
        return StringUtil.getKeyIdList(ids, ";");
    }

    public static String makeQuestionMark(int count) {
        if (count <= 0) {
            return "";
        }
        StringBuffer returnValue = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            returnValue.append(",?");
        }
        if (returnValue.length() > 0) {
            returnValue.delete(0, 1);
        }
        return returnValue.toString();
    }

    public static String connectString(String id, String delim, boolean hasQuotationMask) {
        return delim + (hasQuotationMask ? "'" + id + "'" : id);
    }

    public static String connectString(String id, String delim) {
        return delim + id;
    }

    public static String subZeroAndDot(String s) {
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }
}

