/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.uicontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMClientUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMGroupClientUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class F7ContextManager {
    private static final String MULTIUNITF7_PATH = "com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery";
    private static final String BASEUNIT_PATH = "com.kingdee.eas.basedata.assistant.app.F7MeasureUnitQuery";
    private int contextType = 0;
    private int f7DisplayMode = 0;
    private Map f7Map = null;
    private Component owner;
    private OrgType mainOrgType;
    private Map diffTypeOrgs = null;
    private Map ctxChgF7Map = null;
    private Context mainOrgContext;
    private KDBizPromptBox[] prmtNeedOrgF7s;
    private KDTActiveCellListener measureUnitListener;
    private KDTActiveCellListener assistPropertyListener;

    public F7ContextManager(Component owner, OrgType mainOrgType) throws EASBizException, BOSException {
        this.init(owner, mainOrgType);
    }

    public F7ContextManager(Component owner, int f7DisplayMode, OrgType mainOrgType) throws EASBizException, BOSException {
        this.init(owner, mainOrgType);
        this.f7DisplayMode = f7DisplayMode;
    }

    public F7ContextManager(Component owner, OrgType mainOrgType, int contextType) throws EASBizException, BOSException {
        this.init(owner, mainOrgType);
        this.contextType = contextType;
    }

    private void init(Component owner, OrgType mainOrgType) throws EASBizException, BOSException {
        this.f7DisplayMode = SCMGroupClientUtil.getF7DisplayMode(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.owner = owner;
        this.mainOrgType = mainOrgType;
        this.f7Map = new HashMap();
        this.diffTypeOrgs = new HashMap();
        this.ctxChgF7Map = new HashMap();
    }

    public KDTActiveCellListener getMeasureUnitListener() {
        return this.measureUnitListener;
    }

    public void registerMeasureUnitF7(final KDTable table, final String colNameMaterial, final String colNameUnit) {
        KDBizPromptBox bizUnitBox;
        if (table.getColumn(colNameUnit).getEditor() == null) {
            bizUnitBox = new KDBizPromptBox();
            bizUnitBox.setEditFormat("$number$");
            bizUnitBox.setDisplayFormat("$number$");
            bizUnitBox.setCommitFormat("$number$");
            bizUnitBox.setEditable(true);
            table.getColumn(colNameUnit).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        }
        bizUnitBox = (KDBizPromptBox)table.getColumn(colNameUnit).getEditor().getComponent();
        bizUnitBox.setQueryInfo(MULTIUNITF7_PATH);
        bizUnitBox.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    SCMClientUtil.setMultiToMeasureUnit((KDBizPromptBox)e.getSource());
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Throwable)exc);
                }
            }
        });
        this.measureUnitListener = new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameUnit).getColumnIndex() == colIndex) {
                        MaterialInfo materialInfo = (MaterialInfo)table.getCell(rowIndex, colNameMaterial).getValue();
                        ICellEditor cellEditor = table.getColumn(colNameUnit).getEditor();
                        KDBizPromptBox bizUnitBox = null;
                        if (cellEditor != null) {
                            bizUnitBox = (KDBizPromptBox)cellEditor.getComponent();
                        }
                        if (bizUnitBox == null) {
                            return;
                        }
                        if (materialInfo != null) {
                            bizUnitBox.setQueryInfo(F7ContextManager.MULTIUNITF7_PATH);
                            SCMClientUtil.setF7MeasureUnit(bizUnitBox, materialInfo.getId().toString());
                        } else {
                            bizUnitBox.setQueryInfo(F7ContextManager.BASEUNIT_PATH);
                        }
                    }
                }
            }
        };
        table.addKDTActiveCellListener(this.measureUnitListener);
    }

    public KDTActiveCellListener getAssistPropertyListener() {
        return this.assistPropertyListener;
    }

    public void registerWarehouseF7(final KDTable table, final String colNameStorageOrgUnit, final String colNameWarehouse) {
        KDBizPromptBox kDBizPromptBoxWarehouse;
        if (table.getColumn(colNameWarehouse).getEditor() == null) {
            kDBizPromptBoxWarehouse = new KDBizPromptBox();
            kDBizPromptBoxWarehouse.setEditable(true);
            kDBizPromptBoxWarehouse.setDisplayFormat("$number$");
            kDBizPromptBoxWarehouse.setEditFormat("$number$");
            kDBizPromptBoxWarehouse.setCommitFormat("$number$");
            table.getColumn(colNameWarehouse).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
        }
        kDBizPromptBoxWarehouse = (KDBizPromptBox)table.getColumn(colNameWarehouse).getEditor().getComponent();
        kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        table.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int rowIndex = table.getSelectManager().getActiveRowIndex();
                if (rowIndex >= 0) {
                    StorageOrgUnitInfo storageOrgUnitInfo;
                    int colIndex = table.getSelectManager().getActiveColumnIndex();
                    if (table.getColumn(colNameWarehouse).getColumnIndex() == colIndex && (storageOrgUnitInfo = (StorageOrgUnitInfo)table.getRow(rowIndex).getCell(colNameStorageOrgUnit).getValue()) != null) {
                        try {
                            ((KDBizPromptBox)table.getColumn(colNameWarehouse).getEditor().getComponent()).setEntityViewInfo(SCMClientUtil.getWarehouseFilter(storageOrgUnitInfo, -1));
                        }
                        catch (EASBizException e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                        catch (BOSException e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                    }
                }
            }
        });
    }

    public void registerWarehouseF7(KDBizPromptBox prmtStorageOrgUnit, KDBizPromptBox prmtWarehouse) {
        prmtWarehouse.setEditable(true);
        prmtWarehouse.setDisplayFormat("$number$");
        prmtWarehouse.setEditFormat("$number$");
        prmtWarehouse.setCommitFormat("$number$");
        prmtWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        if (prmtStorageOrgUnit.getValue() != null) {
            storageOrgUnitInfo = (StorageOrgUnitInfo)prmtStorageOrgUnit.getValue();
        }
        if (storageOrgUnitInfo != null) {
            try {
                prmtWarehouse.setEntityViewInfo(SCMClientUtil.getWarehouseFilter(storageOrgUnitInfo, 1));
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    public void registerContextChangeF7(KDBizPromptBox f7, String mainOrgProperty) {
        this.ctxChgF7Map.put(f7, mainOrgProperty);
    }

    private void changeContext4F7(String ids) {
        if (CollectionUtil.isEmpty(this.ctxChgF7Map)) {
            HashMap viewMap = new HashMap();
            EntityViewInfo viewInfo = null;
            Iterator iter = this.ctxChgF7Map.entrySet().iterator();
            Map.Entry entry = null;
            KDBizPromptBox f7 = null;
            while (iter.hasNext()) {
                entry = iter.next();
                f7 = (KDBizPromptBox)entry.getKey();
                String orgProperty = (String)entry.getValue();
                if (orgProperty == null) continue;
                if (viewMap.containsKey(orgProperty)) {
                    viewInfo = (EntityViewInfo)viewMap.get(orgProperty);
                } else {
                    viewInfo = f7.getEntityViewInfo() == null ? new EntityViewInfo() : f7.getEntityViewInfo();
                    viewInfo.clearExtendedProperties();
                    viewInfo.setFilter(this.getFilterInfo(orgProperty, ids));
                }
                f7.setEntityViewInfo(viewInfo);
            }
        }
    }

    private FilterInfo getFilterInfo(String orgProperty, String ids) {
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtil.isEmpty(ids)) {
            if (ids.indexOf(44) == -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo(orgProperty, (Object)ids, CompareType.INCLUDE));
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("1", (Object)"0"));
        }
        return filterInfo;
    }

    public void setMainOrgContext(Context mainOrgContext) {
        this.mainOrgContext = mainOrgContext;
    }

    public void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgType mainOrgType, OrgType orgType, boolean isRelegable) {
        this.registerBizOrgF7(bizOrgUnitBox, col, null, mainOrgType, orgType);
        if (isRelegable) {
            this.diffTypeOrgs.put(bizOrgUnitBox, mainOrgType);
        }
    }

    public void registerBizOrgF7(KDBizPromptBox bizOrgUnitBox, IColumn col, OrgUnitInfo mainOrg, OrgType mainOrgType, OrgType orgType) {
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$number$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        SCMGroupClientUtil.setBizOrgF7ByType(bizOrgUnitBox, orgType, mainOrgType, true);
        if (mainOrg != null) {
            bizOrgUnitBox.setCurrentMainBizOrgUnit(mainOrg, mainOrgType);
        }
        if (col != null) {
            col.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizOrgUnitBox));
        }
        bizOrgUnitBox.setEditable(true);
    }

    private void initUIMainOrgContext(String orgID) {
        if (this.mainOrgContext == null) {
            this.mainOrgContext = new Context();
        }
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)orgID);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void setPrmtNeedOrgF7s(KDBizPromptBox[] prmtNeedOrgF7s) {
        this.prmtNeedOrgF7s = prmtNeedOrgF7s;
    }

    public int getF7DisplayMode() {
        return this.f7DisplayMode;
    }

    private boolean isOnlySupportQueryViaMaterialNumber() {
        IParamControl ipc = null;
        boolean isOnlySupportQueryViaMaterialNumber = false;
        try {
            ipc = ParamControlFactory.getRemoteInstance();
            String paramvalue = ipc.getParamValue(null, "OnlySupportQueryViaMaterialNumber");
            isOnlySupportQueryViaMaterialNumber = Boolean.valueOf(paramvalue);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return isOnlySupportQueryViaMaterialNumber;
    }
}

