/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.uicontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptParamsUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMGroupClientUtil;
import com.kingdee.util.enums.IntEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Map;

public final class ReportQueryConditionHelper {
    private static final String SPLITER = ";";
    private static final String STORAGE_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\StorageOrgUnitQuery";
    private static final String MUTI_WAREHOUSE_QUERY = "com\\kingdee\\eas\\basedata\\scm\\im\\inv\\app\\F7WarehouseQueryForMultiOrg";
    private static final String WAREHOUSE_QUERY = "com\\kingdee\\eas\\basedata\\scm\\im\\inv\\app\\F7AllWarehouseQuery";
    private static final String MATERIAL_QUERY = "com\\kingdee\\eas\\basedata\\master\\material\\app\\F7MaterialInventoryNoGroupQuery";
    private static final String ASSIST_ATTRIBUTE_QUERY = "com\\kingdee\\eas\\basedata\\master\\material\\app\\F7AsstAttrValueQuery";
    private static final String STORE_TYPE_QUERY = "com\\kingdee\\eas\\basedata\\scm\\im\\inv\\app\\F7StoreTypeQuery";
    private static final String LOCATION_QUERY = "com\\kingdee\\eas\\basedata\\scm\\im\\inv\\app\\F7LocationQuery";
    private static final String MATERIAL_TYPE_QUERY = "com\\kingdee\\eas\\basedata\\master\\material\\app\\F7MaterialGroupQuery";
    private static final String ADMIN_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\AdminOrgUnitQuery";
    private static final String TRANSACTION_TYPE = "com\\kingdee\\eas\\basedata\\scm\\common\\app\\F7TransactionTypeInvQuery";
    private static final String COMPANY_ORG_UNIT_QUERY = "com\\kingdee\\eas\\basedata\\org\\app\\CompanyOrgUnitQuery";
    private static final String ACCOUNT_VIEW_QUERY = "com\\kingdee\\eas\\basedata\\master\\account\\app\\F7AccountViewQuery";

    private ReportQueryConditionHelper() {
    }

    public static void fillCustomerParams(CustomerParams params, Container container) {
        Object[] components = container.getComponents();
        if (ArrayUtil.isEmpty(components)) {
            int len = components.length;
            for (int i = 0; i < len; ++i) {
                if (components[i] instanceof KDLabel) continue;
                if (components[i] instanceof KDDatePicker) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDDatePicker)components[i]);
                    continue;
                }
                if (components[i] instanceof KDTextField) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDTextField)components[i]);
                    continue;
                }
                if (components[i] instanceof KDFormattedTextField) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDFormattedTextField)components[i]);
                    continue;
                }
                if (components[i] instanceof KDCheckBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDCheckBox)components[i]);
                    continue;
                }
                if (components[i] instanceof KDRadioButton) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDRadioButton)components[i]);
                    continue;
                }
                if (components[i] instanceof KDComboBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDComboBox)components[i]);
                    continue;
                }
                if (components[i] instanceof KDSpinner) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDSpinner)components[i]);
                    continue;
                }
                if (components[i] instanceof KDBizPromptBox) {
                    ReportQueryConditionHelper.fillCustomerParams(params, (KDBizPromptBox)components[i]);
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                ReportQueryConditionHelper.fillCustomerParams(params, (Container)components[i]);
            }
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDDatePicker datePicker) {
        if (datePicker.getTimestamp() != null) {
            params.addCustomerParam(datePicker.getName(), datePicker.getTimestamp().toString());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDTextField textField) {
        if (!StringUtil.isEmpty(textField.getText())) {
            params.addCustomerParam(textField.getName(), textField.getText());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDFormattedTextField formattedTextField) {
        if (formattedTextField.getNumberValue() != null) {
            params.addCustomerParam(formattedTextField.getName(), String.valueOf(formattedTextField.getNumberValue().intValue()));
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDCheckBox checkBox) {
        params.putBoolean(checkBox.getName(), checkBox.isSelected());
    }

    private static void fillCustomerParams(CustomerParams params, KDRadioButton radioButton) {
        if (radioButton.isSelected()) {
            params.putBoolean(radioButton.getName(), true);
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDComboBox comboBox) {
        Object cobomItem = comboBox.getSelectedItem();
        if (cobomItem instanceof IntEnum) {
            params.addCustomerParam(comboBox.getName(), String.valueOf(((IntEnum)cobomItem).getValue()));
        } else if (cobomItem instanceof String) {
            params.addCustomerParam(comboBox.getName(), (String)cobomItem);
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDSpinner spinner) {
        Integer precision = spinner.getIntegerVlaue();
        if (precision != null) {
            params.putInt(spinner.getName(), precision.intValue());
        }
    }

    private static void fillCustomerParams(CustomerParams params, KDBizPromptBox promptBox) {
        if (!StringUtil.isEmpty(promptBox.getText())) {
            Object promptValue = promptBox.getData();
            if (promptValue != null) {
                if (promptBox.isEnabledMultiSelection() || promptValue.getClass().isArray()) {
                    params.addCustomerParam(promptBox.getName(), ReportQueryConditionHelper.multiCoreBaseInfoToString((Object[])promptBox.getValue()));
                } else if (promptValue instanceof CoreBaseInfo) {
                    params.addCustomerParam(promptBox.getName(), ((CoreBaseInfo)promptValue).getId().toString());
                } else {
                    params.addCustomerParam(promptBox.getName(), promptBox.getText());
                }
            } else {
                params.addCustomerParam(promptBox.getName(), promptBox.getText());
            }
        }
    }

    private static String multiCoreBaseInfoToString(Object[] objects) {
        StringBuffer buffer = new StringBuffer();
        int len = objects.length;
        for (int i = 0; i < len; ++i) {
            if (!(objects[i] instanceof CoreBaseInfo)) continue;
            buffer.append(((CoreBaseInfo)objects[i]).getId().toString());
            buffer.append(SPLITER);
        }
        return buffer.toString();
    }

    public static void fillComponent(Container container, CustomerParams params) {
        Object[] components = container.getComponents();
        if (!ArrayUtil.isEmpty(components)) {
            int len = components.length;
            for (int i = 0; i < len; ++i) {
                if (components[i] instanceof KDLabel) continue;
                if (components[i] instanceof KDDatePicker) {
                    ReportQueryConditionHelper.fillComponent((KDDatePicker)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDTextField) {
                    ReportQueryConditionHelper.fillComponent((KDTextField)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDFormattedTextField) {
                    ReportQueryConditionHelper.fillComponent((KDFormattedTextField)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDCheckBox) {
                    ReportQueryConditionHelper.fillComponent((KDCheckBox)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDRadioButton) {
                    ReportQueryConditionHelper.fillComponent((KDRadioButton)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDComboBox) {
                    ReportQueryConditionHelper.fillComponent((KDComboBox)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDSpinner) {
                    ReportQueryConditionHelper.fillComponent((KDSpinner)components[i], params);
                    continue;
                }
                if (components[i] instanceof KDBizPromptBox) {
                    ReportQueryConditionHelper.fillComponent((KDBizPromptBox)components[i], params);
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                ReportQueryConditionHelper.fillComponent((Container)components[i], params);
            }
        }
    }

    private static void fillComponent(KDDatePicker datePicker, CustomerParams params) {
        try {
            Timestamp mfgFrom;
            String strTime = params.getCustomerParam(datePicker.getName());
            if (!StringUtil.isEmpty(strTime) && (mfgFrom = Timestamp.valueOf(strTime)) != null) {
                datePicker.setValue((Object)mfgFrom);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void fillComponent(KDTextField textField, CustomerParams params) {
        textField.setText(null);
        if (!StringUtil.isEmpty(params.getCustomerParam(textField.getName()))) {
            textField.setText(params.getCustomerParam(textField.getName()));
        }
    }

    private static void fillComponent(KDFormattedTextField formattedTextField, CustomerParams params) {
        formattedTextField.setText(null);
        try {
            if (!StringUtil.isEmpty(params.getCustomerParam(formattedTextField.getName()))) {
                formattedTextField.setValue((Object)Integer.valueOf(params.getCustomerParam(formattedTextField.getName())));
            }
        }
        catch (NumberFormatException e) {
            System.err.println(e);
        }
    }

    private static void fillComponent(KDCheckBox checkBox, CustomerParams params) {
        checkBox.setSelected(params.getBoolean(checkBox.getName()));
    }

    private static void fillComponent(KDRadioButton radioButton, CustomerParams params) {
        radioButton.setSelected(params.getBoolean(radioButton.getName()));
    }

    private static void fillComponent(KDComboBox comboBox, CustomerParams params) {
        if (!StringUtil.isEmpty(params.getCustomerParam(comboBox.getName()))) {
            String strEnum = params.getCustomerParam(comboBox.getName());
            comboBox.setSelectedIndex(ReportQueryConditionHelper.getIdxOfComboBox(comboBox, strEnum));
        }
    }

    private static void fillComponent(KDSpinner spinner, CustomerParams params) {
        spinner.setValue((Object)new Integer(params.getInt(spinner.getName())));
    }

    private static void fillComponent(KDBizPromptBox promptBox, CustomerParams params) {
        try {
            if (!StringUtil.isEmpty(params.getCustomerParam(promptBox.getName()))) {
                ReportQueryConditionHelper.setValueToPromptBox(promptBox, params.getCustomerParam(promptBox.getName()));
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void setValueToPromptBox(KDBizPromptBox promptBox, String keyParam) {
        IStorageOrgUnit iDataBase = null;
        try {
            if (STORAGE_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    promptBox.setValue((Object)SCMGroupClientUtil.getOrgUnitInfos(keyParam));
                } else {
                    iDataBase = StorageOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
                }
            } else if (COMPANY_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    promptBox.setValue((Object)SCMGroupClientUtil.getOrgUnitInfos(keyParam));
                } else {
                    iDataBase = CompanyOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
                }
            } else if (ADMIN_ORG_UNIT_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection() || keyParam.indexOf(SPLITER) > 0) {
                    IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtil.getKeyIdList(keyParam), CompareType.INCLUDE));
                    view.setFilter(filter);
                    AdminOrgUnitCollection collection = iAdminOrgUnit.getAdminOrgUnitCollection(view);
                    AdminOrgUnitInfo[] results = new AdminOrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    promptBox.setValue((Object)results);
                } else {
                    iDataBase = AdminOrgUnitFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
                }
            } else if (STORE_TYPE_QUERY.equals(promptBox.getQueryInfo())) {
                iDataBase = StoreTypeFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (MATERIAL_QUERY.equals(promptBox.getQueryInfo())) {
                iDataBase = MaterialFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (MATERIAL_TYPE_QUERY.equals(promptBox.getQueryInfo())) {
                iDataBase = MaterialGroupFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (MUTI_WAREHOUSE_QUERY.equals(promptBox.getQueryInfo())) {
                if (promptBox.isEnabledMultiSelection()) {
                    IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtil.getKeyIdList(keyParam), CompareType.INCLUDE));
                    view.setFilter(filter);
                    WarehouseCollection collection = iWarehouse.getWarehouseCollection(view);
                    WarehouseInfo[] results = new WarehouseInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    promptBox.setValue((Object)results);
                } else {
                    IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iWarehouse, keyParam);
                }
            } else if (WAREHOUSE_QUERY.equals(promptBox.getQueryInfo())) {
                iDataBase = WarehouseFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (LOCATION_QUERY.equals(promptBox.getQueryInfo())) {
                iDataBase = LocationFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (ASSIST_ATTRIBUTE_QUERY.equals(promptBox.getQueryInfo())) {
                IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getRemoteInstance();
                if (iAsstAttrValue != null) {
                    promptBox.setValue((Object)iAsstAttrValue.getValue((IObjectPK)new ObjectUuidPK(keyParam)));
                }
            } else if (TRANSACTION_TYPE.equals(promptBox.getQueryInfo())) {
                iDataBase = TransactionTypeFactory.getRemoteInstance();
                ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
            } else if (ACCOUNT_VIEW_QUERY.equals(promptBox.getQueryInfo())) {
                if (!promptBox.isEnabledMultiSelection() && keyParam.indexOf(SPLITER) <= 0) {
                    iDataBase = AccountViewFactory.getRemoteInstance();
                    ReportQueryConditionHelper.setFilterInfoObject(promptBox, (IDataBase)iDataBase, keyParam);
                }
            } else if (ReportQueryConditionHelper.isCoreBaseObjectIDs(keyParam)) {
                promptBox.setData(ReportQueryConditionHelper.getCoreBaseObjectByIDs(keyParam));
            } else {
                promptBox.setText(keyParam);
            }
        }
        catch (BOSException e) {
            System.err.println((Object)e);
        }
        catch (EASBizException e) {
            System.err.println((Object)e);
        }
    }

    private static boolean isCoreBaseObjectIDs(String ids) {
        boolean isCoreBaseObjectIDs = false;
        if (ids != null) {
            isCoreBaseObjectIDs = ids.indexOf(SPLITER) >= 0 ? ReportQueryConditionHelper.isCoreBaseObjectIDs(ids.split(SPLITER)[0]) : BOSUuid.isValid((String)ids, (boolean)true);
        }
        return isCoreBaseObjectIDs;
    }

    private static Object getCoreBaseObjectByIDs(String ids) throws BOSException {
        BOSObjectType bosObjectType = null;
        bosObjectType = ids.indexOf(SPLITER) >= 0 ? BOSUuid.read((String)ids.split(SPLITER)[0]).getType() : BOSUuid.read((String)ids).getType();
        ICoreBase coreBase = (ICoreBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosObjectType, ICoreBase.class);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtil.getKeyIdList(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CoreBaseCollection collection = coreBase.getCollection(view);
        Object[] results = new Object[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            results[i] = collection.getObject(i);
        }
        return results;
    }

    private static int getIdxOfComboBox(KDComboBox cobox, String value) {
        if (null == cobox) {
            return -1;
        }
        Object item = null;
        int count = cobox.getItemCount();
        for (int idx = 0; idx < count; ++idx) {
            item = cobox.getItemAt(idx);
            if (item != null && item instanceof IntEnum) {
                int intEnum = Integer.valueOf(value);
                if (((IntEnum)item).getValue() != intEnum) continue;
                return idx;
            }
            if (item == null || !(item instanceof String) || !value.equals(item)) continue;
            return idx;
        }
        return -1;
    }

    private static void setFilterInfoObject(KDBizPromptBox prmtCompnent, IDataBase dataBase, String id) throws BOSException, EASBizException {
        if (dataBase != null) {
            prmtCompnent.setValue((Object)dataBase.getValue((IObjectPK)new ObjectUuidPK(id)));
        }
    }

    public static CustomerParams getDefaultCustomerParams(boolean useDefaultSolution, CustomerQueryPanel userPanel, CoreUI reportUI, IMetaDataPK queryMetaDataPK) throws Exception {
        CustomerParams cp = null;
        userPanel.getUIContext().clear();
        userPanel.getUIContext().putAll(reportUI.getUIContext());
        if (useDefaultSolution) {
            QuerySolutionInfo solution;
            QueryPanelInfo qpi;
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            String queryName = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery(queryMetaDataPK).getFullName();
            if (iQuery.hasDefaultSolution(reportUI.getMetaDataPK().getFullName(), queryName) && (qpi = (solution = iQuery.getDefaultSolution(reportUI.getClass().getName(), queryName)).getQueryPanelInfo().get(0)) != null) {
                cp = CustomerParams.getCustomerParams2((String)qpi.getCustomerParams());
            }
        }
        return cp;
    }

    public static void initQueryDialog(CustomerQueryPanel userPanel, CommonQueryDialog queryDialog, Map uiContext, IMetaDataPK queryMetaDataPK, String parentClassName, RptParams rptParams, RptParams contextInitRptParams) throws Exception {
        userPanel.loadFields();
        Dimension dd = userPanel.getSize();
        queryDialog.setMaxReturnCountVisible(false);
        queryDialog.setWidth(dd.width);
        queryDialog.setHeight(dd.height);
        queryDialog.addUserPanel((KDPanel)userPanel);
        queryDialog.setOwner((Component)uiContext.get("Owner"));
        queryDialog.setTitle(userPanel.getUITitle());
        queryDialog.setQueryObjectPK(queryMetaDataPK);
        queryDialog.setShowFilter(false);
        queryDialog.setShowSorter(false);
        queryDialog.setParentUIClassName(parentClassName);
        Method m = userPanel.getClass().getMethod("onInit", RptParams.class);
        m.invoke((Object)userPanel, contextInitRptParams);
        userPanel.initLayout();
        if (rptParams != null) {
            userPanel.setCustomerParams(RptParamsUtil.setToCustomerParams((CustomerParams)new CustomerParams(), (Object)rptParams));
        }
    }
}

