/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.uicontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.base.uiframe.client.UINewTab;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.client.AsstAttrPromptBox;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSetMetaData;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;

public abstract class SCMClientUtil {
    private static final String MUTEXT_STARTSCMGUIDE = "Lock_SCMIM_StartSCMGuide_";
    private static final String SECRECY_STRING = "***";
    private static final String OR = " or ";
    private static Map materialPlans = new HashMap();

    public static void setTableColumnsFormat(KDTable kdtEntries, String[] strArray, String strFormat) {
        if (ArrayUtil.isEmpty(strArray)) {
            return;
        }
        int n = strArray.length;
        for (int i = 0; i < n; ++i) {
            if (kdtEntries.getColumn(strArray[i]) == null) continue;
            kdtEntries.getColumn(strArray[i]).getStyleAttributes().setNumberFormat(strFormat);
        }
    }

    public static void setEntriesTableStrLength(KDTable kdtEntries, String[] strArray, int length) {
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(length);
        KDTDefaultCellEditor kdtCellEditor = new KDTDefaultCellEditor((JTextField)txtField);
        int n = strArray.length;
        for (int i = 0; i < n; ++i) {
            kdtEntries.getColumn(strArray[i]).setEditor((ICellEditor)kdtCellEditor);
        }
    }

    public static CompanyOrgUnitInfo getCompanyInfo(BOSUuid souId) throws EASBizException, BOSException {
        if (souId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
        return (CompanyOrgUnitInfo)orgCol.get(0);
    }

    public static String[] filterDistnctID(String[] sourceArray) {
        if (ArrayUtil.isEmpty(sourceArray)) {
            return null;
        }
        HashSet<String> setList = new HashSet<String>();
        int n = sourceArray.length;
        for (int i = 0; i < n; ++i) {
            setList.add(sourceArray[i]);
        }
        String[] billIdlist = new String[setList.size()];
        billIdlist = setList.toArray(billIdlist);
        return billIdlist;
    }

    public static boolean isSelectRow(KDTable kdtTable) {
        KDTSelectManager sm = kdtTable.getSelectManager();
        return null == sm ? false : sm.size() > 0;
    }

    public static String[] getEditUIKDTabelFiledKey(KDTable kdtTable, String filterFieldName, String valueFieldname) {
        ArrayList<String> retList = new ArrayList<String>();
        IRow row = null;
        int size = kdtTable.getRowCount();
        for (int index = 0; index < size; ++index) {
            row = kdtTable.getRow(index);
            if (row.getCell(filterFieldName).getValue() == null || row.getCell(valueFieldname).getValue() == null) continue;
            retList.add(row.getCell(valueFieldname).getValue().toString());
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static boolean getKDTabelSizeIsSame(KDTable kdtTable, String filterFieldName, String valueFieldname) {
        int size = kdtTable.getRowCount();
        IRow row = null;
        for (int index = 0; index < size; ++index) {
            row = kdtTable.getRow(index);
            if (row.getCell(filterFieldName).getValue() == null || row.getCell(valueFieldname).getValue() != null) continue;
            return false;
        }
        return true;
    }

    public static String[] getSelectRowFieldValueForCheckBox(KDTable kdtTable, String fieldname) {
        int blockCount = kdtTable.getRowCount();
        int keyField = kdtTable.getColumnIndex(fieldname);
        ArrayList<String> retList = new ArrayList<String>();
        Object value = null;
        for (int i = 0; i < blockCount; ++i) {
            IRow row = kdtTable.getRow(i);
            value = row.getCell(keyField).getValue();
            Object o = row.getCell("select").getValue();
            if (row.getCell("select") == null || o == null || value == null || value.toString().trim().length() == 0 || !o.toString().equals("true")) continue;
            retList.add(value.toString());
        }
        retList.trimToSize();
        if (retList.size() == 0) {
            return null;
        }
        String[] retStrs = new String[retList.size()];
        retStrs = retList.toArray(retStrs);
        return retStrs;
    }

    public static void setF7MeasureUnit(KDBizPromptBox bizBox, String materialId) {
        if (!StringUtil.isEmpty(materialId)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.appendFilterItem("material.id", (Object)materialId);
            filterInfo.setMaskString("#0");
            viewInfo.setFilter(filterInfo);
            bizBox.setEntityViewInfo(viewInfo);
        }
    }

    public static void setMultiToMeasureUnit(KDBizPromptBox bizBox) throws Exception {
        Object o = bizBox.getData();
        if (o instanceof MultiMeasureUnitInfo) {
            MultiMeasureUnitInfo aMultiMeasureUnitInfo = (MultiMeasureUnitInfo)o;
            bizBox.setValue((Object)SCMClientUtil.convertMultiToMeasureUnit(aMultiMeasureUnitInfo));
        }
    }

    public static MeasureUnitInfo convertMultiToMeasureUnit(MultiMeasureUnitInfo multiMeasureUnitInfo) throws Exception {
        if (multiMeasureUnitInfo != null && multiMeasureUnitInfo.getMeasureUnit() != null) {
            IMeasureUnit iunit = MeasureUnitFactory.getRemoteInstance();
            return iunit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(multiMeasureUnitInfo.getMeasureUnit().getId()));
        }
        return null;
    }

    public static Timestamp getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase("startDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase("endDate")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static void setBizPromptData(KDBizPromptBox bizPrompt, String id) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IObjectValue objVal = DynamicObjectFactory.getRemoteInstance().getValue(pk.getObjectType(), (IObjectPK)pk);
        bizPrompt.setData((Object)objVal);
    }

    public static boolean isPlusData(String str) {
        BigDecimal qty = SCMClientUtil.toBigDecimal(str);
        return NumericUtil.isEqualsZero(qty) || NumericUtil.isGreaterthanZero(qty);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        String str;
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if ((obj instanceof String || obj instanceof StringBuffer) && (str = obj.toString().trim()).matches("-?\\d+\\.?\\d*")) {
            return new BigDecimal(str);
        }
        return null;
    }

    public static void setNecessColorInTable(KDTable table, String colName) {
        SCMClientUtil.setBgColor4Columns(table, new String[]{colName}, true);
    }

    public static void setNecessColorInTable(KDTable table, String[] colNames) {
        SCMClientUtil.setBgColor4Columns(table, colNames, true);
    }

    public static void setNecessColorInTable(KDTable table, String colName, boolean isNecessful) {
        SCMClientUtil.setBgColor4Columns(table, new String[]{colName}, isNecessful);
    }

    public static void setNecessColorInTable(KDTable table, String[] colNames, boolean isNecessful) {
        SCMClientUtil.setBgColor4Columns(table, colNames, isNecessful);
    }

    public static void setNecessColorInTable(KDTable table, int row, String[] colNames, boolean isNecessful) {
        SCMClientUtil.setBgColor4Cells(table.getRow(row), colNames, isNecessful);
    }

    public static void setNecessColorInCells(KDTable table, String colNames, int row, boolean isNecessful) {
        SCMClientUtil.setBgColor4Cells(table.getRow(row), new String[]{colNames}, isNecessful);
    }

    public static void setBgColor4Columns(KDTable table, String[] colNames, boolean isNecessary) {
        Color color = isNecessary ? SCMConstant.NECESSARYCOLOR : Color.white;
        int n = colNames.length;
        for (int i = 0; i < n; ++i) {
            table.getColumn(colNames[i]).getStyleAttributes().setBackground(color);
        }
    }

    public static void setBgColor4Cells(IRow row, String[] colNames, boolean necessary) {
        Color color = necessary ? SCMConstant.NECESSARYCOLOR : Color.white;
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).getStyleAttributes().setBackground(color);
        }
    }

    public static void changeTableColPrecisionByCurrency(CurrencyInfo currInfo, KDFormattedTextField[] fieldNames) {
        int precision = currInfo == null ? 2 : currInfo.getPrecision();
        SCMClientUtil.changeTableColPrecision(precision, fieldNames);
    }

    public static void setAlignRight(KDTable table, String[] colNames) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            table.getColumn(colNames[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public static void changeTableColPrecision(int precision, KDFormattedTextField[] fieldNames) {
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            fieldNames[i].setPrecision(precision);
            fieldNames[i].setRemoveingZeroInDispaly(false);
            fieldNames[i].setSupportedEmpty(true);
        }
    }

    public static PaymentTypeInfo getPaymentTypeInfo(String id) {
        try {
            IPaymentType iPaymentType = PaymentTypeFactory.getRemoteInstance();
            PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(id));
            return paymentTypeInfo;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getBaseUnitQty(KDTable table, int rowIndex, String materialFieldName, String baseUnitFieldName, String unitFieldName, String unitQtyFieldName) throws EASBizException, BOSException {
        BigDecimal orderQty = SCMClientUtil.castToBigDecimalForCell(table, rowIndex, unitQtyFieldName);
        MeasureUnitInfo baseUnitInfo = (MeasureUnitInfo)table.getRow(rowIndex).getCell(baseUnitFieldName).getValue();
        MeasureUnitInfo unitInfo = (MeasureUnitInfo)table.getRow(rowIndex).getCell(unitFieldName).getValue();
        MaterialInfo materialInfo = null;
        Object obj = table.getRow(rowIndex).getCell(materialFieldName).getValue();
        if (obj instanceof MaterialInfo) {
            materialInfo = (MaterialInfo)table.getRow(rowIndex).getCell(materialFieldName).getValue();
        }
        return SCMClientUtil.getBaseUnitQtyFromData(baseUnitInfo, unitInfo, materialInfo, orderQty);
    }

    public static BigDecimal castToBigDecimalForCell(KDTable table, int rowIndex, String fieldName) {
        Object value = table.getRow(rowIndex).getCell(fieldName).getValue();
        BigDecimal numeric = null;
        if (value instanceof BigDecimal) {
            numeric = (BigDecimal)value;
        } else if (StringUtil.isNumber((String)value)) {
            numeric = new BigDecimal((String)value);
        }
        return numeric;
    }

    public static BigDecimal getBaseUnitQtyFromData(MeasureUnitInfo baseUnitInfo, MeasureUnitInfo unitInfo, MaterialInfo materialInfo, BigDecimal orderQty) throws EASBizException, BOSException {
        if (orderQty == null || baseUnitInfo == null || unitInfo == null || materialInfo == null) {
            return null;
        }
        BigDecimal baseUnitQty = SCMUtil.getExchangeQtyForClient(materialInfo.getId().toString(), unitInfo, baseUnitInfo, orderQty);
        return baseUnitQty;
    }

    public static BillTypeInfo getBillType(String pk) throws EASBizException, BOSException {
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)pk));
        return billType;
    }

    public static boolean isTableFocus(KDTable detailTable) {
        if (detailTable.hasFocus()) {
            return true;
        }
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (!(c instanceof Window) && c != null) {
            if ((c = c.getParent()) != detailTable) continue;
            return true;
        }
        return false;
    }

    public static void checkTableNumberNotZero(KDTable table, String[] fields) {
        if (table != null && fields != null && fields.length > 0) {
            StringBuffer msg = new StringBuffer();
            int alertCount = 0;
            boolean isFirstCol = true;
            boolean isFirstRow = true;
            int firstAlertRow = 0;
            int firstAlertCol = 0;
            BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;
            IRow row = null;
            int num = table.getRowCount();
            for (int i = 0; i < num; ++i) {
                row = table.getRow(i);
                isFirstRow = true;
                int n = fields.length;
                for (int j = 0; j < n; ++j) {
                    BigDecimal value = (BigDecimal)row.getCell(fields[j]).getValue();
                    if (value == null || value.compareTo(zero) != 0) continue;
                    if (isFirstCol) {
                        firstAlertRow = i;
                        firstAlertCol = j;
                        isFirstCol = false;
                    } else {
                        msg.append(",");
                    }
                    if (isFirstRow) {
                        msg.append(SCMClientUtil.getResource("EntryFieldCheck_RowNum")).append(i).append(":");
                        isFirstRow = false;
                    }
                    msg.append(table.getHeadRow(0).getCell(fields[j]).getValue().toString());
                    if (alertCount == 5) break;
                }
                if (alertCount == 5) break;
            }
            msg.append(SCMClientUtil.getResource("CantBeZero"));
            if (alertCount > 0) {
                MsgBox.showInfo((String)msg.toString());
                table.getSelectManager().select(firstAlertRow, firstAlertCol);
                SysUtil.abort();
            }
        }
    }

    public static String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";";
        return pattern;
    }

    public static String getFormatPattern(int scale, boolean takeOutZero) {
        if (takeOutZero) {
            String pattern = null;
            String temp = "#############";
            String scaleStr = temp.substring(0, scale);
            pattern = scale == 0 ? "%{0}f" : "%{0." + scaleStr + "}f";
            return pattern;
        }
        return SCMClientUtil.getFormatPattern(scale);
    }

    public static void setF7OrgUnitBizUnit(KDBizPromptBox bizBox) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        bizBox.setEntityViewInfo(viewInfo);
    }

    public static void setAsstAttrInputF7(KDBizPromptBox bizBox, MaterialInfo materialinfo, IUIObject editUI) {
        if (bizBox == null || materialinfo == null || materialinfo.getAssistAttr() == null) {
            return;
        }
        AsstAttrPromptBox box = null;
        box = editUI != null && editUI.getUIContext().get("Owner") != null && editUI.getUIContext().get("Owner") instanceof Frame ? new AsstAttrPromptBox((Frame)editUI.getUIContext().get("Owner"), materialinfo) : new AsstAttrPromptBox(editUI, materialinfo);
        box.AsstAttrTypeID = materialinfo.getAssistAttr().getId().toString();
        bizBox.setSelector((KDPromptSelector)box);
        SCMClientUtil.setAsstAttrF7(bizBox, materialinfo);
    }

    public static void setAsstAttrF7(KDBizPromptBox bizBox, MaterialInfo materialinfo) {
        if (bizBox == null || materialinfo == null || materialinfo.getAssistAttr() == null) {
            return;
        }
        bizBox.setDisplayFormat("$name$");
        bizBox.setEditFormat("$number$");
        bizBox.setCommitFormat("$number$");
        bizBox.setEditable(true);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (materialinfo.isUseAsstAttrRelation()) {
            bizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialAsstAttrValueQuery");
            filter.appendFilterItem("Material.id", (Object)materialinfo.getId().toString());
        } else {
            bizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7AsstAttrValueQuery");
            String typeId = materialinfo.getAssistAttr().getId().toString();
            if (SCMClientUtil.isBasictype(typeId)) {
                filter.appendFilterItem("basictype.id", (Object)typeId);
            } else {
                filter.appendFilterItem("compondingtype.id", (Object)typeId);
            }
        }
        viewInfo.setFilter(filter);
        bizBox.setEntityViewInfo(viewInfo);
    }

    public static boolean isBasictype(String attrTypeID) {
        if (StringUtil.isEmpty(attrTypeID)) {
            return true;
        }
        ObjectUuidPK pk = new ObjectUuidPK(attrTypeID);
        BOSObjectType otype = pk.getObjectType();
        return "D3559FEE".equals(otype.toString());
    }

    public static boolean checkEntryIsBlank(KDTable kdtEntrys, String fieldName) {
        int rows = kdtEntrys.getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                if (kdtEntrys.getRow(i).getCell(fieldName).getValue() == null) continue;
                return false;
            }
        }
        return true;
    }

    public static String getResource(String strKey) {
        if (StringUtil.isEmpty(strKey)) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.scm.common.SCMResource", (String)strKey);
    }

    private static KDBizPromptBox getBizPromptBoxWarehouse(StorageOrgUnitInfo sou, int isStarted) {
        KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
        try {
            if (sou != null) {
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$number$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(SCMClientUtil.getWarehouseFilter(sou, isStarted));
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return kDBizPromptBoxWarehouse;
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, String fieldName, int isStarted) {
        if (sou != null) {
            kdtEntry.getColumn(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)SCMClientUtil.getBizPromptBoxWarehouse(sou, isStarted)));
        }
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, int rowIndex, String fieldName, int isStarted) {
        kdtEntry.getRow(rowIndex).getCell(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)SCMClientUtil.getBizPromptBoxWarehouse(sou, isStarted)));
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou, int isStarted) throws EASBizException, BOSException {
        if (sou != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)isStarted, CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static Method findMethod(Object oPObject, String methodName, Class[] paramClasses) throws InvocationTargetException {
        if (oPObject == null) {
            return null;
        }
        Class<?> oClass = oPObject.getClass();
        Method[] oMethods = oClass.getMethods();
        String sMethodName = null;
        Class<?>[] classes = null;
        boolean foundMethod = true;
        int n = oMethods.length;
        for (int i = 0; i < n; ++i) {
            foundMethod = true;
            sMethodName = oMethods[i].getName();
            if (!sMethodName.equals(methodName) && oMethods[i].getParameterTypes().length != paramClasses.length) continue;
            classes = oMethods[i].getParameterTypes();
            int paramNum = paramClasses.length;
            for (int j = 0; j < paramNum; ++j) {
                if (classes[j].isAssignableFrom(paramClasses[j])) continue;
                foundMethod = false;
                break;
            }
            if (!foundMethod) continue;
            return oMethods[i];
        }
        return null;
    }

    public static boolean checkColInRowSet(String field, IRowSet rowSet) throws SQLException {
        RowSetMetaData rsmd = (RowSetMetaData)rowSet.getMetaData();
        int size = rsmd.getColumnCount();
        for (int i = 1; i < size + 1; ++i) {
            if (!rsmd.getColumnName(i).equals(field)) continue;
            return true;
        }
        return false;
    }

    public static void iniColumnsPrecision(int precision, String[] fields, IRowSet rowSet) throws SQLException {
        int i;
        RowSetMetaData rsmd = (RowSetMetaData)rowSet.getMetaData();
        HashMap<String, String> colMap = new HashMap<String, String>();
        int size = rsmd.getColumnCount();
        for (i = 1; i < size + 1; ++i) {
            colMap.put(rsmd.getColumnName(i), rsmd.getColumnName(i));
        }
        int n = fields.length;
        for (i = 0; i < n; ++i) {
            if (!colMap.containsKey(fields[i])) continue;
            SCMClientUtil.iniColumnsPrecision(precision, fields[i], rowSet);
        }
    }

    public static void iniColumnsPrecision(int precision, String[] fields, IRowSet rowSet, Map colMap) throws SQLException {
        if (fields == null || rowSet == null || colMap == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!colMap.containsKey(fields[i])) continue;
            SCMClientUtil.iniColumnsPrecision(precision, fields[i], rowSet);
        }
    }

    public static Map getColumnsByRowSet(IRowSet rowSet) throws SQLException {
        if (rowSet == null) {
            return null;
        }
        RowSetMetaData rsmd = (RowSetMetaData)rowSet.getMetaData();
        HashMap<String, String> colMap = new HashMap<String, String>();
        int size = rsmd.getColumnCount();
        for (int i = 1; i < size + 1; ++i) {
            colMap.put(rsmd.getColumnName(i), rsmd.getColumnName(i));
        }
        return colMap;
    }

    public static void iniColumnsPrecision(int precision, String field, IRowSet rowSet) throws SQLException {
        BigDecimal temp = rowSet.getBigDecimal(field);
        if (temp != null) {
            temp = temp.setScale(precision, 4);
            rowSet.updateObject(field, (Object)temp);
        }
    }

    public static EntityViewInfo getStorageOrgF7OUFilter() throws Exception {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(iProducer.getFilterInfo());
        return view;
    }

    public static EntityViewInfo getAdminF7OUFilter() throws Exception {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Admin);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(iProducer.getFilterInfo());
        return view;
    }

    public static void setSotrageOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        oufip.getModel().setIsCUFilter(true);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public static void setCompanyOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        oufip.getModel().setIsCUFilter(true);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public static void setPurchaseOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Purchase);
        oufip.getModel().setIsCUFilter(true);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public static void setSaleOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Sale);
        oufip.getModel().setIsCUFilter(true);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public static String getMultiMeasureUnitOQL(String[] matId, String[] mUnitId) {
        StringBuffer oqlWhere = new StringBuffer(64);
        oqlWhere.append("");
        if (ArrayUtil.isEmpty(matId) || ArrayUtil.isEmpty(mUnitId)) {
            oqlWhere.append("material.id = null or measureUnit.id = null");
        }
        int size = matId.length;
        for (int i = 0; i < size; ++i) {
            oqlWhere.append(SCMClientUtil.getMultiMeasureUnitOQL(matId[i], mUnitId[i]));
        }
        if (oqlWhere.length() > 0) {
            if (oqlWhere.indexOf(OR) == 0) {
                oqlWhere.delete(0, OR.length());
            }
            return "select material.id, measureUnit.id, qtyPrecision,baseConvsRate where " + oqlWhere.toString();
        }
        return oqlWhere.toString();
    }

    public static void main(String[] args) {
        String[] arr1 = new String[]{"a", "b", "c"};
        String[] arr2 = new String[]{"a", "b", "c"};
        System.out.println(SCMClientUtil.getMultiMeasureUnitOQL(arr1, arr2));
    }

    public static String getMultiMeasureUnitOQL(String matId, String mUnitId) {
        StringBuffer oqlWhere = new StringBuffer(128);
        if (!StringUtils.isEmpty((String)matId) && !StringUtils.isEmpty((String)mUnitId)) {
            oqlWhere.append(" or (material.id = '").append(matId).append("' and measureUnit.id = '").append(mUnitId).append("')");
        }
        return oqlWhere.toString();
    }

    private static String getMultiMeasureUnitOQL(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) {
        StringBuffer oqlWhere = new StringBuffer(64);
        oqlWhere.append("");
        if (ArrayUtil.isEmpty(materialInfos) || ArrayUtil.isEmpty(measureUnitInfos)) {
            oqlWhere.append("material.id = null or measureUnit.id = null");
        }
        int size = materialInfos.length;
        for (int i = 0; i < size; ++i) {
            oqlWhere.append(SCMClientUtil.getMultiMeasureUnitOQL(materialInfos[i].getId().toString(), measureUnitInfos[i].getId().toString()));
        }
        if (oqlWhere.length() > 0) {
            if (oqlWhere.indexOf(OR) == 0) {
                oqlWhere.delete(0, OR.length());
            }
            return "select material.id, measureUnit.id, qtyPrecision,baseConvsRate where " + oqlWhere.toString();
        }
        return oqlWhere.toString();
    }

    public static HashMap getMultiMeasureUnits(String[] materialId, String[] measureUnitId) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        String oqlWhere = SCMClientUtil.getMultiMeasureUnitOQL(materialId, measureUnitId);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static HashMap getMultiMeasureUnits(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        String oqlWhere = SCMClientUtil.getMultiMeasureUnitOQL(materialInfos, measureUnitInfos);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static FilterInfo getF7FilterInfoByAuthorizedSaleOrg(String orgFieldName) {
        return SCMClientUtil.getF7FilterInfoByAuthorize(orgFieldName, null, OrgType.Sale);
    }

    public static FilterInfo getF7FilterInfoByAuthorizedPurOrg(String orgFieldName) {
        return SCMClientUtil.getF7FilterInfoByAuthorize(orgFieldName, null, OrgType.Purchase);
    }

    public static FilterInfo getF7FilterInfoByAuthorizedCompanyOrg(String orgFieldName) {
        return SCMClientUtil.getF7FilterInfoByAuthorize(orgFieldName, null, OrgType.Company);
    }

    public static FilterInfo getF7FilterInfoByAuthorizeStorageOrg(String orgFieldName, String permissionItem) {
        return SCMClientUtil.getF7FilterInfoByAuthorize(orgFieldName, permissionItem, OrgType.Storage);
    }

    public static FilterInfo getF7FilterInfoByAuthorizeTransportOrg(String orgFieldName, String permissionItem) {
        return SCMClientUtil.getF7FilterInfoByAuthorize(orgFieldName, permissionItem, OrgType.Transport);
    }

    private static FilterInfo getF7FilterInfoByAuthorize(String orgFieldName, String permissionItem, OrgType orgType) {
        NewOrgUnitFilterInfoProducer oufip = null;
        oufip = null == permissionItem ? new NewOrgUnitFilterInfoProducer(orgType) : new NewOrgUnitFilterInfoProducer(orgType, permissionItem);
        FilterInfo filterInfo = oufip.getFilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        int num = filterItems.size();
        for (int i = 0; i < num; ++i) {
            filterItems.get(i).setPropertyName(orgFieldName);
        }
        return filterInfo;
    }

    public static KDBizPromptBox setStockerF7ByStorageOrg(KDBizPromptBox kDBizPromptBoxStocker, CoreUI coreUI, String adminUnitId) throws Exception {
        kDBizPromptBoxStocker.setEditable(true);
        kDBizPromptBoxStocker.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        kDBizPromptBoxStocker.setDisplayFormat("$name$");
        kDBizPromptBoxStocker.setEditFormat("$number$");
        kDBizPromptBoxStocker.setCommitFormat("$number$;$idNum$");
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("0", "1");
        hash.put("DEFAULT_SHOW_ALL", "YES");
        hash.put("IS_SINGLE_SELECT", new Boolean(true));
        hash.put("0", "2");
        if (adminUnitId == null && SysContext.getSysContext().getCurrentAdminUnit() != null) {
            adminUnitId = SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
        }
        if (adminUnitId != null) {
            hash.put("ADMIN_ID", adminUnitId);
        }
        PersonPromptBox box = new PersonPromptBox((IUIObject)coreUI, hash);
        box.showAllAdmin();
        kDBizPromptBoxStocker.setSelector((KDPromptSelector)box);
        return kDBizPromptBoxStocker;
    }

    public static void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType, String permissionItem) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        if (!StringUtil.isEmpty(permissionItem)) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public static boolean isAPRelationSCM(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SCMClientUtil.isRelationSCM(company, "AP_SCM_001");
    }

    public static boolean isARRelationSCM(CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SCMClientUtil.isRelationSCM(company, "AR_SCM_001");
    }

    private static boolean isRelationSCM(CompanyOrgUnitInfo company, String paramNumer) throws EASBizException, BOSException {
        String companyID = company.getId().toString();
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String value = ParamManager.getParamValue(null, (IObjectPK)pk, (String)paramNumer);
        return "true".equalsIgnoreCase(value) || "1".equals(value);
    }

    public static void setSalePersonDisplay(KDBizPromptBox bizprmt) {
        bizprmt.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                KDBizPromptBox bizprmt = (KDBizPromptBox)e.getSource();
                SalePersonInfo salePersonInfo = null;
                salePersonInfo = bizprmt.getValue() instanceof SalePersonInfo ? (SalePersonInfo)bizprmt.getValue() : SCMClientUtil.getSalePersonInfo(bizprmt.getValue().toString());
                if (salePersonInfo == null) {
                    return;
                }
                PersonInfo personInfo = salePersonInfo.getPerson();
                if (personInfo != null && !StringUtil.isEmpty(personInfo.getName()) && !StringUtil.isEmpty(personInfo.getNumber())) {
                    salePersonInfo.setName(personInfo.getName());
                    salePersonInfo.setNumber(personInfo.getNumber());
                    bizprmt.setData((Object)salePersonInfo);
                    return;
                }
                salePersonInfo = SCMClientUtil.getSalePersonInfo(salePersonInfo.getId());
                salePersonInfo.setName(salePersonInfo.getPerson().getName());
                salePersonInfo.setNumber(salePersonInfo.getPerson().getNumber());
                bizprmt.setData((Object)salePersonInfo);
            }
        });
    }

    private static SalePersonInfo getSalePersonInfo(String number) {
        SalePersonCollection collection = null;
        try {
            ISalePerson iSalePerson = SalePersonFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.number", (Object)number, CompareType.EQUALS));
            view.setFilter(filterInfo);
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSelector().add(new SelectorItemInfo("person.id"));
            view.getSelector().add(new SelectorItemInfo("person.name"));
            view.getSelector().add(new SelectorItemInfo("person.number"));
            collection = iSalePerson.getSalePersonCollection(view);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!CollectionUtil.isEmpty(collection)) {
            return collection.get(0);
        }
        return null;
    }

    private static SalePersonInfo getSalePersonInfo(BOSUuid pk) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        try {
            ISalePerson iSalePerson = SalePersonFactory.getRemoteInstance();
            return iSalePerson.getSalePersonInfo((IObjectPK)new ObjectUuidPK(pk), sic);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static int getTableCellPrecision(KDTable table, int rowIndex, String fieldName) {
        int precision = 2;
        IRow row = table.getRow(rowIndex);
        ICellEditor cellEditor = null;
        if (row == null) {
            cellEditor = table.getColumn(fieldName).getEditor();
        } else {
            cellEditor = row.getCell(fieldName).getEditor();
            if (cellEditor == null) {
                cellEditor = table.getColumn(fieldName).getEditor();
            }
        }
        if (cellEditor != null && cellEditor.getComponent() instanceof KDFormattedTextField) {
            precision = ((KDFormattedTextField)cellEditor.getComponent()).getPrecision();
        }
        return precision;
    }

    public static String getAdminOrgUnitInfo(String orgID) throws Exception {
        ObjectUuidPK pk;
        if (StringUtil.isEmpty(orgID)) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo aFullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(orgID)));
        if (aFullOrgUnitInfo.isIsAdminOrgUnit()) {
            return orgID;
        }
        String parentID = aFullOrgUnitInfo.getParent().getId().toString();
        return SCMClientUtil.getAdminOrgUnitInfo(parentID);
    }

    public static void setShortCutKey(CoreUIObject ui, Action action) {
        if (ui == null || action == null) {
            return;
        }
        String strKey = SCMClientUtil.getShortCutKeyString(action.getValue("Name").toString());
        if (!StringUtil.isEmpty(strKey)) {
            KeyStroke ks = KeyStroke.getKeyStroke(strKey);
            IUIWindow wnd = ui.getUIWindow();
            JRootPane jp = null;
            IUIObject uio = null;
            if (wnd instanceof UINewTab) {
                UINewTab uitab = (UINewTab)wnd;
                uio = uitab.getUIObject();
            } else if (wnd instanceof UINewFrame) {
                UINewFrame uiFra = (UINewFrame)wnd;
                uio = uiFra.getUIObject();
            }
            if (uio instanceof JPanel) {
                jp = ((JPanel)uio).getRootPane();
            } else if (wnd instanceof UIModelDialog) {
                UIModelDialog uiDlg = (UIModelDialog)wnd;
                uio = uiDlg.getUIObject();
            }
            if (jp != null) {
                jp.getActionMap().put(strKey, action);
                jp.getInputMap(2).put(ks, strKey);
            }
        }
    }

    public static String getShortCutKeyString(String actionName) {
        if (actionName.equalsIgnoreCase("actionAudit")) {
            return "control shift F10";
        }
        if (actionName.equalsIgnoreCase("actionUnAudit")) {
            return "control shift F11";
        }
        if (actionName.equalsIgnoreCase("actionQueryByMaterial")) {
            return "F12";
        }
        return null;
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String mutextName, String actionName, MutexLockType lockType) {
        MutexParameter param = new MutexParameter();
        param.setRequestId(uuid);
        param.setMutexName(MUTEXT_STARTSCMGUIDE + mutextName);
        param.setActionName(actionName);
        param.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        param.setMutexLockType(lockType);
        return param;
    }

    public static String getPeriodDisplay(int periodYear, int periodNumer) {
        String msg = "";
        if (periodYear > 0) {
            String str = SCMClientUtil.getResource("YEAR_PERIOD_I18N");
            MessageFormat mf = new MessageFormat(str);
            msg = mf.format(new String[]{String.valueOf(periodYear), String.valueOf(periodNumer)});
        }
        return msg;
    }

    public static void checkCurrentBillIsInActiveWorkFlow(String[] keyIDs) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ArrayList<String> idList = new ArrayList<String>();
        int n = keyIDs.length;
        for (int i = 0; i < n; ++i) {
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(keyIDs[i]);
            int m = procInsts.length;
            for (int j = 0; j < m; ++j) {
                if (!"open.running".equals(procInsts[j].getState())) continue;
                instInfo = procInsts[j];
            }
            if (instInfo == null) continue;
            idList.add(keyIDs[i]);
            MsgBox.showInfo((String)SCMClientUtil.getResource("INWFDONTAUDIT"));
            SysUtil.abort();
        }
    }

    public static String[] checkBizObjInWfProcess(String[] bizObjIds) throws WfException, BOSException {
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        return service.checkBizObjInWfProcess(bizObjIds);
    }

    public static boolean checkAllBizObjInWfProcess(String[] bizObjIds) throws WfException, BOSException {
        String[] bizObjInWfProcess = SCMClientUtil.checkBizObjInWfProcess(bizObjIds);
        return bizObjInWfProcess != null && bizObjInWfProcess.length == bizObjIds.length;
    }

    public static void checkCurrentBillIsInActiveWorkFlow(String keyID) throws BOSException {
        String[] keyIDs = new String[]{keyID};
        SCMClientUtil.checkCurrentBillIsInActiveWorkFlow(keyIDs);
    }

    public static void checkBotpRule(BOTMappingInfo botMappingInfo, CoreUI coreUI) {
        if (botMappingInfo == null || botMappingInfo.getExtRule() == null || coreUI == null) {
            return;
        }
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            MsgBox.showInfo((Component)coreUI, (String)(SCMClientUtil.getResource("BOTP_NOT_EFFECTED") + "\uff1a " + botMappingInfo.getName() + botMappingInfo.getAlias()));
            SysUtil.abort();
        }
    }

    public static void checkFunctionPermission(IObjectPK userPK, IObjectPK orgPK, String permissionItem) throws BOSException, EASBizException {
        IPermission iPer = PermissionFactory.getRemoteInstance();
        iPer.checkFunctionPermission(userPK, orgPK, permissionItem);
    }

    public static boolean isPersonInAdminOrgIncludeUnderOrg(PersonInfo person, AdminOrgUnitInfo adminOrg) throws BOSException {
        if (person == null || adminOrg == null) {
            return false;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.longNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)person.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("position.adminOrgUnit.longNumber", (Object)(adminOrg.getLongNumber() + "%"), CompareType.LIKE));
        view.setFilter(filter);
        PositionMemberCollection coll = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(view);
        return !CollectionUtil.isEmpty((AbstractObjectCollection)coll);
    }

    public static boolean hasDestBill(String srcId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcId, CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        BOTRelationCollection collection = BOTRelationFactory.getRemoteInstance().getCollection(viewInfo);
        return !CollectionUtil.isEmpty((AbstractObjectCollection)collection);
    }

    public static String getSrcBotpBill(String destObjectID, String destEntityID) throws BOSException, EASBizException {
        if (StringUtil.isEmpty(destEntityID) || StringUtil.isEmpty(destObjectID)) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"destObjectID Or destEntityID"});
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destEntityID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectID, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        viewInfo.setFilter(filterInfo);
        BOTRelationCollection collection = BOTRelationFactory.getRemoteInstance().getCollection(viewInfo);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
            return collection.get(0).getSrcObjectID();
        }
        return null;
    }

    public static String[] getDistinctArray(String[] allIDs) {
        return SCMClientUtil.filterDistnctID(allIDs);
    }

    public static boolean isRowSelected(int rowIndex, KDTable table) {
        if (rowIndex < 0 || table == null) {
            return false;
        }
        ArrayList selectBlocks = table.getSelectManager().getBlocks();
        if (CollectionUtil.isEmpty(selectBlocks)) {
            return false;
        }
        KDTSelectBlock block = null;
        int n = selectBlocks.size();
        for (int i = 0; i < n; ++i) {
            block = (KDTSelectBlock)selectBlocks.get(i);
            if (block == null || rowIndex < block.getBeginRow() || rowIndex > block.getEndRow()) continue;
            return true;
        }
        return false;
    }

    public static EntityViewInfo getWarehouseMutiOrgFilter(HashSet storageSet, int isStarted) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageSet, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)isStarted, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static void setLocationFilter(StorageOrgUnitInfo sou, WarehouseInfo warehouseInfo, MaterialInfo mi, KDTable kdtEntry, int rowIndex, boolean isOnload) {
        if (warehouseInfo == null) {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            if (!isOnload) {
                LocationInfo defaultloc = SCMClientUtil.getDefaultLocation(sou, mi, warehouseInfo);
                LocationInfo lctation = (LocationInfo)kdtEntry.getRow(rowIndex).getCell("location").getValue();
                if (defaultloc != null) {
                    lctation = defaultloc;
                }
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).setValue((Object)lctation);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).getStyleAttributes().setLocked(false);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
            filterInfo.getFilterItems().add(storageFilterItemInfo);
            viewInfo.setFilter(filterInfo);
            KDBizPromptBox kDBizPromptBoxLocation = new KDBizPromptBox();
            kDBizPromptBoxLocation.setEditable(true);
            kDBizPromptBoxLocation.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7LocationQuery");
            kDBizPromptBoxLocation.setDisplayFormat("$name$");
            kDBizPromptBoxLocation.setEditFormat("$number$");
            kDBizPromptBoxLocation.setCommitFormat("$number$");
            kDBizPromptBoxLocation.setEntityViewInfo(viewInfo);
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxLocation));
        } else {
            if (!isOnload) {
                kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).setValue(null);
            }
            kdtEntry.getRow(rowIndex).getCell(kdtEntry.getColumnIndex("location")).getStyleAttributes().setLocked(true);
        }
    }

    public static LocationInfo getDefaultLocation(StorageOrgUnitInfo sou, MaterialInfo mi, WarehouseInfo wi) {
        try {
            if (sou != null && mi != null && wi != null) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORG.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("MATERIAL.ID", (Object)mi.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE.ID", (Object)wi.getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getRemoteInstance();
                if (imsa != null) {
                    IObjectPK[] pks = imsa.getPKList(filterInfo, null);
                    ILocation il = LocationFactory.getRemoteInstance();
                    int recs = pks.length;
                    if (recs > 0 && imsa.getMaterialStorageAssignInfo(pks[0]).getLocation() != null) {
                        ObjectUuidPK pk = new ObjectUuidPK(imsa.getMaterialStorageAssignInfo(pks[0]).getLocation().getBOSUuid("id"));
                        return il.getLocationInfo((IObjectPK)pk);
                    }
                }
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static final EntityViewInfo getNullView() {
        EntityViewInfo nullView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"NotExist"));
        nullView.setFilter(filter);
        return nullView;
    }

    public static String toPlainString(BigDecimal value, int scale) {
        StringBuffer formatString = new StringBuffer("#0");
        if (scale > 0) {
            formatString.append(".");
        }
        for (int i = 0; i < scale; ++i) {
            formatString.append("0");
        }
        DecimalFormat format = new DecimalFormat(formatString.toString());
        return format.format(value);
    }

    public static EntityViewInfo getWarehouseSOAFilter(CompanyOrgUnitInfo companyInfo, int isStarted) throws EASBizException, BOSException {
        if (companyInfo == null) {
            return null;
        }
        Set storageSet = SCMClientUtil.getStoragesIDSet(companyInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageSet, CompareType.INCLUDE));
        if (isStarted != -1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)isStarted, CompareType.EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    public static Set getStoragesIDSet(CompanyOrgUnitInfo company) {
        HashSet<String> storageSet = new HashSet<String>();
        OrgUnitCollection storageColl = SCMClientUtil.getStorageUnitInfo(company);
        if (storageColl != null) {
            OrgUnitInfo org = null;
            int size = storageColl.size();
            for (int index = 0; index < size; ++index) {
                org = storageColl.get(index);
                storageSet.add(org.getId().toString());
            }
        }
        return storageSet;
    }

    public static OrgUnitCollection getStorageUnitInfo(CompanyOrgUnitInfo cou) {
        try {
            if (cou != null) {
                IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgCol = iUnitRel.getFromUnit(cou.getId().toString(), 1, 4);
                return orgCol;
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void setCellsValue(IRow row, String[] colNames, Object value) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).setValue(value);
        }
    }

    public static void clearCells(IRow row, String[] colNames, boolean isClear) {
        if (isClear) {
            SCMClientUtil.clearCells(row, colNames);
        }
    }

    public static void clearCells(IRow row, String[] colNames) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).setValue(null);
        }
    }

    public static void clearCells(IRow row, int[] colIndexs) {
        int length = colIndexs.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colIndexs[i]).setValue(null);
        }
    }

    public static void lockCells(IRow row, String[] colNames, boolean isLock) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public static void lockCells(IRow row, int[] colNames, boolean isLock) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public static void lockCells(KDTable table, String[] colNames, boolean isLock) {
        IRow row = null;
        int n = table.getRowCount();
        for (int j = 0; j < n; ++j) {
            row = table.getRow(j);
            SCMClientUtil.lockCells(row, colNames, isLock);
        }
    }

    public static void lockColumns(KDTable table, int[] colIdxArray, boolean isLock) {
        for (int colIdx : colIdxArray) {
            table.getColumn(colIdx).getStyleAttributes().setLocked(isLock);
        }
    }

    public static void lockColumns(KDTable table, String[] colNames, boolean isLock) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            table.getColumn(colNames[i]).getStyleAttributes().setLocked(isLock);
        }
    }

    public static void enableComponents(IKDTextComponent[] components, boolean isEnable) {
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            components[i].setEnabled(isEnable);
        }
    }

    public static void enableComponents(Component[] components, boolean isEnable) {
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            components[i].setEnabled(isEnable);
        }
    }

    public static void setComponentsEditable(IKDTextComponent[] components, boolean isEditable) {
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            components[i].setEditable(isEditable);
        }
    }

    public static void setComponentsRequired(IKDTextComponent[] components, boolean isRequired) {
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            components[i].setRequired(isRequired);
        }
    }

    public static void hideColumns(KDTable table, String[] colNames, boolean isHidend) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            table.getColumn(colNames[i]).getStyleAttributes().setHided(isHidend);
        }
    }

    public static void setComponentsVisible(Component[] components, boolean isVisiable) {
        int length = components.length;
        for (int i = 0; i < length; ++i) {
            components[i].setVisible(isVisiable);
        }
    }

    public static AssignCollection getBizBillProcessForPerson(String billID) throws BOSException {
        IAssign iAssign = AssignFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)billID, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        ev.getSelector().add(new SelectorItemInfo("personUserID"));
        AssignCollection assignInfoCollection = iAssign.getCollection(ev);
        return assignInfoCollection;
    }

    public static boolean getCurrentPersonIsWFPrcessList(MultiApproveCollection multiApproveCollection) throws BOSException {
        String currentPersonID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        MultiApproveInfo multiApproveInfo = null;
        if (multiApproveCollection != null) {
            int n = multiApproveCollection.size();
            for (int i = 0; i < n; ++i) {
                multiApproveInfo = multiApproveCollection.get(i);
                if (multiApproveInfo == null || multiApproveInfo.getCreator() == null || !currentPersonID.endsWith(multiApproveInfo.getCreator().getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getCurrentPersonIsWFPrcessList(AssignCollection assignInfoCollection) throws BOSException {
        String currentPersonID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        AssignInfo assignInfo = null;
        if (assignInfoCollection != null) {
            int n = assignInfoCollection.size();
            for (int i = 0; i < n; ++i) {
                assignInfo = assignInfoCollection.get(i);
                if (assignInfo == null || assignInfo.getPersonUserID() == null || !currentPersonID.endsWith(assignInfo.getPersonUserID().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static MultiApproveCollection getBizBillHstProcessForPerson(String billID) throws BOSException {
        IMultiApprove iMultiApprove = MultiApproveFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billid", (Object)billID, CompareType.EQUALS));
        ev.setFilter(filterInfo);
        ev.getSelector().add(new SelectorItemInfo("creator"));
        MultiApproveCollection multiApproveCollection = iMultiApprove.getMultiApproveCollection(ev);
        return multiApproveCollection;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fielName) throws BOSException {
        String result = UIRuleUtil.isNull((Object)table.getRow(rowIndex).getCell(fielName).getValue()) ? "0" : table.getRow(rowIndex).getCell(fielName).getValue();
        return result;
    }

    public static void setFieldDefaultValues(KDTable table, int rowIndex, String[] fielName) throws BOSException {
        int n = fielName.length;
        for (int index = 0; index < n; ++index) {
            if (!UIRuleUtil.isNull((Object)table.getRow(rowIndex).getCell(fielName[index]).getValue())) continue;
            table.getRow(rowIndex).getCell(fielName[index]).setValue((Object)SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    public static void secrecyColumns(String[] secrecyStrFields, String[] secrecyNoStrFields, IRowSet rowSet) throws SQLException {
        int i;
        String temp = SECRECY_STRING;
        int n = secrecyStrFields.length;
        for (i = 0; i < n; ++i) {
            if (StringUtil.isEmpty(temp)) continue;
            rowSet.updateObject(secrecyStrFields[i], (Object)temp);
        }
        n = secrecyNoStrFields.length;
        for (i = 0; i < n; ++i) {
            rowSet.updateNull(secrecyNoStrFields[i]);
        }
    }

    public static Map getMaterialPlanCollec(String[] materialIDS, String[] orgIDs) throws BOSException {
        HashMap matPlans = new HashMap();
        MaterialPlanInfo matPlanInfo = null;
        IMaterialPlan iMatPlan = MaterialPlanFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String mateID = "";
        String orgID = "";
        String mskStr = "";
        String key = "";
        StringBuffer msk = new StringBuffer(64);
        int reaSize = 0;
        boolean isNeedSelect = false;
        int size = materialIDS.length;
        for (int i = 0; i < size; ++i) {
            mateID = materialIDS[i];
            orgID = orgIDs[i];
            if (!materialPlans.containsKey(mateID + orgID)) {
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mateID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
                msk.append("(#").append(2 * reaSize).append(" and #").append(2 * reaSize + 1).append(") or ");
                ++reaSize;
                isNeedSelect = true;
                continue;
            }
            matPlans.put(mateID + orgID, materialPlans.get(mateID + orgID));
        }
        if (msk.length() > 0) {
            mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
            if (reaSize > 1) {
                filter.setMaskString(mskStr);
            }
        }
        view.setFilter(filter);
        if (isNeedSelect) {
            MaterialPlanCollection coll = iMatPlan.getMaterialPlanCollection(view);
            int n = coll.size();
            for (int j = 0; j < n; ++j) {
                matPlanInfo = coll.get(j);
                if (matPlanInfo == null || matPlanInfo.getMaterial() == null || matPlanInfo.getOrgUnit() == null) continue;
                key = matPlanInfo.getMaterial().getId().toString() + matPlanInfo.getOrgUnit().getId().toString();
                materialPlans.put(key, matPlanInfo);
                matPlans.put(key, matPlanInfo);
            }
        }
        return matPlans;
    }

    public static void removePropertyListener(KDTable table) {
        if (table == null) {
            return;
        }
        Object[] listeners = table.getListeners(KDTPropertyChangeListener.class);
        if (!ArrayUtil.isEmpty(listeners)) {
            Object event2 = null;
            for (Object event2 : listeners) {
                if (!(event2 instanceof KDTPropertyChangeListener)) continue;
                table.removeKDTPropertyChangeListener((KDTPropertyChangeListener)event2);
            }
        }
    }

    public static KDBizPromptBox createSimpleF7(String displayFormat, String editFormat, String commitFormat, String queryInfo) {
        KDBizPromptBox prmtBox = new KDBizPromptBox();
        prmtBox.setEditable(true);
        prmtBox.setDisplayFormat(displayFormat);
        prmtBox.setEditFormat(editFormat);
        prmtBox.setCommitFormat(commitFormat);
        prmtBox.setQueryInfo(queryInfo);
        return prmtBox;
    }

    public static KDBizPromptBox createSimpleEntryF7(String queryInfo) {
        return SCMClientUtil.createSimpleF7("$name$", "$number$", "$number$;$mnemonicCode$", queryInfo);
    }

    public static EntityViewInfo createStoreTypeView4StockTransfer() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("storeFlag", (Object)3);
        filter.appendFilterItem("storeFlag", (Object)2);
        filter.appendFilterItem("storeFlag", (Object)1);
        filter.setMaskString("#0 or #1 or #2");
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static void fillCellsZero(IRow row, String[] colNames) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            row.getCell(colNames[i]).setValue((Object)SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    public static void removeColumnScientificNotations(KDTable table, String[] colNames) {
        int length = colNames.length;
        for (int i = 0; i < length; ++i) {
            table.getColumn(colNames[i]).getStyleAttributes().setNumberFormat("%r-[=]{#,##0.############}f");
        }
    }

    public static void setLocationEditable(KDTable table, int rowIndex) {
        SCMClientUtil.setLocationEditable(table, rowIndex, "warehouse", "location");
    }

    public static String getStandardFilterTitle(String uiKey) {
        String value = SCMClientUtil.getResource("ConditionFilter");
        if ("Missing Resource".equals(value)) {
            value = "ConditionFilter";
        }
        return uiKey + " - " + value;
    }

    public static void setLocationEditable(KDTable table, int rowIndex, String warehouse, String location) {
        IRow row = table.getRow(rowIndex);
        WarehouseInfo warehouseInfo = (WarehouseInfo)row.getCell(warehouse).getValue();
        if (warehouseInfo == null) {
            SCMClientUtil.setNecessColorInCells(table, location, rowIndex, false);
            row.getCell(location).getStyleAttributes().setLocked(true);
            return;
        }
        if (warehouseInfo.isHasLocation()) {
            SCMClientUtil.setNecessColorInCells(table, location, rowIndex, true);
            row.getCell(location).getStyleAttributes().setLocked(false);
        } else {
            SCMClientUtil.setNecessColorInCells(table, location, rowIndex, false);
            row.getCell(location).getStyleAttributes().setLocked(true);
        }
    }

    public static void removeChangeListeners(KDSpinner kdSpin) {
        if (kdSpin == null) {
            return;
        }
        ChangeListener[] listeners = kdSpin.getChangeListeners();
        if (listeners != null) {
            int size = listeners.length;
            for (int i = 0; i < size; ++i) {
                kdSpin.removeChangeListener(listeners[i]);
            }
        }
    }

    public static ICellEditor getTextCellEditor(int maxLength) {
        KDTextField txt = new KDTextField();
        txt.setMaxLength(maxLength);
        return new KDTDefaultCellEditor((JTextField)txt);
    }
}

