/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.util.uicontrol;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.MultiOUs4OrgFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.uicontrol.SCMClientUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public final class SCMGroupClientUtil {
    public static OrgUnitCollection getOrgsByRelation(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: 
            case 4: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 2: {
                return iDestOrg == 4 ? iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg) : iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 3: {
                return iDestOrg == 1 ? iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg) : iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 24: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static boolean isAuthoriedForOrg(IObjectPK user, OrgType orgType, IObjectPK orgPK, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = SCMGroupClientUtil.getAuthOrgByPermItem(user, orgType, permItem);
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)result)) {
            int n = result.size();
            for (int i = 0; i < n; ++i) {
                if (!result.get(i).getId().toString().equals(orgPK.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void setBizOrgF7ByType(KDBizPromptBox bizOrgUnitBox, OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (bizOrgUnitBox == null) {
            return;
        }
        String query = null;
        if (orgType.equals((Object)OrgType.Storage)) {
            query = "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            query = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Sale)) {
            query = "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Company)) {
            query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Admin)) {
            query = "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery";
        } else if (OrgType.Quality.equals((Object)orgType)) {
            query = "com.kingdee.eas.basedata.org.app.QualityItemQuery";
        } else {
            return;
        }
        bizOrgUnitBox.setQueryInfo(query);
        if (!orgType.equals((Object)OrgType.Admin)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Integer.valueOf("1"), CompareType.EQUALS));
            view.setFilter(filter);
            bizOrgUnitBox.setEntityViewInfo(view);
        }
        if (!OrgType.Admin.equals((Object)mainOrgType)) {
            bizOrgUnitBox.setFilterInfoProducer(SCMGroupClientUtil.getOrgUnitProducer(orgType, mainOrgType, isSingleMainOrg));
        }
    }

    private static IFilterInfoProducer getOrgUnitProducer(OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (isSingleMainOrg) {
            IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)SCMGroupClientUtil.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
            OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
            producer.getModel().setDoNotUseUserOrgRangeAsFilter();
            return producer;
        }
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getMultiOUs4OrgFilterInfoProducer(null, (OrgType)mainOrgType, (DelegationPartsEnum)SCMGroupClientUtil.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
        MultiOUs4OrgFilterInfoProducer producer = (MultiOUs4OrgFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        return producer;
    }

    private static DelegationPartsEnum getDelegationDirection(OrgType orgType, OrgType mainOrgType) {
        int iMainType = mainOrgType.getValue();
        int iDeleType = orgType.getValue();
        switch (iMainType) {
            case 1: {
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 2: {
                return iDeleType == 4 ? DelegationPartsEnum.THE_FROM_UNIT : DelegationPartsEnum.THE_TO_UNIT;
            }
            case 3: {
                return iDeleType == 1 || iDeleType == 32 ? DelegationPartsEnum.THE_TO_UNIT : DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 4: {
                return DelegationPartsEnum.THE_TO_UNIT;
            }
            case 24: {
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
        }
        return DelegationPartsEnum.THE_TO_UNIT;
    }

    public static FullOrgUnitInfo getOrgUnitInfo(String id) {
        FullOrgUnitInfo orgInfo = null;
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            orgInfo = iOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(id));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return orgInfo;
    }

    public static OrgUnitInfo[] getOrgUnitInfos(String ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)SCMGroupClientUtil.getKeyIdList(ids), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    results[i] = collection.get(i);
                }
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LinkedHashSet getKeyIdList(String ids) {
        return SCMGroupClientUtil.getKeyIdList(ids, ";");
    }

    public static LinkedHashSet getKeyIdList(String ids, String delim) {
        StringTokenizer stk = new StringTokenizer(ids, delim);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        while (stk.hasMoreTokens()) {
            result.add(String.valueOf(stk.nextToken()).trim());
        }
        return result;
    }

    public static String getKeyIdList(ObjectBaseInfo[] vos, String delim) {
        if (ArrayUtil.isEmpty(vos)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int n = vos.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(vos[i].getId().toString());
        }
        return sb.toString();
    }

    public static String getKeyIdList(String[] ids) {
        StringBuffer sb = new StringBuffer();
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(ids[i]).append("'");
        }
        return sb.toString();
    }

    public static OrgUnitInfo getOrgUnitInfoByType(String id, OrgType orgType) {
        ObjectStringPK pk = new ObjectStringPK(id);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    return AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                }
                case 1: {
                    return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk);
                }
                case 2: {
                    return SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)pk);
                }
                case 3: {
                    return PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitInfo((IObjectPK)pk);
                }
                case 4: {
                    return StorageOrgUnitFactory.getRemoteInstance().getStorageOrgUnitInfo((IObjectPK)pk);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static String getMainOrgNullMsg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Purchase)) {
            return SCMClientUtil.getResource("PURORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Storage)) {
            return SCMClientUtil.getResource("STORAGENOTNULL");
        }
        if (orgType.equals((Object)OrgType.Sale)) {
            return SCMClientUtil.getResource("SALEORGNOTNULL");
        }
        if (orgType.equals((Object)OrgType.Company)) {
            return SCMClientUtil.getResource("COMPANYORGNOTNULL");
        }
        return SCMClientUtil.getResource("MAINBIZORGISNULL");
    }

    protected static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        if (queryInfo == null) {
            return entityNames;
        }
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        SubObjectInfo subObjectInfo = null;
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo)) continue;
            SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            entityNames.add(entityName);
        }
        return entityNames;
    }

    protected static String getMainEntityName(String queryName) {
        QueryInfo queryInfo = Util.getQueryInfo((String)queryName);
        ArrayList entityNames = SCMGroupClientUtil.getEntitiyNames(queryInfo);
        if (entityNames.size() > 0) {
            return (String)entityNames.get(0);
        }
        return null;
    }

    public static EntityObjectInfo getEntity(String entityName) {
        return Util.getEntity((String)entityName);
    }

    public static boolean isDiffrent4OrgCollection(OrgUnitCollection collection1, OrgUnitCollection collection2) {
        if (CollectionUtil.isEmpty((AbstractObjectCollection)collection1) && !CollectionUtil.isEmpty((AbstractObjectCollection)collection2)) {
            return true;
        }
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection1) && CollectionUtil.isEmpty((AbstractObjectCollection)collection2)) {
            return true;
        }
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection1) && !CollectionUtil.isEmpty((AbstractObjectCollection)collection2)) {
            int i;
            if (collection1.size() != collection2.size()) {
                return true;
            }
            ArrayList<String> list = new ArrayList<String>();
            int n = collection1.size();
            for (i = 0; i < n; ++i) {
                list.add(collection1.get(i).getId().toString());
            }
            n = collection2.size();
            for (i = 0; i < n; ++i) {
                if (list.contains(collection2.get(i).getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDiffrent(Object arg0, Object arg1) {
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            return true;
        }
        if (arg0 != null && arg1 != null) {
            if (arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo) {
                return !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString());
            }
            return !arg0.equals(arg1);
        }
        return false;
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parameterTypes) throws Exception {
        Method method = null;
        Class clz = clazz;
        if (clazz == null || StringUtil.isEmpty((String)methodName)) {
            return null;
        }
        while (clz != null && method == null) {
            try {
                method = clz.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException nsme) {
                clz = clz.getSuperclass();
            }
        }
        return method;
    }

    public static int getF7DisplayMode(String cuId) throws BOSException, EASBizException {
        try {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(cuId);
            return Integer.valueOf(ipc.getParamValue((IObjectPK)pk, "F7DISPLAYMODE"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static void isCurrentMainOrgChanged(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext) {
        FilterInfo bizFilterInfo;
        boolean isHasPorperty = false;
        EntityViewInfo view = null;
        view = promptBox.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if ((bizFilterInfo = SCMGroupClientUtil.getBizFilterInfo(promptBox, propertyOfBizOrg, mainOrgContext)) == null) {
            return;
        }
        FilterItemCollection filterItemCollection = view.getFilter().getFilterItems();
        if (view != null && view.getFilter() != null && !CollectionUtil.isEmpty((AbstractObjectCollection)filterItemCollection)) {
            FilterItemInfo itemInfo = null;
            int n = filterItemCollection.size();
            for (int i = 0; i < n; ++i) {
                itemInfo = filterItemCollection.get(i);
                if (StringUtil.isEmpty((String)propertyOfBizOrg) || itemInfo.getPropertyName().indexOf(propertyOfBizOrg) < 0) continue;
                filterItemCollection.set(i, bizFilterInfo.getFilterItems().get(0));
                isHasPorperty = true;
            }
        }
        try {
            if (bizFilterInfo != null && !isHasPorperty) {
                if (view.getFilter() != null && filterItemCollection.size() > 0) {
                    view.getFilter().mergeFilter(bizFilterInfo, "and");
                } else {
                    view.setFilter(bizFilterInfo);
                }
            }
            promptBox.setEntityViewInfo(view);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private static FilterInfo getBizFilterInfo(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext) {
        FilterInfo bizFilterInfo = null;
        if (promptBox.getCurrentMainBizOrgUnit() != null) {
            OrgUnitInfo orgUnitInfo = promptBox.getCurrentMainBizOrgUnit();
            String cuId = null;
            CtrlUnitInfo cu = orgUnitInfo.getCU();
            if (cu == null && mainOrgContext != null) {
                cu = (CtrlUnitInfo)mainOrgContext.get((Object)OrgType.ControlUnit);
            }
            if (cu == null) {
                try {
                    IFullOrgUnit iFullOrg = FullOrgUnitFactory.getRemoteInstance();
                    orgUnitInfo = iFullOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                cuId = cu.getId().toString();
            }
            if (!StringUtil.isEmpty((String)propertyOfBizOrg)) {
                bizFilterInfo = new FilterInfo();
                if (cuId != null && !orgUnitInfo.getId().toString().equals(cuId)) {
                    StringBuffer orgIdBuffer = new StringBuffer();
                    orgIdBuffer.append(orgUnitInfo.getId().toString());
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
                } else {
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        } else if (promptBox.getMainBizOrgs() != null) {
            OrgUnitCollection collection = promptBox.getMainBizOrgs();
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection)) {
                StringBuffer orgIdBuffer = new StringBuffer();
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        orgIdBuffer.append(",");
                    }
                    orgIdBuffer.append(collection.get(i).getId().toString());
                }
                if (!StringUtil.isEmpty((String)propertyOfBizOrg)) {
                    bizFilterInfo = new FilterInfo();
                    bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
                }
            } else {
                bizFilterInfo = new FilterInfo();
                bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, null, CompareType.EQUALS));
            }
        } else {
            bizFilterInfo = new FilterInfo();
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        return bizFilterInfo;
    }

    public static void setApproved4SupplierF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        bizPromptBox.setEntityViewInfo(SCMGroupClientUtil.getApproved4SupplierF7Filter(orgType));
    }

    public static EntityViewInfo getApproved4SupplierF7Filter(OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Purchase)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierPurchasing.IsFreezeMakeOrder", (Object)false, CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("supplierCompany.isFreezePayment", (Object)false, CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        return view;
    }

    public static void setApproved4CustomerF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        bizPromptBox.setEntityViewInfo(SCMGroupClientUtil.getApproved4CustomerF7Filter(orgType));
    }

    public static EntityViewInfo getApproved4CustomerF7Filter(OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Sale)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.isFreezeOrder", (Object)false, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.isFreezeDelivery", (Object)false, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("customerSale.usingStatus", (Object)Integer.valueOf("0"), CompareType.EQUALS));
        }
        if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)0, CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        return view;
    }

    public static void setApproved4MaterialF7(KDBizPromptBox bizPromptBox, OrgType orgType) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        if (orgType.equals((Object)OrgType.Sale)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Sales.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Purchasing.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Storage)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        } else if (orgType.equals((Object)OrgType.Company)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)String.valueOf(com.kingdee.eas.basedata.master.material.UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        }
        view.setFilter(filterInfo);
        bizPromptBox.setEntityViewInfo(view);
    }

    public static void addFilter4EV(EntityViewInfo viewInfo, FilterItemInfo itemInfo) {
        FilterInfo filter = viewInfo.getFilter();
        String key = itemInfo.getPropertyName();
        FilterItemInfo item = null;
        int n = filter.getFilterItems().size();
        for (int i = 0; i < n; ++i) {
            item = filter.getFilterItems().get(i);
            if (!item.getPropertyName().equalsIgnoreCase(key)) continue;
            item.setCompareType(itemInfo.getCompareType());
            item.setCompareValue(itemInfo.getCompareValue());
            return;
        }
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(itemInfo);
        try {
            filter.mergeFilter(info, "AND");
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

